/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.domain.model.compare;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.mal.domain.model.MalEntity;
import kd.scm.mal.domain.model.compare.MalCompareDimHandler;
import kd.scm.mal.domain.model.compare.MalHistoryPurchaseDimHandler;
import kd.scm.mal.domain.model.goods.MalGoods;

public class MalCompareDetail
extends MalEntity {
    private final Map<String, MalCompareDimHandler> compareDimHandlerMap = new HashMap<String, MalCompareDimHandler>(32);
    private static final MalCompareDimHandler EMPTY_HANDLER = (malGoods, malGoodsList) -> null;

    public MalCompareDetail(DynamicObject dyn) {
        super(dyn);
        this.compareDimHandlerMap.put("goods", (malGoods, malGoodsList) -> malGoods.getId());
        this.compareDimHandlerMap.put("imageap", (malGoods, malGoodsList) -> malGoods.getThumbnail());
        this.compareDimHandlerMap.put("imageap1", (malGoods, malGoodsList) -> malGoods.getThumbnail());
        this.compareDimHandlerMap.put("imageap2", (malGoods, malGoodsList) -> malGoods.getPicture1());
        this.compareDimHandlerMap.put("imageap3", (malGoods, malGoodsList) -> malGoods.getPicture2());
        this.compareDimHandlerMap.put("imageap4", (malGoods, malGoodsList) -> malGoods.getPicture3());
        this.compareDimHandlerMap.put("price", (malGoods, malGoodsList) -> malGoods.getTaxPrice());
        this.compareDimHandlerMap.put("currency", (malGoods, malGoodsList) -> malGoods.getCurrency());
        this.compareDimHandlerMap.put("supplier", (malGoods, malGoodsList) -> malGoods.getSupplierId());
        this.compareDimHandlerMap.put("platform", (malGoods, malGoodsList) -> malGoods.getPlatform());
        this.compareDimHandlerMap.put("stock_desc", (malGoods, malGoodsList) -> {
            String stockDesc = malGoods.getStockDesc();
            if (!EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(malGoods.getPlatform()) || "".equals(stockDesc)) {
                return stockDesc;
            }
            BigDecimal availableQty = new BigDecimal(stockDesc);
            if (availableQty.compareTo(BigDecimal.ZERO) <= 0) {
                return "0";
            }
            return stockDesc;
        });
        this.compareDimHandlerMap.put("isinventorylimited", (malGoods, malGoodsList) -> {
            String stockDesc = malGoods.getStockDesc();
            if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(malGoods.getPlatform()) && !"".equals(stockDesc)) {
                return "1";
            }
            return "0";
        });
        this.compareDimHandlerMap.put("taxrate", (malGoods, malGoodsList) -> malGoods.getTaxRate().stripTrailingZeros().toPlainString());
        this.compareDimHandlerMap.put("brand", (malGoods, malGoodsList) -> malGoods.getBrandId());
        this.compareDimHandlerMap.put("model", (malGoods, malGoodsList) -> malGoods.getModel());
        this.compareDimHandlerMap.put("unit", (malGoods, malGoodsList) -> malGoods.getUnitId());
        this.compareDimHandlerMap.put("minorderqty", (malGoods, malGoodsList) -> {
            if (malGoods.getMinOrderQty() == null || malGoods.getMinOrderQty().compareTo(BigDecimal.ZERO) == 0) {
                return ResManager.loadKDString((String)"\u4e0d\u9650\u5236", (String)"MalCompareDetail_0", (String)"scm-mal-mservice", (Object[])new Object[0]);
            }
            return malGoods.getMinOrderQty().stripTrailingZeros().toPlainString();
        });
        this.compareDimHandlerMap.put("purchased", new MalHistoryPurchaseDimHandler(this));
        this.compareDimHandlerMap.put("price_low", (malGoods, malGoodsList) -> {
            BigDecimal min = BigDecimal.ZERO;
            BigDecimal max = BigDecimal.ZERO;
            for (MalGoods mal : malGoodsList) {
                BigDecimal price = mal.getTaxPrice();
                if (null == price) {
                    price = BigDecimal.ZERO;
                }
                if (price.compareTo(min) <= 0 || min.compareTo(BigDecimal.ZERO) == 0) {
                    min = price;
                }
                if (price.compareTo(max) < 0) continue;
                max = price;
            }
            if (min.compareTo(max) == 0) {
                return "";
            }
            if (min.compareTo(malGoods.getTaxPrice()) == 0) {
                return ResManager.loadKDString((String)"\u4ef7\u683c\u6700\u4f4e", (String)"MalCompareDetail_1", (String)"scm-mal-mservice", (Object[])new Object[0]);
            }
            return "";
        });
        this.compareDimHandlerMap.put("price_high", (malGoods, malGoodsList) -> {
            BigDecimal min = BigDecimal.ZERO;
            BigDecimal max = BigDecimal.ZERO;
            for (MalGoods mal : malGoodsList) {
                BigDecimal price = mal.getTaxPrice();
                if (null == price) {
                    price = BigDecimal.ZERO;
                }
                if (price.compareTo(min) <= 0 || min.compareTo(BigDecimal.ZERO) == 0) {
                    min = price;
                }
                if (price.compareTo(max) < 0) continue;
                max = price;
            }
            if (min.compareTo(max) == 0) {
                return "";
            }
            if (max.compareTo(malGoods.getTaxPrice()) == 0) {
                return ResManager.loadKDString((String)"\u4ef7\u683c\u6700\u9ad8", (String)"MalCompareDetail_2", (String)"scm-mal-mservice", (Object[])new Object[0]);
            }
            return "";
        });
    }

    public Object handleDim(String key, MalGoods malGoods, List<MalGoods> malGoodsList) {
        return this.getCompareDimHander(key).handle(malGoods, malGoodsList);
    }

    private MalCompareDimHandler getCompareDimHander(String key) {
        return this.compareDimHandlerMap.getOrDefault(key, EMPTY_HANDLER);
    }
}

