/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.domain.model.compare;

import java.util.Date;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.mal.domain.model.MalBillEntity;

public class MalCompareRecord
extends MalBillEntity {
    public MalCompareRecord(DynamicObject dyn) {
        super(dyn);
    }

    public MalCompareRecord(Long id) {
        super(id);
    }

    public Long getId() {
        return this.id;
    }

    public Long getGoodsId() {
        return this.dyn.getLong("goods.id");
    }

    public String getSource() {
        return this.dyn.getString("goods.source");
    }

    public String getPlatform() {
        return this.dyn.getString("goods.source");
    }

    public int getExpire() {
        return this.dyn.getInt("expire");
    }

    public Date getOpTime() {
        return this.dyn.getDate("optime");
    }

    public static void addCompareRecord(Long goodsId, Long opUserId, int expire) {
        DynamicObject compareDyn = (DynamicObject)MetadataServiceHelper.getDataEntityType((String)"mal_compare_record").createInstance();
        compareDyn.set("goods_id", (Object)goodsId);
        compareDyn.set("opuser_id", (Object)opUserId);
        compareDyn.set("optime", (Object)TimeServiceHelper.now());
        compareDyn.set("expire", new MalCompareRecord(compareDyn).getDefValue("expire"));
        compareDyn.set("creator", (Object)RequestContext.get().getCurrUserId());
        if (expire > 0) {
            compareDyn.set("expire", (Object)expire);
        }
        MalCompareRecord.executeOp("save", compareDyn);
    }

    public static void addCompareRecords(Set<Long> goodsIds, Long opUserId, int expire) {
        for (Long goodsId : goodsIds) {
            MalCompareRecord.addCompareRecord(goodsId, opUserId, expire);
        }
    }
}

