/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.domain.model.compare;

import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.mal.common.util.MalAuthorityUtils;
import kd.scm.mal.domain.model.compare.MalCompareDetail;
import kd.scm.mal.domain.model.compare.MalCompareDimHandler;
import kd.scm.mal.domain.model.compare.MalHistoryPurchased;
import kd.scm.mal.domain.model.goods.MalGoods;

public class MalHistoryPurchaseDimHandler
implements MalCompareDimHandler {
    private static final String PURCHASED_DAYS = "purchased_days";
    private final MalCompareDetail malCompareDetail;

    public MalHistoryPurchaseDimHandler(MalCompareDetail malCompareDetail) {
        this.malCompareDetail = malCompareDetail;
    }

    @Override
    public Object handle(MalGoods malGoods, List<MalGoods> malGoodsList) {
        int defaultPurchasedDays = (Integer)this.malCompareDetail.getDefValue(PURCHASED_DAYS);
        Set billStatusSet = Stream.of(BillStatusEnum.AUDIT.getVal(), BillStatusEnum.CLOSED.getVal()).collect(Collectors.toSet());
        QFilter filter = new QFilter("billstatus", "in", billStatusSet).and(MalAuthorityUtils.getMalOrderViewAuthorityFilter((String)RequestContext.get().getUserId(), (String)"deporg.id", (String)"mal_order")).and("auditdate", ">", (Object)KDDateUtils.addDays((Date)TimeServiceHelper.now(), (int)(-defaultPurchasedDays))).and("entryentity.erpbillstatus", "in", billStatusSet).and("entryentity.goods.id", "=", (Object)malGoods.getId());
        return new MalHistoryPurchased(filter).toString();
    }
}

