/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.domain.model.compare;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.DateUtil;
import kd.scm.mal.domain.model.compare.MalHistoryPurchaseDimHandler;

public class MalHistoryPurchased {
    private int size = 0;
    private Date latestPurchaseDate;
    private BigDecimal latestPurchasePrice;
    private static final Log log = LogFactory.getLog((String)MalHistoryPurchased.class.getName());

    public MalHistoryPurchased(QFilter filter) {
        log.info("HistoryPurchased.filter:" + filter);
        String selectFields = "id,entryentity.goods.id,entryentity.goods.number,entryentity.taxprice,auditdate";
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)MalHistoryPurchaseDimHandler.class.getName(), (String)"mal_order", (String)selectFields, (QFilter[])new QFilter[]{filter}, (String)"auditdate desc");){
            ds.forEach(row -> {
                if (this.latestPurchasePrice == null) {
                    this.latestPurchasePrice = row.getBigDecimal("entryentity.taxprice");
                    this.latestPurchaseDate = row.getDate("auditdate");
                }
                ++this.size;
            });
        }
    }

    public String toString() {
        if (this.size > 0) {
            return ResManager.loadKDString((String)"\u8d2d\u4e70{0}\u6b21\uff0c\u6700\u8fd1\u8d2d\u4e70{1}\uff0c\u4ef7\u683c{2}\u3002", (String)"MalHistoryPurchased_0", (String)"scm-mal-mservice", (Object[])new Object[]{this.size, DateUtil.date2str((Date)this.latestPurchaseDate, (String)"yyyy.MM.dd"), this.latestPurchasePrice});
        }
        return ResManager.loadKDString((String)"\u672a\u8d2d\u4e70", (String)"MalHistoryPurchased_1", (String)"scm-mal-mservice", (Object[])new Object[0]);
    }
}

