/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.domain.model.goods;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.url.UrlService;
import kd.scm.common.ecapi.entity.SaleAttrInfo;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.es.storage.EsFilterField;
import kd.scm.common.helper.apiconnector.api.ApiAccessor;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.mal.business.factory.MalBusinessFactory;
import kd.scm.mal.business.product.service.MalProductService;
import kd.scm.mal.business.receipt.entity.MalReceipt;
import kd.scm.mal.business.receipt.service.MalReceiptService;
import kd.scm.mal.business.search.service.MalSearchService;
import kd.scm.mal.business.stock.service.MalStockService;
import kd.scm.mal.common.util.MalAddressUtil;
import kd.scm.mal.common.util.MalProductUtil;
import kd.scm.mal.domain.model.MalEntity;
import kd.scm.mal.domain.model.compare.ComparePriceInfo;
import kd.scm.mal.domain.model.goods.MalGoodsInfo;
import kd.scm.mal.domain.model.goods.MalMatGoodsInitParam;
import kd.scm.mal.domain.model.goods.MalSaleAttr;
import kd.scm.mal.domain.model.goods.MalSameKindGoods;
import kd.scm.mal.domain.model.goods.MalSimilarGoods;
import kd.scm.mal.domain.model.search.MalSearchParam;
import kd.scm.mal.domain.model.search.MalSearchResult;
import kd.scm.malcore.domain.GoodsSameRule;
import kd.scm.malcore.domain.LadderPriceInfo;
import kd.scm.malcore.enums.MallStatusEnum;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringEscapeUtils;

public class MalGoods
extends MalEntity {
    @Deprecated
    public static final MalGoods EMPTY_GOODS = new MalGoods(new MalGoodsInfo());
    private static final Log log = LogFactory.getLog((String)MalGoods.class.getName());
    private static final String SPLIT = "_";
    private MalGoodsInfo goodsInfo;
    private static final String TYPE_MALGOODS = "malgoods";
    private static final String MAL_REGION = "mal_region";

    private static LocalMemoryCache getMalGoodsCache() {
        CacheConfigInfo localConfig = new CacheConfigInfo();
        localConfig.setMaxItemSize(1000);
        localConfig.setTimeout(600);
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(MAL_REGION, TYPE_MALGOODS, localConfig);
    }

    @Deprecated
    public MalGoods() {
    }

    private MalGoods(MalGoodsInfo goodsInfo) {
        this.goodsInfo = goodsInfo;
    }

    @Deprecated
    public MalGoods(Long id) {
    }

    @Deprecated
    public static MalGoods of(Long goodsId) {
        List goodsIds = Stream.of(goodsId).collect(Collectors.toList());
        MalMatGoodsInitParam malMatGoodsInitParam = new MalMatGoodsInitParam();
        malMatGoodsInitParam.setGoodsId(goodsId);
        malMatGoodsInitParam.setOrgId(RequestContext.get().getOrgId());
        Map goodsId2PlatformMap = MalProductUtil.getGoodsId2PlatformMap(goodsIds);
        malMatGoodsInitParam.setPlatform((String)goodsId2PlatformMap.get(goodsId));
        return MalGoods.of(malMatGoodsInitParam, false, false);
    }

    public static MalGoods of(MalMatGoodsInitParam malMatGoodsInitParam, boolean initStock, boolean isDetail) {
        ArrayList<MalMatGoodsInitParam> malMatGoodsInitParams = new ArrayList<MalMatGoodsInitParam>(1);
        malMatGoodsInitParams.add(malMatGoodsInitParam);
        return MalGoods.batchInstance(malMatGoodsInitParams, initStock, isDetail).get(malMatGoodsInitParam.getGoodsId());
    }

    public static MalGoods getFromCache(String cacheKey, Long goodsId) {
        return (MalGoods)MalGoods.getMalGoodsCache().get(RequestContext.get().getTenantId() + SPLIT + cacheKey + SPLIT + goodsId);
    }

    public static void cacheMalGoods(String cacheKey, MalGoods malGoods) {
        MalGoods.getMalGoodsCache().put(RequestContext.get().getTenantId() + SPLIT + cacheKey + SPLIT + malGoods.getId(), (Object)malGoods);
    }

    public static void cache(String cacheKey, Long goodsId, MalGoods malGoods) {
        MalGoods.getMalGoodsCache().put(RequestContext.get().getTenantId() + SPLIT + cacheKey + SPLIT + goodsId, (Object)malGoods);
    }

    public static void removeCache(String cacheKey, Long goodsId) {
        MalGoods.getMalGoodsCache().remove(new String[]{RequestContext.get().getTenantId() + SPLIT + cacheKey + SPLIT + goodsId});
    }

    @Deprecated
    public static Map<Long, MalGoods> batchInstance(Set<Long> goodsIds, boolean initStock, boolean isDetail) {
        long orgId = RequestContext.get().getOrgId();
        return MalGoods.batchInstance(goodsIds, initStock, isDetail, orgId);
    }

    @Deprecated
    public static Map<Long, MalGoods> batchInstance(Set<Long> goodsIds, boolean initStock, boolean isDetail, Long orgId) {
        return MalGoods.batchInstance(goodsIds, initStock, MalAddressUtil.getDefaultAdmindivisionId().toString(), isDetail, orgId, new HashMap<Long, BigDecimal>());
    }

    private static Map<Long, MalGoods> batchInstance(Set<Long> goodsIds, boolean initStock, String admindivisionId, boolean isDetail, Long orgId, Map<Long, BigDecimal> qtyMap) {
        ArrayList<MalMatGoodsInitParam> malMatGoodsInitParams = new ArrayList<MalMatGoodsInitParam>(goodsIds.size());
        Map goodsId2PlatformMap = MalProductUtil.getGoodsId2PlatformMap(new ArrayList<Long>(goodsIds));
        for (Long goodsId : goodsIds) {
            malMatGoodsInitParams.add(MalMatGoodsInitParam.buildGeneralParam(goodsId, (String)goodsId2PlatformMap.get(goodsId), qtyMap.get(goodsId), admindivisionId, orgId));
        }
        return MalGoods.batchInstance(malMatGoodsInitParams, initStock, isDetail);
    }

    public static Map<Long, List<LadderPriceInfo>> batchGetLadderPrice(List<Long> goodsIds, Long orgId) {
        if (orgId == 0L) {
            orgId = RequestContext.get().getOrgId();
        }
        QFilter qFilter = new QFilter("goods", "in", goodsIds);
        QFilter orgQFilter = new QFilter("isgoodvisible", "=", (Object)Boolean.TRUE).or(new QFilter("isgoodvisible", "=", (Object)Boolean.FALSE).and(new QFilter("entryentity.orgname", "=", (Object)orgId)));
        qFilter.and(orgQFilter);
        qFilter.and(new QFilter("mallstatus", "=", (Object)MallStatusEnum.SOLD.getVal()));
        DynamicObjectCollection prodPools = QueryServiceHelper.query((String)"pmm_prodpool", (String)"goods.curr,goods,priceentry.qtyfrom,priceentry.qtyto,priceentry.ladprice", (QFilter[])qFilter.toArray(), (String)"priceentry.qtyfrom asc");
        HashMap good_PoolsMap = new HashMap(1024);
        for (DynamicObject prod : prodPools) {
            long id = prod.getLong("goods");
            List<Object> pools = new ArrayList<DynamicObject>(1024);
            if (null != good_PoolsMap.get(id)) {
                pools = (List)good_PoolsMap.get(id);
            }
            pools.add(prod);
            good_PoolsMap.put(id, pools);
        }
        HashMap<Long, List<LadderPriceInfo>> goodsId_LadPriceColMap = new HashMap<Long, List<LadderPriceInfo>>(1024);
        for (Map.Entry map : good_PoolsMap.entrySet()) {
            ArrayList ladderPriceInfos = new ArrayList(1024);
            Long goodsId = (Long)map.getKey();
            List pools = (List)map.getValue();
            if (pools.size() < 2) continue;
            pools.forEach(pool -> ladderPriceInfos.add(new LadderPriceInfo(pool.getBigDecimal("priceentry.qtyfrom"), pool.getBigDecimal("priceentry.qtyto"), pool.getBigDecimal("priceentry.ladprice"), Long.valueOf(pool.getLong("goods.curr")))));
            List newLadderPriceInfos = ladderPriceInfos.stream().sorted(Comparator.comparing(LadderPriceInfo::getQtyfrom)).collect(Collectors.toList());
            goodsId_LadPriceColMap.put(goodsId, newLadderPriceInfos);
        }
        return goodsId_LadPriceColMap;
    }

    public static Map<Long, MalGoods> batchInstance(List<MalMatGoodsInitParam> malMatGoodsInitParams, boolean initStock, boolean isDetail) {
        long start = TimeServiceHelper.getTimeStamp();
        log.info("malMatGoodsInitParams:" + malMatGoodsInitParams + ", initStock:" + initStock + ", isDetail:" + isDetail);
        LinkedHashMap<Long, MalGoods> res = new LinkedHashMap<Long, MalGoods>(malMatGoodsInitParams.size() << 2);
        if (ObjectUtils.isEmpty(malMatGoodsInitParams)) {
            return res;
        }
        HashMap<String, List> platform2InitParamMap = new HashMap<String, List>(malMatGoodsInitParams.size() << 2);
        String addressId = "";
        if (StringUtils.isBlank((CharSequence)malMatGoodsInitParams.get(0).getAddressId())) {
            MalReceipt defaultReceipt = MalBusinessFactory.serviceOf(MalReceiptService.class).getDefaultReceiptByOrg(malMatGoodsInitParams.get(0).getOrgId());
            addressId = String.valueOf(defaultReceipt.getAdmindivisionId());
        }
        HashMap<Long, MalMatGoodsInitParam> malMatGoodsInitParamMap = new HashMap<Long, MalMatGoodsInitParam>(malMatGoodsInitParams.size() << 2);
        for (MalMatGoodsInitParam malMatGoodsInitParam : malMatGoodsInitParams) {
            malMatGoodsInitParamMap.put(malMatGoodsInitParam.getGoodsId(), malMatGoodsInitParam);
            if (StringUtils.isBlank((CharSequence)malMatGoodsInitParam.getAddressId())) {
                malMatGoodsInitParam.setAddressId(addressId);
            }
            List malMatGoodsInitParamsList = platform2InitParamMap.getOrDefault(malMatGoodsInitParam.getPlatform(), new ArrayList());
            malMatGoodsInitParamsList.add(malMatGoodsInitParam);
            platform2InitParamMap.put(malMatGoodsInitParam.getPlatform(), malMatGoodsInitParamsList);
        }
        HashMap<Long, MalGoodsInfo> malGoodsInfoMap = new HashMap<Long, MalGoodsInfo>(malMatGoodsInitParams.size() << 2);
        for (Map.Entry entry : platform2InitParamMap.entrySet()) {
            MalProductService malProductService = MalBusinessFactory.serviceOf(MalProductService.class, (String)entry.getKey());
            if (malProductService == null) continue;
            malGoodsInfoMap.putAll(malProductService.getMalGoodsInfos((List)entry.getValue(), initStock, isDetail));
        }
        if (isDetail) {
            MalGoods.initDetailInfo(malGoodsInfoMap);
        }
        for (MalGoodsInfo malGoodsInfo : malGoodsInfoMap.values()) {
            if (!StringUtils.isNotEmpty((CharSequence)malGoodsInfo.getProductId())) continue;
            Long goodsId = Long.valueOf(malGoodsInfo.getProductId());
            res.put(goodsId, new MalGoods(malGoodsInfo));
            MalMatGoodsInitParam malMatGoodsInitParam = (MalMatGoodsInitParam)malMatGoodsInitParamMap.get(goodsId);
            if (malMatGoodsInitParam == null) continue;
            malGoodsInfo.setQty(malMatGoodsInitParam.getQty());
            long orgId = RequestContext.get().getOrgId();
            if (malMatGoodsInitParam.getOrgId() != null && malMatGoodsInitParam.getOrgId() != 0L) {
                orgId = malMatGoodsInitParam.getOrgId();
            }
            malGoodsInfo.setOrgId(orgId);
        }
        log.info("batchInstance.res:" + res);
        log.info("kd.scm.mal.domain.model.goods.MalGoods.batchInstance\u8017\u65f6\uff1a" + (TimeServiceHelper.getTimeStamp() - start));
        return res;
    }

    private static void initDetailInfo(Map<Long, MalGoodsInfo> goodsInfoMap) {
        try {
            MalGoods.initSameKindGoodsInfo(goodsInfoMap);
        }
        catch (Exception e) {
            log.error(ExceptionUtil.getStackTrace((Throwable)e));
        }
        try {
            MalGoods.initByEsGoods(goodsInfoMap);
        }
        catch (Exception e) {
            log.error(ExceptionUtil.getStackTrace((Throwable)e));
        }
        try {
            MalGoods.initMaterialInfo(goodsInfoMap);
        }
        catch (Exception e) {
            log.error(ExceptionUtil.getStackTrace((Throwable)e));
        }
    }

    private static void initByEsGoods(Map<Long, MalGoodsInfo> goodsInfoMap) {
        EsFilterField goodsIdFilter = new EsFilterField("goodsid", "in", goodsInfoMap.keySet().toArray());
        MalSearchParam malSearchParam = new MalSearchParam();
        malSearchParam.setCustomEsFilterFields(Collections.singletonList(goodsIdFilter));
        malSearchParam.setPageNum(0);
        malSearchParam.setPageSize(goodsInfoMap.size());
        MalSearchResult malSearchResult = MalBusinessFactory.serviceOf(MalSearchService.class).search(malSearchParam, null);
        List<Map<String, Object>> resultData = malSearchResult.getResultData();
        if (resultData != null) {
            for (Map<String, Object> goodsObj : resultData) {
                Object centralPurtypeName;
                MalGoodsInfo malGoodsInfo;
                Object goodsId = goodsObj.get("goodsid");
                if (ObjectUtils.isEmpty((Object)goodsId) || ObjectUtils.isEmpty((Object)(malGoodsInfo = goodsInfoMap.get(Long.valueOf(String.valueOf(goodsId)))))) continue;
                Object sales = goodsObj.get("sales");
                if (!ObjectUtils.isEmpty((Object)sales)) {
                    malGoodsInfo.setSales(new BigDecimal(String.valueOf(sales)));
                }
                if (ObjectUtils.isEmpty((Object)(centralPurtypeName = goodsObj.get("centralpurtype_name")))) continue;
                malGoodsInfo.setCentralpurtypeName(String.valueOf(centralPurtypeName));
            }
        }
    }

    private static void initMaterialInfo(Map<Long, MalGoodsInfo> goodsInfoMap) {
        HashSet<Long> goodsIdSet = new HashSet<Long>(goodsInfoMap.keySet());
        goodsIdSet.removeIf(goodsId -> goodsId == 0L);
        if (goodsIdSet.isEmpty()) {
            return;
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"pmm_prodmatmapping", (String)"material.id,material.name,material.number,goods.id", (QFilter[])new QFilter[]{new QFilter("goods.id", "in", goodsIdSet)}, null);){
            HashMap<Long, Long> goodsIdAndMaterialIdMap = new HashMap<Long, Long>(goodsIdSet.size() << 2);
            HashMap<Long, String> goodsIdAndMaterialNameMap = new HashMap<Long, String>(goodsIdSet.size() << 2);
            HashMap<Long, String> goodsIdAndMaterialNumberMap = new HashMap<Long, String>(goodsIdSet.size() << 2);
            for (Row row : dataSet) {
                goodsIdAndMaterialIdMap.put(row.getLong("goods.id"), row.getLong("material.id"));
                goodsIdAndMaterialNameMap.put(row.getLong("goods.id"), row.getString("material.name"));
                goodsIdAndMaterialNumberMap.put(row.getLong("goods.id"), row.getString("material.number"));
            }
            for (MalGoodsInfo malGoodsInfo : goodsInfoMap.values()) {
                Long goodsId2 = Long.valueOf(malGoodsInfo.getProductId());
                Long materialId = (Long)goodsIdAndMaterialIdMap.get(goodsId2);
                if (materialId == null || materialId == 0L) continue;
                malGoodsInfo.setMaterialId((Long)goodsIdAndMaterialIdMap.get(goodsId2));
                malGoodsInfo.setMaterialName((String)goodsIdAndMaterialNameMap.get(goodsId2));
                malGoodsInfo.setMaterialNumber((String)goodsIdAndMaterialNumberMap.get(goodsId2));
            }
        }
    }

    @Deprecated
    public static Map<Long, MalGoodsInfo> getSameKindGoods(Map<Long, MalGoods> goodsInfoMap) {
        return new HashMap<Long, MalGoodsInfo>();
    }

    private static void initSameKindGoodsInfo(Map<Long, MalGoodsInfo> goodsInfoMap) {
        long goodsId = 0L;
        String source = "";
        for (Map.Entry<Long, MalGoodsInfo> entry : goodsInfoMap.entrySet()) {
            goodsId = entry.getKey();
            source = entry.getValue().getProductSource();
        }
        if (0L != goodsId) {
            GoodsSameRule goodsSameRule = (GoodsSameRule)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pmm", (String)"IPmmGoodsSameRuleService", (String)"getSameGoodsRuleEsFilterByGoodsId", (Object[])new Object[]{goodsId, source});
            if (goodsSameRule.getEsFilterFields() == null || goodsSameRule.getEsFilterFields().size() == 0) {
                for (Map.Entry<Long, MalGoodsInfo> entry : goodsInfoMap.entrySet()) {
                    MalGoodsInfo goodsInfo = goodsInfoMap.get(entry.getKey());
                    goodsInfo.setSamekind(goodsSameRule.isSamekind());
                    goodsInfo.setSimilar(goodsSameRule.isSimilar());
                    goodsInfo.setAutoCompare(goodsSameRule.isAutoCompare());
                }
                return;
            }
            MalSearchParam malSearchParam = new MalSearchParam();
            malSearchParam.setCustomEsFilterFields(goodsSameRule.getEsFilterFields());
            malSearchParam.setSort(goodsSameRule.getSort());
            malSearchParam.setPageNum(0);
            malSearchParam.setPageSize(10);
            MalSearchResult malSearchResult = MalBusinessFactory.serviceOf(MalSearchService.class).search(malSearchParam, null);
            List<Map<String, Object>> resultData = malSearchResult.getResultData();
            for (Map.Entry<Long, MalGoodsInfo> malMap : goodsInfoMap.entrySet()) {
                MalGoodsInfo goodsInfo = goodsInfoMap.get(malMap.getKey());
                goodsInfo.setSamekind(goodsSameRule.isSamekind());
                goodsInfo.setSimilar(goodsSameRule.isSimilar());
                ArrayList<MalSameKindGoods> malSameKindGoods = new ArrayList<MalSameKindGoods>(1024);
                for (Map<String, Object> map : resultData) {
                    goodsId = Long.parseLong(String.valueOf(map.get("goodsid")));
                    if (goodsId == malMap.getKey()) continue;
                    MalSameKindGoods sameKindGoods = new MalSameKindGoods();
                    sameKindGoods.setSupplierId(Long.parseLong(String.valueOf(map.get("supplierid"))));
                    sameKindGoods.setSupplierName(String.valueOf(map.get("suppliername")));
                    if (null == map.get("price")) {
                        sameKindGoods.setPrice(BigDecimal.ZERO);
                    } else {
                        BigDecimal price = new BigDecimal(String.valueOf(map.get("price")));
                        sameKindGoods.setPrice(price);
                    }
                    sameKindGoods.setGoodsId(Long.parseLong(String.valueOf(map.get("goodsid"))));
                    if (map.get("unitid") != null) {
                        sameKindGoods.setUnitId(Long.parseLong(String.valueOf(map.get("unitid"))));
                        sameKindGoods.setUnitName(String.valueOf(map.get("unitname")));
                    }
                    sameKindGoods.setSource(String.valueOf(map.get("source")));
                    sameKindGoods.setSku(String.valueOf(map.get("number")));
                    malSameKindGoods.add(sameKindGoods);
                }
                goodsInfo.setMalSameKindGoods(malSameKindGoods);
            }
        }
    }

    public static Map<Long, MalGoods> batchInstanceOfInitParamMap(Map<Long, MalMatGoodsInitParam> planEntryIdInitParamMap) {
        HashMap<Long, MalGoods> res = new HashMap<Long, MalGoods>(planEntryIdInitParamMap.size() << 2);
        if (planEntryIdInitParamMap.isEmpty()) {
            return res;
        }
        for (MalMatGoodsInitParam malMatGoodsInitParam : planEntryIdInitParamMap.values()) {
            if (malMatGoodsInitParam.getEntryReqOrgId() == null || malMatGoodsInitParam.getEntryReqOrgId() == 0L) continue;
            malMatGoodsInitParam.setOrgId(malMatGoodsInitParam.getEntryReqOrgId());
        }
        ArrayList<MalMatGoodsInitParam> initParams = new ArrayList<MalMatGoodsInitParam>(planEntryIdInitParamMap.values());
        Map<Long, MalGoods> malGoodsMap = MalGoods.batchInstance(initParams, true, false);
        for (Map.Entry<Long, MalMatGoodsInitParam> malMatGoodsInitParamEntry : planEntryIdInitParamMap.entrySet()) {
            MalMatGoodsInitParam initParam = malMatGoodsInitParamEntry.getValue();
            res.put(initParam.getPlanEntryId(), malGoodsMap.get(initParam.getGoodsId()));
        }
        return res;
    }

    public MalGoodsInfo getGoodsInfo() {
        if (this.goodsInfo == null) {
            this.goodsInfo = new MalGoodsInfo();
        }
        return this.goodsInfo;
    }

    public String getSku() {
        return this.getGoodsInfo().getProductNumber();
    }

    public Long getUnitId() {
        if (StringUtils.isEmpty((CharSequence)this.getGoodsInfo().getProductUnitID())) {
            return 0L;
        }
        return Long.valueOf(this.getGoodsInfo().getProductUnitID());
    }

    public String getSupplierId() {
        return StringUtils.isEmpty((CharSequence)this.getGoodsInfo().getSupplier()) ? "0" : String.valueOf(this.getGoodsInfo().getSupplierId());
    }

    public String getSupplierName() {
        return this.getGoodsInfo().getSupplierName();
    }

    public String getSupplierPhone() {
        return this.getGoodsInfo().getSupplierPhone();
    }

    public boolean validateMallStatus() {
        if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(this.getPlatform())) {
            return "B".equals(this.getGoodsInfo().getMallStatus()) && "B".equals(this.getGoodsInfo().getSupplierMallStatus());
        }
        return "1".equals(this.getGoodsInfo().getMallStatus());
    }

    public boolean validateStock(BigDecimal orderQty) {
        return MalBusinessFactory.serviceOf(MalStockService.class).validEcGoodsStock(this, orderQty);
    }

    public boolean validateOrgSaleable(Long orgId) {
        return this.getGoodsInfo().isGoodsVisible() || this.getGoodsInfo().getApplicableOrgSet().contains(orgId);
    }

    public String getStockDesc() {
        return this.getGoodsInfo().getStockState();
    }

    public String getModel() {
        return this.getGoodsInfo().getProductModel();
    }

    public String getThumbnail() {
        return MalGoods.getPictureUrl(this.getGoodsInfo().getProductImgPath());
    }

    private static String getPictureUrl(String pictureUrl) {
        if (StringUtils.isEmpty((CharSequence)pictureUrl) || pictureUrl.contains("http") || pictureUrl.contains("https")) {
            return pictureUrl;
        }
        return UrlService.getImageFullUrl((String)pictureUrl);
    }

    public String getName() {
        return this.getGoodsInfo().getProductName();
    }

    public Long getCurrency() {
        return StringUtils.isEmpty((CharSequence)this.getGoodsInfo().getProductCurrID()) ? 0L : Long.parseLong(this.getGoodsInfo().getProductCurrID());
    }

    public BigDecimal getPrice() {
        if (null == this.getGoodsInfo().getPrice()) {
            return BigDecimal.ZERO;
        }
        return this.getGoodsInfo().getPrice().stripTrailingZeros();
    }

    public Date getPriceModifyTime() {
        return this.getGoodsInfo().getPriceModifyTime();
    }

    public BigDecimal getTaxRate() {
        return this.getGoodsInfo().getTaxRate();
    }

    public Long getTaxrateId() {
        return this.getGoodsInfo().getTaxRateId();
    }

    public Long getId() {
        return Long.valueOf(this.goodsInfo.getProductId());
    }

    public String getPlatform() {
        return this.getGoodsInfo().getProductSource();
    }

    public String getNumber() {
        return this.getGoodsInfo().getProductNumber();
    }

    public String getMallStatus() {
        return this.getGoodsInfo().getMallStatus();
    }

    public String getSupplierMallStatus() {
        return this.getGoodsInfo().getSupplierMallStatus();
    }

    public String getSaleStatus() {
        return this.getGoodsInfo().getSaleStatus();
    }

    public String getPicture1() {
        return MalGoods.getPictureUrl(this.getGoodsInfo().getPicture1());
    }

    public String getPicture2() {
        return MalGoods.getPictureUrl(this.getGoodsInfo().getPicture2());
    }

    public String getPicture3() {
        return MalGoods.getPictureUrl(this.getGoodsInfo().getPicture3());
    }

    public String getPicture4() {
        return MalGoods.getPictureUrl(this.getGoodsInfo().getPicture4());
    }

    public Long getBrandId() {
        return StringUtils.isEmpty((CharSequence)this.getGoodsInfo().getBrandId()) ? 0L : Long.parseLong(this.getGoodsInfo().getBrandId());
    }

    public Date getCreateTime() {
        return this.getGoodsInfo().getCreateTime();
    }

    public String getCentralpurtype() {
        return this.getGoodsInfo().getCentralpurtype();
    }

    public String getBarcode() {
        return this.getGoodsInfo().getBarCode();
    }

    public List<MalSameKindGoods> getMalSameKindGoods() {
        return this.getGoodsInfo().getMalSameKindGoods();
    }

    public void setIsEcLogistics(String desc) {
        this.getGoodsInfo().setIsJDLogistics(desc);
    }

    public void setNoReasonToReturnText(String desc) {
        this.getGoodsInfo().setNoReasonToReturnText(desc);
    }

    public void setGuarantee(String desc) {
        this.getGoodsInfo().setGuarantee(desc);
    }

    public void setPromiseTips(String desc) {
        this.getGoodsInfo().setPromiseTips(desc);
    }

    public String getTipsContent() {
        String manuFacturer = ResManager.loadKDString((String)"\u5382\u5546", (String)"MalGoods_0", (String)"scm-mal-business", (Object[])new Object[0]);
        String tipsContent = EcPlatformEnum.ECPLATFORM_SUNING.getVal().equals(this.getProductSource()) ? String.format(ResManager.loadKDString((String)"\u7531\u201c%s\u201d\u53d1\u8d27\uff0c\u5e76\u63d0\u4f9b\u552e\u540e\u670d\u52a1\u3002", (String)"MalGoods_1", (String)"scm-mal-business", (Object[])new Object[0]), "01".equals(this.getIsEcLogistics()) ? this.getSupplier() : manuFacturer) : String.format(ResManager.loadKDString((String)"\u7531\u201c%s\u201d\u53d1\u8d27\uff0c\u5e76\u63d0\u4f9b\u552e\u540e\u670d\u52a1\u3002", (String)"MalGoods_1", (String)"scm-mal-business", (Object[])new Object[0]), "1".equals(this.getIsEcLogistics()) ? this.getSupplier() : manuFacturer);
        return tipsContent;
    }

    public void setShippingAddress(String admindivisionId) {
        this.getGoodsInfo().setShippingAddress(admindivisionId);
    }

    public void setOrg(Long orgId) {
        this.getGoodsInfo().setOrgId(orgId);
    }

    @Deprecated
    public void setQty(BigDecimal qty) {
    }

    public String getProtocolBillno() {
        return this.getGoodsInfo().getProtocolBillno();
    }

    public String getProductNumber() {
        return this.getGoodsInfo().getProductNumber();
    }

    public String getProductId() {
        return this.getGoodsInfo().getProductId();
    }

    public String getProductModel() {
        return StringUtils.isBlank((CharSequence)this.getGoodsInfo().getProductModel()) ? "" : this.getGoodsInfo().getProductModel();
    }

    public BigDecimal getShopPrice() {
        if (null == this.getGoodsInfo().getShopPrice()) {
            return BigDecimal.ZERO;
        }
        return this.getGoodsInfo().getShopPrice().stripTrailingZeros();
    }

    public String getSupplier() {
        return this.getGoodsInfo().getSupplier();
    }

    public BigDecimal getTaxPrice() {
        if (null == this.getGoodsInfo().getTaxPrice()) {
            return BigDecimal.ZERO;
        }
        return this.getGoodsInfo().getTaxPrice().stripTrailingZeros();
    }

    public BigDecimal getEcPrice() {
        if (null == this.getGoodsInfo().getShopPrice()) {
            return BigDecimal.ZERO;
        }
        return this.getGoodsInfo().getShopPrice().stripTrailingZeros();
    }

    public Map<BigDecimal, BigDecimal> getLadderPriceRange() {
        return this.getGoodsInfo().getLadderPriceRange();
    }

    public BigDecimal priceChange(BigDecimal cartPrice) {
        return this.getTaxPrice().subtract(cartPrice);
    }

    @Deprecated
    public BigDecimal getPriceChange() {
        return BigDecimal.ZERO;
    }

    public String getProductName() {
        return this.getGoodsInfo().getProductName();
    }

    public String getProductUnitID() {
        return this.getGoodsInfo().getProductUnitID();
    }

    public String getShippingAddress() {
        return this.getGoodsInfo().getShippingAddress();
    }

    public String getPromiseTips() {
        return StringUtils.isEmpty((CharSequence)this.getGoodsInfo().getPromiseTips()) ? "" : this.getGoodsInfo().getPromiseTips();
    }

    public String getNoReasonToReturnText() {
        return this.getGoodsInfo().getNoReasonToReturnText();
    }

    public Long getMaterialId() {
        return this.getGoodsInfo().getMaterialId();
    }

    public String getProductDetail() {
        return this.xssEscape(this.getGoodsInfo().getProductDetail());
    }

    public String getSpecification() {
        return this.xssEscape(this.getGoodsInfo().getSpecification());
    }

    private String xssEscape(String text) {
        List<String> words = Arrays.asList("onerror", "<script>", "<iframe>", "<embed>", "<object>", "javascript", "@import", "<input>", "<textarea>", "onclick", "onmouseover");
        if (StringUtils.isNotBlank((CharSequence)text)) {
            String tempText = text.toLowerCase();
            for (String word : words) {
                if (!tempText.contains(word)) continue;
                return StringEscapeUtils.escapeHtml((String)text);
            }
        }
        return text;
    }

    public Map<Object, Map<Object, Object>> getAttributeMap() {
        return this.getGoodsInfo().getAttributeMap();
    }

    public String getPackinglist() {
        return this.getGoodsInfo().getPackinglist();
    }

    public String getGuarantee() {
        return this.getGoodsInfo().getGuarantee();
    }

    public List<ComparePriceInfo> getComparePrices() {
        return this.getGoodsInfo().getComparePrices();
    }

    public String getIsEcLogistics() {
        return this.getGoodsInfo().getIsJDLogistics();
    }

    public String getProductSource() {
        return this.getGoodsInfo().getProductSource();
    }

    public Long getOrgId() {
        return this.getGoodsInfo().getOrgId();
    }

    public BigDecimal getMinOrderQty() {
        return this.getGoodsInfo().getMinOrderQty();
    }

    public String getSalesDesc() {
        return MalProductUtil.getSalesDesc((BigDecimal)this.getGoodsInfo().getSales());
    }

    public int getLeadtime() {
        return this.getGoodsInfo().getLeadtime();
    }

    public boolean isGoodsVisible() {
        return this.getGoodsInfo().isGoodsVisible();
    }

    public Set<Long> getApplicableOrgSet() {
        return this.getGoodsInfo().getApplicableOrgSet();
    }

    public List<LadderPriceInfo> getLadderPriceInfos() {
        return this.getGoodsInfo().getLadderPriceInfos();
    }

    public String getCategoryId() {
        return this.getGoodsInfo().getCategoryId();
    }

    public String getCategoryNumber() {
        return this.getGoodsInfo().getCategoryNumber();
    }

    public String getCategoryName() {
        return this.getGoodsInfo().getCategoryName();
    }

    public String toString() {
        return "MalGoods{, goodsInfo=" + this.goodsInfo + '}';
    }

    public static DynamicObject[] syncEcGoodsToGoodsManage(Set<Long> goodsIdSet) {
        return MalProductUtil.syncEcGoodsToGoodsManage(goodsIdSet);
    }

    public List<MalSimilarGoods> getMalSimilarGoodsList() {
        MalProductService malProductService = MalBusinessFactory.serviceOf(MalProductService.class, this.getPlatform());
        if (malProductService != null) {
            return malProductService.getMalSimilarGoodsList(this.getGoodsInfo());
        }
        return new ArrayList<MalSimilarGoods>();
    }

    public List<MalSimilarGoods> getAllSelfSimilarGoodsList() {
        Map attributeMap = this.getGoodsInfo().getAttributeMap();
        LinkedHashMap<Long, MalSimilarGoods> attrId2MalSimilarGoodsMap = new LinkedHashMap<Long, MalSimilarGoods>(1024);
        if (null != attributeMap && attributeMap.size() > 0) {
            HashSet<Long> attributeIds = new HashSet<Long>(1024);
            for (Map.Entry map : attributeMap.entrySet()) {
                for (Map.Entry attrMap : ((Map)map.getValue()).entrySet()) {
                    long attrId = Long.parseLong(String.valueOf(attrMap.getKey()));
                    if (0L == attrId) continue;
                    attributeIds.add(attrId);
                }
            }
            HashSet<Long> baseAttrIds = new HashSet<Long>(1024);
            QFilter qFilter = new QFilter("prodattributeentry.prodattribute", "in", attributeIds);
            DynamicObjectCollection prodManageDyoCol = QueryServiceHelper.query((String)"pmm_prodmanage", (String)"id,prodattributeentry.prodattribute prodattributeid,prodattributeentry.prodattribute.attributetype attributetype", (QFilter[])new QFilter[]{qFilter});
            HashMap<Long, Integer> goodsCountMap = new HashMap<Long, Integer>(1024);
            for (Object row : prodManageDyoCol) {
                Long l = row.getLong("id");
                int index = 0;
                if (null != goodsCountMap.get(l)) {
                    index = (Integer)goodsCountMap.get(l);
                }
                goodsCountMap.put(l, ++index);
                if (StringUtils.isEmpty((CharSequence)row.getString("attributetype")) || !"1".equals(row.getString("attributetype"))) continue;
                baseAttrIds.add(row.getLong("prodattributeid"));
            }
            HashSet<Object> goodsId = new HashSet<Object>(1024);
            for (Map.Entry entry : goodsCountMap.entrySet()) {
                if ((Integer)entry.getValue() < attributeIds.size()) continue;
                goodsId.add(entry.getKey());
            }
            if (goodsId.size() > 0) {
                qFilter = new QFilter("goods.id", "in", goodsId);
                qFilter.and(new QFilter("mallstatus", "=", (Object)MallStatusEnum.SOLD.getVal()));
                QFilter orgQfilter = new QFilter("isgoodvisible", "=", (Object)true).or(new QFilter("entryentity.orgname", "=", (Object)this.goodsInfo.getOrgId()));
                qFilter.and(orgQfilter);
                String string = "goods.id";
                DynamicObjectCollection pmmProdpools = QueryServiceHelper.query((String)"pmm_prodpool", (String)string, (QFilter[])new QFilter[]{qFilter});
                goodsId.clear();
                for (DynamicObject row : pmmProdpools) {
                    goodsId.add(row.getLong("goods.id"));
                }
                if (goodsId.size() == 0) {
                    return new ArrayList<MalSimilarGoods>(attrId2MalSimilarGoodsMap.values());
                }
                qFilter = new QFilter("id", "in", goodsId);
                String selectors = "prodattributeentry.prodattribute.attributetype attributetype,id,prodattributeentry,prodattributeentry.prodattribute prodattributeid,prodattributeentry.prodattribute.name attributename,prodattributeentry.prodattributevalue attributevalueid,prodattributeentry.prodattributevalue.name attributevaluename,prodattributeentry.prodattribute.prodattributegroup prodattributegroupid,prodattributeentry.prodattribute.prodattributegroup.name attributegroupname";
                prodManageDyoCol = QueryServiceHelper.query((String)"pmm_prodmanage", (String)selectors, (QFilter[])new QFilter[]{qFilter});
                HashSet<Long> removeGoodsId = new HashSet<Long>(1024);
                for (DynamicObject row : prodManageDyoCol) {
                    if (!"1".equals(row.getString("attributetype")) || baseAttrIds.contains(row.getLong("prodattributeid"))) continue;
                    removeGoodsId.add(row.getLong("id"));
                }
                HashMap<Long, MalSaleAttr> attrValueId2MalSaleAttrMap = new HashMap<Long, MalSaleAttr>(1024);
                int dim = 1;
                for (DynamicObject row : prodManageDyoCol) {
                    HashSet<Long> skuIds;
                    SaleAttrInfo saleAttrInfo;
                    if (removeGoodsId.contains(row.getLong("prodattributeid")) || baseAttrIds.contains(row.getLong("prodattributeid")) || !attributeIds.contains(row.getLong("prodattributeid"))) continue;
                    MalSimilarGoods malSimilarGoods = (MalSimilarGoods)attrId2MalSimilarGoodsMap.get(row.getLong("prodattributeid"));
                    if (malSimilarGoods == null) {
                        malSimilarGoods = new MalSimilarGoods();
                        malSimilarGoods.setDim(dim++);
                        ArrayList<MalSaleAttr> malSaleAttrs = new ArrayList<MalSaleAttr>();
                        saleAttrInfo = new SaleAttrInfo();
                        saleAttrInfo.setSaleValue(row.getString("attributevaluename"));
                        skuIds = new HashSet(1024);
                        skuIds.add(row.getLong("id"));
                        saleAttrInfo.setSkuIds(skuIds);
                        MalSaleAttr malSaleAttr = new MalSaleAttr(saleAttrInfo);
                        if (this.getId().longValue() == row.getLong("id")) {
                            malSimilarGoods.setSelectedSku(this.getSku());
                            malSaleAttr.setSelected(true);
                        }
                        malSaleAttrs.add(malSaleAttr);
                        malSimilarGoods.setSaleGroupName(row.getString("attributegroupname"));
                        malSimilarGoods.setSaleName(row.getString("attributename"));
                        malSimilarGoods.setMalSaleAttrs(malSaleAttrs);
                        attrId2MalSimilarGoodsMap.put(row.getLong("prodattributeid"), malSimilarGoods);
                        attrValueId2MalSaleAttrMap.put(row.getLong("attributevalueid"), malSaleAttr);
                        continue;
                    }
                    MalSaleAttr malSaleAttr = (MalSaleAttr)attrValueId2MalSaleAttrMap.get(row.getLong("attributevalueid"));
                    if (malSaleAttr == null) {
                        saleAttrInfo = new SaleAttrInfo();
                        saleAttrInfo.setSaleValue(row.getString("attributevaluename"));
                        skuIds = new HashSet<Long>(1024);
                        skuIds.add(row.getLong("id"));
                        saleAttrInfo.setSkuIds(skuIds);
                        malSaleAttr = new MalSaleAttr(saleAttrInfo);
                        malSimilarGoods.getMalSaleAttrs().add(malSaleAttr);
                        attrValueId2MalSaleAttrMap.put(row.getLong("attributevalueid"), malSaleAttr);
                    } else {
                        malSaleAttr.getSkuIds().add(row.getLong("id"));
                    }
                    if (this.getId().longValue() != row.getLong("id")) continue;
                    malSimilarGoods.setSelectedSku(this.getSku());
                    malSaleAttr.setSelected(true);
                }
                return new ArrayList<MalSimilarGoods>(attrId2MalSimilarGoodsMap.values());
            }
        }
        return new ArrayList<MalSimilarGoods>(attrId2MalSimilarGoodsMap.values());
    }

    public String getSimilarSku(int dim, String saleAttrName) {
        String res = "";
        List<MalSimilarGoods> malSimilarGoodsList = this.getMalSimilarGoodsList();
        MalSaleAttr similarMalSaleAttr = null;
        for (MalSimilarGoods malSimilarGoods : malSimilarGoodsList) {
            if (dim != malSimilarGoods.getDim()) continue;
            for (MalSaleAttr malSaleAttr : malSimilarGoods.getMalSaleAttrs()) {
                if (!StringUtils.equals((CharSequence)malSaleAttr.getSaleValue(), (CharSequence)saleAttrName)) continue;
                similarMalSaleAttr = malSaleAttr;
            }
        }
        if (similarMalSaleAttr == null) {
            throw new KDBizException("dim:" + dim + ",saleAttrName:" + saleAttrName + "similar sku not exist.");
        }
        if (malSimilarGoodsList.size() == 1) {
            for (Object skuId : similarMalSaleAttr.getSkuIds()) {
                if (!StringUtils.isBlank((CharSequence)res) || ObjectUtils.isEmpty((Object)skuId)) continue;
                return String.valueOf(skuId);
            }
        } else {
            HashSet<Object> skuSet = new HashSet<Object>(similarMalSaleAttr.getSkuIds());
            for (MalSimilarGoods malSimilarGoods : malSimilarGoodsList) {
                if (malSimilarGoods.getDim() == dim) continue;
                for (MalSaleAttr malSaleAttr : malSimilarGoods.getMalSaleAttrs()) {
                    if (!malSaleAttr.isSelected()) continue;
                    skuSet.retainAll(malSaleAttr.getSkuIds());
                }
            }
            return skuSet.isEmpty() ? "" : skuSet.iterator().next().toString();
        }
        return res;
    }

    public static Map<String, Long> ecSync(List<String> goodsNumbers, String platform) {
        HashMap<String, Long> res = new HashMap<String, Long>();
        try {
            Object ecGoodsObjs;
            Map executeRes = (Map)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscFlowService", (String)"execute", (Object[])new Object[]{MalGoods.getServiceFlowNumber(platform), Collections.singletonList(goodsNumbers)});
            Map output = (Map)executeRes.get("output");
            if (!ObjectUtils.isEmpty((Object)output) && !ObjectUtils.isEmpty(ecGoodsObjs = output.get("CQ_EC_GOODS"))) {
                JSONArray goodsJa = JSONArray.fromObject(ecGoodsObjs);
                for (int i = 0; i < goodsJa.size(); ++i) {
                    JSONObject goodsJo = goodsJa.getJSONObject(i);
                    res.put(goodsJo.getString("number"), goodsJo.getLong("id"));
                }
            }
        }
        catch (Exception e) {
            log.warn(ExceptionUtil.getStackTrace((Throwable)e));
            throw new KDBizException(e.getMessage());
        }
        return res;
    }

    public static void asyncEcSync(List<String> goodsNumbers, String platform) {
        try {
            if (goodsNumbers.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u884c\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"MalGoods_3", (String)"scm-mal-business", (Object[])new Object[0]));
            }
            ApiAccessor.invokeServiceFlow((String)MalGoods.getServiceFlowNumber(platform), Collections.singletonList(goodsNumbers));
        }
        catch (Exception e) {
            log.warn(ExceptionUtil.getStackTrace((Throwable)e));
            throw new KDBizException(e.getMessage());
        }
    }

    private static String getServiceFlowNumber(String platform) {
        MalProductService malProductService = MalBusinessFactory.serviceOf(MalProductService.class, platform);
        if (malProductService != null) {
            return malProductService.getEcSyncServiceFlowNumber();
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7535\u5546\u7684\u5546\u54c1\u521d\u59cb\u5316\u6d41\u7a0b\u3002", (String)"MalGoods_4", (String)"scm-mal-business", (Object[])new Object[0]));
    }

    public boolean isSimilar() {
        return this.goodsInfo.isSimilar();
    }

    public boolean isSamekind() {
        return this.goodsInfo.isSamekind();
    }

    public BigDecimal getQty() {
        return this.goodsInfo.getQty();
    }
}

