/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.domain.model.goods;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.scm.mal.business.factory.MalBusinessFactory;
import kd.scm.mal.business.product.service.MalProductService;
import kd.scm.mal.common.util.MalAddressUtil;
import kd.scm.mal.common.util.MalProductUtil;
import kd.scm.mal.domain.model.MalEntity;
import kd.scm.mal.domain.model.compare.ComparePriceInfo;
import kd.scm.mal.domain.model.goods.MalMatGoodsInitParam;
import kd.scm.mal.domain.service.impl.MalCompareService;
import kd.scm.malcore.domain.LadderPriceInfo;

public class MalPrice
extends MalEntity {
    @Deprecated
    protected static final MalPrice EMPTY_PRICE = new MalPrice("", BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0L, null);
    private String goodsId;
    private String sku;
    private BigDecimal price;
    private BigDecimal taxprice;
    private BigDecimal shopprice;
    @Deprecated
    private BigDecimal priceChange;
    private BigDecimal taxrate;
    private Long taxrateId;
    private Date modifytime;
    @Deprecated
    private BigDecimal qty;
    private Long orgId;
    @Deprecated
    private Map<BigDecimal, BigDecimal> ladderPriceRange;
    private List<LadderPriceInfo> ladderPriceInfos;
    private List<ComparePriceInfo> comparePrices;

    public List<ComparePriceInfo> getComparePrices() {
        return this.comparePrices;
    }

    public void setComparePrices(List<ComparePriceInfo> comparePrices) {
        this.comparePrices = comparePrices;
    }

    private MalPrice() {
    }

    public MalPrice(String goodsId, BigDecimal taxprice, BigDecimal price, BigDecimal shopprice, BigDecimal taxrate, Long taxrateId, Date modifytime) {
        this.goodsId = goodsId;
        this.taxprice = taxprice;
        this.priceChange = BigDecimal.ZERO;
        this.price = price;
        this.shopprice = shopprice;
        this.taxrate = taxrate;
        this.taxrateId = taxrateId;
        this.modifytime = modifytime;
    }

    public String getSku() {
        return this.sku;
    }

    public void setSku(String sku) {
        this.sku = sku;
    }

    public BigDecimal getQty() {
        return this.qty;
    }

    public void setQty(BigDecimal qty) {
        this.qty = qty;
    }

    public Long getOrgId() {
        return this.orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    @Deprecated
    public BigDecimal getEcPrice() {
        return this.shopprice;
    }

    @Deprecated
    public void setEcPrice(BigDecimal ecPrice) {
        this.shopprice = ecPrice;
    }

    public BigDecimal getShopprice() {
        return this.shopprice;
    }

    public BigDecimal getTaxrate() {
        return this.taxrate == null ? BigDecimal.ZERO : this.taxrate;
    }

    public String getGoodsId() {
        return this.goodsId;
    }

    public BigDecimal getTaxprice() {
        return this.taxprice;
    }

    public Date getModifytime() {
        return this.modifytime;
    }

    public Long getTaxrateId() {
        return this.taxrateId;
    }

    public Map<BigDecimal, BigDecimal> getLadderPriceRange() {
        return this.ladderPriceRange;
    }

    public void setLadderPriceRange(Map<BigDecimal, BigDecimal> ladderPriceRange) {
        this.ladderPriceRange = ladderPriceRange;
    }

    @Deprecated
    public BigDecimal priceChange(BigDecimal cartPrice) {
        this.priceChange = this.getTaxprice().subtract(cartPrice);
        return this.priceChange;
    }

    @Deprecated
    public BigDecimal getPriceChange() {
        return this.priceChange;
    }

    public List<LadderPriceInfo> getLadderPriceInfos() {
        return this.ladderPriceInfos;
    }

    public void setLadderPriceInfos(List<LadderPriceInfo> ladderPriceInfos) {
        this.ladderPriceInfos = ladderPriceInfos;
    }

    @Deprecated
    protected static Map<Long, MalPrice> batchInstanceOfGoodsId(List<Long> goodsIds, long orgId) {
        ArrayList<MalMatGoodsInitParam> malMatGoodsInitParams = new ArrayList<MalMatGoodsInitParam>(goodsIds.size());
        Map goodsId2PlatformMap = MalProductUtil.getGoodsId2PlatformMap(goodsIds);
        String addressId = MalAddressUtil.getDefaultAdmindivisionId().toString();
        for (Long goodsId : goodsIds) {
            malMatGoodsInitParams.add(MalMatGoodsInitParam.buildGeneralParam(goodsId, (String)goodsId2PlatformMap.get(goodsId), BigDecimal.ONE, addressId, orgId));
        }
        return MalPrice.batchInstance(malMatGoodsInitParams);
    }

    @Deprecated
    protected static Map<Long, MalPrice> batchInstanceOfGoodsId(List<Long> goodsIds) {
        long orgId = RequestContext.get().getOrgId();
        return MalPrice.batchInstanceOfGoodsId(goodsIds, orgId);
    }

    public static Map<Long, MalPrice> batchInstance(List<MalMatGoodsInitParam> malMatGoodsInitParams) {
        HashMap<Long, MalPrice> res = new HashMap<Long, MalPrice>(malMatGoodsInitParams.size() << 2);
        HashMap<String, List> platform2InitParamMap = new HashMap<String, List>(malMatGoodsInitParams.size());
        for (MalMatGoodsInitParam malMatGoodsInitParam : malMatGoodsInitParams) {
            List matGoodsInitParamList = platform2InitParamMap.getOrDefault(malMatGoodsInitParam.getPlatform(), new ArrayList());
            matGoodsInitParamList.add(malMatGoodsInitParam);
            platform2InitParamMap.put(malMatGoodsInitParam.getPlatform(), matGoodsInitParamList);
        }
        platform2InitParamMap.forEach((key, value) -> {
            MalProductService malProductService = MalBusinessFactory.serviceOf(MalProductService.class, key);
            if (malProductService != null) {
                res.putAll(malProductService.getMalPrices((List<MalMatGoodsInitParam>)value));
            }
        });
        if (malMatGoodsInitParams.get(0).getCompareId() != null) {
            MalPrice.dealMalpriceByComparePrice(res, malMatGoodsInitParams);
        }
        return res;
    }

    private static void dealMalpriceByComparePrice(Map<Long, MalPrice> res, List<MalMatGoodsInitParam> malMatGoodsInitParams) {
        Long orgId = malMatGoodsInitParams.get(0).getOrgId();
        HashSet<Long> compareIds = new HashSet<Long>(1024);
        for (MalMatGoodsInitParam param : malMatGoodsInitParams) {
            if (null == param.getCompareId()) continue;
            compareIds.add(param.getCompareId());
        }
        MalCompareService service = new MalCompareService();
        Map<Long, List<ComparePriceInfo>> compareMap = service.queryComparePriceRecord(new ArrayList<Long>(res.keySet()), orgId, compareIds);
        for (Map.Entry<Long, MalPrice> map : res.entrySet()) {
            Long goodsId = map.getKey();
            MalPrice malPrice = map.getValue();
            if (null == compareMap.get(goodsId)) continue;
            malPrice.setComparePrices(compareMap.get(goodsId));
        }
    }
}

