/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.domain.model.plan;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.CommonUtil;
import kd.scm.mal.domain.model.MalBillEntity;

public class MalPlan
extends MalBillEntity {
    private MalPlan(DynamicObject malPlanDyn) {
        super(malPlanDyn);
    }

    public static MalPlan getInstance(DynamicObject malPlanDyn) {
        return new MalPlan(malPlanDyn);
    }

    public String getSrcBillId() {
        DynamicObjectCollection entryCol = this.dyn.getDynamicObjectCollection("entryentity");
        if (entryCol.isEmpty()) {
            return "";
        }
        return ((DynamicObject)entryCol.get(0)).getString("srcbillid");
    }

    public Set<String> getSrcEntryIds() {
        HashSet<String> res = new HashSet<String>();
        DynamicObjectCollection entryCol = this.dyn.getDynamicObjectCollection("entryentity");
        if (entryCol.isEmpty()) {
            return res;
        }
        for (DynamicObject entry : entryCol) {
            if (!StringUtils.isNotEmpty((CharSequence)entry.getString("srcentryid"))) continue;
            res.add(entry.getString("srcentryid"));
        }
        return res;
    }

    public Long getId() {
        return this.id;
    }

    public static DynamicObjectCollection queryMalPlanById(Long malPlanId) {
        return QueryServiceHelper.query((String)"mal_plan", (String)MalPlan.getSelectFields(), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)malPlanId)});
    }

    public static DynamicObjectCollection queryMalPlanByIds(List<Long> malPlanIds) {
        return QueryServiceHelper.query((String)"mal_plan", (String)MalPlan.getSelectFields(), (QFilter[])new QFilter[]{new QFilter("id", "in", malPlanIds)});
    }

    private static String getSelectFields() {
        return "id,person,businesstype,remark,org.id,org.number,org.name,entryentity,entryentity.entryreqorg,entryentity.entryrcvorg,entryentity.material.id,entryentity.unit.id,entryentity.qty,entryentity.baseqty,entryentity.srcbilltype,entryentity.srcbillid,entryentity.id,entryentity.srcentryid,entryentity.srcbillno,entryentity.entryreqperson.id,entryentity.reqdate,entryentity.entryrcvorg.id,entryentity.entryreqorg.id,entryentity.linetype.id,entryentity.reqbaseqty,entryentity.reqqty,entryentity.joinqty,entryentity.joinbaseqty,entryentity.material,entryentity.unit,entryentity.baseunit,entryentity.material.number";
    }

    public MalPlan(long id) {
        super(id);
    }

    public static DynamicObjectCollection queryMalPlanBySrcEntryIds(Set<String> srcEntryIds) {
        QFilter filter = new QFilter("entryentity.srcentryid", "in", srcEntryIds);
        return QueryServiceHelper.query((String)"mal_plan", (String)MalPlan.getSelectFields(), (QFilter[])new QFilter[]{filter});
    }

    public static DynamicObject queryMalPlanBySrcEntryId(String srcEntryId) {
        QFilter filter = new QFilter("entryentity.srcentryid", "=", (Object)srcEntryId);
        return QueryServiceHelper.queryOne((String)"mal_plan", (String)MalPlan.getSelectFields(), (QFilter[])new QFilter[]{filter});
    }

    public static String getSrcBillTypeBySrcEntryId(String srcEntryId) {
        DynamicObject dyn = MalPlan.queryMalPlanBySrcEntryId(srcEntryId);
        return dyn == null ? "" : dyn.getString("entryentity.srcbilltype");
    }

    public static MalPlan instanceOfId(Long id) {
        return new MalPlan((long)id);
    }

    public void doUpdateJoinQty(Map<String, BigDecimal> joinQtyMap) {
        DynamicObjectCollection entryentityCol = this.dyn.getDynamicObjectCollection("entryentity");
        if (entryentityCol.isEmpty()) {
            return;
        }
        for (DynamicObject entry : entryentityCol) {
            joinQtyMap.forEach((srcEntryId, joinQty) -> {
                if (srcEntryId.equals(entry.getString("srcentryid"))) {
                    BigDecimal joinBaseQty = entry.getBigDecimal("joinbaseqty").add(this.calBaseQty(entry, (BigDecimal)joinQty));
                    entry.set("joinbaseqty", (Object)joinBaseQty);
                    BigDecimal entryJoinQty = entry.getBigDecimal("joinqty").add((BigDecimal)joinQty);
                    entry.set("joinqty", (Object)entryJoinQty);
                    entry.set("baseqty", (Object)entry.getBigDecimal("reqbaseqty").subtract(joinBaseQty));
                    entry.set("qty", (Object)entry.getBigDecimal("reqqty").subtract(entryJoinQty));
                }
            });
        }
    }

    public void doResetJoinQty(Map<String, BigDecimal> joinQtyMap) {
        DynamicObjectCollection entryentityCol = this.dyn.getDynamicObjectCollection("entryentity");
        if (entryentityCol.isEmpty()) {
            return;
        }
        for (DynamicObject entry : entryentityCol) {
            joinQtyMap.forEach((srcEntryId, joinQty) -> {
                if (srcEntryId.equals(entry.getString("srcentryid"))) {
                    BigDecimal joinBaseQty = this.calBaseQty(entry, (BigDecimal)joinQty);
                    entry.set("joinbaseqty", (Object)joinBaseQty);
                    entry.set("joinqty", joinQty);
                    entry.set("baseqty", (Object)entry.getBigDecimal("reqbaseqty").subtract(joinBaseQty));
                    entry.set("qty", (Object)entry.getBigDecimal("reqqty").subtract((BigDecimal)joinQty));
                }
            });
        }
    }

    public static void batchUpdateJoinQtyAndQty(Map<String, BigDecimal> srcEntryIdJoinQtyMap) {
        if (srcEntryIdJoinQtyMap == null || srcEntryIdJoinQtyMap.isEmpty()) {
            return;
        }
        List<MalPlan> malPlans = MalPlan.batchInstanceOfSrcEntryIdSet(srcEntryIdJoinQtyMap.keySet());
        for (MalPlan malPlan : malPlans) {
            malPlan.doUpdateJoinQty(srcEntryIdJoinQtyMap);
        }
        MalPlan.batchSave(malPlans);
    }

    public static void batchResetJoinQty(Map<String, BigDecimal> srcEntryIdJoinQtyMap) {
        if (srcEntryIdJoinQtyMap == null || srcEntryIdJoinQtyMap.isEmpty()) {
            return;
        }
        List<MalPlan> malPlans = MalPlan.batchInstanceOfSrcEntryIdSet(srcEntryIdJoinQtyMap.keySet());
        for (MalPlan malPlan : malPlans) {
            malPlan.doResetJoinQty(srcEntryIdJoinQtyMap);
        }
        MalPlan.batchSave(malPlans);
    }

    public static void batchSave(List<MalPlan> malPlans) {
        DynamicObject[] dyns = new DynamicObject[malPlans.size()];
        for (int i = 0; i < malPlans.size(); ++i) {
            dyns[i] = malPlans.get((int)i).dyn;
        }
        SaveServiceHelper.save((DynamicObject[])dyns);
    }

    public static List<MalPlan> batchInstanceOfSrcEntryIdSet(Set<String> srcEntryIdSet) {
        DynamicObject[] malPlans;
        ArrayList<MalPlan> res = new ArrayList<MalPlan>(srcEntryIdSet.size());
        for (DynamicObject malPlan : malPlans = BusinessDataServiceHelper.load((String)"mal_plan", (String)MalPlan.getSelectFields(), (QFilter[])new QFilter[]{new QFilter("entryentity.srcentryid", "in", srcEntryIdSet)})) {
            res.add(new MalPlan(malPlan));
        }
        return res;
    }

    public void validateMaxPurchaseQtyForPurchase(Set<String> srcEntryIds) {
        DynamicObjectCollection entryCol = this.dyn.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entryCol) {
            if (!srcEntryIds.contains(entry.getString("srcentryid")) || entry.getBigDecimal("reqqty").subtract(entry.getBigDecimal("joinqty")).compareTo(BigDecimal.ONE) >= 0) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u7269\u6599{0}\u6700\u5927\u53ef\u91c7\u8d2d\u91cf\u5c0f\u4e8e1\uff0c\u4e0d\u80fd\u8fdb\u884c\u5546\u57ce\u9009\u8d2d\u3002", (String)"MalPlan_0", (String)"scm-mal-mservice", (Object[])new Object[]{entry.getString("material.number")}));
        }
    }

    public static Map<String, BigDecimal> validateMaxPurchaseQty(Map<String, BigDecimal> srcEntryIdOrderQtyMap) {
        HashMap<String, BigDecimal> res = new HashMap<String, BigDecimal>();
        DynamicObjectCollection dynCol = MalPlan.queryMalPlanBySrcEntryIds(srcEntryIdOrderQtyMap.keySet());
        for (DynamicObject dyn : dynCol) {
            BigDecimal maxPurchaseQty = dyn.getBigDecimal("entryentity.reqqty").subtract(dyn.getBigDecimal("entryentity.joinqty"));
            if (maxPurchaseQty.compareTo(srcEntryIdOrderQtyMap.get(dyn.getString("entryentity.srcentryid"))) >= 0) continue;
            res.put(dyn.getString("entryentity.srcentryid"), maxPurchaseQty);
        }
        return res;
    }

    private BigDecimal calBaseQty(DynamicObject entry, BigDecimal joinQty) {
        return CommonUtil.getDesQtyConv((DynamicObject)entry.getDynamicObject("material"), (DynamicObject)entry.getDynamicObject("unit"), (BigDecimal)joinQty, (DynamicObject)entry.getDynamicObject("baseunit"));
    }

    public Set<Long> getEntryReqOrgSetFilterBySrcEntryIds(Set<String> srcEntryIds) {
        DynamicObjectCollection entryCol = this.dyn.getDynamicObjectCollection("entryentity");
        HashSet<Long> res = new HashSet<Long>(entryCol.size());
        for (DynamicObject entry : entryCol) {
            if (!srcEntryIds.contains(entry.getString("srcentryid"))) continue;
            res.add(entry.getLong("entryreqorg.id"));
        }
        return res;
    }

    public Set<Long> getEntryRcvOrgSetFilterBySrcEntryIds(Set<String> srcEntryIds) {
        DynamicObjectCollection entryCol = this.dyn.getDynamicObjectCollection("entryentity");
        HashSet<Long> res = new HashSet<Long>(entryCol.size());
        for (DynamicObject entry : entryCol) {
            if (!srcEntryIds.contains(entry.getString("srcentryid"))) continue;
            res.add(entry.getLong("entryrcvorg.id"));
        }
        return res;
    }
}

