/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.domain.service;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.extension.ScmExtensionFactory;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.mal.business.history.MalProBrowsingHistoryService;
import kd.scm.mal.business.history.impl.MalProBrowsingHistoryServiceImpl;
import kd.scm.mal.domain.service.IGetMalTrendPriceService;
import kd.scm.mal.domain.service.IGetQtyAndJoinQtyService;
import kd.scm.mal.domain.service.IMalCompareService;
import kd.scm.mal.domain.service.MalConverRuleService;
import kd.scm.mal.domain.service.MalEsSearchService;
import kd.scm.mal.domain.service.MalGoodsSelectService;
import kd.scm.mal.domain.service.MalSearchService;
import kd.scm.mal.domain.service.MalVersionSwitchService;
import kd.scm.mal.domain.service.impl.GetMalDealTrendPriceService;
import kd.scm.mal.domain.service.impl.GetMalQuoteTrendPriceService;
import kd.scm.mal.domain.service.impl.MalCompareService;
import kd.scm.mal.domain.service.impl.MalConverRuleServiceImpl;
import kd.scm.mal.domain.service.impl.MalEsSearchServiceImpl;
import kd.scm.mal.domain.service.impl.MalGoodsSelectBySalesService;
import kd.scm.mal.domain.service.impl.MalGoodsSelectBySelfSelectService;
import kd.scm.mal.domain.service.impl.MalGoodsSelectByUploadTimeService;
import kd.scm.mal.domain.service.impl.MalSearchServiceImpl;
import kd.scm.mal.domain.service.impl.MalVersionSwitchServiceImpl;
import kd.scm.mal.domain.service.impl.PmGetQtyAndJoinQtyService;

public class DomainServiceFactory {
    private static final Log log = LogFactory.getLog((String)DomainServiceFactory.class.getName());
    private static final Map<Class<?>, Object> serviceMap = new ConcurrentHashMap();
    private static final Map<Class<?>, Map<String, Object>> serviceMapWithKey = new ConcurrentHashMap();

    public static <T> T serviceOf(Class<T> serviceClass) {
        return (T)serviceMap.get(serviceClass);
    }

    public static <T> T serviceOf(Class<T> serviceClass, String key) {
        Object service = ((Map)serviceMapWithKey.getOrDefault(serviceClass, new HashMap())).get(key);
        if (service == null) {
            try {
                service = ScmExtensionFactory.getExtensionFacotry(serviceClass).getExtension(key);
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u670d\u52a1\u5b9e\u73b0\u5931\u8d25\uff1a" + e.getMessage() + System.lineSeparator() + ExceptionUtil.getStackTrace((Throwable)e));
                return null;
            }
        }
        return (T)service;
    }

    static {
        HashMap<String, IGetMalTrendPriceService> getMalTrendPriceServiceMap = new HashMap<String, IGetMalTrendPriceService>(2);
        getMalTrendPriceServiceMap.put("malQuotePriceTrend", new GetMalQuoteTrendPriceService());
        getMalTrendPriceServiceMap.put("malDealPriceTrend", new GetMalDealTrendPriceService());
        serviceMapWithKey.put(IGetMalTrendPriceService.class, getMalTrendPriceServiceMap);
        HashMap<String, MalGoodsSelectService> malGoodsSelectService = new HashMap<String, MalGoodsSelectService>(8);
        malGoodsSelectService.put("A", new MalGoodsSelectBySelfSelectService());
        malGoodsSelectService.put("B", new MalGoodsSelectBySalesService());
        malGoodsSelectService.put("C", new MalGoodsSelectByUploadTimeService());
        serviceMapWithKey.put(MalGoodsSelectService.class, malGoodsSelectService);
        serviceMap.put(IMalCompareService.class, new MalCompareService());
        serviceMap.put(IGetQtyAndJoinQtyService.class, new PmGetQtyAndJoinQtyService());
        serviceMap.put(MalSearchService.class, new MalSearchServiceImpl());
        serviceMap.put(MalConverRuleService.class, new MalConverRuleServiceImpl());
        serviceMap.put(MalEsSearchService.class, new MalEsSearchServiceImpl());
        serviceMap.put(MalVersionSwitchService.class, new MalVersionSwitchServiceImpl());
        serviceMap.put(MalProBrowsingHistoryService.class, new MalProBrowsingHistoryServiceImpl());
    }
}

