/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.domain.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.scm.mal.common.enums.SrcBillTypeEnum;
import kd.scm.mal.domain.model.plan.MalPlan;
import kd.scm.mal.domain.service.IGetQtyAndJoinQtyService;
import kd.scm.mal.domain.service.impl.PmGetQtyAndJoinQtyService;
import kd.scm.mal.domain.service.impl.XkGetJoinQtyService;

public class MalMaxPurchaseQtyService {
    private final IGetQtyAndJoinQtyService qtyAndJoinQtyService;

    public MalMaxPurchaseQtyService(IGetQtyAndJoinQtyService qtyAndJoinQtyService) {
        this.qtyAndJoinQtyService = qtyAndJoinQtyService;
    }

    public Map<String, BigDecimal> checkMaxPurchaseQty(Map<String, BigDecimal> srcEntryIdQtyMap) {
        HashMap<String, BigDecimal> res = new HashMap<String, BigDecimal>();
        if (ObjectUtils.isEmpty(srcEntryIdQtyMap)) {
            return res;
        }
        this.resetJoinQty(srcEntryIdQtyMap);
        return MalPlan.validateMaxPurchaseQty(srcEntryIdQtyMap);
    }

    private void resetJoinQty(Map<String, BigDecimal> srcEntryIdQtyMap) {
        ArrayList<Long> srcEntryIds = new ArrayList<Long>(srcEntryIdQtyMap.size());
        for (String srcEntryId : srcEntryIdQtyMap.keySet()) {
            srcEntryIds.add(Long.valueOf(srcEntryId));
        }
        MalPlan.batchResetJoinQty(this.qtyAndJoinQtyService.getQtyAndJoinQty(srcEntryIds));
    }

    public static MalMaxPurchaseQtyService getInstance(String srcBillType) {
        if (SrcBillTypeEnum.PM_PURAPPLYBILL.getVal().equals(srcBillType)) {
            return new MalMaxPurchaseQtyService(new PmGetQtyAndJoinQtyService());
        }
        if (SrcBillTypeEnum.PUR_REQUISITION.getVal().equals(srcBillType)) {
            return new MalMaxPurchaseQtyService(new XkGetJoinQtyService());
        }
        return null;
    }
}

