/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.domain.service;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.container.TabAp;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.scm.common.util.MetaDataUtil;
import kd.scm.mal.business.factory.MalBusinessFactory;
import kd.scm.mal.business.search.service.MalSearchService;
import kd.scm.mal.domain.model.goods.MalGoods;
import kd.scm.mal.domain.model.goods.MalGoodsInfo;
import kd.scm.mal.domain.model.search.MalSearchParam;
import kd.scm.mal.domain.model.search.MalSearchResult;
import kd.scm.mal.domain.model.trend.MalTrend;
import kd.scm.mal.domain.service.MalPriceTrendService;
import kd.scm.malcore.domain.GoodsSameRule;

public class MalPriceMonitorService {
    public boolean checkIsShowPriceMonitorForm(MalGoods malGoods, List<String> invisibleTabKeys) {
        boolean isHasData = false;
        FormMetadata mal_pricemonitordetail = MetaDataUtil.getFormMetaData((String)"mal_pricemonitordetail");
        if (null != mal_pricemonitordetail) {
            List pricemonitordetailAp = MetaDataUtil.getFormMetaData((String)"mal_pricemonitordetail").getItems();
            HashSet<String> tabKeySet = new HashSet<String>(16);
            for (ControlAp controlAp : pricemonitordetailAp) {
                String key = controlAp.getKey();
                if (!"tabap".equals(key)) continue;
                TabAp taAp = (TabAp)controlAp;
                List items = taAp.getItems();
                for (ControlAp item : items) {
                    String tabKey = item.getKey();
                    if (invisibleTabKeys.contains(tabKey)) continue;
                    tabKeySet.add(tabKey);
                }
            }
            if (tabKeySet.contains("comparedetail")) {
                isHasData = this.isCompare(malGoods);
            }
            if (!isHasData && tabKeySet.contains("samegoods")) {
                isHasData = this.isSamegoods(malGoods);
            }
            if (!isHasData && tabKeySet.contains("historyprice")) {
                isHasData = this.isShowQuoPriceTab(malGoods);
            }
            if (!isHasData && tabKeySet.contains("orgprice")) {
                isHasData = this.isShowOrderPriceTab(malGoods);
            }
        }
        return isHasData;
    }

    public boolean isCompare(MalGoods malGoods) {
        return null != malGoods && null != malGoods.getComparePrices() && malGoods.getComparePrices().size() != 0;
    }

    public boolean isSamegoods(MalGoods malGoods) {
        GoodsSameRule goodsSameRule = (GoodsSameRule)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pmm", (String)"IPmmGoodsSameRuleService", (String)"getSameGoodsRuleEsFilterByGoodsId", (Object[])new Object[]{Long.parseLong(malGoods.getProductId()), malGoods.getProductSource()});
        MalGoodsInfo malGoodsInfo = malGoods.getGoodsInfo();
        malGoodsInfo.setSamekind(goodsSameRule.isSamekind());
        malGoodsInfo.setSimilar(goodsSameRule.isSimilar());
        if (!goodsSameRule.isSamekind() || null == goodsSameRule.getEsFilterFields() || goodsSameRule.getEsFilterFields().size() == 0) {
            return false;
        }
        MalSearchParam malSearchParam = new MalSearchParam();
        malSearchParam.setCustomEsFilterFields(goodsSameRule.getEsFilterFields());
        malSearchParam.setSort(goodsSameRule.getSort());
        malSearchParam.setPageNum(0);
        malSearchParam.setPageSize(10);
        MalSearchResult malSearchResult = MalBusinessFactory.serviceOf(MalSearchService.class).search(malSearchParam, null);
        List<Map<String, Object>> resultData = malSearchResult.getResultData();
        return resultData.size() > 1;
    }

    public boolean isShowQuoPriceTab(MalGoods malGoods) {
        MalPriceTrendService malQuotePriceTrend = new MalPriceTrendService("malQuotePriceTrend");
        MalTrend quoTrend = malQuotePriceTrend.createMalTrend(malGoods);
        return quoTrend != null;
    }

    public boolean isShowOrderPriceTab(MalGoods malGoods) {
        MalPriceTrendService malDealPriceTrend = new MalPriceTrendService("malDealPriceTrend");
        MalTrend dealPriceTrend = malDealPriceTrend.createMalTrend(malGoods);
        return dealPriceTrend != null;
    }
}

