/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.domain.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.util.DateUtil;
import kd.scm.mal.domain.model.goods.MalGoods;
import kd.scm.mal.domain.model.trend.MalPoint;
import kd.scm.mal.domain.model.trend.MalTrend;
import kd.scm.mal.domain.service.DomainServiceFactory;
import kd.scm.mal.domain.service.IGetMalTrendPriceService;

public class MalPriceTrendService {
    private static final Log log = LogFactory.getLog(MalPriceTrendService.class);
    private IGetMalTrendPriceService iGetMalTrendPriceService;

    public MalPriceTrendService(String trendType) {
        this.iGetMalTrendPriceService = DomainServiceFactory.serviceOf(IGetMalTrendPriceService.class, trendType);
    }

    public MalTrend createMalTrend(MalGoods malGoods) {
        Map<String, Integer> filterTabMap = this.iGetMalTrendPriceService.getFilterTabMap();
        Integer maxTimeFilter = this.getMaxTimeFilter(filterTabMap);
        Map<List<Date>, List<BigDecimal>> malHistoryPrice = this.iGetMalTrendPriceService.getMalHistoryPrice(malGoods, maxTimeFilter);
        if (malHistoryPrice.isEmpty()) {
            return null;
        }
        List<Object> dateList = new ArrayList();
        List<Object> historyPriceList = new ArrayList();
        Set<Map.Entry<List<Date>, List<BigDecimal>>> entries = malHistoryPrice.entrySet();
        for (Map.Entry<List<Date>, List<BigDecimal>> entry : entries) {
            dateList = entry.getKey();
            historyPriceList = entry.getValue();
        }
        ArrayList<MalPoint> malPoints = new ArrayList<MalPoint>(dateList.size());
        MalPoint showMalPoint = null;
        for (int i = 0; i < dateList.size(); ++i) {
            BigDecimal price = (BigDecimal)historyPriceList.get(i);
            String date = DateUtil.date2str((Date)((Date)dateList.get(i)), (String)"yyyy-MM-dd");
            MalPoint malPoint = new MalPoint(date, price);
            malPoints.add(malPoint);
            showMalPoint = this.iGetMalTrendPriceService.setShowMalPoint(showMalPoint, malPoint, i);
        }
        MalTrend malTrend = new MalTrend(malPoints, filterTabMap, showMalPoint);
        log.info("\u5546\u54c1id\uff1a{" + malGoods.getId() + "}\u6240\u6784\u5efa\u7684MalTrend:" + SerializationUtils.toJsonString((Object)malTrend));
        return malTrend;
    }

    private Integer getMaxTimeFilter(Map<String, Integer> filterTabMap) {
        int max = 0;
        for (Map.Entry<String, Integer> entry : filterTabMap.entrySet()) {
            if (entry.getValue() <= max) continue;
            max = entry.getValue();
        }
        return max;
    }

    public IGetMalTrendPriceService getIGetMalTrendPriceService() {
        return this.iGetMalTrendPriceService;
    }
}

