/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.domain.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.DateUtil;
import kd.scm.mal.common.util.MalAuthorityUtils;
import kd.scm.mal.domain.model.goods.MalGoods;
import kd.scm.mal.domain.model.trend.MalPoint;
import kd.scm.mal.domain.service.IGetMalTrendPriceService;

public class GetMalDealTrendPriceService
implements IGetMalTrendPriceService {
    private static final Log log = LogFactory.getLog(GetMalDealTrendPriceService.class);

    @Override
    public MalPoint setShowMalPoint(MalPoint showMalPoint, MalPoint newMalPoint, int i) {
        if (i == 0 || showMalPoint.getPointY().compareTo(newMalPoint.getPointY()) > 0) {
            showMalPoint = newMalPoint;
        }
        return showMalPoint;
    }

    @Override
    public Map<String, Integer> getFilterTabMap() {
        LinkedHashMap<String, Integer> filterTabMap = new LinkedHashMap<String, Integer>();
        filterTabMap.put(ResManager.loadKDString((String)"180\u5929", (String)"GetMalDealTrendPriceService_0", (String)"scm-mal-mservice", (Object[])new Object[0]), 180);
        filterTabMap.put(ResManager.loadKDString((String)"90\u5929", (String)"GetMalDealTrendPriceService_1", (String)"scm-mal-mservice", (Object[])new Object[0]), 90);
        filterTabMap.put(ResManager.loadKDString((String)"30\u5929", (String)"GetMalDealTrendPriceService_2", (String)"scm-mal-mservice", (Object[])new Object[0]), 30);
        return filterTabMap;
    }

    @Override
    public Map<List<Date>, List<BigDecimal>> getMalHistoryPrice(MalGoods malGoods, Integer time) {
        Date timeFilter = null;
        if (time > 0) {
            timeFilter = DateUtil.addDays((Date)TimeServiceHelper.now(), (int)(-time.intValue()));
        }
        QFilter qFilter = new QFilter("entryentity.erpbillstatus", "=", (Object)BillStatusEnum.AUDIT.getVal()).or("entryentity.erpbillstatus", "=", (Object)BillStatusEnum.CLOSED.getVal());
        if (null != timeFilter) {
            qFilter.and(new QFilter("auditdate", ">=", (Object)timeFilter));
        }
        qFilter.and(new QFilter("entryentity.goods", "=", (Object)malGoods.getId()));
        List<Long> orgIds = this.getOrgIdsQFilter();
        if (orgIds.contains(malGoods.getOrgId())) {
            orgIds.clear();
            orgIds.add(malGoods.getOrgId());
        } else {
            orgIds.clear();
        }
        qFilter.and(new QFilter("deporg", "in", orgIds));
        QFilter authorityFilter = MalAuthorityUtils.getMalOrderViewAuthorityFilter((String)RequestContext.get().getUserId(), (String)"deporg.id", (String)"mal_order");
        qFilter.and(authorityFilter);
        DynamicObjectCollection malOrderDynColl = QueryServiceHelper.query((String)"mal_order", (String)"id,auditdate,entryentity.goods,deporg,entryentity.erpbillstatus,entryentity.taxprice taxprice", (QFilter[])new QFilter[]{qFilter}, (String)"auditdate");
        ArrayList<BigDecimal> historyDealPriceList = new ArrayList<BigDecimal>(malOrderDynColl.size() * 2);
        ArrayList<Date> dateList = new ArrayList<Date>(malOrderDynColl.size() * 2);
        for (DynamicObject dynamicObject : malOrderDynColl) {
            historyDealPriceList.add(dynamicObject.getBigDecimal("taxprice"));
            dateList.add(dynamicObject.getDate("auditdate"));
        }
        HashMap<List<Date>, List<BigDecimal>> res = new HashMap<List<Date>, List<BigDecimal>>();
        if (dateList.size() > 0 && historyDealPriceList.size() > 0) {
            res.put(dateList, historyDealPriceList);
        }
        log.info("\u5546\u54c1id:{" + malGoods.getId() + "}\u83b7\u53d6" + time + "\u5185\u7684\u5386\u53f2\u6210\u4ea4\u4ef7\u6570\u636e\u4e3a:" + SerializationUtils.toJsonString(res));
        return res;
    }

    private List<Long> getOrgIdsQFilter() {
        List permissionOrgs = PermissionServiceHelper.getAllPermissionOrgs((Long)RequestContext.get().getCurrUserId(), (String)"mal_order", (String)"47150e89000000ac");
        QFilter qFilter = new QFilter("fispurchase", "=", (Object)"1");
        qFilter.and("id", "in", (Object)permissionOrgs);
        ArrayList<Long> purOrgs = new ArrayList<Long>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"orgUtil", (String)"bos_org", (String)"id", (QFilter[])new QFilter[]{qFilter}, (String)"number");){
            dataSet.forEach(row -> purOrgs.add(row.getLong(0)));
        }
        return purOrgs;
    }
}

