/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.domain.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.enums.ConfirmStatusEnum;
import kd.scm.common.util.DateUtil;
import kd.scm.mal.domain.model.goods.MalGoods;
import kd.scm.mal.domain.model.trend.MalPoint;
import kd.scm.mal.domain.service.IGetMalTrendPriceService;

public class GetMalQuoteTrendPriceService
implements IGetMalTrendPriceService {
    private static final Log log = LogFactory.getLog(GetMalQuoteTrendPriceService.class);

    @Override
    public MalPoint setShowMalPoint(MalPoint showMalPoint, MalPoint newMalPoint, int i) {
        if (i == 0 || showMalPoint.getPointY().compareTo(newMalPoint.getPointY()) > 0) {
            showMalPoint = newMalPoint;
        }
        return showMalPoint;
    }

    @Override
    public Map<String, Integer> getFilterTabMap() {
        LinkedHashMap<String, Integer> filterTabMap = new LinkedHashMap<String, Integer>();
        filterTabMap.put(ResManager.loadKDString((String)"180\u5929", (String)"GetMalQuoteTrendPriceService_0", (String)"scm-mal-mservice", (Object[])new Object[0]), 180);
        filterTabMap.put(ResManager.loadKDString((String)"90\u5929", (String)"GetMalQuoteTrendPriceService_1", (String)"scm-mal-mservice", (Object[])new Object[0]), 90);
        filterTabMap.put(ResManager.loadKDString((String)"30\u5929", (String)"GetMalQuoteTrendPriceService_2", (String)"scm-mal-mservice", (Object[])new Object[0]), 30);
        return filterTabMap;
    }

    @Override
    public Map<List<Date>, List<BigDecimal>> getMalHistoryPrice(MalGoods malGoods, Integer time) {
        Date timeFilter = null;
        if (time > 0) {
            timeFilter = DateUtil.addDays((Date)TimeServiceHelper.now(), (int)(-time.intValue()));
        }
        HashMap<List<Date>, List<BigDecimal>> malHistoryPrice = new HashMap();
        if (!EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(malGoods.getPlatform()) && !EcPlatformEnum.UNKNOW.getVal().equals(malGoods.getPlatform())) {
            malHistoryPrice = this.getEcMalHistoryPrice(malGoods, timeFilter);
        } else if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(malGoods.getPlatform())) {
            malHistoryPrice = this.getSelfMalHistoryPrice(malGoods, timeFilter);
        }
        log.info("\u5546\u54c1id\uff1a{" + malGoods.getId() + "}\u7c7b\u578b\u4e3a{" + malGoods.getPlatform() + "}\u83b7\u53d6" + time + "\u5929\u5185\u7684\u5386\u53f2\u62a5\u4ef7\u6570\u636e\uff1a" + SerializationUtils.toJsonString(malHistoryPrice));
        return malHistoryPrice;
    }

    private Map<List<Date>, List<BigDecimal>> getEcMalHistoryPrice(MalGoods malGoods, Date timeFilter) {
        HashMap<List<Date>, List<BigDecimal>> res = new HashMap<List<Date>, List<BigDecimal>>();
        ArrayList<BigDecimal> historyQuotePriceList = new ArrayList<BigDecimal>();
        ArrayList<Date> dateList = new ArrayList<Date>();
        QFilter qFilter = null;
        qFilter = new QFilter("mallgoods", "=", (Object)malGoods.getId());
        if (null != timeFilter) {
            qFilter.and(new QFilter("modifytime", ">=", (Object)timeFilter));
        }
        qFilter.and(new QFilter("modifytime", ">=", (Object)malGoods.getCreateTime()));
        DynamicObjectCollection mallGoodsPriceDynColl = QueryServiceHelper.query((String)"pbd_mallgoods_pricelog", (String)"id,mallgoods,price,modifytime", (QFilter[])new QFilter[]{qFilter}, (String)"modifytime");
        for (DynamicObject dynamicObject : mallGoodsPriceDynColl) {
            BigDecimal price = dynamicObject.getBigDecimal("price");
            historyQuotePriceList.add(price);
            dateList.add(dynamicObject.getDate("modifytime"));
        }
        if (null != malGoods.getPriceModifyTime() && (null == timeFilter || malGoods.getPriceModifyTime().after(timeFilter))) {
            dateList.add(malGoods.getPriceModifyTime());
            BigDecimal currentPrice = malGoods.getTaxPrice();
            historyQuotePriceList.add(currentPrice);
        }
        if (dateList.size() > 0 && historyQuotePriceList.size() > 0) {
            res.put(dateList, historyQuotePriceList);
        }
        return res;
    }

    private Map<List<Date>, List<BigDecimal>> getSelfMalHistoryPrice(MalGoods malGoods, Date timeFilter) {
        HashMap<List<Date>, List<BigDecimal>> res = new HashMap<List<Date>, List<BigDecimal>>();
        DynamicObjectCollection mallGoodsPrice = null;
        DynamicObjectCollection firstGoodsPrice = null;
        ArrayList<BigDecimal> historyQuotePriceList = new ArrayList<BigDecimal>();
        ArrayList<Date> dateList = new ArrayList<Date>();
        QFilter qFilter = null;
        long prodPoolId = malGoods.getGoodsInfo().getProdPoolId();
        qFilter = new QFilter("entryentity.goods", "=", (Object)malGoods.getId());
        qFilter.and(new QFilter("goodspool", "=", (Object)prodPoolId));
        if (null != timeFilter) {
            qFilter.and(new QFilter("adjustdate", ">=", (Object)timeFilter));
        }
        String selectors = "taxprice,lastprice,adjustdate";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getSelfMalHistoryPrice", (String)"pmm_newpricelog", (String)selectors, (QFilter[])qFilter.toArray(), (String)"adjustdate asc");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                historyQuotePriceList.add(row.getBigDecimal("taxprice"));
                dateList.add(row.getDate("adjustdate"));
            }
        }
        if (dateList.size() == 0) {
            qFilter = new QFilter("entryentity.goods", "=", (Object)malGoods.getId());
            if (0L != prodPoolId) {
                qFilter.and(new QFilter("entryentity.prodpool", "=", (Object)prodPoolId));
            }
            qFilter.and(new QFilter("cfmstatus", "=", (Object)ConfirmStatusEnum.CONFIRM.getVal()));
            if (null != timeFilter) {
                qFilter.and(new QFilter("cfmdate", ">=", (Object)timeFilter));
            }
            if (!(firstGoodsPrice = QueryServiceHelper.query((String)"pmm_priceaudit", (String)"id,cfmdate,entryentity.taxprice_old", (QFilter[])new QFilter[]{new QFilter("entryentity.goods", "=", (Object)malGoods.getId()).and(new QFilter("cfmstatus", "=", (Object)ConfirmStatusEnum.CONFIRM.getVal()))}, (String)"cfmdate", (int)1)).isEmpty()) {
                mallGoodsPrice = QueryServiceHelper.query((String)"pmm_priceaudit", (String)"id,cfmdate,entryentity.taxprice price", (QFilter[])new QFilter[]{qFilter}, (String)"cfmdate");
            }
            if (mallGoodsPrice != null && !mallGoodsPrice.isEmpty()) {
                if (firstGoodsPrice.size() > 0 && StringUtils.equals((CharSequence)((DynamicObject)firstGoodsPrice.get(0)).getString("id"), (CharSequence)((DynamicObject)mallGoodsPrice.get(0)).getString("id")) && (null == timeFilter || malGoods.getCreateTime().after(timeFilter))) {
                    Iterator dynamicObject = (DynamicObject)firstGoodsPrice.get(0);
                    BigDecimal oldTaxPrice = dynamicObject.getBigDecimal("entryentity.taxprice_old");
                    historyQuotePriceList.add(oldTaxPrice);
                    dateList.add(malGoods.getCreateTime());
                }
                for (DynamicObject dynamicObject : mallGoodsPrice) {
                    BigDecimal price = dynamicObject.getBigDecimal("price");
                    historyQuotePriceList.add(price);
                    dateList.add(dynamicObject.getDate("cfmdate"));
                }
            }
            if (dateList.isEmpty() && (null == timeFilter || malGoods.getCreateTime().after(timeFilter))) {
                BigDecimal firstPrice = malGoods.getTaxPrice();
                Date auditDate = malGoods.getCreateTime();
                dateList.add(auditDate);
                historyQuotePriceList.add(firstPrice);
            }
        }
        if (dateList.size() > 0 && historyQuotePriceList.size() > 0) {
            res.put(dateList, historyQuotePriceList);
        }
        return res;
    }
}

