/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.domain.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.cardentry.CardEntryFieldAp;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.mal.domain.model.compare.ComparePriceInfo;
import kd.scm.mal.domain.model.compare.MalCompareDetail;
import kd.scm.mal.domain.model.compare.MalCompareRecord;
import kd.scm.mal.domain.model.goods.MalGoods;
import kd.scm.mal.domain.model.goods.MalMatGoodsInitParam;
import kd.scm.mal.domain.service.IMalCompareService;
import kd.scm.malcore.domain.LadderPriceInfo;

public class MalCompareService
implements IMalCompareService {
    private static final Log log = LogFactory.getLog(MalCompareService.class);
    private static final int DEFAULT_MAX_COMPARE_ROWS = 4;
    private String MAL_COMPAREPRICE = "mal_compareprice";

    @Override
    public int addCompareRecord(Long goodsId, Long opUserId, int expire) {
        Set<Long> goodsIds = Stream.of(goodsId).collect(Collectors.toSet());
        List<MalCompareRecord> malCompareRecords = this.queryCompareRecords(opUserId, null, null, null);
        int maxCompareRows = this.getMaxCompareRows();
        if (malCompareRecords.size() >= maxCompareRows) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6bcf\u6b21\u53ef\u5bf9\u6bd4{0}\u4e2a\u5546\u54c1\uff0c\u8bf7\u70b9\u51fb\u5bf9\u6bd4\u680f\u8fdb\u884c\u5bf9\u6bd4\u3002", (String)"MalCompareService_0", (String)"scm-mal-business", (Object[])new Object[]{maxCompareRows}));
        }
        if (malCompareRecords.stream().anyMatch(malCompareRecord -> malCompareRecord.getGoodsId().equals(goodsId))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u5546\u54c1\u5df2\u5728\u5bf9\u6bd4\u8bb0\u5f55\u4e2d\u3002", (String)"MalCompareService_1", (String)"scm-mal-business", (Object[])new Object[]{maxCompareRows}));
        }
        MalGoods.syncEcGoodsToGoodsManage(goodsIds);
        MalCompareRecord.addCompareRecord(goodsId, opUserId, expire);
        return malCompareRecords.size() + 1;
    }

    @Override
    public int addCompareRecords(Set<Long> goodsIds, Long opUserId, int expire) {
        List<MalCompareRecord> malCompareRecords = this.queryCompareRecords(opUserId, null, null, null);
        int maxCompareRows = this.getMaxCompareRows();
        if (malCompareRecords.size() >= maxCompareRows) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6bcf\u6b21\u53ef\u5bf9\u6bd4{0}\u4e2a\u5546\u54c1\uff0c\u8bf7\u70b9\u51fb\u5bf9\u6bd4\u680f\u8fdb\u884c\u5bf9\u6bd4\u3002", (String)"MalCompareService_0", (String)"scm-mal-business", (Object[])new Object[]{maxCompareRows}));
        }
        HashSet<Long> newGoodsIds = new HashSet<Long>(104);
        for (Long goodsId : goodsIds) {
            if (malCompareRecords.stream().anyMatch(malCompareRecord -> malCompareRecord.getGoodsId().equals(goodsId))) continue;
            newGoodsIds.add(goodsId);
        }
        MalGoods.syncEcGoodsToGoodsManage(goodsIds);
        MalCompareRecord.addCompareRecords(newGoodsIds, opUserId, expire);
        return malCompareRecords.size() + 1;
    }

    public int getMaxCompareRows() {
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)"mal_newshop", (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        List entitys = entityMetadata.getEntitys();
        for (Entity entity : entitys) {
            if (!(entity instanceof EntryEntity) || !"compare_entryentity".equals(entity.getKey())) continue;
            return ((EntryEntity)entity).getDefaultRows();
        }
        return 4;
    }

    private void deleteExpiredCompareRecords(Long opUserId, List<MalCompareRecord> malCompareRecords) {
        Set<Long> recordIdSet = malCompareRecords.stream().filter(malCompareRecord -> KDDateUtils.addMinutes((Date)malCompareRecord.getOpTime(), (int)malCompareRecord.getExpire()).before(TimeServiceHelper.now())).map(MalCompareRecord::getId).collect(Collectors.toSet());
        log.info("\u5220\u9664\u5f53\u524d\u7528\u6237\u8fc7\u671f\u5bf9\u6bd4\u8bb0\u5f55\uff1a" + opUserId + recordIdSet);
        if (recordIdSet.isEmpty()) {
            return;
        }
        MalCompareRecord.executeOp("delete", "mal_compare_record", recordIdSet);
        malCompareRecords.removeIf(malCompareRecord -> recordIdSet.contains(malCompareRecord.getId()));
    }

    @Override
    public void deleteCompareRecords(Set<Long> goodsIds, Long opUserId) {
        List<MalCompareRecord> malCompareRecords = this.queryCompareRecords(opUserId, goodsIds, null, null);
        Set<Long> recordIdSet = malCompareRecords.stream().map(MalCompareRecord::getId).collect(Collectors.toSet());
        if (recordIdSet.isEmpty()) {
            return;
        }
        MalCompareRecord.executeOp("delete", "mal_compare_record", recordIdSet);
    }

    @Override
    public List<MalCompareRecord> queryCurrentUserCompareRecords() {
        return this.queryCompareRecords(RequestContext.get().getCurrUserId(), null, null, null);
    }

    @Override
    public List<MalCompareRecord> queryCompareRecords(Long opUserId, Set<Long> goodsIds, Date fromDate, Date toDate) {
        ArrayList<MalCompareRecord> res = new ArrayList<MalCompareRecord>();
        Objects.requireNonNull(opUserId);
        QFilter filter = new QFilter("opuser", "=", (Object)opUserId);
        if (!ObjectUtils.isEmpty(goodsIds)) {
            filter.and("goods", "in", goodsIds);
        }
        if (fromDate != null) {
            filter.and("optime", ">", (Object)fromDate);
        }
        if (toDate != null) {
            filter.and("optime", "<", (Object)toDate);
        }
        DynamicObjectCollection malCompareRecordDynCol = QueryServiceHelper.query((String)"mal_compare_record", (String)"id,goods,goods.id,goods.number,goods.source,opuser,optime,expire", (QFilter[])new QFilter[]{filter}, (String)"optime");
        for (DynamicObject malCompareRecordDyn : malCompareRecordDynCol) {
            res.add(new MalCompareRecord(malCompareRecordDyn));
        }
        this.deleteExpiredCompareRecords(opUserId, res);
        return res;
    }

    @Override
    public List<MalGoods> getSimpleCompareGoods(Long opUserId) {
        List<MalCompareRecord> malCompareRecords = this.queryCurrentUserCompareRecords();
        Set<Long> goodsIds = malCompareRecords.stream().map(MalCompareRecord::getGoodsId).collect(Collectors.toSet());
        ArrayList<MalGoods> res = new ArrayList<MalGoods>(MalGoods.batchInstance(goodsIds, false, false).values());
        return this.sortByOpTime(malCompareRecords, res);
    }

    @Override
    public List<MalGoods> getSimpleCompareGoods(Long opUserId, Long orgId) {
        List<MalCompareRecord> malCompareRecords = this.queryCurrentUserCompareRecords();
        Set<Long> goodsIds = malCompareRecords.stream().map(MalCompareRecord::getGoodsId).collect(Collectors.toSet());
        ArrayList<MalGoods> res = new ArrayList<MalGoods>(MalGoods.batchInstance(goodsIds, false, false, orgId).values());
        return this.sortByOpTime(malCompareRecords, res);
    }

    private List<MalGoods> sortByOpTime(List<MalCompareRecord> malCompareRecords, List<MalGoods> malGoodsList) {
        ArrayList<MalGoods> res = new ArrayList<MalGoods>();
        for (MalCompareRecord malCompareRecord : malCompareRecords) {
            for (MalGoods malGoods : malGoodsList) {
                if (!malCompareRecord.getGoodsId().equals(malGoods.getId())) continue;
                res.add(malGoods);
            }
        }
        return res;
    }

    @Override
    public List<MalGoods> getDetailCompareGoods(Long opUserId) {
        List<MalCompareRecord> malCompareRecords = this.queryCompareRecords(opUserId, null, null, null);
        Set<Long> goodsIds = malCompareRecords.stream().map(MalCompareRecord::getGoodsId).collect(Collectors.toSet());
        ArrayList<MalGoods> res = new ArrayList<MalGoods>(MalGoods.batchInstance(goodsIds, true, false).values());
        return this.sortByOpTime(malCompareRecords, res);
    }

    @Override
    public List<MalGoods> getDetailCompareGoods(Long opUserId, Long orgId) {
        List<MalCompareRecord> malCompareRecords = this.queryCompareRecords(opUserId, null, null, null);
        Set<Long> goodsIds = malCompareRecords.stream().map(MalCompareRecord::getGoodsId).collect(Collectors.toSet());
        ArrayList<MalGoods> res = new ArrayList<MalGoods>(MalGoods.batchInstance(goodsIds, true, false, orgId).values());
        return this.sortByOpTime(malCompareRecords, res);
    }

    @Override
    public List<MalGoods> getDetailCompareGoods(Long opUserId, Long orgId, BigDecimal qty) {
        List<MalCompareRecord> malCompareRecords = this.queryCompareRecords(opUserId, null, null, null);
        ArrayList<MalMatGoodsInitParam> malMatGoodsInitParams = new ArrayList<MalMatGoodsInitParam>(1024);
        for (MalCompareRecord malCompareRecord : malCompareRecords) {
            malMatGoodsInitParams.add(MalMatGoodsInitParam.buildGeneralParam(malCompareRecord.getGoodsId(), malCompareRecord.getSource(), qty, null, orgId));
        }
        Map<Long, MalGoods> malGoodsMap = MalGoods.batchInstance(malMatGoodsInitParams, true, false);
        ArrayList<MalGoods> res = new ArrayList<MalGoods>(malGoodsMap.values());
        return this.sortByOpTime(malCompareRecords, res);
    }

    @Override
    public void validateCompareGoods(Long opUserId) {
        List<MalGoods> malGoodsList = this.getSimpleCompareGoods(opUserId);
        StringBuilder invalidGoods = new StringBuilder();
        HashSet<Long> invalidGoodsIdSet = new HashSet<Long>(malGoodsList.size());
        for (MalGoods malGoods : malGoodsList) {
            if (malGoods.validateMallStatus()) continue;
            invalidGoods.append(malGoods.getName()).append(' ');
            invalidGoodsIdSet.add(malGoods.getId());
        }
        if (invalidGoods.length() > 0) {
            this.deleteCompareRecords(invalidGoodsIdSet, RequestContext.get().getCurrUserId());
            throw new KDBizException(ResManager.loadKDString((String)"\u5546\u54c1{0}\u5df2\u5931\u6548\uff0c\u5df2\u4ece\u5bf9\u6bd4\u680f\u6e05\u7a7a\u8be5\u5546\u54c1\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5bf9\u6bd4\u5546\u54c1\u3002", (String)"MalCompareService_2", (String)"scm-mal-business", (Object[])new Object[]{" " + invalidGoods}));
        }
    }

    @Override
    public Long addComparePriceRecord(Long goodsId, Long opUserId, Long compareId, Long orgId) {
        Date now = TimeServiceHelper.now();
        QFilter compareFilter = new QFilter("id", "=", (Object)compareId);
        compareFilter.and(new QFilter("org", "=", (Object)orgId));
        boolean isExists = QueryServiceHelper.exists((String)this.MAL_COMPAREPRICE, (QFilter[])compareFilter.toArray());
        DynamicObject comparePrice = null;
        if (isExists) {
            String selectors = DynamicObjectUtil.getSelectfields((String)this.MAL_COMPAREPRICE, (boolean)false);
            selectors = DynamicObjectUtil.getEntrySelectfields((String)selectors, (String)this.MAL_COMPAREPRICE, (String)"entryentity", (boolean)false);
            comparePrice = BusinessDataServiceHelper.load((String)this.MAL_COMPAREPRICE, (String)selectors, (QFilter[])compareFilter.toArray())[0];
        } else {
            comparePrice = BusinessDataServiceHelper.newDynamicObject((String)this.MAL_COMPAREPRICE);
        }
        comparePrice.set("creator_id", (Object)opUserId);
        comparePrice.set("createtime", (Object)now);
        comparePrice.set("org_id", (Object)orgId);
        this.setComparePriceEntryInfo(comparePrice, goodsId, opUserId, orgId, null);
        if (comparePrice.getDynamicObjectCollection("entryentity").size() <= 1) {
            return 0L;
        }
        DynamicObject[] saveObj = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{comparePrice});
        return saveObj[0].getLong("id");
    }

    @Override
    public void deleteComparePriceRecord(Long goodsId, Long compareId, Long orgId) {
        QFilter compareFilter = new QFilter("id", "=", (Object)compareId);
        compareFilter.and(new QFilter("org", "=", (Object)orgId));
        String selectors = DynamicObjectUtil.getSelectfields((String)this.MAL_COMPAREPRICE, (boolean)false);
        selectors = DynamicObjectUtil.getEntrySelectfields((String)selectors, (String)this.MAL_COMPAREPRICE, (String)"entryentity", (boolean)false);
        DynamicObject[] comparePrices = BusinessDataServiceHelper.load((String)this.MAL_COMPAREPRICE, (String)selectors, (QFilter[])compareFilter.toArray());
        if (comparePrices.length > 0) {
            DynamicObject comparePrice = comparePrices[0];
            DynamicObjectCollection entrys = comparePrice.getDynamicObjectCollection("entryentity");
            DynamicObject removeObj = null;
            for (DynamicObject row : entrys) {
                if (!goodsId.equals(row.getLong("goods_id"))) continue;
                removeObj = row;
                break;
            }
            if (removeObj != null) {
                entrys.remove(removeObj);
            }
            String comparedetailshot = comparePrice.getString("comparedetailshot");
            ArrayList<Map> newCompareDetailshots = new ArrayList<Map>(1024);
            if (!StringUtils.isEmpty((CharSequence)comparedetailshot)) {
                List comparedetailshots = SerializationUtils.fromJsonStringToList((String)comparedetailshot, Map.class);
                for (Map comparedetailshotMap : comparedetailshots) {
                    if (comparedetailshotMap.get("goods").equals(goodsId)) continue;
                    newCompareDetailshots.add(comparedetailshotMap);
                }
            }
            boolean isDelete = true;
            for (DynamicObject row : entrys) {
                if (!row.getBoolean("isadd")) continue;
                isDelete = false;
            }
            if (isDelete || entrys.size() == 1) {
                DeleteServiceHelper.delete((IDataEntityType)comparePrice.getDataEntityType(), (Object[])new Object[]{comparePrice.getPkValue()});
                log.info("delete=" + comparePrice.getPkValue());
            } else {
                if (!StringUtils.isEmpty((CharSequence)comparedetailshot)) {
                    comparePrice.set("comparedetailshot", (Object)SerializationUtils.toJsonString(newCompareDetailshots));
                }
                SaveServiceHelper.save((DynamicObject[])comparePrices);
            }
        }
    }

    @Override
    public List<ComparePriceInfo> queryComparePriceRecordShot(Long compareId) {
        QFilter compareFilter = new QFilter("id", "=", (Object)compareId);
        String selectors = "comparedetailshot_tag,entryentity.goods.name,entryentity.compareresult,entryentity.remark,creator,creator.name,createtime,org,entryentity.goods.unit,entryentity.goods.source,entryentity.goods,entryentity.goods.model,entryentity.goods.number,entryentity.goods.thumbnail,entryentity.supplier,entryentity.ladderprice,entryentity.price,id";
        DynamicObjectCollection comparePrices = QueryServiceHelper.query((String)this.MAL_COMPAREPRICE, (String)selectors, (QFilter[])compareFilter.toArray());
        ArrayList<ComparePriceInfo> infoList = new ArrayList<ComparePriceInfo>(1024);
        for (DynamicObject row : comparePrices) {
            Long id = row.getLong("id");
            ComparePriceInfo info = new ComparePriceInfo();
            info.setCompareDate(row.getDate("createtime"));
            info.setCompareOrg(row.getLong("org"));
            info.setComparePerson(row.getLong("creator"));
            info.setGoodsId(row.getLong("entryentity.goods"));
            info.setSupplierId(row.getLong("entryentity.supplier"));
            info.setPrice(row.getBigDecimal("entryentity.price"));
            info.setGoodsDesc(row.getString("entryentity.goods.model"));
            info.setGoodsNumber(row.getString("entryentity.goods.number"));
            info.setGoodsPic(row.getString("entryentity.goods.thumbnail"));
            info.setGoodsUnit(row.getLong("entryentity.goods.unit"));
            info.setGoodsSource(row.getString("entryentity.goods.source"));
            info.setComparePersonName(row.getString("creator.name"));
            info.setGoodsName(row.getString("entryentity.goods.name"));
            info.setPageId(row.getLong("id"));
            info.setRemark(row.getString("entryentity.remark"));
            info.setCompareResult(row.getString("entryentity.compareresult"));
            info.setCompareDetailShot(row.getString("comparedetailshot_tag"));
            infoList.add(info);
        }
        return infoList;
    }

    @Override
    public Long addComparePriceRecord(Long goodsId, Long opUserId, Long compareId, Long orgId, List<Map<String, Object>> shots) {
        Date now = TimeServiceHelper.now();
        QFilter compareFilter = new QFilter("id", "=", (Object)compareId);
        compareFilter.and(new QFilter("org", "=", (Object)orgId));
        boolean isExists = QueryServiceHelper.exists((String)this.MAL_COMPAREPRICE, (QFilter[])compareFilter.toArray());
        DynamicObject comparePrice = null;
        if (isExists) {
            String selectors = DynamicObjectUtil.getSelectfields((String)this.MAL_COMPAREPRICE, (boolean)false);
            selectors = DynamicObjectUtil.getEntrySelectfields((String)selectors, (String)this.MAL_COMPAREPRICE, (String)"entryentity", (boolean)false);
            comparePrice = BusinessDataServiceHelper.load((String)this.MAL_COMPAREPRICE, (String)selectors, (QFilter[])compareFilter.toArray())[0];
        } else {
            comparePrice = BusinessDataServiceHelper.newDynamicObject((String)this.MAL_COMPAREPRICE);
        }
        comparePrice.set("creator_id", (Object)opUserId);
        comparePrice.set("createtime", (Object)now);
        comparePrice.set("org_id", (Object)orgId);
        comparePrice.set("comparedetailshot_tag", (Object)SerializationUtils.toJsonString(shots));
        this.setComparePriceEntryInfo(comparePrice, goodsId, opUserId, orgId, shots);
        if (comparePrice.getDynamicObjectCollection("entryentity").size() <= 1) {
            return 0L;
        }
        DynamicObjectCollection entryentity = comparePrice.getDynamicObjectCollection("entryentity");
        for (DynamicObject row : entryentity) {
            for (Map<String, Object> shopMap : shots) {
                if (!row.getString("goods_id").equals(shopMap.get("goods"))) continue;
                row.set("addqty", shopMap.get("addqty"));
                row.set("price", shopMap.get("price"));
                row.set("ladderprice", shopMap.get("price"));
            }
        }
        DynamicObject[] saveObj = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{comparePrice});
        return saveObj[0].getLong("id");
    }

    @Override
    public Map<Long, List<ComparePriceInfo>> queryComparePriceRecord(List<Long> goodsIds, Long orgId, Set<Long> compareIds) {
        QFilter compareFilter = new QFilter("org", "=", (Object)orgId);
        ArrayList<Long> comparesList = new ArrayList<Long>(compareIds);
        if (compareIds.size() > 1 || compareIds.size() == 1 && !((Long)comparesList.get(0)).equals(0L)) {
            compareFilter.and(new QFilter("id", "in", compareIds));
        }
        compareFilter.and(new QFilter("entryentity.goods", "in", goodsIds));
        compareFilter.and(new QFilter("entryentity.isadd", "=", (Object)Boolean.TRUE));
        DynamicObjectCollection comparePrices = QueryServiceHelper.query((String)"mal_compareprice", (String)"createtime,id,entryentity.goods", (QFilter[])compareFilter.toArray(), (String)"createtime asc");
        HashMap<Long, Long> goodsId_compareIdMap = new HashMap<Long, Long>(1024);
        HashSet<Long> newCompareIds = new HashSet<Long>(1024);
        for (DynamicObject row : comparePrices) {
            goodsId_compareIdMap.put(row.getLong("entryentity.goods"), row.getLong("id"));
            newCompareIds.add(row.getLong("id"));
        }
        HashMap<Long, List<ComparePriceInfo>> goodsId_infoMap = new HashMap<Long, List<ComparePriceInfo>>(1024);
        HashMap compareId_infoMap = new HashMap(1024);
        if (compareIds.size() > 0) {
            compareFilter = new QFilter("id", "in", newCompareIds);
            String selectors = "entryentity.goods.name,entryentity.compareresult,entryentity.remark,creator,creator.name,createtime,org,entryentity.goods.unit,entryentity.goods.source,entryentity.goods,entryentity.goods.model,entryentity.goods.number,entryentity.goods.thumbnail,entryentity.supplier,entryentity.ladderprice,entryentity.price,id";
            comparePrices = QueryServiceHelper.query((String)"mal_compareprice", (String)selectors, (QFilter[])compareFilter.toArray());
            for (DynamicObject row : comparePrices) {
                Long id = row.getLong("id");
                ComparePriceInfo info = new ComparePriceInfo();
                info.setCompareDate(row.getDate("createtime"));
                info.setCompareOrg(row.getLong("org"));
                info.setComparePerson(row.getLong("creator"));
                info.setGoodsId(row.getLong("entryentity.goods"));
                info.setSupplierId(row.getLong("entryentity.supplier"));
                info.setPrice(row.getBigDecimal("entryentity.price"));
                info.setGoodsDesc(row.getString("entryentity.goods.model"));
                info.setGoodsNumber(row.getString("entryentity.goods.number"));
                info.setGoodsPic(row.getString("entryentity.goods.thumbnail"));
                info.setGoodsUnit(row.getLong("entryentity.goods.unit"));
                info.setGoodsSource(row.getString("entryentity.goods.source"));
                info.setComparePersonName(row.getString("creator.name"));
                info.setGoodsName(row.getString("entryentity.goods.name"));
                info.setPageId(row.getLong("id"));
                info.setRemark(row.getString("entryentity.remark"));
                info.setCompareResult(row.getString("entryentity.compareresult"));
                List<ComparePriceInfo> infoList = new ArrayList<ComparePriceInfo>(1024);
                if (null != compareId_infoMap.get(id)) {
                    infoList = (List)compareId_infoMap.get(id);
                }
                infoList.add(info);
                compareId_infoMap.put(id, infoList);
            }
        }
        for (Map.Entry map : goodsId_compareIdMap.entrySet()) {
            Long comparepriceId = (Long)map.getValue();
            if (null == compareId_infoMap.get(comparepriceId)) continue;
            goodsId_infoMap.put((Long)map.getKey(), (List<ComparePriceInfo>)compareId_infoMap.get(comparepriceId));
        }
        return goodsId_infoMap;
    }

    @Override
    public Map<Long, Long> addComparePriceRecord(Map<Long, List<Long>> goodsMap, Long opUserId, Long orgId) {
        HashSet<Long> goodsIds = new HashSet<Long>(16);
        for (Map.Entry<Long, List<Long>> map : goodsMap.entrySet()) {
            goodsIds.add(map.getKey());
            goodsIds.addAll((Collection<Long>)map.getValue());
        }
        Map<Long, List<LadderPriceInfo>> goodsLadMap = MalGoods.batchGetLadderPrice(new ArrayList<Long>(goodsIds), orgId);
        Map<Long, MalGoods> malGoodsMap = MalGoods.batchInstance(goodsIds, true, false, orgId);
        ArrayList<DynamicObject> addComparePriceList = new ArrayList<DynamicObject>(16);
        HashMap<Long, Long> goodsId_CompareIdMap = new HashMap<Long, Long>(16);
        HashSet<Long> compareGoodsId = new HashSet<Long>(16);
        for (Map.Entry<Long, List<Long>> map : goodsMap.entrySet()) {
            DynamicObject comparePriceInfo = this.getComparePriceInfo(map, malGoodsMap, opUserId, orgId, goodsLadMap);
            if (null == comparePriceInfo) continue;
            addComparePriceList.add(comparePriceInfo);
            compareGoodsId.add(map.getKey());
        }
        if (addComparePriceList.size() > 0) {
            DynamicObject[] saveDyns;
            block2: for (DynamicObject info : saveDyns = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])addComparePriceList.toArray(new DynamicObject[0]))) {
                DynamicObjectCollection rows = info.getDynamicObjectCollection("entryentity");
                for (DynamicObject row : rows) {
                    if (null == row.get("goods_id") || !compareGoodsId.contains(row.getLong("goods_id")) || !row.getBoolean("isadd")) continue;
                    goodsId_CompareIdMap.put(row.getLong("goods_id"), info.getLong("id"));
                    continue block2;
                }
            }
        }
        return goodsId_CompareIdMap;
    }

    private DynamicObject getComparePriceInfo(Map.Entry<Long, List<Long>> map, Map<Long, MalGoods> malGoodsMap, Long opUserId, Long orgId, Map<Long, List<LadderPriceInfo>> goodsLadMap) {
        DynamicObject mal_compare = ORM.create().newDynamicObject("mal_compare_detail");
        MalCompareDetail malCompareDetail = new MalCompareDetail(mal_compare);
        DynamicObject comparePrice = BusinessDataServiceHelper.newDynamicObject((String)this.MAL_COMPAREPRICE);
        List<String> compareDims = this.getCompareDims();
        ArrayList<Map<String, Object>> compareDeatilShop = new ArrayList<Map<String, Object>>(1024);
        ArrayList<MalGoods> malGoodsList = new ArrayList<MalGoods>(16);
        for (Long goodsId : map.getValue()) {
            malGoodsList.add(malGoodsMap.get(goodsId));
        }
        malGoodsList.add(malGoodsMap.get(map.getKey()));
        map.getValue().add(map.getKey());
        for (Long goodsId : map.getValue()) {
            HashMap<String, Object> compareDeatilShotMap = new HashMap<String, Object>(16);
            MalGoods malGoods = malGoodsMap.get(goodsId);
            for (String compareDim : compareDims) {
                Object value = malCompareDetail.handleDim(compareDim, malGoods, malGoodsList);
                if (value == null) continue;
                compareDeatilShotMap.put(compareDim, value);
            }
            compareDeatilShotMap.put("addqty", BigDecimal.ONE);
            compareDeatilShop.add(compareDeatilShotMap);
            if (null == goodsLadMap.get(Long.parseLong(malGoods.getProductId()))) continue;
            compareDeatilShotMap.put("ladprice", goodsLadMap.get(Long.parseLong(malGoods.getProductId())));
        }
        comparePrice.set("creator_id", (Object)opUserId);
        comparePrice.set("createtime", (Object)TimeServiceHelper.now());
        comparePrice.set("org_id", (Object)orgId);
        comparePrice.set("comparedetailshot_tag", (Object)SerializationUtils.toJsonString(compareDeatilShop));
        this.setComparePriceEntryInfo(comparePrice, malGoodsMap, map, compareDeatilShop);
        if (comparePrice.getDynamicObjectCollection("entryentity").size() <= 1) {
            return null;
        }
        DynamicObjectCollection entryentity = comparePrice.getDynamicObjectCollection("entryentity");
        for (DynamicObject row : entryentity) {
            for (Map map2 : compareDeatilShop) {
                if (!row.getString("goods_id").equals(map2.get("goods"))) continue;
                row.set("addqty", map2.get("addqty"));
                row.set("price", map2.get("price"));
                row.set("ladderprice", map2.get("price"));
            }
        }
        return comparePrice;
    }

    private void setComparePriceEntryInfo(DynamicObject comparePrice, Map<Long, MalGoods> malGoodsMap, Map.Entry<Long, List<Long>> dataMap, List<Map<String, Object>> compareDeatilShop) {
        ArrayList goodsIds = new ArrayList(16);
        goodsIds.addAll(dataMap.getValue());
        BigDecimal min = BigDecimal.ZERO;
        BigDecimal max = BigDecimal.ZERO;
        for (Map.Entry<Long, MalGoods> map : malGoodsMap.entrySet()) {
            if (!goodsIds.contains(map.getKey())) continue;
            MalGoods malGoods = map.getValue();
            BigDecimal price = malGoods.getTaxPrice();
            if (price.compareTo(min) <= 0 || min.compareTo(BigDecimal.ZERO) == 0) {
                min = price;
            }
            if (price.compareTo(max) < 0) continue;
            max = price;
        }
        DynamicObjectCollection entryCol = comparePrice.getDynamicObjectCollection("entryentity");
        HashSet<Long> goodsIdSet = new HashSet<Long>(1024);
        for (DynamicObject row : entryCol) {
            if (!row.getBoolean("isadd")) continue;
            goodsIdSet.add(row.getLong("goods_id"));
        }
        entryCol.clear();
        Long selectGoodIds = dataMap.getKey();
        for (Long goodsId : goodsIds) {
            DynamicObject row = entryCol.addNew();
            MalGoods malGoods = malGoodsMap.get(goodsId);
            long compareGoodsId = Long.parseLong(malGoods.getProductId());
            row.set("goods_id", (Object)compareGoodsId);
            row.set("supplier_id", (Object)Long.parseLong(malGoods.getSupplierId()));
            row.set("addqty", (Object)BigDecimal.ONE);
            row.set("unit_id", (Object)malGoods.getUnitId());
            row.set("currency_id", (Object)malGoods.getCurrency());
            if (selectGoodIds == compareGoodsId || goodsIdSet.contains(compareGoodsId)) {
                row.set("isadd", (Object)Boolean.TRUE);
            } else {
                row.set("isadd", (Object)Boolean.FALSE);
            }
            BigDecimal taxPrice = malGoods.getTaxPrice();
            row.set("price", (Object)taxPrice);
            if (null == compareDeatilShop || compareDeatilShop.size() <= 0) continue;
            for (Map<String, Object> shopMap : compareDeatilShop) {
                if (!row.getString("goods_id").equals(String.valueOf(shopMap.get("goods"))) || null == shopMap.get("addqty")) continue;
                row.set("addqty", shopMap.get("addqty"));
                row.set("price", shopMap.get("price"));
                row.set("ladderprice", shopMap.get("price"));
            }
        }
        for (DynamicObject row : entryCol) {
            BigDecimal taxPrice = row.getBigDecimal("price");
            if (min.compareTo(max) == 0) break;
            if (!row.getBoolean("isadd")) continue;
            row.set("remark", (Object)"");
            if (taxPrice.compareTo(min) == 0) {
                row.set("remark", (Object)ResManager.loadKDString((String)"\u6700\u4f4e\u4ef7", (String)"MalCompareService_3", (String)"scm-mal-business", (Object[])new Object[0]));
                row.set("compareresult", (Object)1);
            }
            if (taxPrice.compareTo(max) != 0) continue;
            row.set("remark", (Object)ResManager.loadKDString((String)"\u6700\u9ad8\u4ef7", (String)"MalCompareService_4", (String)"scm-mal-business", (Object[])new Object[0]));
            row.set("compareresult", (Object)0);
        }
    }

    private List<String> getCompareDims() {
        ArrayList<String> res = new ArrayList<String>();
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)"mal_compare_detail", (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        List controlAps = formMeta.getItems();
        for (ControlAp controlAp : controlAps) {
            if (!(controlAp instanceof CardEntryFieldAp) || controlAp.isHidden()) continue;
            res.add(controlAp.getKey());
        }
        return res;
    }

    private void setComparePriceEntryInfo(DynamicObject comparePrice, Long goodsId, Long opUserId, Long orgId, List<Map<String, Object>> shots) {
        BigDecimal one = BigDecimal.ONE;
        QFilter filter = new QFilter("opuser", "=", (Object)opUserId);
        DynamicObjectCollection malCompareRecordDynCol = QueryServiceHelper.query((String)"mal_compare_record", (String)"id,goods.id,goods.number,goods.supplier.id,goods.unit.id,goods.curr.id,goods.source", (QFilter[])filter.toArray());
        ArrayList<MalMatGoodsInitParam> malMatGoodsInitParams = new ArrayList<MalMatGoodsInitParam>(1024);
        for (DynamicObject info : malCompareRecordDynCol) {
            MalMatGoodsInitParam param = MalMatGoodsInitParam.buildGeneralParam(info.getLong("goods.id"), info.getString("goods.source"), one, null, orgId);
            malMatGoodsInitParams.add(param);
        }
        Map<Long, MalGoods> malGoodsMap = MalGoods.batchInstance(malMatGoodsInitParams, false, false);
        BigDecimal min = BigDecimal.ZERO;
        BigDecimal max = BigDecimal.ZERO;
        for (Map.Entry<Long, MalGoods> map : malGoodsMap.entrySet()) {
            MalGoods malGoods = map.getValue();
            BigDecimal price = malGoods.getTaxPrice();
            if (price.compareTo(min) <= 0 || min.compareTo(BigDecimal.ZERO) == 0) {
                min = price;
            }
            if (price.compareTo(max) < 0) continue;
            max = price;
        }
        DynamicObjectCollection entryCol = comparePrice.getDynamicObjectCollection("entryentity");
        HashSet<Long> goodsIdSet = new HashSet<Long>(1024);
        for (DynamicObject row : entryCol) {
            if (!row.getBoolean("isadd")) continue;
            goodsIdSet.add(row.getLong("goods_id"));
        }
        entryCol.clear();
        for (DynamicObject info : malCompareRecordDynCol) {
            DynamicObject row = entryCol.addNew();
            row.set("goods_id", (Object)info.getLong("goods.id"));
            row.set("supplier_id", (Object)info.getLong("goods.supplier.id"));
            row.set("addqty", (Object)one);
            row.set("unit_id", (Object)info.getLong("goods.unit.id"));
            row.set("currency_id", (Object)info.getLong("goods.curr.id"));
            if (goodsId.equals(info.getLong("goods.id")) || goodsIdSet.contains(info.getLong("goods.id"))) {
                row.set("isadd", (Object)Boolean.TRUE);
            } else {
                row.set("isadd", (Object)Boolean.FALSE);
            }
            MalGoods malGoods = malGoodsMap.get(info.getLong("goods.id"));
            BigDecimal taxPrice = malGoods.getTaxPrice();
            row.set("price", (Object)taxPrice);
            if (null == shots || shots.size() <= 0) continue;
            for (Map<String, Object> shopMap : shots) {
                if (!row.getString("goods_id").equals(String.valueOf(shopMap.get("goods"))) || null == shopMap.get("addqty")) continue;
                row.set("addqty", shopMap.get("addqty"));
                row.set("price", shopMap.get("price"));
                row.set("ladderprice", shopMap.get("price"));
            }
        }
        for (DynamicObject row : entryCol) {
            BigDecimal taxPrice = row.getBigDecimal("price");
            if (min.compareTo(max) == 0) break;
            if (!row.getBoolean("isadd")) continue;
            row.set("remark", (Object)"");
            if (taxPrice.compareTo(min) == 0) {
                row.set("remark", (Object)ResManager.loadKDString((String)"\u6700\u4f4e\u4ef7", (String)"MalCompareService_3", (String)"scm-mal-business", (Object[])new Object[0]));
                row.set("compareresult", (Object)1);
            }
            if (taxPrice.compareTo(max) != 0) continue;
            row.set("remark", (Object)ResManager.loadKDString((String)"\u6700\u9ad8\u4ef7", (String)"MalCompareService_4", (String)"scm-mal-business", (Object[])new Object[0]));
            row.set("compareresult", (Object)0);
        }
    }
}

