/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.domain.service.impl;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.url.UrlService;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.es.storage.EsResultVo;
import kd.scm.common.es.storage.EsSuggestParam;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.mal.common.util.MalProductUtil;
import kd.scm.mal.domain.model.search.MalEsSearchParam;
import kd.scm.mal.domain.model.search.MalFilterBar;
import kd.scm.mal.domain.model.search.MalSearchResult;
import kd.scm.mal.domain.model.search.SearchOption;
import kd.scm.mal.domain.service.MalEsSearchService;
import kd.scm.malcore.util.MalConfigUtil;

public class MalEsSearchServiceImpl
implements MalEsSearchService {
    private static final Log log = LogFactory.getLog((String)MalEsSearchServiceImpl.class.getName());
    private static final String PRODUCT_SOURCE = "productgoods_source";

    @Override
    public MalSearchResult search(MalEsSearchParam malEsSearchParam) {
        if (malEsSearchParam == null) {
            MalSearchResult emptyRes = new MalSearchResult();
            emptyRes.setMalFilterBars(new ArrayList<MalFilterBar>());
            emptyRes.setTotals(0L);
            return emptyRes;
        }
        EsResultVo esResultVo = (EsResultVo)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pbd", (String)"PbdEsSearchService", (String)"search", (Object[])new Object[]{malEsSearchParam.getEsSearchParam(), malEsSearchParam.getGoodsEsConfigId() == null ? MalConfigUtil.DEFAULT_ESCONFIGID : malEsSearchParam.getGoodsEsConfigId()});
        MalSearchResult malSearchResult = this.resolveEsResult(esResultVo);
        DynamicObjectCollection entryCol = esResultVo.getTargetDyn().getDynamicObjectCollection("search_entryentity");
        entryCol.removeIf(entry -> StringUtils.isBlank((CharSequence)entry.getString("searchgoods_sku")));
        Map<String, DynamicObject> sourceToSupplierNameMap = this.getSourceToSupplierNameMap();
        this.complementSupplierInfo(sourceToSupplierNameMap, esResultVo.getResultData());
        Iterator iterator = entryCol.iterator();
        while (iterator.hasNext()) {
            DynamicObject ecAdminDyn;
            DynamicObject entry2 = (DynamicObject)iterator.next();
            if (StringUtils.isBlank((CharSequence)entry2.getString("searchgoods_sku"))) {
                iterator.remove();
                continue;
            }
            BigDecimal salebigDecimal = BigDecimal.ZERO;
            if (null != entry2.get("sales") && entry2.get("sales") instanceof Integer) {
                salebigDecimal = new BigDecimal(String.valueOf(entry2.get("sales")));
            }
            String salesDesc = MalProductUtil.getSalesDesc((BigDecimal)salebigDecimal);
            entry2.set("sales_desc", (Object)salesDesc);
            entry2.set("sales_desc1", (Object)salesDesc);
            if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(entry2.getString(PRODUCT_SOURCE)) || (ecAdminDyn = sourceToSupplierNameMap.get(entry2.getString(PRODUCT_SOURCE))) == null) continue;
            entry2.set("supplier", (Object)ecAdminDyn.getString("malsupplier.name"));
            entry2.set("supplier1", (Object)ecAdminDyn.getString("malsupplier.name"));
        }
        return malSearchResult;
    }

    private void complementSupplierInfo(Map<String, DynamicObject> sourceToSupplierNameMap, List<Map<String, Object>> resultData) {
        for (Map<String, Object> goodsObj : resultData) {
            DynamicObject ecAdminRow = sourceToSupplierNameMap.get(String.valueOf(goodsObj.get("source")));
            if (ecAdminRow == null) continue;
            goodsObj.put("supplierid", ecAdminRow.getLong("malsupplier.id"));
            goodsObj.put("suppliername", ecAdminRow.getString("malsupplier.name"));
        }
    }

    private Map<String, DynamicObject> getSourceToSupplierNameMap() {
        HashMap<String, DynamicObject> res = new HashMap<String, DynamicObject>(16);
        QFilter filter = new QFilter("openstatus", "=", (Object)"2");
        Map ecAdminDynMap = BusinessDataServiceHelper.loadFromCache((String)"pmm_ecadmit", (String)"platform,malsupplier.id,malsupplier.name", (QFilter[])new QFilter[]{filter});
        for (DynamicObject ecAdminDyn : ecAdminDynMap.values()) {
            res.put(ecAdminDyn.getString("platform"), ecAdminDyn);
        }
        return res;
    }

    @Override
    public MalSearchResult searchBySales(MalEsSearchParam malEsSearchParam) {
        malEsSearchParam.setWithSales(true);
        MalSearchResult res = this.search(malEsSearchParam);
        DynamicObjectCollection entryCol = res.getMalNewSearchDyn().getDynamicObjectCollection("search_entryentity");
        entryCol.sort((a, b) -> b.getInt("sales") - a.getInt("sales"));
        return res;
    }

    @Override
    public List<String> suggest(EsSuggestParam esSuggestParam, Long esConfigId) {
        List<String> res = new ArrayList<String>();
        if (esConfigId == null || esConfigId == 0L) {
            return res;
        }
        try {
            res = (List)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pbd", (String)"PbdEsSearchService", (String)"suggest", (Object[])new Object[]{esSuggestParam, esConfigId});
        }
        catch (Exception e) {
            log.warn("kd.scm.mal.domain.service.impl.MalEsSearchServiceImpl.suggest:" + ExceptionUtil.getStackTrace((Throwable)e));
        }
        return res;
    }

    @Override
    public List<SearchOption> getSearchOption() {
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)"mal_newshop", (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        List items = ((ComboField)entityMetadata.getFieldByKey("searchfield")).getItems();
        ArrayList<SearchOption> searchOptions = new ArrayList<SearchOption>(items.size());
        for (ComboItem comboItem : items) {
            SearchOption searchOption = new SearchOption();
            searchOption.setName(comboItem.getCaption().getLocaleValue());
            searchOption.setSearchfield(comboItem.getValue());
            searchOptions.add(searchOption);
        }
        return searchOptions;
    }

    private String getPictureUrl(String pictureUrl) {
        if (StringUtils.isEmpty((CharSequence)pictureUrl) || pictureUrl.contains("http") || pictureUrl.contains("https")) {
            return pictureUrl;
        }
        return UrlService.getImageFullUrl((String)pictureUrl);
    }

    private MalSearchResult resolveEsResult(EsResultVo esResultVo) {
        MalSearchResult searchResult = new MalSearchResult();
        searchResult.setEsResultVo(esResultVo);
        searchResult.setTotals(esResultVo.getTotalHits());
        searchResult.setMalNewSearchDyn(esResultVo.getTargetDyn());
        for (Map goodsObj : esResultVo.getResultData()) {
            Object thumbnail = goodsObj.get("thumbnail");
            if (thumbnail == null) continue;
            goodsObj.put("thumbnail", this.getPictureUrl(thumbnail.toString()));
        }
        searchResult.setResultData(esResultVo.getResultData());
        Map convertedAggResult = esResultVo.getConvertedAggResult();
        ArrayList<MalFilterBar> malFilterBars = new ArrayList<MalFilterBar>(convertedAggResult.size() << 2);
        for (Map aggs : convertedAggResult.values()) {
            Object aggItem = aggs.get("result");
            if (aggItem instanceof List) {
                for (Object item : (List)aggItem) {
                    MalFilterBar malFilterBar = (MalFilterBar)JSON.parseObject((String)JSON.toJSONString(item), MalFilterBar.class);
                    malFilterBars.add(malFilterBar);
                }
                continue;
            }
            MalFilterBar malFilterBar = (MalFilterBar)JSON.parseObject((String)JSON.toJSONString(aggItem), MalFilterBar.class);
            if (malFilterBar == null) continue;
            malFilterBar.setAggId(malFilterBar.getFilterItemId());
            malFilterBar.setAggName(malFilterBar.getFilterItemName());
            malFilterBars.add(malFilterBar);
        }
        searchResult.setMalFilterBars(malFilterBars);
        return searchResult;
    }
}

