/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.domain.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.mal.domain.model.goods.MalGoodsSelectStrategyParam;
import kd.scm.mal.domain.service.MalGoodsSelectService;

public class MalGoodsSelectByUploadTimeService
implements MalGoodsSelectService {
    @Override
    public List<Long> loadMalGoods(MalGoodsSelectStrategyParam malGoodsSelectStrategyParam) {
        if (StringUtils.isEmpty((CharSequence)malGoodsSelectStrategyParam.getSource())) {
            TreeMap<Date, Long> mixRes = this.loadSelfGoodsIds(malGoodsSelectStrategyParam);
            mixRes.putAll(this.loadEcGoodsIds(malGoodsSelectStrategyParam));
            List<Long> goodsIdList = this.filterGoods(new ArrayList<Long>(mixRes.descendingMap().values()));
            return goodsIdList;
        }
        if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(malGoodsSelectStrategyParam.getSource())) {
            return new ArrayList<Long>(this.loadSelfGoodsIds(malGoodsSelectStrategyParam).descendingMap().values());
        }
        return new ArrayList<Long>(this.loadEcGoodsIds(malGoodsSelectStrategyParam).descendingMap().values());
    }

    private TreeMap<Date, Long> loadEcGoodsIds(MalGoodsSelectStrategyParam malGoodsSelectStrategyParam) {
        TreeMap<Date, Long> res = new TreeMap<Date, Long>();
        QFilter categoryFilter = this.getEcCategoryFilter(malGoodsSelectStrategyParam.getCategoryLongNumber());
        QFilter statusFilter = new QFilter("mallstatus", "=", (Object)"1").and("saleable", "=", (Object)"1");
        QFilter timeFilter = new QFilter("mallgoods.modifytime", ">=", (Object)this.getTime(malGoodsSelectStrategyParam));
        QFilter sourceFilter = null;
        if (!StringUtils.isEmpty((CharSequence)malGoodsSelectStrategyParam.getSource())) {
            sourceFilter = new QFilter("mallgoods.source", "=", (Object)malGoodsSelectStrategyParam.getSource());
        }
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"pbd_mallgoods_status", (String)"id,mallgoods.id,mallgoods.createtime", (QFilter[])new QFilter[]{statusFilter, categoryFilter, timeFilter, sourceFilter}, null);){
            Iterator rowIterator = malGoodsSelectStrategyParam.getLimit() > 0 ? ds.limit(0, malGoodsSelectStrategyParam.getLimit()).iterator() : ds.iterator();
            HashSet<String> idSet = new HashSet<String>(Math.max(malGoodsSelectStrategyParam.getLimit(), 16));
            int timeAdd = 1;
            while (rowIterator.hasNext()) {
                Row row = (Row)rowIterator.next();
                if (!idSet.add(row.getString("mallgoods.id"))) continue;
                res.put(KDDateUtils.addSeconds((Date)row.getDate("mallgoods.createtime"), (int)timeAdd++), row.getLong("mallgoods.id"));
            }
            TreeMap<Date, Long> treeMap = res;
            return treeMap;
        }
    }

    private TreeMap<Date, Long> loadSelfGoodsIds(MalGoodsSelectStrategyParam malGoodsSelectStrategyParam) {
        TreeMap<Date, Long> res = new TreeMap<Date, Long>();
        QFilter categoryFilter = this.getSelfCategoryFilter(malGoodsSelectStrategyParam.getCategoryLongNumber());
        QFilter timeFilter = new QFilter("uploaddate", ">=", (Object)this.getTime(malGoodsSelectStrategyParam));
        QFilter source = new QFilter("source", "=", (Object)EcPlatformEnum.ECPLATFORM_SELF.getVal());
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"pmm_prodmanage", (String)"id,uploaddate", (QFilter[])new QFilter[]{source, categoryFilter, timeFilter}, (String)"uploaddate desc");){
            Iterator rowIterator = malGoodsSelectStrategyParam.getLimit() != -1 ? ds.limit(0, malGoodsSelectStrategyParam.getLimit()).iterator() : ds.iterator();
            HashSet<String> idSet = new HashSet<String>(Math.max(malGoodsSelectStrategyParam.getLimit(), 16));
            int timeAdd = 1;
            ArrayList<Long> goodIds = new ArrayList<Long>(1024);
            while (rowIterator.hasNext()) {
                Row row = (Row)rowIterator.next();
                goodIds.add(row.getLong("id"));
                if (!idSet.add(row.getString("id"))) continue;
                res.put(KDDateUtils.addSeconds((Date)row.getDate("uploaddate"), (int)timeAdd++), row.getLong("id"));
            }
            List<Long> goodsIdList = this.filterGoods(goodIds);
            ArrayList removeDateList = new ArrayList(1024);
            for (Map.Entry map : res.entrySet()) {
                if (goodsIdList.contains(map.getValue())) continue;
                removeDateList.add(map.getKey());
            }
            for (Date dateKey : removeDateList) {
                res.remove(dateKey);
            }
            TreeMap<Date, Long> treeMap = res;
            return treeMap;
        }
    }

    private QFilter getSelfCategoryFilter(String categoryLongNumber) {
        if (StringUtils.isEmpty((CharSequence)categoryLongNumber)) {
            return null;
        }
        String[] classLevels = categoryLongNumber.split("\\.");
        if (classLevels.length == 3) {
            return new QFilter("category.number", "=", (Object)classLevels[2]);
        }
        if (classLevels.length == 2) {
            return new QFilter("category.parent.number", "=", (Object)classLevels[1]);
        }
        return new QFilter("category.parent.parent.number", "=", (Object)categoryLongNumber);
    }

    private QFilter getEcCategoryFilter(String categoryLongNumber) {
        if (StringUtils.isEmpty((CharSequence)categoryLongNumber)) {
            return null;
        }
        String[] classLevels = categoryLongNumber.split("\\.");
        if (classLevels.length == 3) {
            return new QFilter("mallgoods.group.number", "=", (Object)classLevels[2]);
        }
        if (classLevels.length == 2) {
            return new QFilter("mallgoods.group.parent.number", "=", (Object)classLevels[1]);
        }
        return new QFilter("mallgoods.group.parent.parent.number", "=", (Object)categoryLongNumber);
    }

    private Date getTime(MalGoodsSelectStrategyParam malGoodsSelectStrategyParam) {
        return KDDateUtils.addDays((Date)TimeServiceHelper.now(), (int)(-malGoodsSelectStrategyParam.getTimeRange()));
    }
}

