/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.domain.service.impl;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.olap.util.Pair;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.scm.mal.domain.model.goods.MalGoods;
import kd.scm.mal.domain.service.MalLadderPriceRangeService;

public class MalLadderPriceRangeServiceImpl
implements MalLadderPriceRangeService {
    @Override
    public String getLadderPriceContent(MalGoods malgoods, BigDecimal qty, String unitName, String currencySign) {
        Map<BigDecimal, BigDecimal> ladderPriceRange = malgoods.getLadderPriceRange();
        return this.conver2HtmlContent(this.parse2PairMap(ladderPriceRange), qty, unitName, ladderPriceRange, currencySign);
    }

    @Override
    public Map<Long, String> batchGetLadderPriceContent(List<MalGoods> malgoodsList) {
        return null;
    }

    private List<Pair<BigDecimal, BigDecimal>> parse2PairMap(Map<BigDecimal, BigDecimal> ladderPriceRange) {
        if (ladderPriceRange == null) {
            return new ArrayList<Pair<BigDecimal, BigDecimal>>();
        }
        ArrayList<Pair<BigDecimal, BigDecimal>> resList = new ArrayList<Pair<BigDecimal, BigDecimal>>(ladderPriceRange.size());
        ArrayList<BigDecimal> qtyList = new ArrayList<BigDecimal>(ladderPriceRange.keySet());
        for (int i = 0; i < qtyList.size(); ++i) {
            BigDecimal qty = (BigDecimal)qtyList.get(i);
            if (i == qtyList.size() - 1) {
                resList.add((Pair<BigDecimal, BigDecimal>)new Pair((Object)qty, null));
                continue;
            }
            resList.add((Pair<BigDecimal, BigDecimal>)new Pair((Object)qty, qtyList.get(i + 1)));
        }
        return resList;
    }

    private String conver2HtmlContent(List<Pair<BigDecimal, BigDecimal>> qtyRangeList, BigDecimal qty, String unitName, Map<BigDecimal, BigDecimal> ladderPriceRange, String currencySign) {
        StringBuilder sb = new StringBuilder();
        sb.append("<table style=\"border-collapse: collapse; background-color: #ffffff; border-color: #ffffff; border-style: none;\" border=\"0px\" cellpadding=\"0px\"><tbody>");
        NumberFormat formatter = NumberFormat.getNumberInstance();
        formatter.setGroupingUsed(true);
        for (Pair<BigDecimal, BigDecimal> qtyRange : qtyRangeList) {
            BigDecimal fromQty = (BigDecimal)qtyRange.getValue0();
            BigDecimal toQty = (BigDecimal)qtyRange.getValue1();
            String color = this.getColor(fromQty, toQty, qty);
            sb.append("<tr style=\"height: 18px;\">");
            sb.append("<td style=\"width: 100px; text-align: right; height: 18px; border: 0px; padding: 0px;\"><span style=\"font-size: 14px; color: ").append(color).append(";\">");
            if (null != toQty) {
                sb.append(fromQty.stripTrailingZeros().toPlainString()).append('-').append(toQty.stripTrailingZeros().toPlainString()).append(StringUtils.isBlank((CharSequence)unitName) ? "" : unitName);
            } else {
                sb.append(fromQty.stripTrailingZeros().toPlainString()).append(StringUtils.isBlank((CharSequence)unitName) ? "" : unitName).append(ResManager.loadKDString((String)"\u4ee5\u4e0a", (String)"MalLadderPriceRangeServiceImpl_0", (String)"scm-mal-mservice", (Object[])new Object[0]));
            }
            sb.append('\uff1a').append("</span></td><td style=\"width: 80px; height: 18px; border: 0px; padding: 0px;\"><span style=\"font-size: 14px; color: ").append(color).append(";\">");
            sb.append(currencySign).append(formatter.format(ladderPriceRange.get(fromQty).stripTrailingZeros())).append("</span></td></tr>");
        }
        sb.append("</tbody></table>");
        return sb.toString();
    }

    private String getColor(BigDecimal fromQty, BigDecimal toQty, BigDecimal qty) {
        if (null == fromQty) {
            fromQty = BigDecimal.ZERO;
        }
        if (null == toQty || BigDecimal.ZERO.compareTo(toQty) == 0) {
            return qty.compareTo(fromQty) >= 0 ? "#333" : "#b2b2b2";
        }
        return qty.compareTo(fromQty) >= 0 && qty.compareTo(toQty) < 0 ? "#333" : "#b2b2b2";
    }
}

