/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.domain.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.fulltext.FTCompare;
import kd.bos.fulltext.FTDataType;
import kd.bos.fulltext.FTFilter;
import kd.bos.fulltext.FTValue;
import kd.bos.fulltext.FullTextFactory;
import kd.bos.fulltext.FullTextQuery;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.param.ParameterUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scm.common.ecapi.entity.GoodsInfo;
import kd.scm.common.es.storage.EsDataType;
import kd.scm.common.es.storage.EsFilterField;
import kd.scm.common.es.storage.EsSearchParam;
import kd.scm.common.es.storage.EsSortField;
import kd.scm.common.helper.apiconnector.api.util.EcApiUtil;
import kd.scm.mal.business.factory.MalBusinessFactory;
import kd.scm.mal.business.search.service.MalSearchExtensionService;
import kd.scm.mal.common.util.MalNewSearchUtils;
import kd.scm.mal.domain.model.recommend.SearchParam;
import kd.scm.mal.domain.model.search.MalEsSearchParam;
import kd.scm.mal.domain.model.search.MalFilterItem;
import kd.scm.mal.domain.model.search.MalSearchParam;
import kd.scm.mal.domain.model.search.MalSearchResult;
import kd.scm.mal.domain.service.DomainServiceFactory;
import kd.scm.mal.domain.service.MalEsSearchService;
import kd.scm.mal.domain.service.MalSearchService;

public class MalSearchServiceImpl
implements MalSearchService {
    private static final Log logger = LogFactory.getLog(MalSearchServiceImpl.class);
    private static final String REGION = "pur";
    private static final String MALL_STATUS = "mallstatus";
    private static final String CLASS_NUMBER = "classnumber";
    private static final String NAME = "name";
    private static final String[] ENTITY_GOODS = new String[]{"pbd_goods", "pbd_mallgoods"};
    private static final String RETURN_FILEDS = "id_string,number_string,name_zh_cn_string,source_string,classid_string,brandid_string,classname_string,classnumber_string,brandname_string,brandnumber_string,mainpic_string,model_string,mallstatus_string,price_float,centralpurtype_string,suppliername_string,classlongnumber_string";
    private static final String SORT_SALES = "sales";
    private static final String SPLIT = "_";
    private static final String ESCONFIG_GOODS = "esconfig_goods";
    private static final String SEARCHFIELD_GOODS = "searchfield_goods";
    private static final String DOT = ",";
    private static final String FIELD_SUPPLIERNAME = "suppliername";
    private static final String FIELD_SOURCE_NAME = "source_name";
    private static final String FIELD_GOODS = "goods";
    private static final String PIPE = "\\|";
    private static final String SOURCE = "source";
    private static final String PRODOBTAIN = "prodobtain";
    private static final String EXT_KEY_CATEGORY_UNION = "CATEGORY_UNION";
    private static final String EXT_KEY_OTHER = "OTHER";
    private static final String SCENESE_NAME = "scenarioscheme";
    private static final String PAKAGESELECT_NAME = "pakageselectscheme";

    @Override
    public MalSearchResult search(MalSearchParam malSearchParam, DynamicObject malSearchDyn) {
        DynamicObjectCollection col;
        QFilter orgfilter;
        QFilter fiter;
        String searchText;
        if (StringUtils.isNotEmpty((CharSequence)malSearchParam.getSearchField()) && PRODOBTAIN.equals(malSearchParam.getSearchField().split(PIPE)[0])) {
            DynamicObject prodObtainDyn;
            String cp = this.getCp(malSearchParam.getSearchField());
            if ("match".equals(cp)) {
                cp = "=";
            }
            searchText = malSearchParam.getSearchText();
            if ("like".equals(cp)) {
                searchText = "%" + searchText + "%";
            }
            if ((prodObtainDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"pmm_product_obtain", (QFilter[])new QFilter[]{new QFilter(NAME, cp, (Object)searchText)})) != null) {
                malSearchParam.setProductObtainId(prodObtainDyn.getLong("id"));
                malSearchParam.setSearchText("");
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)malSearchParam.getSearchField()) && SCENESE_NAME.equals(malSearchParam.getSearchField().split(PIPE)[0])) {
            boolean iscontainsOrg = this.checkOrg();
            if (iscontainsOrg) {
                searchText = malSearchParam.getSearchText();
                fiter = null;
                fiter = searchText != null && searchText.length() > 0 ? new QFilter(NAME, "=", (Object)searchText.trim()) : new QFilter(NAME, "=", (Object)searchText);
                orgfilter = BaseDataServiceHelper.getBaseDataFilter((String)"pmm_scenarioscheme", (Long)RequestContext.get().getOrgId());
                fiter.and(new QFilter("enable", "=", (Object)"1"));
                fiter.and(new QFilter("status", "=", (Object)"C"));
                fiter.and(new QFilter("type", "=", (Object)"2"));
                col = QueryServiceHelper.query((String)"pmm_scenarioscheme", (String)"id", (QFilter[])new QFilter[]{orgfilter, fiter});
                if (col.size() > 0) {
                    malSearchParam.setProductObtainId(((DynamicObject)col.get(0)).getLong("id"));
                    malSearchParam.setSearchText("");
                }
            } else {
                malSearchParam.setProductObtainId(0L);
                malSearchParam.setSearchText("");
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)malSearchParam.getSearchField()) && PAKAGESELECT_NAME.equals(malSearchParam.getSearchField().split(PIPE)[0])) {
            boolean iscontainsOrg = this.checkOrg();
            if (iscontainsOrg) {
                searchText = malSearchParam.getSearchText();
                fiter = null;
                fiter = searchText != null && searchText.length() > 0 ? new QFilter(NAME, "=", (Object)searchText.trim()) : new QFilter(NAME, "=", (Object)searchText);
                orgfilter = BaseDataServiceHelper.getBaseDataFilter((String)"pmm_packageselection", (Long)RequestContext.get().getOrgId());
                fiter.and(new QFilter("enable", "=", (Object)"1"));
                fiter.and(new QFilter("status", "=", (Object)"C"));
                fiter.and(new QFilter("type", "=", (Object)"3"));
                col = QueryServiceHelper.query((String)"pmm_packageselection", (String)"id", (QFilter[])new QFilter[]{orgfilter, fiter});
                if (col.size() > 0) {
                    malSearchParam.setProductObtainId(((DynamicObject)col.get(0)).getLong("id"));
                    malSearchParam.setSearchText("");
                }
            } else {
                malSearchParam.setProductObtainId(0L);
                malSearchParam.setSearchText("");
            }
        }
        return this.searchBySearchParam(malSearchParam, malSearchDyn);
    }

    private boolean checkOrg() {
        DynamicObjectCollection colorgs = BaseDataServiceHelper.getAllUseOrg((String)"pmm_scenarioscheme");
        long curOrg = RequestContext.get().getOrgId();
        boolean iscontainsOrg = false;
        for (DynamicObject org : colorgs) {
            if (org.getLong("id") != curOrg) continue;
            iscontainsOrg = true;
            break;
        }
        return iscontainsOrg;
    }

    private MalSearchResult searchBySearchParam(MalSearchParam malSearchParam, DynamicObject malSearchDyn) {
        MalSearchExtensionService otherSearchExtensionService;
        EsFilterField sourceEsFilter;
        EsFilterField classEsFilter;
        logger.info("searchBySearchParam\u53c2\u6570\uff1a" + malSearchParam);
        MalEsSearchParam malEsSearchParam = new MalEsSearchParam();
        if (malSearchDyn == null) {
            malSearchDyn = this.createDefaultMalSearchDyn();
        }
        EsSearchParam esSearchParam = new EsSearchParam();
        if (malSearchParam.getProductObtainId() != null) {
            esSearchParam = (EsSearchParam)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pmm", (String)"PmmProdObtainMService", (String)"getEsSearchParamByProdObtain", (Object[])new Object[]{malSearchParam.getProductObtainId()});
            DynamicObject prodObtainDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)malSearchParam.getProductObtainId(), (String)"pmm_product_obtain");
            String orderby = prodObtainDyn.getString("orderby");
            if (SORT_SALES.equals(orderby) && !"sales_true".equals(malSearchParam.getSort()) && !"sales_false".equals(malSearchParam.getSort())) {
                malSearchParam.setSort("sales_false");
            }
            if (prodObtainDyn.getInt("limit") > 0) {
                malSearchParam.setPageSize(prodObtainDyn.getInt("limit"));
            }
            if ("6".equals(prodObtainDyn.getString("acquisition_mode"))) {
                malSearchParam.setPageSize(999);
            }
            malSearchParam.setPageNum(0);
        }
        malEsSearchParam.setGoodsEsConfigId(malSearchDyn.getLong("esconfig_goods.id"));
        ArrayList<EsFilterField> esFilterFields = esSearchParam.getEsFilterFields();
        if (esFilterFields == null) {
            esFilterFields = new ArrayList<EsFilterField>();
        }
        HashSet<String> sourceSet = new HashSet<String>(16);
        if (StringUtils.isNotBlank((CharSequence)malSearchParam.getCategoryNumber()) && (classEsFilter = this.getClassEsFilter(malSearchParam)) != null) {
            esFilterFields.add(classEsFilter);
        }
        esFilterFields.add(this.getMallstatusFilter());
        esFilterFields.add(this.getOrgEsFilter());
        EsFilterField searchFieldEsFilter = this.getSearchFieldEsFilter(malSearchParam, malSearchDyn);
        if (searchFieldEsFilter != null) {
            esFilterFields.add(searchFieldEsFilter);
        }
        if ((sourceEsFilter = this.getSourceEsFilter(malSearchParam.getSources(), sourceSet)) != null) {
            esFilterFields.add(sourceEsFilter);
        }
        esFilterFields.addAll(this.getFilterItemFilters(malSearchParam.getMalFilterItemList()));
        EsFilterField priceRangeFilter = this.getPriceRangeFilter(malSearchParam);
        if (priceRangeFilter != null) {
            esFilterFields.add(priceRangeFilter);
        }
        esFilterFields.addAll(malSearchParam.getCustomEsFilterFields());
        esSearchParam.setEsFilterFields(esFilterFields);
        esSearchParam.setPageNum(malSearchParam.getPageNum());
        if (malSearchParam.getPageSize() > 0) {
            esSearchParam.setPageSize(malSearchParam.getPageSize());
        } else {
            esSearchParam.setPageSize(malSearchDyn.getInt("pagesize"));
        }
        esSearchParam.setTargetDyn(malSearchDyn);
        esSearchParam.setEsSortFields(new EsSortField[]{this.getEsSortField(malSearchParam.getSort())});
        malEsSearchParam.setEsSearchParam(esSearchParam);
        MalSearchExtensionService malCategoryUnionSearchExtensionService = MalBusinessFactory.serviceOf(MalSearchExtensionService.class, EXT_KEY_CATEGORY_UNION);
        if (malCategoryUnionSearchExtensionService != null) {
            malEsSearchParam = malCategoryUnionSearchExtensionService.beforeSearch(malEsSearchParam, malSearchParam);
        }
        if ((otherSearchExtensionService = MalBusinessFactory.serviceOf(MalSearchExtensionService.class, EXT_KEY_OTHER)) != null) {
            logger.info("\u52a0\u8f7d\u5230\u5176\u4ed6\u6269\u5c55\u914d\u7f6e\uff1a" + otherSearchExtensionService);
            malEsSearchParam = otherSearchExtensionService.beforeSearch(malEsSearchParam, malSearchParam);
            logger.info("\u52a0\u8f7d\u5230\u5176\u4ed6\u6269\u5c55\u914d\u7f6e\uff1a{}, \u641c\u7d22\u6267\u884c\u524d\u4ecb\u5165\u53c2\u6570\uff1a{}", (Object)otherSearchExtensionService, (Object)malEsSearchParam);
        }
        MalSearchResult malSearchResult = DomainServiceFactory.serviceOf(MalEsSearchService.class).search(malEsSearchParam);
        if (malSearchParam.getProductObtainId() != null) {
            malSearchResult.setTotals(malSearchResult.getResultData().size());
        }
        if (malCategoryUnionSearchExtensionService != null) {
            malSearchResult = malCategoryUnionSearchExtensionService.afterSearch(malSearchResult, malSearchParam);
        }
        if (otherSearchExtensionService != null) {
            malSearchResult = otherSearchExtensionService.afterSearch(malSearchResult, malSearchParam);
            logger.info("\u52a0\u8f7d\u5230\u5176\u4ed6\u9ed8\u8ba4\u6269\u5c55\u914d\u7f6e\uff1a{}, \u641c\u7d22\u6267\u884c\u540e\u4ecb\u5165\u7ed3\u679c\u805a\u5408\u4fe1\u606f\uff1a{}", (Object)otherSearchExtensionService, malSearchResult.getMalFilterBars());
        }
        return malSearchResult;
    }

    private EsFilterField getSourceEsFilter(String sources, Set<String> sourceSet) {
        Set<String> enableStandardPlats = this.getEnableStandardPlats();
        if (Objects.isNull(sources) && sourceSet.size() == 0) {
            if (enableStandardPlats.size() > 0) {
                return new EsFilterField(SOURCE, "not in", enableStandardPlats.toArray(new Object[0]));
            }
            return null;
        }
        ArrayList<String> keyWords = new ArrayList<String>(8);
        if (!Objects.isNull(sources)) {
            for (String source : sources.split(DOT)) {
                if (!StringUtils.isNotBlank((CharSequence)source)) continue;
                keyWords.add(source);
            }
        }
        if (Objects.isNull(sources) || !sources.contains(DOT)) {
            keyWords.addAll(sourceSet);
        }
        keyWords.removeAll(enableStandardPlats);
        return new EsFilterField(SOURCE, "in", new HashSet(keyWords).toArray(new Object[0]));
    }

    private Set<String> getEnableStandardPlats() {
        QFilter qFilter = new QFilter("enable", "=", (Object)Boolean.TRUE).and(new QFilter("openstatus", "!=", (Object)"2").and(new QFilter("tenantid", "=", (Object)RequestContext.getOrCreate().getTenantId())));
        Map ecadmits = BusinessDataServiceHelper.loadFromCache((String)"pmm_ecadmit", (String)"platform", (QFilter[])new QFilter[]{qFilter});
        HashSet<String> platForms = new HashSet<String>(16);
        for (Map.Entry infoMap : ecadmits.entrySet()) {
            platForms.add(((DynamicObject)infoMap.getValue()).getString("platform"));
        }
        return platForms;
    }

    private List<String> getCategoryLongNumnberList(String categoryLongNumber, String source, int level) {
        List<String> categoryLongNumnberList = new ArrayList<String>(10);
        if (level < 3) {
            categoryLongNumnberList = MalSearchServiceImpl.getLongNumber(source, String.valueOf(level), categoryLongNumber);
            if (null == categoryLongNumnberList) {
                return categoryLongNumnberList;
            }
        } else {
            categoryLongNumnberList.add(categoryLongNumber);
        }
        return categoryLongNumnberList;
    }

    private EsFilterField getClassEsFilter(MalSearchParam malSearchParam) {
        int level;
        String source;
        String categoryNumber = malSearchParam.getCategoryNumber();
        List<String> categoryLongNumnberList = this.getCategoryLongNumnberList(categoryNumber, source = malSearchParam.getSources(), level = malSearchParam.getCategoryLevel());
        if (null == categoryLongNumnberList || categoryLongNumnberList.size() == 0) {
            return null;
        }
        return new EsFilterField("classlongnumber", "in", categoryLongNumnberList.toArray());
    }

    private static List<String> getLongNumber(String source, String level, String longnumber) {
        QFilter qFilter = new QFilter("standard", "=", (Object)Long.valueOf(EcApiUtil.getStandard((String)source))).and(new QFilter("level", "=", (Object)3));
        if ("1".equals(level)) {
            qFilter.and(new QFilter("parent.parent.number", "=", (Object)longnumber));
        } else if ("2".equals(level)) {
            qFilter.and(new QFilter("parent.longnumber", "=", (Object)longnumber));
        } else {
            return null;
        }
        DynamicObjectCollection query = QueryServiceHelper.query((String)"mdr_goodsclass", (String)"longnumber", (QFilter[])new QFilter[]{qFilter});
        ArrayList<String> longList = new ArrayList<String>(query.size());
        if (query.size() == 0) {
            return null;
        }
        for (DynamicObject dyn : query) {
            longList.add(dyn.getString("longnumber"));
        }
        return longList;
    }

    private EsFilterField getSearchFieldEsFilter(MalSearchParam malSearchParam, DynamicObject malSearchDyn) {
        String searchText = malSearchParam.getSearchText();
        String searchField = malSearchParam.getSearchField();
        if (StringUtils.isBlank((CharSequence)searchText)) {
            return null;
        }
        EsFilterField res = null;
        if (FIELD_GOODS.equals(searchField.split(PIPE)[0])) {
            String searchFieldGoods = malSearchDyn.getString(SEARCHFIELD_GOODS);
            if (StringUtils.isNotBlank((CharSequence)searchFieldGoods)) {
                for (String field : searchFieldGoods.split(DOT)) {
                    if (!StringUtils.isNotBlank((CharSequence)field)) continue;
                    String cp = this.getCp(field);
                    String innerSearchKey = searchText;
                    String innerField = field.split(PIPE)[0];
                    if ("like".equals(cp)) {
                        innerSearchKey = "%" + searchText + "%";
                    }
                    if (res == null) {
                        res = new EsFilterField(innerField, cp, new Object[]{innerSearchKey.trim()});
                        continue;
                    }
                    res.or(new EsFilterField(innerField, cp, new Object[]{innerSearchKey.trim()}));
                }
            }
        } else if (FIELD_SUPPLIERNAME.equals(searchField.split(PIPE)[0])) {
            String cp = this.getCp(searchField);
            if ("like".equals(cp)) {
                searchText = "%" + searchText + "%";
            }
            String acctualSearchField = searchField.split(PIPE)[0];
            res = new EsFilterField(acctualSearchField, cp, new Object[]{searchText.trim()}).or(new EsFilterField(FIELD_SOURCE_NAME, cp, new Object[]{searchText.trim()}));
        } else {
            String cp = this.getCp(searchField);
            if ("like".equals(cp)) {
                searchText = "%" + searchText + "%";
            }
            String acctualSearchField = searchField.split(PIPE)[0];
            res = new EsFilterField(acctualSearchField, cp, new Object[]{searchText});
        }
        return res;
    }

    private String getCp(String searchField) {
        if (StringUtils.isNotBlank((CharSequence)searchField) && searchField.split(PIPE).length == 2) {
            return searchField.split(PIPE)[1];
        }
        return "match";
    }

    private EsFilterField getPriceRangeFilter(MalSearchParam malSearchParam) {
        BigDecimal startPrice = malSearchParam.getStartPrice();
        BigDecimal endPrice = malSearchParam.getEndPrice();
        if (startPrice == null) {
            startPrice = BigDecimal.ZERO;
        }
        if (endPrice == null) {
            endPrice = BigDecimal.ZERO;
        }
        if (startPrice.compareTo(BigDecimal.ZERO) == 0 && endPrice.compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        if (endPrice.compareTo(BigDecimal.ZERO) == 0) {
            endPrice = new BigDecimal("9999999999");
        }
        return new EsFilterField("price", ">=", new Object[]{startPrice}).and(new EsFilterField("price", "<=", new Object[]{endPrice}));
    }

    private List<EsFilterField> getFilterItemFilters(List<MalFilterItem> malFilterItemList) {
        ArrayList<EsFilterField> esFilterFields = new ArrayList<EsFilterField>();
        if (ObjectUtils.isEmpty(malFilterItemList)) {
            return esFilterFields;
        }
        HashSet<Long> aggIdSet = new HashSet<Long>(malFilterItemList.size());
        for (MalFilterItem malFilterItem : malFilterItemList) {
            aggIdSet.add(malFilterItem.getAggId());
        }
        Map esAggDynMap = BusinessDataServiceHelper.loadFromCache((Object[])aggIdSet.toArray(new Object[0]), (String)"pbd_esaggregation");
        for (MalFilterItem malFilterItem : malFilterItemList) {
            DynamicObject fieldDyn;
            DynamicObject esAggDyn = (DynamicObject)esAggDynMap.get(malFilterItem.getAggId());
            if (esAggDyn == null || (fieldDyn = esAggDyn.getDynamicObject("field")) == null) continue;
            String path = esAggDyn.getString("path");
            if (StringUtils.isNotBlank((CharSequence)path)) {
                EsFilterField esFilterField = new EsFilterField(path, path + "." + fieldDyn.getString("number"), "=", new Object[]{malFilterItem.getFilterItemValueId()});
                esFilterFields.add(esFilterField);
                continue;
            }
            String cp = "=";
            if (EsDataType.ARRAY.getVal().equals(fieldDyn.getString("datatype"))) {
                cp = "in";
            } else if (EsDataType.TEXT.getVal().equals(fieldDyn.getString("datatype"))) {
                cp = "match";
            }
            EsFilterField esFilterField = new EsFilterField(fieldDyn.getString("number"), cp, new Object[]{malFilterItem.getFilterItemValueId()});
            esFilterFields.add(esFilterField);
        }
        return esFilterFields;
    }

    private EsSortField getEsSortField(String sort) {
        if (StringUtils.isNotBlank((CharSequence)sort) && !SORT_SALES.equals(sort)) {
            return new EsSortField(sort.split(SPLIT)[0], Boolean.parseBoolean(sort.split(SPLIT)[1]));
        }
        return null;
    }

    private DynamicObject createDefaultMalSearchDyn() {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"mal_newsearch_v1");
        return ParameterUtils.createDefaultEntity((MainEntityType)entityType, (DynamicObject)((DynamicObject)entityType.createInstance()));
    }

    private EsFilterField getMallstatusFilter() {
        return new EsFilterField(MALL_STATUS, "=", new Object[]{"B"}).or(new EsFilterField(MALL_STATUS, "=", new Object[]{"1"}));
    }

    private EsFilterField getOrgEsFilter() {
        EsFilterField res = new EsFilterField("isgoodvisible", "=", new Object[]{true});
        res.or(new EsFilterField("orgids", "in", new Object[]{RequestContext.get().getOrgId()}));
        return res;
    }

    @Override
    @Deprecated
    public List<GoodsInfo> searchGoods(SearchParam searchParam) {
        return MalSearchServiceImpl.searchMallGoods(searchParam, 1, 1000);
    }

    @Deprecated
    public static List<GoodsInfo> searchMallGoods(SearchParam searchParam, int pageNo, int pageSize) {
        List result = new ArrayList(1);
        pageNo = pageNo == 0 ? 1 : pageNo;
        pageSize = pageSize == 0 ? 1000 : pageSize;
        logger.info("@@malsearch param:" + searchParam + "|" + pageNo + "|" + pageSize);
        FullTextQuery fq = FullTextFactory.getFullTextQuery((String)REGION);
        FTFilter filterSource = new FTFilter(SOURCE, FTCompare.EQ, FTValue.normal((FTDataType)FTDataType.STRING, (Object[])new Object[]{searchParam.getSource()}));
        FTFilter filterStatus = new FTFilter(MALL_STATUS, FTCompare.EQ, FTValue.normal((FTDataType)FTDataType.STRING, (Object[])new Object[]{"B"})).or(new FTFilter(MALL_STATUS, FTCompare.EQ, FTValue.normal((FTDataType)FTDataType.STRING, (Object[])new Object[]{"1"})));
        FTFilter filterClassNumber = new FTFilter(CLASS_NUMBER, FTCompare.EQ, FTValue.normal((FTDataType)FTDataType.STRING, (Object[])new Object[]{searchParam.getCategoryNumber()}));
        FTFilter filterName = new FTFilter(NAME, FTCompare.MATCH, FTValue.lang((Lang)Lang.zh_CN, (String[])new String[]{searchParam.getProductName()}));
        FTFilter filterTotal = null;
        filterTotal = filterSource.and(filterStatus.and(filterClassNumber.and(filterName)));
        logger.info("@@mal fulltext query filter:" + filterTotal.toExp());
        result = fq.searchMuiltExp(ENTITY_GOODS, RETURN_FILEDS, filterTotal.toExp(), pageNo, pageSize);
        return MalNewSearchUtils.convertResult(result);
    }
}

