/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.bizrule.asyncbizrule.AbstractAsyncMService;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.helper.apiconnector.api.util.Parser;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.mal.common.enums.MalBizflowParamEnum;
import kd.scm.mal.common.service.AsyncPushBillService;
import kd.scm.mal.common.service.AsyncPushBillServiceFactory;
import kd.scm.mal.common.util.MalBizFowUtil;

public class AsyncPushPmOrderService
extends AbstractAsyncMService {
    private static Log log = LogFactory.getLog(AsyncPushPmOrderService.class);

    public void execute() {
        String billID;
        boolean lastest = MalOrderUtil.getDefaultMalVersion();
        if (!lastest) {
            return;
        }
        AsyncPushBillService service = AsyncPushBillServiceFactory.getAsyncPushBillService((String)MalBizflowParamEnum.PMORDER.getVal());
        DynamicObjectCollection billColl = service.assemblePushBillData(billID = Parser.toString((Object)this.getBillID()), "mal_order");
        if (null == billColl) {
            log.error("@@@AsyncPushPmOrderService:\u4e0b\u63a8\u6e90\u6570\u636e\u4e3a\u7a7a\uff01");
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0b\u63a8\u6e90\u6570\u636e\u4e3a\u7a7a,\u8bf7\u68c0\u67e5", (String)"AsyncPushPmOrderService_0", (String)"scm-mal-mservice", (Object[])new Object[0]));
        }
        Long malOrderCreatorId = ((DynamicObject)billColl.get(0)).getLong("creator.id");
        ArrayList<String> splitType = new ArrayList<String>();
        splitType.add("id");
        splitType.add("supplier");
        Map<String, Map<String, Object>> wrapPropertyMap = this.getWrapPropertyMap(billColl, splitType);
        if (wrapPropertyMap.size() == 0) {
            List targetDataList = MalBizFowUtil.getPushTargetDataList((DynamicObjectCollection)billColl, (String)"mal_order", (String)"pm_purorderbill");
            service.handleAfterPushBillData(targetDataList);
            service.doTargetBizOperation("pm_purorderbill", targetDataList, malOrderCreatorId);
        } else {
            HashMap<String, String> customParam = new HashMap<String, String>();
            customParam.put("invokebizservice", "scm,mal,IMalPmOrdersWraperService,wrapPmOrdersBill");
            customParam.put("issuppcolla", "true");
            List targetDataList = MalBizFowUtil.getPushWithParamsTargetDataList((DynamicObjectCollection)billColl, (String)"pm_purapplybill", (String)"pm_purorderbill", customParam, splitType, (String)"erpsourceid", (String)"billentry", (String)"erpsourceentryid", wrapPropertyMap);
            service.handleAfterPushBillData(targetDataList);
            service.doTargetBizOperation("pm_purorderbill", targetDataList, malOrderCreatorId);
        }
    }

    private Map<String, Map<String, Object>> getWrapPropertyMap(DynamicObjectCollection billColl, List<String> splitType) {
        HashMap<String, Map<String, Object>> propertyMap = new HashMap<String, Map<String, Object>>();
        for (DynamicObject dynamicObject : billColl) {
            String erpsourcebilltype = dynamicObject.getString("erpsourcebilltype");
            if (!"pm_purapplybill".equals(erpsourcebilltype)) continue;
            String splitTypeId = MalBizFowUtil.getSplitType((DynamicObject)dynamicObject, splitType);
            HashMap<String, Long> idMap = (HashMap<String, Long>)propertyMap.get(splitTypeId);
            if (idMap == null) {
                idMap = new HashMap<String, Long>(16);
                propertyMap.put(splitTypeId, idMap);
            }
            String erpsourceentryid = dynamicObject.getString("erpsourceentryid");
            idMap.put(erpsourceentryid, dynamicObject.getLong("entryentity"));
        }
        return propertyMap;
    }
}

