/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.ecapi.entity.PriceInfo;
import kd.scm.common.ecapi.entity.PriceLogDTO;
import kd.scm.mal.service.GoodsPriceService;

public class GoodsPriceServiceImpl
implements GoodsPriceService {
    private static Log log = LogFactory.getLog(GoodsPriceServiceImpl.class);

    public Map<Long, PriceInfo> getGoodsPriceByGoodsIds(List<Long> ids) throws Exception {
        String selectFields = "id,discountrate,price,mallprice,taxrate,taxprice,nakedprice,modifytime,mallgoods.name";
        QFilter[] filters = new QFilter[]{new QFilter("mallgoods", "in", ids)};
        HashMap<Long, PriceInfo> result = new HashMap<Long, PriceInfo>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"pbd_mallgoods_price", (String)"id,discountrate,price,mallprice,taxrate,taxprice,nakedprice,modifytime,mallgoods.name", (QFilter[])filters, null);){
            Iterator iterator = dataSet.iterator();
            while (iterator.hasNext()) {
                PriceInfo priceInfo = new PriceInfo();
                Row row = (Row)iterator.next();
                priceInfo.setTaxPrice(row.getBigDecimal("price"));
                priceInfo.setEcPrice(row.getBigDecimal("mallprice"));
                priceInfo.setTaxRate(row.getBigDecimal("taxrate"));
                priceInfo.setTax(row.getBigDecimal("taxprice"));
                priceInfo.setPrice(row.getBigDecimal("nakedprice"));
                priceInfo.setShowprice(row.getBigDecimal("price"));
                result.put(row.getLong("id"), priceInfo);
            }
        }
        return result;
    }

    public List<PriceLogDTO> getGoodsPriceLogByGoodsId(Long id) throws Exception {
        String selectFields = "id,discountrate,price,mallprice,taxrate,taxprice,nakedprice,modifytime,mallgoods.name";
        QFilter[] filters = new QFilter[]{new QFilter("mallgoods", "=", (Object)id)};
        ArrayList<PriceLogDTO> result = new ArrayList<PriceLogDTO>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"pbd_mallgoods_pricelog", (String)"id,discountrate,price,mallprice,taxrate,taxprice,nakedprice,modifytime,mallgoods.name", (QFilter[])filters, (String)"modifytime");){
            Iterator iterator = dataSet.iterator();
            while (iterator.hasNext()) {
                PriceLogDTO dto = new PriceLogDTO();
                Row row = (Row)iterator.next();
                dto.setGoodsId(id);
                dto.setPrice(row.getBigDecimal("price"));
                dto.setMallPrice(row.getBigDecimal("mallprice"));
                dto.setNakedPrice(row.getBigDecimal("nakedprice"));
                dto.setTaxPrice(row.getBigDecimal("taxprice"));
                dto.setTaxRate(row.getBigDecimal("taxRate"));
                dto.setDiscountRate(row.getBigDecimal("discountrate"));
                dto.setModifyTime(row.getDate("modifytime"));
                result.add(dto);
            }
        }
        return result;
    }

    public PriceInfo getGoodsPriceByGoodsId(Long id) throws Exception {
        String selectFields = "id,discountrate,price,mallprice,taxrate,taxprice,nakedprice,modifytime,mallgoods.name";
        QFilter[] filters = new QFilter[]{new QFilter("mallgoods", "=", (Object)id)};
        PriceInfo priceInfo = new PriceInfo();
        DynamicObject data = QueryServiceHelper.queryOne((String)"pbd_mallgoods_price", (String)"id,discountrate,price,mallprice,taxrate,taxprice,nakedprice,modifytime,mallgoods.name", (QFilter[])filters);
        priceInfo.setTaxPrice(data.getBigDecimal("price"));
        priceInfo.setEcPrice(data.getBigDecimal("mallprice"));
        priceInfo.setTaxRate(data.getBigDecimal("taxrate"));
        priceInfo.setTax(data.getBigDecimal("taxprice"));
        priceInfo.setPrice(data.getBigDecimal("nakedprice"));
        priceInfo.setShowprice(data.getBigDecimal("price"));
        return priceInfo;
    }
}

