/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.DateUtil;
import kd.scm.mal.service.IMalPmOrdersWraperService;

public class MalPmOrdersWraperServiceImpl
implements IMalPmOrdersWraperService {
    private static Log log = LogFactory.getLog(MalPmOrdersWraperServiceImpl.class);

    public List<DynamicObject> wrapPmOrdersBill(List<DynamicObject> orders, Map<String, String> paramMap) {
        log.info("start MalPmOrdersWraperServiceImpl==============");
        log.info("paraMap:" + SerializationUtils.toJsonString(paramMap));
        if (paramMap != null) {
            Object values;
            String data = paramMap.get("data");
            HashMap<String, DynamicObject> storeMap = new HashMap<String, DynamicObject>();
            Map infosMap = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
            HashMap<String, String> propertiesBaseDataMapping = this.getProBdMapping();
            HashMap<String, ArrayList<Long>> propertyIdMapping = new HashMap<String, ArrayList<Long>>();
            HashMap<String, Map> propertyDynMapping = new HashMap<String, Map>(16);
            ArrayList<BigDecimal> taxRateValue = new ArrayList<BigDecimal>();
            if (infosMap != null && infosMap.size() > 0 && !(values = infosMap.values()).isEmpty()) {
                QFilter qFilter = new QFilter("entryentity.id", "in", values);
                DynamicObjectCollection compareColls = QueryServiceHelper.query((String)"mal_order", (String)this.getProperties(), (QFilter[])new QFilter[]{qFilter}, null);
                for (DynamicObject compareColl : compareColls) {
                    storeMap.put(compareColl.getString("entryentity.erpsourceentryid"), compareColl);
                    for (Map.Entry entry : propertiesBaseDataMapping.entrySet()) {
                        String property = (String)entry.getKey();
                        ArrayList<Long> idList = (ArrayList<Long>)propertyIdMapping.get(property);
                        if (idList == null) {
                            idList = new ArrayList<Long>();
                            propertyIdMapping.put(property, idList);
                        }
                        idList.add(compareColl.getLong(property));
                    }
                    taxRateValue.add(compareColl.getBigDecimal("entryentity.taxrate"));
                }
            }
            for (Map.Entry entry : propertyIdMapping.entrySet()) {
                String property = (String)entry.getKey();
                Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((Object[])((ArrayList)entry.getValue()).toArray(), (String)((String)propertiesBaseDataMapping.get(property)));
                propertyDynMapping.put(property, dynamicObjectMap);
            }
            log.info("propertyDynMapping size:" + propertiesBaseDataMapping.size());
            HashMap<BigDecimal, DynamicObject> taxDynMapping = this.getTaxDynMapping(taxRateValue);
            StringBuilder stringBuilder = new StringBuilder();
            for (DynamicObject order : orders) {
                stringBuilder.append("pmOrderId:").append(order.getLong("id")).append("\n");
                DynamicObjectCollection billentry = order.getDynamicObjectCollection("billentry");
                for (DynamicObject dynamicObject : billentry) {
                    DynamicObject info = (DynamicObject)storeMap.get(dynamicObject.getString("srcbillentryid"));
                    if (info == null) continue;
                    dynamicObject.set("soubillnumber", (Object)info.getString("billno"));
                    dynamicObject.set("mainbillnumber", (Object)info.getString("billno"));
                    stringBuilder.append("MalPmOrdersWraperServiceImpl:billno:").append(info.getString("billno")).append("\n");
                    dynamicObject.set("deliverdate", (Object)info.getDate("delidate"));
                    dynamicObject.set("entryreqorg_id", (Object)info.getLong("deporg"));
                    if (((Map)propertyDynMapping.get("person")).get(info.getLong("person")) != null) {
                        order.set("operator", (Object)((DynamicObject)((Map)propertyDynMapping.get("person")).get(info.getLong("person"))).getDynamicObject("person"));
                        order.set("operatorgroup", (Object)((DynamicObject)((Map)propertyDynMapping.get("person")).get(info.getLong("person"))).getDynamicObject("group"));
                    } else {
                        order.set("operator_id", (Object)0);
                        order.set("operatorgroup_id", (Object)0);
                    }
                    order.set("comment", (Object)info.getString("remark"));
                    dynamicObject.set("deliveraddress", (Object)info.getString("recieptaddr"));
                    order.set("org_id", (Object)info.getLong("org"));
                    dynamicObject.set("entryrecorg_id", (Object)info.getLong("rcvorg"));
                    dynamicObject.set("entrysettleorg", ((Map)propertyDynMapping.get("settleorg")).get(info.getLong("settleorg")));
                    dynamicObject.set("owner", ((Map)propertyDynMapping.get("settleorg")).get(info.getLong("settleorg")));
                    dynamicObject.set("entrypayorg_id", (Object)info.getLong("invoiceorg"));
                    order.set("settletype_id", (Object)info.getLong("settletype"));
                    order.set("settlecurrency", ((Map)propertyDynMapping.get("curr")).get(info.getLong("curr")));
                    order.set("istax", (Object)("2".equals(info.getString("taxtype")) ? "0" : "1"));
                    DynamicObject material = (DynamicObject)((Map)propertyDynMapping.get("entryentity.material")).get(info.getLong("entryentity.material"));
                    boolean isdisposable = material.getBoolean("isdisposable");
                    if (isdisposable) {
                        dynamicObject.set("materialname", (Object)info.getString("goodsname"));
                    }
                    dynamicObject.set("qty", (Object)info.getBigDecimal("entryentity.qty"));
                    dynamicObject.set("baseqty", null);
                    dynamicObject.set("receiveqtyup", null);
                    dynamicObject.set("receiveqtydown", null);
                    dynamicObject.set("price", (Object)info.getBigDecimal("entryentity.price"));
                    dynamicObject.set("priceandtax", (Object)info.getBigDecimal("entryentity.taxprice"));
                    BigDecimal taxRate = info.getBigDecimal("entryentity.taxrate");
                    if (taxDynMapping.get(taxRate) == null) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7a0e\u7387\u4e3a%1$s\u7684\u57fa\u7840\u8d44\u6599\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u7ef4\u62a4", (String)"MalPmOrdersWraperServiceImpl_0", (String)"scm-mal-mservice", (Object[])new Object[0]), taxRate));
                    }
                    dynamicObject.set("taxrateid", (Object)taxDynMapping.get(taxRate));
                    dynamicObject.set("taxrate", (Object)taxRate);
                    dynamicObject.set("taxamount", (Object)info.getBigDecimal("entryentity.tax"));
                    order.set("supplier_id", (Object)info.getLong("entryentity.supplier"));
                    DynamicObject linkMan = this.getLinkMan((DynamicObject)((Map)propertyDynMapping.get("entryentity.supplier")).get(info.getLong("entryentity.supplier")));
                    order.set("linkman", (Object)linkMan);
                    order.set("providerlinkman", (Object)linkMan);
                    order.set("invoicesupplier", (Object)((DynamicObject)((Map)propertyDynMapping.get("entryentity.supplier")).get(info.getLong("entryentity.supplier"))).getDynamicObject("invoicesupplierid"));
                    order.set("receivesupplier", (Object)((DynamicObject)((Map)propertyDynMapping.get("entryentity.supplier")).get(info.getLong("entryentity.supplier"))).getDynamicObject("receivingsupplierid"));
                    order.set("providersupplier_id", (Object)info.getLong("entryentity.supplier"));
                    dynamicObject.set("entrycomment", (Object)info.getString("entryentity.note"));
                    dynamicObject.set("mainbillentity", (Object)"mal_order");
                    dynamicObject.set("mainbillid", (Object)info.getLong("id"));
                    dynamicObject.set("mainbillentryid", (Object)info.getLong("entryentity.id"));
                    dynamicObject.set("soubillentity", (Object)"mal_order");
                    dynamicObject.set("soubillid", (Object)info.getLong("id"));
                    dynamicObject.set("soubillentryid", (Object)info.getLong("entryentity.id"));
                    order.set("creator_id", (Object)info.getLong("creator"));
                    order.set("createtime", (Object)info.getDate("createtime"));
                    order.set("modifier_id", (Object)info.getLong("modifier"));
                    order.set("modifytime", (Object)info.getDate("modifytime"));
                    order.set("auditor_id", (Object)info.getLong("auditor"));
                    order.set("auditdate", (Object)info.getDate("auditdate"));
                    Date auditshortdate = DateUtil.string2date((String)DateUtil.date2str((Date)info.getDate("auditdate"), (String)"yyyy-MM-dd HH:mm:ss"), (String)"yyyy-MM-dd");
                    order.set("biztime", (Object)auditshortdate);
                    order.set("exratedate", (Object)auditshortdate);
                    stringBuilder.append("MalPmOrdersWraperServiceImpl:mainbillnumber:").append(dynamicObject.getString("mainbillnumber"));
                }
            }
            log.info(stringBuilder.toString());
        }
        log.info("end MalPmOrdersWraperServiceImpl=================");
        return orders;
    }

    private String getProperties() {
        StringBuilder selectProperies = new StringBuilder();
        selectProperies.append("billno,delidate,deporg,person,receipt.wholeaddress recieptaddr,remark,").append("org,rcvorg,settleorg,invoiceorg,").append("settletype,curr,taxtype,").append("entryentity.goods.name goodsname,entryentity.qty,entryentity.price,entryentity.taxprice,entryentity.taxrateid,entryentity.supplier,entryentity.note,entryentity.id,id,").append("creator,createtime,modifier,modifytime,auditor,auditdate,").append("entryentity.erpsourcebilltype,entryentity.erpsourceid,entryentity.erpsourceentryid,").append("entryentity.tax,entryentity.taxrate,entryentity.material");
        return selectProperies.toString();
    }

    private HashMap<String, String> getProBdMapping() {
        HashMap<String, String> propertiesBaseDataMapping = new HashMap<String, String>();
        propertiesBaseDataMapping.put("person", "pur_bizperson");
        propertiesBaseDataMapping.put("entryentity.supplier", "bd_supplier");
        propertiesBaseDataMapping.put("settleorg", "bos_org");
        propertiesBaseDataMapping.put("curr", "bd_currency");
        propertiesBaseDataMapping.put("entryentity.material", "bd_material");
        return propertiesBaseDataMapping;
    }

    private HashMap<BigDecimal, DynamicObject> getTaxDynMapping(List<BigDecimal> taxRateValue) {
        DynamicObject[] taxDyn;
        HashMap<BigDecimal, DynamicObject> taxDynMapping = new HashMap<BigDecimal, DynamicObject>();
        block0: for (DynamicObject dynamicObject : taxDyn = BusinessDataServiceHelper.load((String)"bd_taxrate", (String)"id,taxrate", (QFilter[])new QFilter[]{new QFilter("taxrate", "in", taxRateValue)})) {
            BigDecimal taxrate = dynamicObject.getBigDecimal("taxrate");
            for (BigDecimal tax : taxRateValue) {
                if (tax.compareTo(taxrate) != 0) continue;
                taxDynMapping.put(tax, dynamicObject);
                continue block0;
            }
        }
        return taxDynMapping;
    }

    private DynamicObject getLinkMan(DynamicObject supplier) {
        if (supplier == null) {
            return null;
        }
        DynamicObjectCollection entry_linkman = supplier.getDynamicObjectCollection("entry_linkman");
        if (entry_linkman.size() == 0) {
            return null;
        }
        for (DynamicObject dynamicObject : entry_linkman) {
            if (!dynamicObject.getBoolean("isdefault_linkman")) continue;
            return dynamicObject;
        }
        return (DynamicObject)entry_linkman.get(0);
    }
}

