/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.helper.apiconnector.api.util.Parser;
import kd.scm.common.util.FeatureCheckUtil;
import kd.scm.mal.common.util.MalBizFowUtil;
import kd.scm.mal.domain.model.order.MalOrder;
import kd.scm.mal.domain.model.plan.MalPlan;
import kd.scm.mal.service.MalPushPlanService;

public class PmPushMalPlanImpl
implements MalPushPlanService {
    private static final Log log = LogFactory.getLog((String)PmPushMalPlanImpl.class.getName());
    private static final String PM_PURAPPLYBILL = "pm_purapplybill";
    private static final String APPLY_PLAN_RULE = "1391267851683537920";

    public Map<String, Object> pushMalPlan(Map<String, List<Map<String, Object>>> paramMap) {
        Map<String, Object> res;
        log.info("pushMalPlan.paramMap:" + paramMap);
        ArrayList<Long> result = new ArrayList<Long>();
        if (paramMap == null || paramMap.size() != 1) {
            return this.createResult(false, ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u9009\u62e9\u4e00\u5f20\u7533\u8bf7\u5355\u8fdb\u884c\u5546\u54c1\u9009\u8d2d", (String)"PmPushMalPlanImpl_0", (String)"scm-mal-mservice", (Object[])new Object[0]), result);
        }
        this.validateLicense();
        HashMap<String, BigDecimal> srcEntryIdJoinQtyMap = new HashMap<String, BigDecimal>();
        HashMap<Long, HashSet<Long>> srcIdSrcEntryIdsMap = new HashMap<Long, HashSet<Long>>();
        try {
            ArrayList<DynamicObject> targetDatas;
            List malPlans;
            block10: {
                for (Map.Entry<String, List<Map<String, Object>>> entry : paramMap.entrySet()) {
                    HashSet<Long> srcEntryIdSet = (HashSet<Long>)srcIdSrcEntryIdsMap.get(Long.valueOf(entry.getKey()));
                    for (Map<String, Object> entryMap : entry.getValue()) {
                        srcEntryIdJoinQtyMap.put(String.valueOf(entryMap.get("entryid")), new BigDecimal(String.valueOf(entryMap.get("joinqty"))));
                        if (srcEntryIdSet == null) {
                            srcEntryIdSet = new HashSet<Long>(paramMap.size() * 2);
                        }
                        srcEntryIdSet.add((Long)entryMap.get("entryid"));
                    }
                    srcIdSrcEntryIdsMap.put(Long.valueOf(entry.getKey()), srcEntryIdSet);
                }
                this.validateOnOrder(srcEntryIdJoinQtyMap.keySet());
                malPlans = MalPlan.batchInstanceOfSrcEntryIdSet(srcEntryIdJoinQtyMap.keySet());
                Iterator itr = srcIdSrcEntryIdsMap.entrySet().iterator();
                while (itr.hasNext()) {
                    Map.Entry entry = itr.next();
                    for (MalPlan malPlan : malPlans) {
                        result.add(malPlan.getId());
                        ((Set)entry.getValue()).removeIf(srcEntryId -> malPlan.getSrcEntryIds().contains(String.valueOf(srcEntryId)));
                        malPlan.doResetJoinQty(srcEntryIdJoinQtyMap);
                    }
                    if (!((Set)entry.getValue()).isEmpty()) continue;
                    itr.remove();
                }
                MalPlan.batchSave((List)malPlans);
                targetDatas = new ArrayList();
                try {
                    targetDatas = MalBizFowUtil.pushBySrcIdMap((String)APPLY_PLAN_RULE, (String)PM_PURAPPLYBILL, srcIdSrcEntryIdsMap, (String)"billentry", (String)"mal_plan");
                }
                catch (KDBizException e) {
                    log.warn("\u4e0b\u63a8\u91c7\u8d2d\u8ba1\u5212\u5931\u8d25\uff1a" + e.getMessage());
                    if (!result.isEmpty()) break block10;
                    throw new KDBizException(e.getMessage());
                }
            }
            this.validateIfExistDifferentOrg(targetDatas, malPlans, srcEntryIdJoinQtyMap.keySet());
            this.validateMaxPurchaseQtyForPurchase(targetDatas, malPlans, srcEntryIdJoinQtyMap.keySet());
            result.addAll(this.handleAfterPush(targetDatas));
            res = this.createResult(true, "", result);
            log.info("res:" + res);
        }
        catch (KDBizException e) {
            log.warn((Throwable)e);
            res = this.createResult(false, e.getMessage(), result);
        }
        return res;
    }

    private void validateLicense() {
        Map malLicenseResult = FeatureCheckUtil.checkMalFeature();
        Map jdLicenseResult = FeatureCheckUtil.checkMalJdFeature();
        if (Objects.nonNull(malLicenseResult) && Objects.nonNull(jdLicenseResult)) {
            boolean passCheck;
            boolean bl = passCheck = (Boolean)malLicenseResult.get("hasLicense") != false || (Boolean)jdLicenseResult.get("hasLicense") != false;
            if (!passCheck) {
                throw new KDBizException(Parser.toString(malLicenseResult.get("licenseMsg")));
            }
        }
    }

    private void validateMaxPurchaseQtyForPurchase(List<DynamicObject> targetDatas, List<MalPlan> malPlans, Set<String> srcEntryIds) {
        for (DynamicObject dyn : targetDatas) {
            MalPlan.getInstance((DynamicObject)dyn).validateMaxPurchaseQtyForPurchase(srcEntryIds);
        }
        for (MalPlan malPlan : malPlans) {
            malPlan.validateMaxPurchaseQtyForPurchase(srcEntryIds);
        }
    }

    private List<Long> handleAfterPush(List<DynamicObject> targetDatas) {
        if (targetDatas.isEmpty()) {
            return new ArrayList<Long>();
        }
        OperateOption option = MalBizFowUtil.createDefaultOpiton();
        OperationResult saveResult = MalBizFowUtil.doSaveOperation((String)"mal_plan", targetDatas, (OperateOption)option);
        OperationResult submitResult = MalBizFowUtil.doOperation((String)"mal_plan", (String)"submit", (Object[])saveResult.getSuccessPkIds().toArray(new Object[0]), (OperateOption)option, (boolean)true, (boolean)true);
        MalBizFowUtil.doOperation((String)"mal_plan", (String)"audit", (Object[])submitResult.getSuccessPkIds().toArray(new Object[0]), (OperateOption)option, (boolean)true, (boolean)true);
        ArrayList<Long> res = new ArrayList<Long>(targetDatas.size());
        for (Object id : saveResult.getSuccessPkIds()) {
            res.add((Long)id);
        }
        return res;
    }

    private void validateIfExistDifferentOrg(List<DynamicObject> targetDatas, List<MalPlan> malPlans, Set<String> srcEntryIds) {
        HashSet<Long> entryReqOrgSet = new HashSet<Long>(targetDatas.size() + malPlans.size());
        HashSet<Long> entryRcvOrgSet = new HashSet<Long>(targetDatas.size() + malPlans.size());
        for (DynamicObject dyn : targetDatas) {
            DynamicObjectCollection entryCol = dyn.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryCol) {
                entryReqOrgSet.add(entry.getLong("entryreqorg.id"));
                entryRcvOrgSet.add(entry.getLong("entryrcvorg.id"));
            }
        }
        for (MalPlan malPlan : malPlans) {
            entryReqOrgSet.addAll(malPlan.getEntryReqOrgSetFilterBySrcEntryIds(srcEntryIds));
            entryRcvOrgSet.addAll(malPlan.getEntryRcvOrgSetFilterBySrcEntryIds(srcEntryIds));
        }
        if (entryReqOrgSet.size() > 1 || entryRcvOrgSet.size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5bf9\u540c\u4e00\u4e2a\u9700\u6c42\u7ec4\u7ec7\u3001\u540c\u4e00\u4e2a\u6536\u8d27\u7ec4\u7ec7\u9009\u8d2d\u5546\u54c1", (String)"PmPushMalPlanImpl_1", (String)"scm-mal-mservice", (Object[])new Object[0]));
        }
    }

    private void validateOnOrder(Set<String> srcEntryIds) {
        DynamicObjectCollection malOrderCol = MalOrder.queryMalOrderBySrcEntryIdsOnOrder(srcEntryIds);
        if (malOrderCol.isEmpty()) {
            return;
        }
        HashSet<String> malOrderBillNoSet = new HashSet<String>();
        for (DynamicObject malOrder : malOrderCol) {
            malOrderBillNoSet.add(malOrder.getString("billno"));
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u5728\u9014\u5546\u57ce\u8ba2\u5355{0}\uff0c\u8bf7\u7b49\u5f85\u5173\u8054\u5546\u57ce\u8ba2\u5355\u5ba1\u6838\u540e\u91cd\u65b0\u8fdb\u884c\u5546\u57ce\u9009\u8d2d", (String)"PmPushMalPlanImpl_2", (String)"scm-mal-mservice", (Object[])new Object[]{malOrderBillNoSet}));
    }

    public Set<Long> queryMalOrderBySrcBillIds(Set<String> srcBillIds) {
        this.validateLicense();
        HashSet<Long> res = new HashSet<Long>(srcBillIds.size());
        DynamicObjectCollection malOrderCol = MalOrder.queryMalOrderBySrcBillIds(srcBillIds);
        for (DynamicObject malOrder : malOrderCol) {
            res.add(malOrder.getLong("id"));
        }
        return res;
    }

    private Map<String, Object> createResult(boolean success, String msg, List<Long> result) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("success", success);
        res.put("message", msg);
        res.put("result", result);
        return res;
    }
}

