/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.addcart;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ecapi.entity.GoodsInfo;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.ecapi.jd.JdApiUtil;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.ParamUtil;
import kd.scm.mal.common.addcart.MalAddToCartService;
import kd.scm.mal.common.addcart.impl.MalEcAddToCart;
import kd.scm.mal.common.addcart.impl.MalSelfAddToCart;
import kd.scm.malcore.domain.MalProdPool;
import kd.scm.malcore.enums.MallStatusEnum;

@Deprecated
public class MalAddToCartHelper {
    private static Map<String, MalAddToCartService> map = new HashMap<String, MalAddToCartService>();
    private static final BigDecimal DEFUALTQTY = BigDecimal.ONE;

    public static MalAddToCartService getAddToCartService(String source) {
        if (source.equals(EcPlatformEnum.ECPLATFORM_SELF.getVal())) {
            if (map.get(source) == null) {
                map.put(source, new MalSelfAddToCart());
            }
        } else if (map.get(source) == null) {
            map.put(source, new MalEcAddToCart());
        }
        return map.get(source);
    }

    public static void registerService(String productSource, MalAddToCartService pluginService) {
        if (productSource == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6765\u6e90\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MalAddToCartHelper_0", (String)"scm-mal-common", (Object[])new Object[0]));
        }
        if (pluginService == null) {
            throw new KDBizException(ResManager.loadKDString((String)"pluginService\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MalAddToCartHelper_1", (String)"scm-mal-common", (Object[])new Object[0]));
        }
        map.put(productSource, pluginService);
    }

    public static void clearMap() {
        map.clear();
    }

    public static boolean addCartNew(Long pk, String source) {
        boolean flag = false;
        if (StringUtils.isNotBlank((Object)pk) && pk != 0L && StringUtils.isNotEmpty((CharSequence)source)) {
            flag = MalAddToCartHelper.getAddToCartService(source).addCart(pk);
        }
        return flag;
    }

    public static boolean addCartNew(Long pk, String source, BigDecimal addqty) {
        boolean flag = false;
        if (addqty == null || addqty.compareTo(BigDecimal.ZERO) <= 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u52a0\u5165\u8d2d\u7269\u8f66\u7684\u5546\u54c1\u6570\u91cf\u5e94\u5927\u4e8e0\u3002", (String)"MalAddToCartHelper_3", (String)"scm-mal-common", (Object[])new Object[0]));
        }
        if (StringUtils.isNotBlank((Object)pk) && pk != 0L && StringUtils.isNotEmpty((CharSequence)source)) {
            flag = MalAddToCartHelper.getAddToCartService(source).addCart(pk, addqty);
        }
        return flag;
    }

    public static boolean addCartNew(String number, String source) {
        boolean flag = false;
        if (StringUtils.isNotBlank((CharSequence)number) && StringUtils.isNotEmpty((CharSequence)source)) {
            flag = MalAddToCartHelper.getAddToCartService(source).addCart(number, source);
        }
        return flag;
    }

    public static boolean addCart(String pk, String source) {
        if (StringUtils.isNotEmpty((CharSequence)pk) && StringUtils.isNotEmpty((CharSequence)source)) {
            if (source.equals(EcPlatformEnum.ECPLATFORM_SELF.getName()) || source.equals(EcPlatformEnum.ECPLATFORM_SELF.getVal())) {
                return MalAddToCartHelper.addMalProdToCart(pk, EcPlatformEnum.ECPLATFORM_SELF.getVal());
            }
            if (source.equals(EcPlatformEnum.ECPLATFORM_JD.getName()) || source.equals(EcPlatformEnum.ECPLATFORM_JD.getVal())) {
                return MalAddToCartHelper.addJDProdToCart(pk);
            }
        }
        return false;
    }

    public static boolean addMalProdToCart(String pk, String source) {
        DynamicObject dynamicObject;
        Long pkId = Long.valueOf(pk);
        String selectFields = "id,number,thumbnail,name,description,model,remark,source,supplier,unit,taxrate,curr,price,taxprice,shopprice";
        QFilter filter = new QFilter("id", "=", (Object)pkId);
        if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(source)) {
            filter.and("mallstatus", "=", (Object)MallStatusEnum.SOLD.getVal());
        }
        if ((dynamicObject = QueryServiceHelper.queryOne((String)"pbd_goods", (String)selectFields, (QFilter[])new QFilter[]{filter})) != null) {
            GoodsInfo goodsInfo = MalAddToCartHelper.getGoodsInfo(dynamicObject);
            DynamicObject cartDyObject = null;
            cartDyObject = MalAddToCartHelper.isExist(goodsInfo, source) ? MalAddToCartHelper.upateCartProd(goodsInfo, source) : MalAddToCartHelper.addnewCartProd(goodsInfo);
            SaveServiceHelper.save((IDataEntityType)cartDyObject.getDataEntityType(), (Object[])new DynamicObject[]{cartDyObject});
            return true;
        }
        return false;
    }

    public static boolean batchAddMalProdToCart(List<Long> pkList, Map<Long, BigDecimal> qtyMap) {
        DynamicObject[] dyos = MalAddToCartHelper.batchGetMalProd(pkList, qtyMap);
        if (dyos.length < 1) {
            return false;
        }
        OperationResult operationResult = SaveServiceHelper.saveOperate((String)"save", (String)"mal_shopcartbill", (DynamicObject[])dyos, null);
        return operationResult != null && operationResult.isSuccess();
    }

    public static DynamicObject[] batchGetMalProd(List<Long> pkList, Map<Long, BigDecimal> qtyMap) {
        String selectFields = "id,number,thumbnail,name,description,model,remark,source,supplier,unit,taxrate,curr,price,taxprice,shopprice";
        QFilter filter = new QFilter("id", "in", pkList);
        DynamicObjectCollection dyoCol = QueryServiceHelper.query((String)"pbd_goods", (String)selectFields, (QFilter[])new QFilter[]{filter});
        if (dyoCol != null && dyoCol.size() > 0) {
            DynamicObject[] dyos = new DynamicObject[dyoCol.size()];
            if (dyoCol.size() > 0) {
                for (int i = 0; i < dyoCol.size(); ++i) {
                    GoodsInfo goodsInfo = MalAddToCartHelper.getGoodsInfo((DynamicObject)dyoCol.get(i));
                    if (null != qtyMap && null != goodsInfo) {
                        goodsInfo.setQty(qtyMap.get(Long.valueOf(goodsInfo.getProductId())));
                    }
                    dyos[i] = MalAddToCartHelper.addnewCartProd(goodsInfo);
                }
            }
            return dyos;
        }
        return new DynamicObject[0];
    }

    public static boolean isExistNew(GoodsInfo goodsInfo) {
        return MalAddToCartHelper.isExist(goodsInfo, EcPlatformEnum.ECPLATFORM_SELF.getVal());
    }

    private static boolean isExist(GoodsInfo goodsInfo, String source) {
        QFilter personFilter = new QFilter("person", "=", (Object)RequestContext.get().getCurrUserId());
        QFilter goodsFilter = "1".equals(source) ? new QFilter("goods", "=", (Object)Long.parseLong(goodsInfo.getProductId())) : new QFilter("remark", "=", (Object)goodsInfo.getProductId());
        return QueryServiceHelper.exists((String)"mal_shopcartbill", (QFilter[])new QFilter[]{personFilter, goodsFilter});
    }

    public static boolean isNumberExist(String number, String source) {
        QFilter sourceFilter = new QFilter("source", "=", (Object)source);
        QFilter goodsFilter = new QFilter("goods.number", "=", (Object)number);
        return QueryServiceHelper.exists((String)"mal_shopcartbill", (QFilter[])new QFilter[]{sourceFilter, goodsFilter});
    }

    public static boolean addJDProdToCart(String pk) {
        GoodsInfo jdGoodsInfo = JdApiUtil.getJdProdDetail((String)pk, (boolean)false);
        if (jdGoodsInfo != null) {
            DynamicObject cartDyObject = null;
            cartDyObject = MalAddToCartHelper.isExist(jdGoodsInfo, EcPlatformEnum.ECPLATFORM_JD.getVal()) ? MalAddToCartHelper.upateCartProd(jdGoodsInfo, EcPlatformEnum.ECPLATFORM_JD.getVal()) : MalAddToCartHelper.addnewCartProd(jdGoodsInfo);
            SaveServiceHelper.save((IDataEntityType)cartDyObject.getDataEntityType(), (Object[])new DynamicObject[]{cartDyObject});
            return true;
        }
        return false;
    }

    public static DynamicObject addnewCartProd(GoodsInfo goodsInfo) {
        DynamicObject cartDyObject = BusinessDataServiceHelper.newDynamicObject((String)"mal_shopcartbill");
        cartDyObject.set("qty", (Object)(goodsInfo.getQty() != null ? goodsInfo.getQty() : DEFUALTQTY));
        MalAddToCartHelper.setCartObject(cartDyObject, goodsInfo);
        return cartDyObject;
    }

    private static void setCartObject(DynamicObject cartDyObject, GoodsInfo goodsInfo) {
        cartDyObject.set("goods", (Object)goodsInfo.getProductId());
        cartDyObject.set("goodsimg", (Object)goodsInfo.getProductImgPath());
        cartDyObject.set("goodsname", (Object)goodsInfo.getProductName());
        cartDyObject.set("goodsdesc", (Object)goodsInfo.getProductModel());
        cartDyObject.set("goodsource", (Object)goodsInfo.getProductSource());
        cartDyObject.set("taxprice", (Object)goodsInfo.getShopPrice());
        cartDyObject.set("unit_id", (Object)goodsInfo.getProductUnitID());
        cartDyObject.set("taxamount", (Object)goodsInfo.getShopPrice().multiply(cartDyObject.getBigDecimal("qty")));
        cartDyObject.set("curr_id", (Object)goodsInfo.getProductCurrID());
        cartDyObject.set("remark", (Object)goodsInfo.getRemark());
        cartDyObject.set("stockstatus", (Object)goodsInfo.getStockState());
        if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equalsIgnoreCase(goodsInfo.getProductSource())) {
            cartDyObject.set("stockqty", (Object)goodsInfo.getStockQty());
        } else if (EcPlatformEnum.ECPLATFORM_JD.getVal().equalsIgnoreCase(goodsInfo.getProductSource())) {
            if (null == goodsInfo.getProductDesc() || StringUtils.isEmpty((CharSequence)goodsInfo.getProductDesc())) {
                String soldOut = ResManager.loadKDString((String)"\u65e0\u8d27", (String)"MalAddToCartHelper_2", (String)"scm-mal-common", (Object[])new Object[0]);
                cartDyObject.set("goodsdesc", (Object)soldOut);
            } else {
                cartDyObject.set("goodsdesc", (Object)goodsInfo.getProductDesc());
            }
        }
        cartDyObject.set("supplier", (Object)goodsInfo.getSupplier());
        cartDyObject.set("price", (Object)goodsInfo.getPrice());
        cartDyObject.set("taxrate", (Object)goodsInfo.getTaxRate());
        cartDyObject.set("person", (Object)RequestContext.get().getCurrUserId());
        cartDyObject.set("billdate", (Object)new Date());
        cartDyObject.set("org", (Object)goodsInfo.getOrgId());
    }

    public static List<DynamicObject> addnewCartProd(List<GoodsInfo> goodsInfos) {
        HashSet<Long> goodsIds = new HashSet<Long>(1024);
        for (GoodsInfo info : goodsInfos) {
            goodsIds.add(Long.parseLong(info.getProductId()));
        }
        QFilter qFilter = new QFilter("goods.id", "in", goodsIds).and("person", "=", (Object)RequestContext.get().getCurrUserId());
        DynamicObjectCollection shopcarts = QueryServiceHelper.query((String)"mal_shopcartbill", (String)"qty,org,id,goods", (QFilter[])qFilter.toArray());
        HashMap<String, BigDecimal> qtyMap = new HashMap<String, BigDecimal>(1024);
        StringBuilder stringBuilder = new StringBuilder();
        Long contextOrgId = RequestContext.get().getOrgId();
        StringBuilder orgStr = new StringBuilder();
        for (DynamicObject shopcart : shopcarts) {
            Long orgId = shopcart.getLong("org");
            Long goodsId = shopcart.getLong("goods");
            stringBuilder.setLength(0);
            stringBuilder.append(orgId).append('_').append(goodsId);
            qtyMap.put(stringBuilder.toString(), shopcart.getBigDecimal("qty"));
        }
        ArrayList<DynamicObject> cartList = new ArrayList<DynamicObject>(1024);
        for (GoodsInfo goodsInfo : goodsInfos) {
            BigDecimal qty;
            orgStr.append('_').append(goodsInfo.getProductId());
            DynamicObject cartDyObject = BusinessDataServiceHelper.newDynamicObject((String)"mal_shopcartbill");
            stringBuilder.setLength(0);
            stringBuilder.append(goodsInfo.getOrgId()).append('_').append(goodsInfo.getProductId());
            if (qtyMap.get(stringBuilder.toString()) != null) {
                qty = (BigDecimal)qtyMap.get(stringBuilder.toString());
                cartDyObject.set("qty", (Object)qty.add(BigDecimal.ONE));
            } else {
                stringBuilder.setLength(0);
                stringBuilder.append(contextOrgId).append('_').append(goodsInfo.getProductId());
                if (goodsInfo.getOrgId().equals(0L) && qtyMap.get(stringBuilder.toString()) != null) {
                    qty = (BigDecimal)qtyMap.get(stringBuilder.toString());
                    cartDyObject.set("qty", (Object)qty.add(BigDecimal.ONE));
                } else {
                    stringBuilder.setLength(0);
                    stringBuilder.append(0L).append('_').append(goodsInfo.getProductId());
                    if (qtyMap.get(stringBuilder.toString()) != null) {
                        qty = (BigDecimal)qtyMap.get(stringBuilder.toString());
                        if (goodsInfo.getOrgId().equals(contextOrgId)) {
                            cartDyObject.set("qty", (Object)qty.add(BigDecimal.ONE));
                        } else {
                            cartDyObject.set("qty", (Object)qty);
                        }
                    } else {
                        cartDyObject.set("qty", (Object)(goodsInfo.getQty() != null ? goodsInfo.getQty() : DEFUALTQTY));
                    }
                }
            }
            MalAddToCartHelper.setCartObject(cartDyObject, goodsInfo);
            cartList.add(cartDyObject);
        }
        MalAddToCartHelper.setLaddprice(cartList);
        return cartList;
    }

    private static void setLaddprice(List<DynamicObject> cartList) {
        String param = ParamUtil.getSysCtrlParam((String)"UUPIH+47DAK", (String)"latestladderprice");
        if (Boolean.parseBoolean(param)) {
            HashSet<Long> goodIds = new HashSet<Long>(1024);
            for (DynamicObject info : cartList) {
                MalProdPool pool = new MalProdPool();
                pool.setQty(info.getBigDecimal("qty"));
                if (info.get("goods") instanceof DynamicObject) {
                    pool.setGoodsId(Long.valueOf(info.getDynamicObject("goods").getLong("id")));
                    goodIds.add(info.getDynamicObject("goods").getLong("id"));
                    continue;
                }
                pool.setGoodsId(Long.valueOf(info.getLong("goods")));
                goodIds.add(info.getLong("goods"));
            }
            HashSet<Long> poolIds = new HashSet<Long>(1024);
            HashMap pool_ladPriceMap = new HashMap(1024);
            QFilter qFilter = new QFilter("goods.id", "in", goodIds);
            StringBuilder ladderStr = new StringBuilder();
            String sectors = "id,priceentry.qtyfrom,priceentry.qtyto,priceentry.ladprice";
            DynamicObjectCollection pmm_prodpool = QueryServiceHelper.query((String)"pmm_prodpool", (String)sectors, (QFilter[])qFilter.toArray());
            for (Object row : pmm_prodpool) {
                ladderStr.setLength(0);
                long poolId = row.getLong("id");
                if (row.getBigDecimal("priceentry.qtyfrom").compareTo(BigDecimal.ZERO) <= 0) continue;
                poolIds.add(row.getLong("id"));
                List<String> ladderPrice = new ArrayList(1024);
                if (null != pool_ladPriceMap.get(poolId)) {
                    ladderPrice = (List)pool_ladPriceMap.get(poolId);
                }
                ladderStr.append(row.getBigDecimal("priceentry.qtyfrom")).append('_').append(row.getBigDecimal("priceentry.qtyto")).append('_').append(row.getBigDecimal("priceentry.ladprice"));
                ladderPrice.add(ladderStr.toString());
                pool_ladPriceMap.put(poolId, ladderPrice);
            }
            qFilter = new QFilter("id", "in", poolIds);
            sectors = "id,goods.id,entryentity.orgname";
            pmm_prodpool = QueryServiceHelper.query((String)"pmm_prodpool", (String)sectors, (QFilter[])qFilter.toArray());
            HashMap prodsOrg_LadpriceMap = new HashMap(1024);
            for (DynamicObject row : pmm_prodpool) {
                long poolId = row.getLong("id");
                Long goodsId = row.getLong("goods.id");
                Long orgId = row.getLong("entryentity.orgname");
                prodsOrg_LadpriceMap.put(String.valueOf(goodsId + orgId), pool_ladPriceMap.get(poolId));
            }
            BigDecimal one = new BigDecimal("1");
            for (DynamicObject info : cartList) {
                String key;
                BigDecimal qty = info.getBigDecimal("qty");
                BigDecimal taxrate = info.getBigDecimal("taxrate");
                Long goodsId = null;
                goodsId = info.get("goods") instanceof DynamicObject ? Long.valueOf(info.getDynamicObject("goods").getLong("id")) : Long.valueOf(info.getLong("goods"));
                long orgId = 0L;
                if (info.get("org") instanceof DynamicObject) {
                    if (null != info.getDynamicObject("org")) {
                        orgId = info.getDynamicObject("org").getLong("id");
                    }
                } else {
                    orgId = info.getLong("org");
                }
                if (null == prodsOrg_LadpriceMap.get(key = String.valueOf(goodsId + orgId))) continue;
                List LadpriceStr = (List)prodsOrg_LadpriceMap.get(key);
                for (String priceStr : LadpriceStr) {
                    String[] priceStrArr = priceStr.split("_");
                    BigDecimal qtyfrom = new BigDecimal(priceStrArr[0]);
                    BigDecimal qtyto = new BigDecimal(priceStrArr[1]);
                    BigDecimal ladprice = new BigDecimal(priceStrArr[2]);
                    if (qty.compareTo(qtyfrom) < 0 || qty.compareTo(qtyto) >= 0 && qtyto.compareTo(BigDecimal.ZERO) != 0) continue;
                    info.set("taxprice", (Object)ladprice);
                    if (taxrate.compareTo(BigDecimal.ZERO) == 0) {
                        info.set("price", (Object)ladprice);
                    } else {
                        BigDecimal price = ladprice.multiply(one.subtract(taxrate));
                        info.set("price", (Object)price);
                    }
                    info.set("taxamount", (Object)ladprice.multiply(info.getBigDecimal("qty")));
                }
            }
        }
    }

    public static DynamicObject upateCartProdNew(GoodsInfo goodsInfo) {
        String qtyFields = "qty,taxprice,taxamount,supplier,taxrate";
        QFilter prodNumberFilter = new QFilter("goods", "=", (Object)Long.parseLong(goodsInfo.getProductId()));
        QFilter pesronFilter = new QFilter("person", "=", (Object)RequestContext.get().getCurrUserId());
        DynamicObject cartDyObject = BusinessDataServiceHelper.loadSingle((String)"mal_shopcartbill", (String)qtyFields, (QFilter[])new QFilter[]{prodNumberFilter, pesronFilter});
        BigDecimal cartQty = (BigDecimal)cartDyObject.get("qty");
        BigDecimal newCartQty = null;
        newCartQty = Objects.nonNull(goodsInfo.getQty()) ? cartQty.add(goodsInfo.getQty()) : cartQty.add(DEFUALTQTY);
        BigDecimal cartTaxPrice = (BigDecimal)cartDyObject.get("taxprice");
        cartDyObject.set("qty", (Object)newCartQty);
        cartDyObject.set("taxamount", (Object)newCartQty.multiply(cartTaxPrice));
        cartDyObject.set("supplier", (Object)goodsInfo.getSupplier());
        return cartDyObject;
    }

    public static List<DynamicObject> upateCartProdNew(List<GoodsInfo> goodsInfos) {
        HashSet<Long> prods = new HashSet<Long>(1024);
        HashMap<Long, GoodsInfo> org_infoMap = new HashMap<Long, GoodsInfo>(1024);
        for (GoodsInfo info : goodsInfos) {
            prods.add(Long.parseLong(info.getProductId()));
            org_infoMap.put(info.getOrgId(), info);
        }
        String qtyFields = "qty,taxprice,taxamount,supplier,org,goods,price,taxrate";
        QFilter prodNumberFilter = new QFilter("goods", "in", prods);
        QFilter pesronFilter = new QFilter("person", "=", (Object)RequestContext.get().getCurrUserId());
        DynamicObject[] cartDyObject = BusinessDataServiceHelper.load((String)"mal_shopcartbill", (String)qtyFields, (QFilter[])new QFilter[]{prodNumberFilter, pesronFilter});
        ArrayList<DynamicObject> carts = new ArrayList<DynamicObject>(1024);
        for (DynamicObject info : cartDyObject) {
            DynamicObject org = info.getDynamicObject("org");
            Long orgId = 0L;
            if (null != org) {
                orgId = org.getLong("id");
            }
            if (null == org_infoMap.get(orgId)) continue;
            GoodsInfo goodsInfo = (GoodsInfo)org_infoMap.get(orgId);
            BigDecimal cartQty = info.getBigDecimal("qty");
            BigDecimal newCartQty = null;
            newCartQty = Objects.nonNull(goodsInfo.getQty()) ? cartQty.add(goodsInfo.getQty()) : cartQty.add(DEFUALTQTY);
            BigDecimal cartTaxPrice = info.getBigDecimal("taxprice");
            info.set("qty", (Object)newCartQty);
            info.set("taxamount", (Object)newCartQty.multiply(cartTaxPrice));
            info.set("supplier", (Object)goodsInfo.getSupplier());
            carts.add(info);
        }
        MalAddToCartHelper.setLaddprice(carts);
        return carts;
    }

    public static DynamicObject upateCartProd(GoodsInfo goodsInfo, String source) {
        String qtyFields = "qty,taxprice,taxamount";
        QFilter prodNumberFilter = null;
        prodNumberFilter = "1".equals(source) ? new QFilter("goods", "=", (Object)Long.parseLong(goodsInfo.getProductId())) : new QFilter("remark", "=", (Object)goodsInfo.getProductId());
        QFilter pesronFilter = new QFilter("person", "=", (Object)RequestContext.get().getCurrUserId());
        DynamicObject cartDyObject = BusinessDataServiceHelper.loadSingle((String)"mal_shopcartbill", (String)qtyFields, (QFilter[])new QFilter[]{prodNumberFilter, pesronFilter});
        BigDecimal cartQty = (BigDecimal)cartDyObject.get("qty");
        BigDecimal newCartQty = cartQty.add(DEFUALTQTY);
        BigDecimal cartTaxPrice = (BigDecimal)cartDyObject.get("taxprice");
        cartDyObject.set("qty", (Object)newCartQty);
        cartDyObject.set("taxamount", (Object)newCartQty.multiply(cartTaxPrice));
        return cartDyObject;
    }

    public static GoodsInfo getGoodsInfo(DynamicObject dyo, BigDecimal addqty) {
        GoodsInfo goodsInfo = MalAddToCartHelper.getGoodsInfo(dyo);
        goodsInfo.setQty(addqty);
        goodsInfo.setAmount(goodsInfo.getQty().multiply(goodsInfo.getShopPrice()));
        return goodsInfo;
    }

    public static GoodsInfo getGoodsInfo(DynamicObject dyo) {
        GoodsInfo goodsInfo = new GoodsInfo();
        String prodId = dyo.getString("id");
        goodsInfo.setProductId(prodId);
        goodsInfo.setProductNumber(dyo.getString("number"));
        goodsInfo.setProductImgPath(dyo.getString("thumbnail"));
        goodsInfo.setProductName(dyo.getString("name"));
        goodsInfo.setProductDesc(dyo.getString("description"));
        goodsInfo.setProductModel(dyo.getString("model"));
        goodsInfo.setRemark(dyo.getString("remark"));
        goodsInfo.setProductSource(dyo.getString("source"));
        goodsInfo.setSupplier(dyo.getString("supplier"));
        goodsInfo.setProductUnitID(dyo.getString("unit"));
        goodsInfo.setTaxRate(CommonUtil.getBigDecimalPro((Object)dyo.getString("taxrate")));
        goodsInfo.setProductCurrID(dyo.getString("curr"));
        goodsInfo.setPrice(dyo.getBigDecimal("price"));
        goodsInfo.setTaxPrice(dyo.getBigDecimal("taxprice"));
        if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(goodsInfo.getProductSource())) {
            goodsInfo.setShopPrice(dyo.getBigDecimal("taxprice"));
        } else {
            goodsInfo.setShopPrice(dyo.getBigDecimal("shopprice"));
        }
        BigDecimal stockQty = MalAddToCartHelper.getAvailableqty(prodId);
        goodsInfo.setStockQty(stockQty);
        goodsInfo.setStockState("1");
        return goodsInfo;
    }

    public static GoodsInfo getEcGoodsInfo(DynamicObject dyo, BigDecimal addqty) {
        GoodsInfo goodsInfo = MalAddToCartHelper.getEcGoodsInfo(dyo);
        goodsInfo.setQty(addqty);
        return goodsInfo;
    }

    public static GoodsInfo getEcGoodsInfo(DynamicObject dyo) {
        GoodsInfo goodsInfo = new GoodsInfo();
        Long prodId = dyo.getLong("id");
        QFilter qFilters = new QFilter("mallgoods", "=", (Object)prodId);
        DynamicObject price = QueryServiceHelper.queryOne((String)"pbd_mallgoods_price", (String)"mallgoods,price,nakedprice,taxrate", (QFilter[])new QFilter[]{qFilters});
        goodsInfo.setProductId(String.valueOf(prodId));
        goodsInfo.setProductNumber(dyo.getString("number"));
        goodsInfo.setProductImgPath(dyo.getString("thumbnail"));
        goodsInfo.setProductName(dyo.getString("name"));
        goodsInfo.setProductModel(dyo.getString("model"));
        goodsInfo.setProductSource(dyo.getString("source"));
        goodsInfo.setSupplier(dyo.getString("supplier"));
        goodsInfo.setProductUnitID(dyo.getString("unit"));
        goodsInfo.setTaxRate(CommonUtil.getBigDecimalPro((Object)price.getString("taxrate")).setScale(2));
        goodsInfo.setProductCurrID(dyo.getString("curr"));
        goodsInfo.setPrice(price.getBigDecimal("nakedprice"));
        goodsInfo.setTaxPrice(price.getBigDecimal("price"));
        goodsInfo.setShopPrice(price.getBigDecimal("price"));
        goodsInfo.setRemark(dyo.getString("number"));
        goodsInfo.setStockQty(BigDecimal.ZERO);
        goodsInfo.setStockState("1");
        return goodsInfo;
    }

    public static BigDecimal getAvailableqty(String goodsid) {
        BigDecimal bigDecimal = BigDecimal.ZERO;
        QFilter goodsidFilter = new QFilter("goods", "in", (Object)Long.parseLong(goodsid));
        String selectFields = "availableqty";
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"pmm_inventory", (String)selectFields, (QFilter[])new QFilter[]{goodsidFilter});
        if (dyn != null) {
            bigDecimal = CommonUtil.getBigDecimalPro((Object)dyn.getString("availableqty"));
        }
        return bigDecimal;
    }
}

