/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.aftersale;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.ReturnStatusEnum;
import kd.scm.common.util.AfterSaleUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.mal.common.aftersale.AftersaleUpdateModel;

public abstract class AbstractAfterSaleUpdater {
    private static final String SUMRETURNREQQTY = "sumreturnreqqty";
    private Log log = LogFactory.getLog((String)this.getClass().getName());
    private AftersaleUpdateModel aftersaleUpdateModel;
    private DynamicObject malreturnreqDyn;
    private DynamicObjectCollection asServiceBillDynCol;
    private DynamicObject malorderDyn;
    private DynamicObject purorderDyn;
    private DynamicObject malorderEntryDyn;
    private DynamicObject purorderEntryDyn;
    private Map<String, String> statusMap;
    private BigDecimal returnAmout = BigDecimal.ZERO;
    private String source;

    public String getSource() {
        return this.source;
    }

    public Map<String, String> getStatusMap() {
        return this.statusMap;
    }

    public AftersaleUpdateModel getAftersaleUpdateModel() {
        return this.aftersaleUpdateModel;
    }

    public void setAftersaleUpdateModel(AftersaleUpdateModel aftersaleUpdateModel) {
        this.aftersaleUpdateModel = aftersaleUpdateModel;
    }

    public DynamicObject getMalreturnreqDyn() {
        return this.malreturnreqDyn;
    }

    public DynamicObjectCollection getAsServiceBillDynCol() {
        return this.asServiceBillDynCol;
    }

    public DynamicObject getMalorderDyn() {
        return this.malorderDyn;
    }

    public DynamicObject getPurorderDyn() {
        return this.purorderDyn;
    }

    public AbstractAfterSaleUpdater() {
    }

    public AbstractAfterSaleUpdater(DynamicObject malreturnreqDyn, Object serviceResult) {
        this.malreturnreqDyn = malreturnreqDyn;
        this.statusMap = this.getStatusMapping();
        this.aftersaleUpdateModel = this.initConvertModel(serviceResult);
        this.asServiceBillDynCol = this.getAsServiceBillDynColByReturnReqDyn(malreturnreqDyn);
        this.getMalorderAndPurOrderDyn(malreturnreqDyn);
    }

    public AbstractAfterSaleUpdater(DynamicObject malreturnreqDyn, Object serviceResult, String source) {
        this.source = source;
        this.malreturnreqDyn = malreturnreqDyn;
        this.statusMap = this.getStatusMapping();
        this.aftersaleUpdateModel = this.initConvertModel(serviceResult);
        this.asServiceBillDynCol = this.getAsServiceBillDynColByReturnReqDyn(malreturnreqDyn);
        this.getMalorderAndPurOrderDyn(malreturnreqDyn);
    }

    private AftersaleUpdateModel initConvertModel(Object serviceResult) {
        return this.convertModel(serviceResult);
    }

    private Map<String, String> getStatusMapping() {
        Map<String, String> stateMap = this.statusMapping();
        if (stateMap == null) {
            return new HashMap<String, String>();
        }
        return stateMap;
    }

    private void getMalorderAndPurOrderDyn(DynamicObject malreturnreqDyn) {
        DynamicObject purOrderDyn;
        DynamicObjectCollection entryentityCol = malreturnreqDyn.getDynamicObjectCollection("entryentity");
        if (entryentityCol.isEmpty()) {
            return;
        }
        String poentryid = ((DynamicObject)entryentityCol.get(0)).getString("poentryid");
        String selectPurOrderField = "id,materialentry,materialentry.sumreturnreqqty,materialentry.srcentryid,materialentry.poentryid,materialentry.pobillid";
        String filterEntryField = "poentryid";
        this.purorderDyn = purOrderDyn = BusinessDataServiceHelper.loadSingle((String)"pur_order", (String)selectPurOrderField, (QFilter[])new QFilter[]{new QFilter("materialentry." + filterEntryField, "=", (Object)poentryid)});
        if (purOrderDyn != null) {
            DynamicObjectCollection entryCol = purOrderDyn.getDynamicObjectCollection("materialentry");
            if (entryCol.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u5173\u8054\u7684\u534f\u540c\u8ba2\u5355\u5206\u5f55\u3002", (String)"AbstractAfterSaleUpdater_0", (String)"scm-mal-common", (Object[])new Object[0]));
            }
            String malOrderEntryId = "";
            for (DynamicObject entry : entryCol) {
                if (!poentryid.equals(entry.getString("poentryid"))) continue;
                malOrderEntryId = entry.getString("srcentryid");
                this.purorderEntryDyn = entry;
                break;
            }
            this.initMalOrderEntryDyn(malOrderEntryId);
        }
    }

    private void initMalOrderEntryDyn(String malOrderEntryId) {
        if (StringUtils.isEmpty((CharSequence)malOrderEntryId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u5173\u8054\u7684\u5546\u57ce\u8ba2\u5355\u5206\u5f55\u3002", (String)"AbstractAfterSaleUpdater_1", (String)"scm-mal-common", (Object[])new Object[0]));
        }
        String selectMalOrderField = "entryentity,entryentity.sumreturnreqqty,entryentity.returnamount,entryentity.taxprice,platform,billno,entryentity.order,entryentity.srcentryid";
        DynamicObject malOrderDyn = BusinessDataServiceHelper.loadSingle((String)"mal_order", (String)selectMalOrderField, (QFilter[])new QFilter[]{new QFilter("entryentity.id", "=", (Object)Long.parseLong(malOrderEntryId))});
        if (malOrderDyn == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u5173\u8054\u7684\u5546\u57ce\u8ba2\u5355\u5206\u5f55\u3002", (String)"AbstractAfterSaleUpdater_1", (String)"scm-mal-common", (Object[])new Object[0]));
        }
        this.malorderDyn = malOrderDyn;
        DynamicObjectCollection malOrderEntryCol = malOrderDyn.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : malOrderEntryCol) {
            if (!malOrderEntryId.equals(entry.getString("id"))) continue;
            this.malorderEntryDyn = entry;
            break;
        }
    }

    private DynamicObjectCollection getAsServiceBillDynColByReturnReqDyn(DynamicObject malreturnreqDyn) {
        DynamicObjectCollection afterSaleEntryCol = malreturnreqDyn.getDynamicObjectCollection("aftersaleentry");
        DynamicObjectCollection result = new DynamicObjectCollection();
        HashSet<Long> afsIdSet = new HashSet<Long>();
        DynamicObjectType dt = null;
        for (DynamicObject afterSaleEntry : afterSaleEntryCol) {
            DynamicObject afsDyn = afterSaleEntry.getDynamicObject("afservicebill");
            if (afsDyn == null) continue;
            afsIdSet.add(afsDyn.getLong("id"));
            dt = afsDyn.getDynamicObjectType();
        }
        if (dt != null) {
            DynamicObject[] afsDyns = BusinessDataServiceHelper.load((Object[])afsIdSet.toArray(), dt);
            result.addAll(Arrays.asList(afsDyns));
        }
        return result;
    }

    public abstract AftersaleUpdateModel convertModel(Object var1);

    public Map<String, String> statusMapping() {
        HashMap<String, String> returnStatusMap = new HashMap<String, String>();
        QFilter filter = new QFilter("statustypenumber", "=", (Object)"2");
        filter.and(new QFilter("emaltype", "=", (Object)this.malreturnreqDyn.getString("platform")));
        DynamicObjectCollection emalstatusDynCol = QueryServiceHelper.query((String)"pbd_emalstatus", (String)"number,emalstatusnumber", (QFilter[])new QFilter[]{filter});
        for (DynamicObject emalstatusDyn : emalstatusDynCol) {
            returnStatusMap.put(emalstatusDyn.getString("emalstatusnumber"), emalstatusDyn.getString("number"));
        }
        return returnStatusMap;
    }

    public boolean isServiceFailed() {
        String curStep = this.getStatusMap().get(this.getAftersaleUpdateModel().getAfsservicestepnum());
        return ReturnStatusEnum.REFUSE.getVal().equals(curStep) || ReturnStatusEnum.CANCEL.getVal().equals(curStep);
    }

    public void update() {
        if (this.asServiceBillDynCol.isEmpty()) {
            for (AftersaleUpdateModel relatedAfs : this.aftersaleUpdateModel.getRelatedAfs()) {
                this.asServiceBillDynCol.add((Object)this.createAsServBillDynAndRelate(relatedAfs));
            }
        } else {
            HashSet<String> existAfsIdSet = new HashSet<String>();
            for (DynamicObject dyn : this.asServiceBillDynCol) {
                String existAfsId = dyn.getString("number");
                if (!StringUtils.isNotEmpty((CharSequence)existAfsId)) continue;
                existAfsIdSet.add(dyn.getString("number"));
            }
            List<AftersaleUpdateModel> relatedAfsList = this.aftersaleUpdateModel.getRelatedAfs();
            if (relatedAfsList != null && !relatedAfsList.isEmpty()) {
                for (AftersaleUpdateModel relatedAfs : relatedAfsList) {
                    this.updateAsServBillDyn(relatedAfs);
                    if (!StringUtils.isNotEmpty((CharSequence)relatedAfs.getAfsServiceId()) || existAfsIdSet.contains(relatedAfs.getAfsServiceId())) continue;
                    this.asServiceBillDynCol.add((Object)this.createAsServBillDynAndRelate(relatedAfs));
                }
            }
        }
        AfterSaleUtil.adjustData((DynamicObject[])new DynamicObject[]{this.malreturnreqDyn});
        this.updateMalreturnreqDyn();
    }

    protected void updateAsServBillDyn(AftersaleUpdateModel model) {
        DynamicObject asServiceBillDyn = null;
        if (StringUtils.isEmpty((CharSequence)model.getAfsServiceId())) {
            asServiceBillDyn = (DynamicObject)this.asServiceBillDynCol.get(0);
        } else {
            for (DynamicObject dyn : this.asServiceBillDynCol) {
                if (!model.getAfsServiceId().equals(dyn.getString("number"))) continue;
                asServiceBillDyn = dyn;
            }
        }
        if (asServiceBillDyn != null) {
            asServiceBillDyn.set("orderid", (Object)model.getOrderId());
            asServiceBillDyn.set("number", (Object)model.getAfsServiceId());
            asServiceBillDyn.set("afsservicestepnum", (Object)model.getAfsservicestepnum());
            asServiceBillDyn.set("afsservicestep", (Object)model.getAfsServiceStep());
            asServiceBillDyn.set("cancelstatus", (Object)model.getCancel());
            asServiceBillDyn.set("afsservicestepdate", (Object)model.getAfsservicestepdate());
            asServiceBillDyn.set("returncontact", (Object)model.getReturnContact());
            asServiceBillDyn.set("returnphone", (Object)model.getReturnPhone());
            asServiceBillDyn.set("returnaddress", (Object)model.getReturnAddress());
            asServiceBillDyn.set("returnamount", (Object)model.getReturnAmount());
        }
    }

    protected void updateMalorderDyn() {
        if (this.malorderEntryDyn == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u552e\u540e\u7533\u8bf7\u5355\u5bf9\u5e94\u7684\u5546\u57ce\u8ba2\u5355\u5206\u5f55\uff0c\u8bf7\u4fdd\u8bc1\u914d\u7f6e\u5de5\u5177\u4e2d\u91c7\u8d2d\u534f\u540c\u7cfb\u7edf\u53c2\u6570\u7684\u540c\u6b65\u53c2\u6570\u59cb\u7ec8\u4e00\u81f4\u3002", (String)"AbstractAfterSaleUpdater_2", (String)"scm-mal-common", (Object[])new Object[0]));
        }
        if (this.isServiceFailed()) {
            BigDecimal oldSumReturnReqQty = this.malorderEntryDyn.getBigDecimal(SUMRETURNREQQTY);
            BigDecimal newSumReturnReqQty = oldSumReturnReqQty.subtract(this.aftersaleUpdateModel.getNum());
            if (newSumReturnReqQty.compareTo(BigDecimal.ZERO) < 0) {
                newSumReturnReqQty = BigDecimal.ZERO;
            }
            this.malorderEntryDyn.set(SUMRETURNREQQTY, (Object)newSumReturnReqQty);
        }
        this.malorderEntryDyn.set("returnamount", (Object)this.calReturnAmount());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.malorderDyn});
    }

    private BigDecimal calReturnAmount() {
        String selectFields = "aftersaleentry.afservicebill.orderid,aftersaleentry.afservicebill.returnamount,entryentity.srcentryid";
        QFilter filter = new QFilter("malorderno", "=", (Object)this.malorderDyn.getString("billno")).and("cfmstatus", "in", (Object)new String[]{"B", "F"}).and("entryentity.srcentryid", "=", (Object)this.malorderEntryDyn.getString("id"));
        DynamicObjectCollection returnEntryCol = QueryServiceHelper.query((String)"mal_returnreq", (String)selectFields, (QFilter[])new QFilter[]{filter});
        BigDecimal returnAmount = BigDecimal.ZERO;
        for (DynamicObject returnEntry : returnEntryCol) {
            returnAmount = returnAmount.add(returnEntry.getBigDecimal("aftersaleentry.afservicebill.returnamount"));
        }
        this.returnAmout = returnAmount;
        return returnAmount;
    }

    protected void updatePurorderDyn() {
        if (this.isServiceFailed()) {
            BigDecimal oldSumReturnReqQty = this.purorderEntryDyn.getBigDecimal(SUMRETURNREQQTY);
            BigDecimal newSumReturnReqQty = oldSumReturnReqQty.subtract(this.aftersaleUpdateModel.getNum());
            if (newSumReturnReqQty.compareTo(BigDecimal.ZERO) < 0) {
                newSumReturnReqQty = BigDecimal.ZERO;
            }
            this.purorderEntryDyn.set(SUMRETURNREQQTY, (Object)newSumReturnReqQty);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.purorderDyn});
        }
    }

    protected void updateMalreturnreqDyn() {
        String aftersaleStatus;
        if (this.isServiceFailed()) {
            this.malreturnreqDyn.set("billstatus", (Object)BillStatusEnum.CANCELED.getVal());
        }
        if (StringUtils.isNotEmpty((CharSequence)(aftersaleStatus = this.statusMap.get(this.aftersaleUpdateModel.getAfsservicestepnum())))) {
            this.malreturnreqDyn.set("cfmstatus", (Object)aftersaleStatus);
        }
    }

    public void commit() {
        try (TXHandle h = TX.requiresNew();){
            SaveServiceHelper.save((DynamicObject[])((DynamicObject[])this.asServiceBillDynCol.toArray((Object[])new DynamicObject[0])));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.malreturnreqDyn});
        }
        catch (Exception rollback) {
            this.log.error("\u552e\u540e\u66f4\u65b0\u63d0\u4ea4\u6570\u636e\u5e93\u5931\u8d25\uff1a" + ExceptionUtil.getStackTrace((Throwable)rollback));
        }
    }

    public void afterCommit() {
        this.updatePurorderDyn();
        this.updateMalorderDyn();
        this.updatePurThirdData();
    }

    public void updatePurThirdData() {
        DynamicObject[] purThirdDataDyns;
        if (StringUtils.isEmpty((CharSequence)this.aftersaleUpdateModel.getOrderId())) {
            return;
        }
        for (DynamicObject purThirdDataDyn : purThirdDataDyns = this.loadThirdDataDyns(this.aftersaleUpdateModel.getOrderId())) {
            DynamicObjectCollection entryCol = purThirdDataDyn.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryCol) {
                if (!this.aftersaleUpdateModel.getOrderId().equals(entry.getString("childorder"))) continue;
                entry.set("returnamount", (Object)this.returnAmout);
            }
        }
        SaveServiceHelper.save((DynamicObject[])purThirdDataDyns);
    }

    public DynamicObject[] loadThirdDataDyns(String ecOrderId) {
        String selectField = "entryentity,entryentity.childorder,entryentity.returnamount";
        QFilter childOrderFilter = new QFilter("entryentity.childorder", "=", (Object)ecOrderId);
        return BusinessDataServiceHelper.load((String)"pur_thirddata", (String)selectField, (QFilter[])new QFilter[]{childOrderFilter});
    }

    protected DynamicObject createAsServBillDynAndRelate(AftersaleUpdateModel model) {
        if (model == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u670d\u52a1\u5355\u4fe1\u606f\u5931\u8d25\uff0c\u65e0\u6cd5\u521b\u5efa\u7535\u5546\u670d\u52a1\u5355\u3002", (String)"AbstractAfterSaleUpdater_3", (String)"scm-mal-common", (Object[])new Object[0]));
        }
        DynamicObjectType dt = this.getAsServiceBillDynCol().getDynamicObjectType();
        if (dt == null) {
            dt = BusinessDataServiceHelper.newDynamicObject((String)"pbd_eafservicebill").getDynamicObjectType();
        }
        DynamicObject afServiceBillDyn = new DynamicObject(dt);
        Date applydate = model.getAfsservicestepdate();
        afServiceBillDyn.set("applydate", (Object)(applydate == null ? TimeServiceHelper.now() : applydate));
        DynamicObject returnReqEntryDyn = (DynamicObject)this.malreturnreqDyn.getDynamicObjectCollection("entryentity").get(0);
        afServiceBillDyn.set("returntype", (Object)returnReqEntryDyn.getString("returntype"));
        afServiceBillDyn.set("source", (Object)this.malreturnreqDyn.getString("platform"));
        afServiceBillDyn.set("porderid", (Object)model.getPorderId());
        afServiceBillDyn.set("orderid", (Object)model.getOrderId());
        afServiceBillDyn.set("number", (Object)model.getAfsServiceId());
        afServiceBillDyn.set("afsservicestepnum", (Object)model.getAfsservicestepnum());
        afServiceBillDyn.set("afsservicestep", (Object)model.getAfsServiceStep());
        afServiceBillDyn.set("cancelstatus", (Object)model.getCancel());
        afServiceBillDyn.set("afsservicestepdate", (Object)model.getAfsservicestepdate());
        afServiceBillDyn.set("returncontact", (Object)model.getReturnContact());
        afServiceBillDyn.set("returnphone", (Object)model.getReturnPhone());
        afServiceBillDyn.set("returnaddress", (Object)model.getReturnAddress());
        afServiceBillDyn.set("returnamount", (Object)model.getReturnAmount());
        DynamicObjectCollection afServiceBillEntryCol = afServiceBillDyn.getDynamicObjectCollection("entryentity");
        DynamicObject afServiceBillEntry = new DynamicObject(afServiceBillEntryCol.getDynamicObjectType());
        afServiceBillEntry.set("sku", (Object)returnReqEntryDyn.getString("goods.number"));
        afServiceBillEntry.set("goods_id", (Object)returnReqEntryDyn.getString("goods.id"));
        afServiceBillEntry.set("returnqty", (Object)returnReqEntryDyn.getBigDecimal("qty"));
        afServiceBillEntryCol.add((Object)afServiceBillEntry);
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", String.valueOf(true));
        option.setVariableValue("isStrict", String.valueOf(false));
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"pbd_eafservicebill", (DynamicObject[])new DynamicObject[]{afServiceBillDyn}, (OperateOption)option);
        if (!saveResult.isSuccess()) {
            String msg = ResManager.loadKDString((String)"\u521b\u5efa\u7535\u5546\u552e\u540e\u670d\u52a1\u5355\u5931\u8d25\u3002\u539f\u56e0\uff1a", (String)"AbstractAfterSaleUpdater_4", (String)"scm-mal-common", (Object[])new Object[0]);
            throw new KDBizException(msg + ExceptionUtil.getErrorInfoDetails((List)saveResult.getAllErrorOrValidateInfo()));
        }
        DynamicObject afsDyn = BusinessDataServiceHelper.loadSingle(saveResult.getSuccessPkIds().get(0), (DynamicObjectType)dt);
        DynamicObjectCollection returnReqEntryCol = this.malreturnreqDyn.getDynamicObjectCollection("aftersaleentry");
        DynamicObject returnReqEntry = new DynamicObject(returnReqEntryCol.getDynamicObjectType());
        returnReqEntry.set("afservicebill_id", saveResult.getSuccessPkIds().get(0));
        returnReqEntry.set("afservicebill", (Object)afsDyn);
        returnReqEntryCol.add((Object)returnReqEntry);
        return afsDyn;
    }

    public void updateAndCommit() {
        this.update();
        this.commit();
        this.afterCommit();
    }
}

