/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.aftersale;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.ecapi.jd.dto.AfsServicebyCustomerPin;
import kd.scm.common.util.AfterSaleUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.mal.common.aftersale.AbstractAfterSaleUpdater;
import kd.scm.mal.common.aftersale.AftersaleUpdateModel;
import kd.scm.mal.common.aftersale.impl.JDNewAfterSaleService;
import kd.scm.mal.common.aftersale.impl.JDProAfterSaleService;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class JDAfterSaleUpdater
extends AbstractAfterSaleUpdater {
    private static final Log log = LogFactory.getLog(JDAfterSaleUpdater.class);

    public JDAfterSaleUpdater(DynamicObject malreturnreqDyn, Object serviceResult) {
        super(malreturnreqDyn, serviceResult);
    }

    public JDAfterSaleUpdater(DynamicObject malreturnreqDyn, Object serviceResult, String source) {
        super(malreturnreqDyn, serviceResult, source);
    }

    @Override
    public AftersaleUpdateModel convertModel(Object serviceResult) {
        JDNewAfterSaleService afterSaleService = this.getJdService(this.getSource());
        AftersaleUpdateModel aftersaleUpdateModel = new AftersaleUpdateModel();
        DynamicObject malreturnreqDyn = this.getMalreturnreqDyn();
        String ecSource = malreturnreqDyn.getString("ecsource");
        DynamicObjectCollection entryCol = malreturnreqDyn.getDynamicObjectCollection("entryentity");
        if (entryCol.isEmpty()) {
            return aftersaleUpdateModel;
        }
        String ecPorderPk = ((DynamicObject)entryCol.get(0)).getString("ecorder.id");
        BigDecimal returnQty = ((DynamicObject)entryCol.get(0)).getBigDecimal("qty");
        aftersaleUpdateModel.setNum(returnQty);
        String orderId = afterSaleService.queryEcOrderId(ecPorderPk, ecSource);
        if (StringUtils.isEmpty((CharSequence)orderId)) {
            orderId = ((DynamicObject)entryCol.get(0)).getString("jdchildorderid");
        }
        List<AfsServicebyCustomerPin> afsServicebyCustomerPins = afterSaleService.queryAfsServicebyCustomerPins(orderId);
        StringBuilder logStr = new StringBuilder();
        for (AfsServicebyCustomerPin afs : afsServicebyCustomerPins) {
            if (!StringUtils.equals((CharSequence)String.valueOf(afs.getWareId()), (CharSequence)((DynamicObject)entryCol.get(0)).getString("goods.number"))) continue;
            try {
                this.initAftersaleUpdateModel(aftersaleUpdateModel, afs);
            }
            catch (ParseException e) {
                logStr.append("initAftersaleUpdateModel:").append(ExceptionUtil.getStackTrace((Throwable)e)).append(System.lineSeparator());
            }
        }
        log.error(logStr.toString());
        return aftersaleUpdateModel;
    }

    private void initAftersaleUpdateModel(AftersaleUpdateModel aftersaleUpdateModel, AfsServicebyCustomerPin afs) throws ParseException {
        JDNewAfterSaleService afterSaleService = this.getJdService(this.getSource());
        AftersaleUpdateModel model = new AftersaleUpdateModel();
        if (StringUtils.isEmpty((CharSequence)aftersaleUpdateModel.getAfsServiceId())) {
            model = aftersaleUpdateModel;
        } else {
            model.setNum(BigDecimal.ONE);
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        model.setAfsservicestepdate(df.parse(afs.getAfsApplyTime()));
        model.setPlatform(this.getSource());
        model.setAfsServiceId(String.valueOf(afs.getAfsServiceId()));
        model.setAfsServiceStep(afs.getAfsServiceStepName());
        model.setAfsservicestepnum(String.valueOf(afs.getAfsServiceStep()));
        model.setSkuId(String.valueOf(afs.getWareId()));
        model.setPorderId(String.valueOf(afs.getPorderId()));
        model.setOrderId(String.valueOf(afs.getOrderId()));
        model.setCancel(afs.getCancel());
        JSONArray appendInfoSteps = JSONArray.fromObject((Object)"[1,2,3,4,5]");
        JSONObject compatibleServiceDetailJo = afterSaleService.getServiceDetailInfo(String.valueOf(afs.getAfsServiceId()), appendInfoSteps.toString());
        AfterSaleUtil.setReturnAmount((JSONObject)compatibleServiceDetailJo, (AfsServicebyCustomerPin)afs);
        AfterSaleUtil.setReturnAddressInfo((JSONObject)compatibleServiceDetailJo, (AfsServicebyCustomerPin)afs);
        model.setReturnAmount(afs.getReturnAmount());
        model.setReturnAddress(afs.getReturnAddress());
        model.setReturnContact(afs.getReturnContact());
        model.setReturnPhone(afs.getReturnPhone());
        aftersaleUpdateModel.getRelatedAfs().add(model);
    }

    private JDNewAfterSaleService getJdService(String source) {
        return EcPlatformEnum.ECPLATFORM_JDPRO.getVal().equals(source) ? new JDProAfterSaleService() : new JDNewAfterSaleService();
    }
}

