/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.aftersale;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.mal.common.aftersale.AbstractAfterSaleUpdater;
import kd.scm.mal.common.aftersale.AftersaleUpdateModel;
import kd.scm.mal.common.aftersale.bean.ReturnInfo;
import kd.scm.mal.common.aftersale.bean.SNServiceResult;
import kd.scm.mal.common.aftersale.bean.SNServiceScheduleResultInfo;
import kd.scm.mal.common.aftersale.enums.SNAfterSrvStatusEnum;
import kd.scm.mal.common.util.MalPlaceOrderUtils;

public class SNAfterSaleUpdater
extends AbstractAfterSaleUpdater {
    public SNAfterSaleUpdater(DynamicObject malreturnreqDyn, SNServiceResult<SNServiceScheduleResultInfo> serviceResult) {
        super(malreturnreqDyn, serviceResult);
    }

    @Override
    public AftersaleUpdateModel convertModel(Object serviceResult) {
        AftersaleUpdateModel aftersaleUpdateModel = new AftersaleUpdateModel();
        if (serviceResult instanceof SNServiceResult) {
            aftersaleUpdateModel.setPlatform(EcPlatformEnum.ECPLATFORM_SUNING.getVal());
            SNServiceResult snServiceResult = (SNServiceResult)serviceResult;
            List snServiceScheduleResultInfoList = snServiceResult.getResultInfoList();
            if (!snServiceScheduleResultInfoList.isEmpty()) {
                SNServiceScheduleResultInfo snServiceScheduleResultInfo = (SNServiceScheduleResultInfo)snServiceScheduleResultInfoList.get(0);
                aftersaleUpdateModel.setAfsServiceId(snServiceScheduleResultInfo.getSheetId());
                aftersaleUpdateModel.setAfsServiceStep(snServiceScheduleResultInfo.getAfterSrvStatus().getName());
                aftersaleUpdateModel.setAfsservicestepnum(snServiceScheduleResultInfo.getAfterSrvStatus().getVal());
                aftersaleUpdateModel.setSkuId(snServiceScheduleResultInfo.getSku());
                aftersaleUpdateModel.setNum(new BigDecimal(snServiceScheduleResultInfo.getNum()));
                aftersaleUpdateModel.setPorderId(snServiceResult.getOrderId());
                aftersaleUpdateModel.setOrderId(snServiceScheduleResultInfo.getOrderItemId());
                aftersaleUpdateModel.setReturnAmount(this.queryReturnAmount(snServiceResult.getOrderId(), snServiceScheduleResultInfo.getSku()));
                HashSet<String> canCancelStatus = new HashSet<String>();
                canCancelStatus.add(SNAfterSrvStatusEnum.RETEXCHG_AGREE.getVal());
                canCancelStatus.add(SNAfterSrvStatusEnum.RETEXCHG_TODO.getVal());
                canCancelStatus.add(SNAfterSrvStatusEnum.RETEXCHG_RECEIVE.getVal());
                canCancelStatus.add(SNAfterSrvStatusEnum.RETEXCHG_CUSTOMER_SEND.getVal());
                canCancelStatus.add(SNAfterSrvStatusEnum.RETEXCHG_AGREE_REFUND_OR_EXCHG.getVal());
                canCancelStatus.add(SNAfterSrvStatusEnum.RETEXCHG_EXCHG_SEND.getVal());
                if (snServiceScheduleResultInfo.getAfterSrvStatus() != null && canCancelStatus.contains(snServiceScheduleResultInfo.getAfterSrvStatus().getVal())) {
                    aftersaleUpdateModel.setCancel(1);
                } else {
                    aftersaleUpdateModel.setCancel(0);
                }
                List<ReturnInfo> returnInfos = snServiceScheduleResultInfo.getReturnInfos();
                if (!returnInfos.isEmpty()) {
                    ReturnInfo returnInfo = returnInfos.get(0);
                    aftersaleUpdateModel.setReturnAddress(returnInfo.getReturnAddress());
                    aftersaleUpdateModel.setReturnContact(returnInfo.getReturnName());
                    aftersaleUpdateModel.setReturnPhone(returnInfo.getReturnPhone());
                }
                aftersaleUpdateModel.getRelatedAfs().add(aftersaleUpdateModel);
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u89e3\u6790\u9519\u8bef", (String)"SNAfterSaleUpdater_0", (String)"scm-mal-common", (Object[])new Object[0]));
        }
        return aftersaleUpdateModel;
    }

    public BigDecimal queryReturnAmount(String orderId, String sku) {
        Map<String, Map<String, String>> orderDetail = MalPlaceOrderUtils.getSnOrderDetail(orderId);
        Map<String, String> itemInfo = orderDetail.get(sku);
        String returnAmountStr = itemInfo.get("refundMoney");
        if (StringUtils.isEmpty((CharSequence)returnAmountStr)) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(returnAmountStr);
    }
}

