/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.aftersale.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.ecapi.jd.enums.AfterSaleServiceTypeEnum;
import kd.scm.common.ecapi.jd.enums.ComponentExportEnum;
import kd.scm.common.ecapi.util.AddressUtil;
import kd.scm.common.helper.apiconnector.api.ApiAccessor;
import kd.scm.common.helper.apiconnector.api.ApiResult;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.mal.common.aftersale.AbstractAfterSaleUpdater;
import kd.scm.mal.common.aftersale.CGAfterSaleUpdater;
import kd.scm.mal.common.aftersale.bean.AfterSaleServiceDetailInfo;
import kd.scm.mal.common.aftersale.bean.AftersaleSubmitParam;
import kd.scm.mal.common.aftersale.bean.AftersaleSubmitSkuInfo;
import kd.scm.mal.common.aftersale.bean.ServiceResult;
import kd.scm.mal.common.aftersale.impl.StandardAfterSaleService;

public class CGAfterSaleService
extends StandardAfterSaleService {
    private final Log log = LogFactory.getLog((String)this.getClass().getName());

    @Override
    public ServiceResult doSubmit(AftersaleSubmitParam aftersaleSubmitParam) {
        StringBuilder logString = new StringBuilder();
        logString.append("@@SRM_CG_AFTERSALE_refundApply:").append("\n");
        HashMap<String, Object> paramMap = new HashMap<String, Object>(32);
        paramMap.put("orderId", aftersaleSubmitParam.getOrderId());
        logString.append("orderId:").append(aftersaleSubmitParam.getOrderId()).append("\n");
        if (StringUtils.isNotEmpty((CharSequence)aftersaleSubmitParam.getAftersaleType())) {
            paramMap.put("aftersaleType", aftersaleSubmitParam.getAftersaleType());
            logString.append("aftersaleType:").append(aftersaleSubmitParam.getAftersaleType()).append("\n");
        }
        if (StringUtils.isNotEmpty((CharSequence)aftersaleSubmitParam.getQuestionDesc())) {
            paramMap.put("questionDesc", aftersaleSubmitParam.getQuestionDesc());
            logString.append("questionDesc:").append(aftersaleSubmitParam.getQuestionDesc()).append("\n");
        }
        if (StringUtils.isNotEmpty((CharSequence)aftersaleSubmitParam.getAddress())) {
            paramMap.put("address", aftersaleSubmitParam.getAddress());
        }
        if (StringUtils.isNotEmpty((CharSequence)aftersaleSubmitParam.getPickwareType())) {
            paramMap.put("pickwareType", aftersaleSubmitParam.getPickwareType());
        }
        if (StringUtils.isNotEmpty((CharSequence)aftersaleSubmitParam.getAftersaleName())) {
            paramMap.put("aftersaleName", aftersaleSubmitParam.getAftersaleName());
        }
        if (StringUtils.isNotEmpty((CharSequence)aftersaleSubmitParam.getAftersalePhone())) {
            paramMap.put("aftersalePhone", aftersaleSubmitParam.getAftersalePhone());
        }
        if (StringUtils.isNotEmpty((CharSequence)aftersaleSubmitParam.getCustomerMobilePhone())) {
            paramMap.put("customerMobilePhone", aftersaleSubmitParam.getCustomerMobilePhone());
        }
        if (StringUtils.isNotEmpty((CharSequence)aftersaleSubmitParam.getCustomerEmail())) {
            paramMap.put("customerEmail", aftersaleSubmitParam.getCustomerEmail());
        }
        if (StringUtils.isNotEmpty((CharSequence)aftersaleSubmitParam.getApplyTime())) {
            paramMap.put("applyTime", aftersaleSubmitParam.getApplyTime());
            logString.append("applyTime:").append(aftersaleSubmitParam.getApplyTime()).append("\n");
        }
        if (StringUtils.isNotEmpty((CharSequence)aftersaleSubmitParam.getProvinceId())) {
            paramMap.put("provinceId", aftersaleSubmitParam.getProvinceId());
            logString.append("provinceId:").append(aftersaleSubmitParam.getProvinceId()).append("\n");
        }
        if (StringUtils.isNotEmpty((CharSequence)aftersaleSubmitParam.getCityId())) {
            paramMap.put("cityId", aftersaleSubmitParam.getCityId());
        }
        if (StringUtils.isNotEmpty((CharSequence)aftersaleSubmitParam.getCountyId())) {
            paramMap.put("countyId", aftersaleSubmitParam.getCountyId());
        }
        if (StringUtils.isNotEmpty((CharSequence)aftersaleSubmitParam.getFullAddress())) {
            paramMap.put("fullAddress", aftersaleSubmitParam.getFullAddress());
        }
        List<AftersaleSubmitSkuInfo> skus = aftersaleSubmitParam.getSkus();
        ArrayList skuMapList = new ArrayList();
        skus.forEach(aftersaleSubmitSkuInfo -> {
            HashMap<String, Object> skuMap = new HashMap<String, Object>();
            skuMap.put("sku", aftersaleSubmitSkuInfo.getSkuId());
            skuMap.put("num", aftersaleSubmitSkuInfo.getNum());
            skuMap.put("price", aftersaleSubmitSkuInfo.getTaxPrice());
            skuMapList.add(skuMap);
        });
        paramMap.put("skus", skuMapList);
        logString.append("skus:").append(SerializationUtils.toJsonString(skuMapList)).append("\n");
        this.log.info(logString.toString());
        Object res = ApiAccessor.invoke((String)"SRM_CG_AFTERSALE_refundApply", paramMap);
        return this.parseAfterSaleRes(res);
    }

    public ServiceResult parseAfterSaleRes(Object res) {
        Map resMap = (Map)res;
        if (!((Boolean)resMap.get("success")).booleanValue()) {
            this.log.info((String)resMap.get("resultMessage"));
            throw new KDBizException((String)resMap.get("resultMessage"));
        }
        Map resultMap = (Map)resMap.get("result");
        ServiceResult serviceResult = new ServiceResult();
        serviceResult.setSheetId(String.valueOf(resultMap.get("sheetId")));
        return serviceResult;
    }

    @Override
    public void afterSubmit(Object submitResult, AftersaleSubmitParam aftersaleSubmitParam, DynamicObject returnReqDyn) {
        super.afterSubmit(submitResult, aftersaleSubmitParam, returnReqDyn);
    }

    @Override
    public List<ComponentExportEnum> getComponentExport(String ecOrderId, String sku) {
        ArrayList<ComponentExportEnum> componentExportEnums = new ArrayList<ComponentExportEnum>();
        componentExportEnums.add(ComponentExportEnum.CG_DOOR_TO_TAKE);
        componentExportEnums.add(ComponentExportEnum.CG_CUSTOMER_SEND);
        return componentExportEnums;
    }

    @Override
    public AftersaleSubmitParam packageAfterSaleParam(DynamicObject returnReqDyn) {
        DynamicObjectCollection entryentityCol = returnReqDyn.getDynamicObjectCollection("entryentity");
        String platform = returnReqDyn.getString("platform");
        DynamicObject returnEntry = (DynamicObject)entryentityCol.get(0);
        AftersaleSubmitParam aftersaleSubmitParam = new AftersaleSubmitParam();
        aftersaleSubmitParam.setSource(platform);
        aftersaleSubmitParam.setApplyTime(this.now());
        aftersaleSubmitParam.setAddress(returnReqDyn.getString("address"));
        aftersaleSubmitParam.setAftersaleName(returnReqDyn.getString("linkman"));
        aftersaleSubmitParam.setAftersalePhone(returnReqDyn.getString("phone"));
        aftersaleSubmitParam.setAftersaleType(returnEntry.getString("returntype"));
        aftersaleSubmitParam.setQuestionDesc(returnEntry.getString("retreason"));
        aftersaleSubmitParam.setPickwareType(returnEntry.getString("pickwaretype").substring(1));
        String admindivisionLongNum = AddressUtil.getLongNumber((Long)returnReqDyn.getLong("admindivision"), (String)platform);
        String[] addrLongnumberStrs = admindivisionLongNum.split("\\.");
        if (addrLongnumberStrs.length > 2) {
            aftersaleSubmitParam.setProvinceId(addrLongnumberStrs[0]);
            aftersaleSubmitParam.setCityId(addrLongnumberStrs[1]);
            aftersaleSubmitParam.setCountyId(addrLongnumberStrs[2]);
        }
        aftersaleSubmitParam.setAftersaleName(returnReqDyn.getString("linkman"));
        aftersaleSubmitParam.setCustomerMobilePhone(returnReqDyn.getString("phone"));
        aftersaleSubmitParam.setCustomerEmail(returnReqDyn.getString("email"));
        aftersaleSubmitParam.setOrderId(this.getOrderId(returnReqDyn));
        ArrayList<AftersaleSubmitSkuInfo> aftersaleSubmitSkuInfos = new ArrayList<AftersaleSubmitSkuInfo>();
        for (DynamicObject entry : entryentityCol) {
            AftersaleSubmitSkuInfo aftersaleSubmitSkuInfo = new AftersaleSubmitSkuInfo(entry.getInt("qty"), entry.getString("goods.number"));
            aftersaleSubmitSkuInfo.setTaxPrice(entry.getString("taxprice"));
            aftersaleSubmitSkuInfos.add(aftersaleSubmitSkuInfo);
        }
        aftersaleSubmitParam.setSkus(aftersaleSubmitSkuInfos);
        return aftersaleSubmitParam;
    }

    @Override
    public BigDecimal getAvailableNumberComp(String orderId, String sku) {
        return BigDecimal.ONE;
    }

    @Override
    public DynamicObject createAfServiceBill(Object submitResult, DynamicObject returnReqDyn) {
        ServiceResult cgSubmitResult = (ServiceResult)submitResult;
        DynamicObject afServiceBillDyn = super.createAfServiceBill(submitResult, returnReqDyn);
        afServiceBillDyn.set("number", (Object)cgSubmitResult.getSheetId());
        afServiceBillDyn.set("porderid", (Object)cgSubmitResult.getOrderId());
        afServiceBillDyn.set("orderid", (Object)cgSubmitResult.getOrderId());
        return afServiceBillDyn;
    }

    @Override
    public <T extends AftersaleSubmitParam> ServiceResult queryAfterSrvSchedule(T aftersaleSubmitParam) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("orderId", aftersaleSubmitParam.getOrderId());
        paramMap.put("sheetId", aftersaleSubmitParam.getSheetId());
        Object res = ApiAccessor.invoke((String)"SRM_CG_AFTERSALE_refundQuery", paramMap);
        if (res != null) {
            return (ServiceResult)this.parseAfterSrvScheduleRes(res).getResult();
        }
        return new AfterSaleServiceDetailInfo();
    }

    public ApiResult<AfterSaleServiceDetailInfo> parseAfterSrvScheduleRes(Object res) {
        ApiResult apiResult = new ApiResult();
        try {
            Map resMap = (Map)res;
            apiResult.setSuccess(((Boolean)resMap.get("success")).booleanValue());
            apiResult.setResultMessage((String)resMap.get("resultMessage"));
            apiResult.setResultCode((String)resMap.get("resultCode"));
            if (!apiResult.isSuccess()) {
                this.log.error((String)resMap.get("resultMessage"));
                throw new KDBizException((String)resMap.get("resultMessage"));
            }
            Map resultMap = (Map)resMap.get("result");
            apiResult.setResult((Object)new AfterSaleServiceDetailInfo(resultMap));
        }
        catch (ClassCastException e) {
            this.log.error(res.toString() + "\r\n" + ExceptionUtil.getStackTrace((Throwable)e));
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u8f6c\u6362\u9519\u8bef\u3002", (String)"CGAfterSaleService_0", (String)"scm-mal-common", (Object[])new Object[0]));
        }
        return apiResult;
    }

    @Override
    public void updateAfterServiceSchedule(DynamicObject malreturnreqDyn) {
        AftersaleSubmitParam aftersaleSubmitParam = new AftersaleSubmitParam();
        aftersaleSubmitParam.setSheetId(this.getAfsId(malreturnreqDyn));
        aftersaleSubmitParam.setOrderId(this.getOrderId(malreturnreqDyn));
        AfterSaleServiceDetailInfo serviceResult = (AfterSaleServiceDetailInfo)this.queryAfterSrvSchedule(aftersaleSubmitParam);
        DynamicObjectCollection entryentityCol = malreturnreqDyn.getDynamicObjectCollection("entryentity");
        DynamicObject firstEntry = (DynamicObject)entryentityCol.get(0);
        serviceResult.setNum(firstEntry.getInt("qty"));
        serviceResult.setSkuId(firstEntry.getString("goods.number"));
        AbstractAfterSaleUpdater afterSaleUpdater = this.getAfterSaleUpdater(malreturnreqDyn, serviceResult);
        afterSaleUpdater.updateAndCommit();
    }

    public AbstractAfterSaleUpdater getAfterSaleUpdater(DynamicObject malreturnreqDyn, AfterSaleServiceDetailInfo serviceResult) {
        return new CGAfterSaleUpdater(malreturnreqDyn, serviceResult);
    }

    @Override
    public List<AfterSaleServiceTypeEnum> getCustomerExpectComp(String orderItemId, String skuId, String orderId, String cityId, String countyId) {
        ArrayList<AfterSaleServiceTypeEnum> afterSaleServiceTypeEnums = new ArrayList<AfterSaleServiceTypeEnum>();
        afterSaleServiceTypeEnums.add(AfterSaleServiceTypeEnum.CG_RETURN);
        afterSaleServiceTypeEnums.add(AfterSaleServiceTypeEnum.CG_EXCHANGE);
        return afterSaleServiceTypeEnums;
    }

    @Override
    public List<Long> cancelAfterSale(Map<String, String> orderItemIdSkuIdMap, String orderId, String cancelType, String sheetId) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("orderId", orderId);
        paramMap.put("sheetId", sheetId);
        Map res = (Map)ApiAccessor.invoke((String)"SRM_CG_AFTERSALE_refundCancel", paramMap);
        if (!((Boolean)res.get("success")).booleanValue()) {
            throw new KDBizException(String.valueOf(res.get("resultMessage")));
        }
        return new ArrayList<Long>();
    }
}

