/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.aftersale.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.ecapi.jd.enums.AfterSaleServiceTypeEnum;
import kd.scm.common.ecapi.jd.enums.ComponentExportEnum;
import kd.scm.common.helper.apiconnector.api.ApiAccessor;
import kd.scm.common.helper.apiconnector.api.ApiResult;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.mal.common.aftersale.AbstractAfterSaleUpdater;
import kd.scm.mal.common.aftersale.DLAfterSaleUpdater;
import kd.scm.mal.common.aftersale.bean.AfterSaleServiceDetailInfo;
import kd.scm.mal.common.aftersale.bean.AftersaleSubmitParam;
import kd.scm.mal.common.aftersale.bean.AftersaleSubmitSkuInfo;
import kd.scm.mal.common.aftersale.bean.ServiceResult;
import kd.scm.mal.common.aftersale.impl.StandardAfterSaleService;
import net.sf.json.JSONArray;

public class DLAfterSaleService
extends StandardAfterSaleService {
    private final Log log = LogFactory.getLog((String)this.getClass().getName());

    @Override
    public ServiceResult doSubmit(AftersaleSubmitParam aftersaleSubmitParam) {
        StringBuilder logString = new StringBuilder();
        logString.append("@@SRM_DL_AFTERSALE_submitReturn:").append("\n");
        HashMap<String, String> paramMap = new HashMap<String, String>(32);
        paramMap.put("orderId", aftersaleSubmitParam.getOrderId());
        logString.append("orderId:").append(aftersaleSubmitParam.getOrderId()).append("\n");
        String sheetId = String.valueOf(TimeServiceHelper.getTimeStamp());
        aftersaleSubmitParam.setSheetId(sheetId);
        paramMap.put("sheetId", sheetId);
        logString.append("sheetId:").append(sheetId).append("\n");
        if (StringUtils.isNotEmpty((CharSequence)aftersaleSubmitParam.getQuestionDesc())) {
            paramMap.put("questionDesc", aftersaleSubmitParam.getQuestionDesc());
            logString.append("questionDesc:").append(aftersaleSubmitParam.getQuestionDesc()).append("\n");
        }
        if (StringUtils.isNotEmpty((CharSequence)aftersaleSubmitParam.getAftersaleName())) {
            paramMap.put("aftersaleName", aftersaleSubmitParam.getAftersaleName());
        }
        if (StringUtils.isNotEmpty((CharSequence)aftersaleSubmitParam.getAftersalePhone())) {
            paramMap.put("aftersalePhone", aftersaleSubmitParam.getAftersalePhone());
        }
        if (StringUtils.isNotEmpty((CharSequence)aftersaleSubmitParam.getApplyTime())) {
            paramMap.put("applyTime", aftersaleSubmitParam.getApplyTime());
            logString.append("applyTime:").append(aftersaleSubmitParam.getApplyTime()).append("\n");
        }
        List<AftersaleSubmitSkuInfo> skus = aftersaleSubmitParam.getSkus();
        ArrayList skuMapList = new ArrayList();
        skus.forEach(aftersaleSubmitSkuInfo -> {
            HashMap<String, Object> skuMap = new HashMap<String, Object>();
            skuMap.put("sku", aftersaleSubmitSkuInfo.getSkuId());
            skuMap.put("num", aftersaleSubmitSkuInfo.getNum());
            skuMapList.add(skuMap);
        });
        paramMap.put("skus", (String)JSONArray.fromObject(skuMapList));
        logString.append("skus:").append(SerializationUtils.toJsonString(skuMapList)).append("\n");
        this.log.info(logString.toString());
        Object res = ApiAccessor.invoke((String)"SRM_DL_AFTERSALE_submitReturn", paramMap);
        ServiceResult serviceResult = this.parseAfterSaleRes(res);
        serviceResult.setSheetId(aftersaleSubmitParam.getSheetId());
        return serviceResult;
    }

    public ServiceResult parseAfterSaleRes(Object res) {
        Map resMap = (Map)res;
        if (((Boolean)resMap.get("success")).booleanValue()) {
            return new ServiceResult();
        }
        this.log.info((String)resMap.get("resultMessage"));
        throw new KDBizException((String)resMap.get("resultMessage"));
    }

    @Override
    public void afterSubmit(Object submitResult, AftersaleSubmitParam aftersaleSubmitParam, DynamicObject returnReqDyn) {
        super.afterSubmit(submitResult, aftersaleSubmitParam, returnReqDyn);
    }

    @Override
    public List<ComponentExportEnum> getComponentExport(String ecOrderId, String sku) {
        ArrayList<ComponentExportEnum> componentExportEnums = new ArrayList<ComponentExportEnum>(1);
        componentExportEnums.add(ComponentExportEnum.CUSTOMER_SEND);
        return componentExportEnums;
    }

    @Override
    public AftersaleSubmitParam packageAfterSaleParam(DynamicObject returnReqDyn) {
        DynamicObjectCollection entryentityCol = returnReqDyn.getDynamicObjectCollection("entryentity");
        String platform = returnReqDyn.getString("platform");
        DynamicObject returnEntry = (DynamicObject)entryentityCol.get(0);
        AftersaleSubmitParam aftersaleSubmitParam = new AftersaleSubmitParam();
        aftersaleSubmitParam.setSource(platform);
        aftersaleSubmitParam.setApplyTime(this.now());
        aftersaleSubmitParam.setAftersaleName(returnReqDyn.getString("linkman"));
        aftersaleSubmitParam.setAftersalePhone(returnReqDyn.getString("phone"));
        aftersaleSubmitParam.setAftersaleType(returnEntry.getString("returntype"));
        aftersaleSubmitParam.setQuestionDesc(returnEntry.getString("retreason"));
        aftersaleSubmitParam.setAftersaleName(returnReqDyn.getString("linkman"));
        aftersaleSubmitParam.setOrderId(this.getOrderId(returnReqDyn));
        ArrayList<AftersaleSubmitSkuInfo> aftersaleSubmitSkuInfos = new ArrayList<AftersaleSubmitSkuInfo>();
        for (DynamicObject entry : entryentityCol) {
            AftersaleSubmitSkuInfo aftersaleSubmitSkuInfo = new AftersaleSubmitSkuInfo(entry.getInt("qty"), entry.getString("goods.number"));
            aftersaleSubmitSkuInfo.setTaxPrice(entry.getString("taxprice"));
            aftersaleSubmitSkuInfos.add(aftersaleSubmitSkuInfo);
        }
        aftersaleSubmitParam.setSkus(aftersaleSubmitSkuInfos);
        return aftersaleSubmitParam;
    }

    @Override
    public BigDecimal getAvailableNumberComp(String orderId, String sku) {
        return BigDecimal.ONE;
    }

    @Override
    public DynamicObject createAfServiceBill(Object submitResult, DynamicObject returnReqDyn) {
        ServiceResult dlSubmitResult = (ServiceResult)submitResult;
        DynamicObject afServiceBillDyn = super.createAfServiceBill(submitResult, returnReqDyn);
        afServiceBillDyn.set("number", (Object)dlSubmitResult.getSheetId());
        afServiceBillDyn.set("porderid", (Object)dlSubmitResult.getOrderId());
        afServiceBillDyn.set("orderid", (Object)dlSubmitResult.getOrderId());
        return afServiceBillDyn;
    }

    @Override
    public <T extends AftersaleSubmitParam> ServiceResult queryAfterSrvSchedule(T aftersaleSubmitParam) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("sheetId", aftersaleSubmitParam.getSheetId());
        Object res = ApiAccessor.invoke((String)"SRM_DL_AFTERSALE_getReturn", paramMap);
        AfterSaleServiceDetailInfo serviceResult = res != null ? (AfterSaleServiceDetailInfo)this.parseAfterSrvScheduleRes(res).getResult() : new AfterSaleServiceDetailInfo();
        serviceResult.setOrderId(aftersaleSubmitParam.getOrderId());
        serviceResult.setSheetId(aftersaleSubmitParam.getSheetId());
        serviceResult.setApplyTime(aftersaleSubmitParam.getApplyTime());
        serviceResult.setCustomerExpect(String.valueOf(AfterSaleServiceTypeEnum.RETURN.getVal()));
        serviceResult.setSkuId(aftersaleSubmitParam.getSkus().get(0).getSkuId());
        serviceResult.setNum(aftersaleSubmitParam.getSkus().get(0).getNum());
        return serviceResult;
    }

    public ApiResult<AfterSaleServiceDetailInfo> parseAfterSrvScheduleRes(Object res) {
        ApiResult apiResult = new ApiResult();
        try {
            Map resMap = (Map)res;
            apiResult.setSuccess(((Boolean)resMap.get("success")).booleanValue());
            apiResult.setResultMessage((String)resMap.get("resultMessage"));
            apiResult.setResultCode((String)resMap.get("resultCode"));
            if (apiResult.isSuccess()) {
                Map resultMap = (Map)resMap.get("result");
                apiResult.setResult((Object)new AfterSaleServiceDetailInfo(resultMap));
                return apiResult;
            }
            this.log.error((String)resMap.get("resultMessage"));
            throw new KDBizException((String)resMap.get("resultMessage"));
        }
        catch (ClassCastException var5) {
            this.log.error(res.toString() + "\r\n" + ExceptionUtil.getStackTrace((Throwable)var5));
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u8f6c\u6362\u9519\u8bef\u3002", (String)"DLAfterSaleService_1", (String)"scm-mal-common", (Object[])new Object[0]));
        }
    }

    @Override
    public void updateAfterServiceSchedule(DynamicObject malreturnreqDyn) {
        AftersaleSubmitParam aftersaleSubmitParam = this.packageAfterSaleParam(malreturnreqDyn);
        aftersaleSubmitParam.setSheetId(this.getAfsId(malreturnreqDyn));
        AfterSaleServiceDetailInfo serviceResult = (AfterSaleServiceDetailInfo)this.queryAfterSrvSchedule(aftersaleSubmitParam);
        AbstractAfterSaleUpdater afterSaleUpdater = this.getAfterSaleUpdater(malreturnreqDyn, serviceResult);
        afterSaleUpdater.updateAndCommit();
    }

    public AbstractAfterSaleUpdater getAfterSaleUpdater(DynamicObject malreturnreqDyn, AfterSaleServiceDetailInfo serviceResult) {
        return new DLAfterSaleUpdater(malreturnreqDyn, serviceResult);
    }

    @Override
    public List<AfterSaleServiceTypeEnum> getCustomerExpectComp(String orderItemId, String skuId, String orderId, String cityId, String countyId) {
        ArrayList<AfterSaleServiceTypeEnum> afterSaleServiceTypeEnums = new ArrayList<AfterSaleServiceTypeEnum>();
        afterSaleServiceTypeEnums.add(AfterSaleServiceTypeEnum.RETURN);
        return afterSaleServiceTypeEnums;
    }

    @Override
    public List<Long> cancelAfterSale(Map<String, String> orderItemIdSkuIdMap, String orderId, String cancelType, String sheetId) {
        throw new KDBizException(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u5f97\u529b\u9000\u8d27\u53d6\u6d88\uff0c\u82e5\u6709\u76f8\u5173\u7591\u95ee\uff0c\u8bf7\u8054\u7cfb\u5f97\u529b\u5ba2\u670d\u4eba\u5458\u3002", (String)"DLAfterSaleService_0", (String)"scm-mal-common", (Object[])new Object[0]));
    }
}

