/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.aftersale.impl;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.enums.LogisticsStatusEnum;
import kd.scm.common.enums.ProductSourceEnum;
import kd.scm.mal.common.aftersale.AfterSaleFactory;
import kd.scm.mal.common.aftersale.IAfterSaleService;
import kd.scm.mal.common.aftersale.bean.AfterSaleValidateInfo;
import kd.scm.mal.common.util.MalPlaceOrderUtils;

public class DefaultAfterSaleService
implements IAfterSaleService {
    private static final Log log = LogFactory.getLog((String)DefaultAfterSaleService.class.getName());

    @Override
    public AfterSaleValidateInfo aftersaleCheck(List<String> entryIDs) {
        AfterSaleValidateInfo afterSaleValidateInfo = new AfterSaleValidateInfo();
        if (null == entryIDs || entryIDs.size() < 1) {
            return afterSaleValidateInfo;
        }
        this.beforeAfteraleCheck(entryIDs);
        ArrayList<String> idlist = new ArrayList<String>();
        HashSet<String> ecOrderIdSet = new HashSet<String>();
        DynamicObjectCollection malOrderDyns = this.queryMalOrder(entryIDs);
        HashSet<String> erpbillnumberSet = new HashSet<String>();
        Map<String, String> entryIdEcOrderIdMap = this.getEcOrderIdMap(malOrderDyns);
        HashSet<Long> malOrderIdSet = new HashSet<Long>();
        if (malOrderDyns.size() > 0) {
            DynamicObject bill = (DynamicObject)malOrderDyns.get(0);
            String source = bill.getString("platform");
            Map srcEntryIdRetMap = (Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"IPurOrderService", (String)"getDataForReceiptAndReturn", (Object[])new Object[]{new HashSet<String>(entryIDs)});
            log.info("aftersaleCheck.srcEntryIdRetMap:" + srcEntryIdRetMap);
            for (DynamicObject malOrderDyn : malOrderDyns) {
                BigDecimal canreturnqty;
                malOrderIdSet.add(malOrderDyn.getLong("id"));
                String entryid = malOrderDyn.getString("entryentity.id");
                erpbillnumberSet.add(malOrderDyn.getString("entryentity.erpbillnumber"));
                String ecOrderId = this.getEcOrderId(entryIdEcOrderIdMap, malOrderDyn, entryid);
                Map entryMap = (Map)srcEntryIdRetMap.get(malOrderDyn.getString("entryentity.id"));
                BigDecimal sumrecretqty = BigDecimal.ZERO;
                BigDecimal suminstockretqty = BigDecimal.ZERO;
                if (entryMap != null) {
                    sumrecretqty = (BigDecimal)entryMap.get("sumrecretqty");
                    suminstockretqty = (BigDecimal)entryMap.get("suminstockretqty");
                }
                if ((canreturnqty = this.getCanReturnQty(ecOrderId, malOrderDyn, sumrecretqty, suminstockretqty)).compareTo(BigDecimal.ZERO) <= 0) continue;
                idlist.add(entryid);
                if (StringUtils.isBlank((CharSequence)ecOrderId)) continue;
                ecOrderIdSet.add(ecOrderId);
            }
            if (erpbillnumberSet.size() > 1) {
                afterSaleValidateInfo.addErrorInfo(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76f8\u540c\u91c7\u8d2d\u8ba2\u5355\u53f7\u7684\u5206\u5f55\u53d1\u8d77\u552e\u540e\u7533\u8bf7\u3002", (String)"DefaultAfterSaleService_0", (String)"scm-mal-common", (Object[])new Object[0]));
                return afterSaleValidateInfo;
            }
            if (idlist.isEmpty()) {
                afterSaleValidateInfo.addErrorInfo(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u884c\u672a\u6536\u8d27\u3001\u672a\u5165\u5e93\u3001\u53ef\u552e\u540e\u6570\u91cf\u4e3a0\u6216\u5df2\u7ecf\u53d1\u8d77\u8fc7\u552e\u540e\uff0c\u4e0d\u5141\u8bb8\u7533\u8bf7\u552e\u540e\u3002", (String)"DefaultAfterSaleService_6", (String)"scm-mal-common", (Object[])new Object[0]));
                return afterSaleValidateInfo;
            }
            if (malOrderIdSet.size() > 1) {
                afterSaleValidateInfo.addErrorInfo(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76f8\u540c\u5546\u57ce\u8ba2\u5355\u7684\u5206\u5f55\u53d1\u8d77\u552e\u540e\u7533\u8bf7\u3002", (String)"DefaultAfterSaleService_2", (String)"scm-mal-common", (Object[])new Object[0]));
                return afterSaleValidateInfo;
            }
            String logstatus = bill.getString("entryentity.erplogstatus");
            if (!(LogisticsStatusEnum.PARTRECIPT.getVal().equalsIgnoreCase(logstatus) || LogisticsStatusEnum.ALLRECIPT.getVal().equalsIgnoreCase(logstatus) || LogisticsStatusEnum.PARTINSTOCK.getVal().equalsIgnoreCase(logstatus) || LogisticsStatusEnum.ALLINSTOCK.getVal().equalsIgnoreCase(logstatus))) {
                afterSaleValidateInfo.addErrorInfo(ResManager.loadKDString((String)"\u8ba2\u5355\u672a\u6536\u8d27\u4e0d\u80fd\u7533\u8bf7\u552e\u540e\u3002", (String)"DefaultAfterSaleService_3", (String)"scm-mal-common", (Object[])new Object[0]));
                return afterSaleValidateInfo;
            }
            if (!ProductSourceEnum.PRODUCTSOURCE_SELF.getVal().equals(source)) {
                if (ecOrderIdSet.size() == 0) {
                    afterSaleValidateInfo.addErrorInfo(ResManager.loadKDString((String)"\u7535\u5546\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728\uff0c\u4e0d\u80fd\u7533\u8bf7\u552e\u540e\u3002", (String)"DefaultAfterSaleService_4", (String)"scm-mal-common", (Object[])new Object[0]));
                    return afterSaleValidateInfo;
                }
                if (ecOrderIdSet.size() > 1) {
                    afterSaleValidateInfo.addErrorInfo(ResManager.loadKDString((String)"\u7535\u5546\u8ba2\u5355\u53ea\u80fd\u9009\u62e9\u76f8\u540c\u5b50\u8ba2\u5355\u7684\u5206\u5f55\u53d1\u8d77\u552e\u540e\u3002", (String)"DefaultAfterSaleService_5", (String)"scm-mal-common", (Object[])new Object[0]));
                    return afterSaleValidateInfo;
                }
            }
            afterSaleValidateInfo.addMalOrderIdEntryIds(bill.getString("id"), idlist);
        }
        return afterSaleValidateInfo;
    }

    private String getEcOrderId(Map<String, String> entryIdEcOrderIdMap, DynamicObject malOrderDyn, String entryid) {
        String source = malOrderDyn.getString("platform");
        String ecOrderId = entryIdEcOrderIdMap.get(entryid);
        if (ProductSourceEnum.PRODUCTSOURCE_JD.getVal().equals(source) && StringUtils.isEmpty((CharSequence)ecOrderId)) {
            ecOrderId = malOrderDyn.getString("entryentity.jdorder.number");
        }
        return ecOrderId;
    }

    @Override
    public BigDecimal getCanReturnQty(String ecOrderId, DynamicObject malOrderDyn, BigDecimal sumrecretqty, BigDecimal suminstockretqty) {
        BigDecimal sumreturnreqqty;
        String source = malOrderDyn.getString("platform");
        IAfterSaleService afterSaleService = AfterSaleFactory.getAfterSaleServiceBySource(source);
        BigDecimal max = malOrderDyn.getBigDecimal("entryentity.sumreceiptqty").max(malOrderDyn.getBigDecimal("entryentity.suminstockqty"));
        String sku = malOrderDyn.getString("entryentity.goods.number");
        BigDecimal sumreceiptqty = malOrderDyn.getBigDecimal("entryentity.sumreceiptqty");
        BigDecimal suminstockqty = malOrderDyn.getBigDecimal("entryentity.suminstockqty");
        Boolean isSumreceiptqty = Boolean.FALSE;
        if (sumreceiptqty.compareTo(suminstockqty) > 0) {
            isSumreceiptqty = Boolean.TRUE;
        }
        BigDecimal canreturnqty = this.isFromJd(source) ? afterSaleService.getAvailableNumberComp(ecOrderId, sku) : (isSumreceiptqty.booleanValue() ? (Objects.nonNull(sumrecretqty) ? ((sumreturnreqqty = malOrderDyn.getBigDecimal("entryentity.sumreturnreqqty")).compareTo(BigDecimal.ZERO) == 0 && sumrecretqty.compareTo(BigDecimal.ZERO) > 0 ? max.subtract(sumreturnreqqty) : max.subtract(sumreturnreqqty).add(sumrecretqty)) : max.subtract(malOrderDyn.getBigDecimal("entryentity.sumreturnreqqty"))) : (Objects.nonNull(suminstockretqty) ? ((sumreturnreqqty = malOrderDyn.getBigDecimal("entryentity.sumreturnreqqty")).compareTo(BigDecimal.ZERO) == 0 && suminstockretqty.compareTo(BigDecimal.ZERO) > 0 ? max.subtract(sumreturnreqqty) : max.subtract(sumreturnreqqty).add(suminstockretqty)) : max.subtract(malOrderDyn.getBigDecimal("entryentity.sumreturnreqqty"))));
        return canreturnqty;
    }

    private boolean isFromJd(String source) {
        return EcPlatformEnum.ECPLATFORM_JD.getVal().equals(source) || EcPlatformEnum.ECPLATFORM_JDPRO.getVal().equals(source);
    }

    public void beforeAfteraleCheck(List<String> entryIDs) {
    }

    public DynamicObject[] queryPurOrder(List<String> entryIDs) {
        String selectSb = "id,billno,cfmstatus,billstatus,logstatus,org,srctype,materialentry.pobillid,materialentry.poentryid,materialentry.srcbillid,materialentry.id,materialentry.qty,materialentry.sumreceiveqty,materialentry.sumoutstockqty,materialentry.sumreceiptqty,materialentry.suminstockqty,materialentry.vmistockqty,materialentry.srcentryid";
        return BusinessDataServiceHelper.load((String)"pur_order", (String)selectSb, (QFilter[])new QFilter[]{new QFilter("materialentry.srcentryid", "in", entryIDs)});
    }

    @Override
    public BigDecimal getAvailableNumberComp(String orderId, String sku) {
        return BigDecimal.ZERO;
    }

    public Map<String, String> getEcOrderIdMap(DynamicObjectCollection malOrderEntrys) {
        HashMap<String, String> resMap = new HashMap<String, String>();
        ArrayList ecOrderPks = new ArrayList();
        if (malOrderEntrys.size() > 0) {
            String ecSource = ((DynamicObject)malOrderEntrys.get(0)).getString("ecsource");
            malOrderEntrys.forEach(dynamicObject -> ecOrderPks.add(dynamicObject.getLong("entryentity.order")));
            QFilter ecIdFilter = new QFilter("id", "in", ecOrderPks);
            if (StringUtils.isNotEmpty((CharSequence)ecSource)) {
                DynamicObjectCollection ecOrderDynCol = "pbd_jdorder".equals(ecSource) ? QueryServiceHelper.query((String)ecSource, (String)"id,number orderid ", (QFilter[])new QFilter[]{ecIdFilter}) : QueryServiceHelper.query((String)ecSource, (String)"id,orderid", (QFilter[])new QFilter[]{ecIdFilter});
                malOrderEntrys.forEach(malOrderEntry -> {
                    String ecOrderPk = malOrderEntry.getString("entryentity.order");
                    ecOrderDynCol.forEach(ecOrderDyn -> {
                        if (ecOrderPk.equals(ecOrderDyn.getString("id"))) {
                            resMap.put(malOrderEntry.getString("entryentity.id"), ecOrderDyn.getString("orderid"));
                        }
                    });
                });
            }
        }
        return resMap;
    }

    public DynamicObjectCollection queryMalOrder(List<String> entryIDs) {
        ArrayList malOrderEntryIds = new ArrayList(entryIDs.size());
        entryIDs.forEach(id -> malOrderEntryIds.add(Long.valueOf(id)));
        QFilter entryidFilter = new QFilter("entryentity.id", "in", malOrderEntryIds);
        return QueryServiceHelper.query((String)"mal_order", (String)"id,platform,cfmstatus,entryentity.order,entryentity.id,entryentity.erplogstatus,entryentity.goods.number,entryentity.sumreceiptqty,entryentity.suminstockqty,entryentity.sumreturnreqqty,entryentity.jdorder.number,ecsource,entryentity.erpbillnumber", (QFilter[])new QFilter[]{entryidFilter});
    }

    @Override
    public DynamicObject createAfServiceBill(Object submitResult, DynamicObject returnReqDyn) {
        DynamicObject afServiceBillDyn = BusinessDataServiceHelper.newDynamicObject((String)"pbd_eafservicebill");
        afServiceBillDyn.set("applydate", (Object)TimeServiceHelper.now());
        DynamicObject returnReqEntryDyn = (DynamicObject)returnReqDyn.getDynamicObjectCollection("entryentity").get(0);
        afServiceBillDyn.set("returntype", (Object)returnReqEntryDyn.getString("returntype"));
        afServiceBillDyn.set("pickwaretype", (Object)returnReqEntryDyn.getString("pickwaretype"));
        afServiceBillDyn.set("source", (Object)returnReqDyn.getString("platform"));
        DynamicObjectCollection entryentity = afServiceBillDyn.getDynamicObjectCollection("entryentity");
        DynamicObject entry = new DynamicObject(entryentity.getDynamicObjectType());
        entry.set("sku", (Object)returnReqEntryDyn.getString("goods.number"));
        entry.set("goods_id", (Object)returnReqEntryDyn.getString("goods.id"));
        entry.set("returnqty", (Object)returnReqEntryDyn.getBigDecimal("qty"));
        entryentity.add((Object)entry);
        return afServiceBillDyn;
    }

    public String queryEcOrderId(String ecOrderPk, String ecSource) {
        DynamicObject ecOrderDyn = null;
        if (StringUtils.isNotEmpty((CharSequence)ecOrderPk) && StringUtils.isNotEmpty((CharSequence)ecSource)) {
            ecOrderDyn = "pbd_jdorder".equals(ecSource) ? QueryServiceHelper.queryOne((String)ecSource, (String)"number orderid,jdorderid porderid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(ecOrderPk))}) : QueryServiceHelper.queryOne((String)ecSource, (String)"orderid,porderid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(ecOrderPk))});
        }
        return ecOrderDyn == null ? "" : ecOrderDyn.getString("orderid");
    }

    String getAfsId(DynamicObject malreturnreqDyn) {
        DynamicObjectCollection aftersaleEntryCol = malreturnreqDyn.getDynamicObjectCollection("aftersaleentry");
        if (!aftersaleEntryCol.isEmpty()) {
            return ((DynamicObject)aftersaleEntryCol.get(0)).getString("afservicebill.number");
        }
        return "";
    }

    public String now() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
    }

    public String getOrderId(DynamicObject malReturnReqDyn) {
        DynamicObjectCollection entryentityCol = malReturnReqDyn.getDynamicObjectCollection("entryentity");
        String platform = malReturnReqDyn.getString("platform");
        DynamicObject returnEntry = (DynamicObject)entryentityCol.get(0);
        String ecPorderPk = returnEntry.getString("ecorder.id");
        DynamicObject orderDyn = null;
        if (StringUtils.isNotEmpty((CharSequence)ecPorderPk)) {
            orderDyn = MalPlaceOrderUtils.getOrderDyn(ecPorderPk, platform);
        }
        return orderDyn == null ? "" : orderDyn.getString("porderid");
    }

    protected String getSource() {
        return "";
    }
}

