/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.aftersale.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.ecapi.jd.JdApiUtil;
import kd.scm.common.ecapi.jd.dto.AfsServicebyCustomerPin;
import kd.scm.common.ecapi.jd.dto.AfterSaleCustomerDto;
import kd.scm.common.ecapi.jd.dto.AfterSaleDetailDto;
import kd.scm.common.ecapi.jd.dto.AfterSaleDto;
import kd.scm.common.ecapi.jd.dto.AfterSalePickwareDto;
import kd.scm.common.ecapi.jd.dto.AfterSaleReturnwareDto;
import kd.scm.common.ecapi.jd.entity.JdApiResponse;
import kd.scm.common.ecapi.jd.enums.AfterSaleServiceTypeEnum;
import kd.scm.common.ecapi.jd.enums.ComponentExportEnum;
import kd.scm.common.ecapi.util.AddressUtil;
import kd.scm.common.util.AfterSaleUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.mal.common.aftersale.impl.DefaultAfterSaleService;
import kd.scm.mal.common.util.MalAddressUtil;
import kd.scm.mal.common.util.MalPlaceOrderUtils;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class JDAfterSaleService
extends DefaultAfterSaleService {
    private Log log = LogFactory.getLog((String)this.getClass().getName());
    private String source;

    public JDAfterSaleService() {
    }

    public JDAfterSaleService(String source) {
        this.source = source;
    }

    @Override
    public Boolean submitAfterSale(DynamicObject malreturnreqDyn) {
        AfterSaleDto afterSaleDto = this.packageAfterSaleParam(malreturnreqDyn);
        JdApiResponse res = JdApiUtil.createAfsApply((AfterSaleDto)afterSaleDto, null);
        return res.getResultCode().equals("0");
    }

    @Override
    public List<Long> cancelAfterSale(List<String> ecOrderIds, List<String> serviceIDlist) {
        HashMap<String, Boolean> allCancelMap = new HashMap<String, Boolean>((int)((double)serviceIDlist.size() / 0.75));
        for (String ecOrderId : ecOrderIds) {
            allCancelMap.putAll(this.canCancelAfterSale(ecOrderId));
        }
        ArrayList<Long> canCancelList = new ArrayList<Long>(allCancelMap.size());
        allCancelMap.forEach((key, value) -> {
            if (value.booleanValue()) {
                canCancelList.add(Long.valueOf(key));
            }
        });
        if (canCancelList.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u53d6\u6d88\u7684\u670d\u52a1\u5355\u3002", (String)"JDAfterSaleService_0", (String)"scm-mal-common", (Object[])new Object[0]));
        }
        String result = JdApiUtil.auditCancel(canCancelList, (String)ResManager.loadKDString((String)"\u901a\u8fc7", (String)"JDAfterSaleService_1", (String)"scm-mal-common", (Object[])new Object[0]), null);
        if ("true".equals(result)) {
            return canCancelList;
        }
        return new ArrayList<Long>();
    }

    @Override
    public List<AfterSaleServiceTypeEnum> getCustomerExpectComp(String ecOrderId, String sku) {
        return JdApiUtil.getCustomerExpectComp((String)ecOrderId, (String)sku, null);
    }

    @Override
    public List<ComponentExportEnum> getComponentExport(String ecOrderId, String sku) {
        return JdApiUtil.getWareReturnJdComp((String)ecOrderId, (String)sku, null);
    }

    public AfterSaleDto packageAfterSaleParam(DynamicObject returnReqDyn) {
        int countyId;
        int cityId;
        int provinceId;
        String admindivisionId = returnReqDyn.getString("admindivision");
        String detailAddress = MalAddressUtil.getWholeAddress(admindivisionId, returnReqDyn.getString("address"));
        int townId = 0;
        String ecAdrLongNumber = AddressUtil.getLongNumber((Long)Long.valueOf(admindivisionId), (String)this.getSource());
        String[] ecAdrStrs = ecAdrLongNumber.split("\\.");
        if (ecAdrStrs.length >= 3) {
            provinceId = Integer.parseInt(ecAdrStrs[0]);
            cityId = Integer.parseInt(ecAdrStrs[1]);
            countyId = Integer.parseInt(ecAdrStrs[2]);
            if (ecAdrStrs.length >= 4) {
                townId = Integer.parseInt(ecAdrStrs[3]);
            }
        } else {
            String jsonRes = JdApiUtil.getAddressJonString((String)detailAddress);
            JSONObject jdAddressJO = JSONObject.fromObject((Object)jsonRes);
            cityId = jdAddressJO.getInt("cityId");
            countyId = jdAddressJO.getInt("countyId");
            provinceId = jdAddressJO.getInt("provinceId");
            if (!StringUtils.equals((CharSequence)"null", (CharSequence)jdAddressJO.getString("townId")) && StringUtils.isNotBlank((CharSequence)jdAddressJO.getString("townId"))) {
                townId = jdAddressJO.getInt("townId");
            }
        }
        AfterSaleCustomerDto asCustomerDto = new AfterSaleCustomerDto();
        asCustomerDto.setCustomerContactName(returnReqDyn.getString("linkman"));
        asCustomerDto.setCustomerTel(returnReqDyn.getString("phone"));
        asCustomerDto.setCustomerEmail(returnReqDyn.getString("email"));
        asCustomerDto.setCustomerMobilePhone(returnReqDyn.getString("phone"));
        AfterSalePickwareDto asPickwareDto = new AfterSalePickwareDto();
        asPickwareDto.setPickwareAddress(detailAddress);
        asPickwareDto.setPickwareCity(Integer.valueOf(cityId));
        asPickwareDto.setPickwareCounty(Integer.valueOf(countyId));
        asPickwareDto.setPickwareProvince(Integer.valueOf(provinceId));
        asPickwareDto.setPickwareVillage(Integer.valueOf(townId));
        AfterSaleReturnwareDto asReturnwareDto = new AfterSaleReturnwareDto();
        asReturnwareDto.setReturnwareAddress(detailAddress);
        asReturnwareDto.setReturnwareCity(Integer.valueOf(cityId));
        asReturnwareDto.setReturnwareCounty(Integer.valueOf(countyId));
        asReturnwareDto.setReturnwareProvince(Integer.valueOf(provinceId));
        asReturnwareDto.setReturnwareType(Integer.valueOf(10));
        asReturnwareDto.setReturnwareVillage(Integer.valueOf(townId));
        DynamicObjectCollection entryCol = returnReqDyn.getDynamicObjectCollection("entryentity");
        String ecPorderPk = ((DynamicObject)entryCol.get(0)).getString("ecorder.id");
        DynamicObject jdOrderDyn = null;
        if (StringUtils.isNotEmpty((CharSequence)ecPorderPk)) {
            jdOrderDyn = MalPlaceOrderUtils.getOrderDyn(ecPorderPk, this.getSource());
        }
        String jdOrderId = jdOrderDyn == null ? "" : jdOrderDyn.getString("number");
        AfterSaleDto afterSaleDto = new AfterSaleDto();
        ArrayList<String> jdOrderIdList = new ArrayList<String>(entryCol.size());
        for (int i = 0; i < entryCol.size(); ++i) {
            AfterSaleDetailDto asDetailDto = new AfterSaleDetailDto();
            DynamicObject entry = (DynamicObject)entryCol.get(i);
            asPickwareDto.setPickwareType(Integer.valueOf(entry.getInt("pickwaretype")));
            String sku = entry.getString("goods.number");
            asDetailDto.setSkuId(Long.valueOf(sku));
            BigDecimal qty = entry.getBigDecimal("qty");
            asDetailDto.setSkuNum(Integer.valueOf(qty.intValue()));
            afterSaleDto.setAsCustomerDto(asCustomerDto);
            afterSaleDto.setAsDetailDto(asDetailDto);
            afterSaleDto.setAsPickwareDto(asPickwareDto);
            afterSaleDto.setAsReturnwareDto(asReturnwareDto);
            afterSaleDto.setCustomerExpect(Integer.valueOf(entry.getInt("returntype")));
            if (StringUtils.isEmpty((CharSequence)jdOrderId)) {
                jdOrderId = entry.getString("jdchildorderid");
            }
            afterSaleDto.setJdOrderId(Long.valueOf(Long.parseLong(jdOrderId)));
            jdOrderIdList.add(jdOrderId);
            afterSaleDto.setQuestionDesc(entry.getString("retreason"));
        }
        this.log.info("jdchildorderid:" + jdOrderIdList);
        return afterSaleDto;
    }

    @Override
    public BigDecimal getAvailableNumberComp(String ecOrderId, String sku) {
        return JdApiUtil.getAvailableNumberComp((String)ecOrderId, (String)sku, null);
    }

    @Override
    public Map<String, Boolean> canCancelAfterSale(String orderId) {
        List afsServicebyCustomerPins = JdApiUtil.getServiceListPage((String)orderId, (String)"1", (String)"20", null);
        HashMap<String, Boolean> result = new HashMap<String, Boolean>((int)((double)afsServicebyCustomerPins.size() / 0.75));
        for (AfsServicebyCustomerPin afsServicebyCustomerPin : afsServicebyCustomerPins) {
            result.put(afsServicebyCustomerPin.getAfsServiceId().toString(), afsServicebyCustomerPin.getCancel() == 1);
        }
        return result;
    }

    @Override
    public void updateAfterServiceSchedule(DynamicObject malreturnreqDyn) {
        AfterSaleUtil.updateJdAfterSaleStateInPurOder();
    }

    @Override
    public void updateAfterSaleTrack(AbstractFormDataModel model, String afservicebillid) {
        JSONArray appendInfoSteps = JSONArray.fromObject((Object)"[4]");
        JSONObject compatibleServiceDetailJo = JdApiUtil.getServiceDetailInfo((String)String.valueOf(afservicebillid), (JSONArray)appendInfoSteps);
        this.updateAfterSaleTrackByDetail(model, compatibleServiceDetailJo);
    }

    public void updateAfterSaleTrackByDetail(AbstractFormDataModel model, JSONObject compatibleServiceDetailJo) {
        if (compatibleServiceDetailJo.containsKey((Object)"serviceTrackInfoDTOs") && !StringUtils.equals((CharSequence)"null", (CharSequence)compatibleServiceDetailJo.getString("serviceTrackInfoDTOs")) && StringUtils.isNotBlank((CharSequence)compatibleServiceDetailJo.getString("serviceTrackInfoDTOs"))) {
            JSONArray serviceTrackInfoDTOsJa = compatibleServiceDetailJo.getJSONArray("serviceTrackInfoDTOs");
            TableValueSetter vs = new TableValueSetter(new String[0]);
            int index = serviceTrackInfoDTOsJa.size() - 1;
            for (Object jo : serviceTrackInfoDTOsJa) {
                JSONObject jsonObject = (JSONObject)jo;
                vs.set("afservicebillid", (Object)jsonObject.getString("afsServiceId"), index);
                vs.set("opdatetime", (Object)DateUtil.string2date((String)jsonObject.getString("createDate"), (String)"yyyy-MM-dd HH:mm:ss"), index);
                vs.set("opdetail", (Object)jsonObject.getString("context"), index--);
            }
            model.deleteEntryData("trackentryentity");
            model.batchCreateNewEntryRow("trackentryentity", vs);
        }
    }

    @Override
    protected String getSource() {
        return StringUtils.isBlank((CharSequence)this.source) ? EcPlatformEnum.ECPLATFORM_JD.getVal() : this.source;
    }
}

