/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.aftersale.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.ecapi.jd.JDAccessTokenUtil;
import kd.scm.common.ecapi.jd.dto.AfsServicebyCustomerPin;
import kd.scm.common.ecapi.jd.dto.AfterSaleDto;
import kd.scm.common.ecapi.jd.enums.AfterSaleServiceTypeEnum;
import kd.scm.common.ecapi.jd.enums.ComponentExportEnum;
import kd.scm.common.helper.apiconnector.api.ApiAccessor;
import kd.scm.common.helper.apiconnector.api.parser.JdApiParser;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.mal.common.aftersale.JDAfterSaleUpdater;
import kd.scm.mal.common.aftersale.impl.DefaultAfterSaleService;
import kd.scm.mal.common.aftersale.impl.JDAfterSaleService;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class JDNewAfterSaleService
extends DefaultAfterSaleService {
    private static final String TRUE = "true";
    private static final Log log = LogFactory.getLog((String)JDNewAfterSaleService.class.getName());

    @Override
    public Boolean submitAfterSale(DynamicObject malreturnreqDyn) {
        AfterSaleDto afterSaleDto = this.packageAfterSaleParam(malreturnreqDyn);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("param", afterSaleDto.toString());
        String token = JDAccessTokenUtil.getValidToken((String)malreturnreqDyn.getString("settleorg.id"), (String)this.getSource());
        if (StringUtils.isNotBlank((CharSequence)token)) {
            paramMap.put("token", token);
        }
        paramMap.put("param", afterSaleDto.toString());
        Object res = ApiAccessor.invoke((String)this.getApiNumber("SRM_JD_AFTERSALE_createAfsApplyForInvoke"), paramMap);
        if (res instanceof Map) {
            Boolean result;
            Map resMap = (Map)res;
            if (resMap.isEmpty()) {
                return Boolean.FALSE;
            }
            Boolean bl = result = (Boolean)resMap.get("success") != false ? Boolean.TRUE : Boolean.FALSE;
            if (!result.booleanValue()) {
                throw new KDBizException(String.valueOf(resMap.get("resultMessage")));
            }
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public List<Long> cancelAfterSale(List<String> ecOrderIds, List<String> serviceIDlist) {
        Object res;
        HashMap<String, Boolean> allCancelMap = new HashMap<String, Boolean>((int)((double)serviceIDlist.size() / 0.75));
        for (String ecOrderId : ecOrderIds) {
            allCancelMap.putAll(this.canCancelAfterSale(ecOrderId));
        }
        ArrayList<Long> canCancelList = new ArrayList<Long>(allCancelMap.size());
        allCancelMap.forEach((key, value) -> {
            if (value.booleanValue()) {
                canCancelList.add(Long.valueOf(key));
            }
        });
        if (canCancelList.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u53ef\u53d6\u6d88\u7684\u670d\u52a1\u5355\u3002", (String)"JDNewAfterSaleService_0", (String)"scm-mal-common", (Object[])new Object[0]));
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        JSONObject paramJo = new JSONObject();
        paramJo.put((Object)"serviceIdList", canCancelList);
        paramJo.put((Object)"approveNotes", (Object)ResManager.loadKDString((String)"\u901a\u8fc7", (String)"JDNewAfterSaleService_1", (String)"scm-mal-common", (Object[])new Object[0]));
        paramMap.put("param", paramJo.toString());
        String token = this.getTokenByEcOrderId(String.valueOf(canCancelList.get(0)));
        if (StringUtils.isNotBlank((CharSequence)token)) {
            paramMap.put("token", token);
        }
        if (TRUE.equals(String.valueOf(this.getResult(res = ApiAccessor.invoke((String)this.getApiNumber("SRM_JD_AFTERSALE_auditCancel"), paramMap))))) {
            return canCancelList;
        }
        return new ArrayList<Long>();
    }

    @Override
    public List<AfterSaleServiceTypeEnum> getCustomerExpectComp(String ecOrderId, String sku) {
        log.info("getCustomerExpectComp\u53c2\u6570ecOrderId:" + ecOrderId + ", sku:" + sku);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("jdOrderId", ecOrderId);
        paramMap.put("skuId", sku);
        String token = this.getTokenByEcOrderId(ecOrderId);
        if (StringUtils.isNotBlank((CharSequence)token)) {
            paramMap.put("token", token);
        }
        Object res = ApiAccessor.invoke((String)this.getApiNumber("SRM_JD_AFTERSALE_getCustomerExpectComp"), paramMap);
        Object result = this.getResult(res);
        log.info("getCustomerExpectComp\u7ed3\u679c\uff1a" + res);
        ArrayList<AfterSaleServiceTypeEnum> afterSaleServiceTypeEnums = new ArrayList<AfterSaleServiceTypeEnum>();
        if (result != null && !((List)result).isEmpty()) {
            for (Map nameCodeMap : (List)result) {
                afterSaleServiceTypeEnums.add(AfterSaleServiceTypeEnum.fromVal((int)Integer.parseInt((String)nameCodeMap.get("code"))));
            }
        }
        log.info("getCustomerExpectComp\u7ed3\u679c\uff1a" + afterSaleServiceTypeEnums);
        return afterSaleServiceTypeEnums;
    }

    public Object getResult(Object res) {
        Map resMap = (Map)res;
        if (((Boolean)resMap.get("success")).booleanValue()) {
            return resMap.get("result");
        }
        return null;
    }

    @Override
    public List<ComponentExportEnum> getComponentExport(String ecOrderId, String sku) {
        HashMap<String, String> paramMap = new HashMap<String, String>(16);
        paramMap.put("orderId", ecOrderId);
        paramMap.put("sku", sku);
        String token = this.getTokenByEcOrderId(ecOrderId);
        if (StringUtils.isNotBlank((CharSequence)token)) {
            paramMap.put("token", token);
        }
        Object res = ApiAccessor.invoke((String)this.getApiNumber("SRM_JD_AFTERSALE_getWareReturnJdComp"), paramMap);
        ArrayList<ComponentExportEnum> componentExportEnums = new ArrayList<ComponentExportEnum>(8);
        Object result = this.getResult(res);
        log.info("getComponentExport\u7ed3\u679c\uff1a" + res);
        if (result != null && !((List)result).isEmpty()) {
            for (Map nameCodeMap : (List)result) {
                componentExportEnums.add(ComponentExportEnum.fromVal((int)Integer.parseInt((String)nameCodeMap.get("code"))));
            }
        }
        return componentExportEnums;
    }

    public AfterSaleDto packageAfterSaleParam(DynamicObject returnReqDyn) {
        return new JDAfterSaleService(this.getSource()).packageAfterSaleParam(returnReqDyn);
    }

    @Override
    public BigDecimal getAvailableNumberComp(String ecOrderId, String sku) {
        BigDecimal canReturnQty = BigDecimal.ZERO;
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("orderId", ecOrderId);
        paramMap.put("sku", sku);
        String token = this.getTokenByEcOrderId(ecOrderId);
        if (StringUtils.isNotBlank((CharSequence)token)) {
            paramMap.put("token", token);
        }
        Object res = ApiAccessor.invoke((String)this.getApiNumber("SRM_JD_AFTERSALE_getAvailableNumberComp"), paramMap);
        Object result = this.getResult(res);
        log.info("getAvailableNumberComp\u7ed3\u679c\uff1a" + res);
        if (result != null) {
            canReturnQty = new BigDecimal(Integer.parseInt(String.valueOf(result)));
        }
        return canReturnQty;
    }

    @Override
    public Map<String, Boolean> canCancelAfterSale(String orderId) {
        List<AfsServicebyCustomerPin> afsServicebyCustomerPins = this.queryAfsServicebyCustomerPins(orderId);
        HashMap<String, Boolean> result = new HashMap<String, Boolean>((int)((double)afsServicebyCustomerPins.size() / 0.75));
        for (AfsServicebyCustomerPin afsServicebyCustomerPin : afsServicebyCustomerPins) {
            result.put(afsServicebyCustomerPin.getAfsServiceId().toString(), afsServicebyCustomerPin.getCancel() == 1);
        }
        return result;
    }

    public List<AfsServicebyCustomerPin> queryAfsServicebyCustomerPins(String orderId) {
        Object res;
        Object result;
        ArrayList<AfsServicebyCustomerPin> afsSerList = new ArrayList<AfsServicebyCustomerPin>();
        if (StringUtils.isEmpty((CharSequence)orderId)) {
            return afsSerList;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("orderId", orderId);
        paramMap.put("pageSize", 20);
        paramMap.put("pageIndex", 1);
        String token = this.getTokenByEcOrderId(orderId);
        if (StringUtils.isNotBlank((CharSequence)token)) {
            paramMap.put("token", token);
        }
        if ((result = this.getResult(res = ApiAccessor.invoke((String)this.getApiNumber("SRM_JD_AFTERSALE_getServiceListPage"), paramMap))) != null) {
            Map resMap = (Map)result;
            List serviceInfoList = (List)resMap.get("serviceInfoList");
            for (int i = 0; i < serviceInfoList.size(); ++i) {
                Map serviceInfo = (Map)serviceInfoList.get(i);
                if (serviceInfo == null) continue;
                AfsServicebyCustomerPin afsServicebyCustomerPin = new AfsServicebyCustomerPin();
                afsServicebyCustomerPin.setAfsApplyTime(String.valueOf(serviceInfo.get("afsApplyTime")));
                afsServicebyCustomerPin.setAfsServiceId(Integer.valueOf(String.valueOf(serviceInfo.get("afsServiceId"))));
                afsServicebyCustomerPin.setAfsServiceStep(Integer.valueOf(String.valueOf(serviceInfo.get("afsServiceStep"))));
                afsServicebyCustomerPin.setAfsServiceStepName(String.valueOf(serviceInfo.get("afsServiceStepName")));
                afsServicebyCustomerPin.setCancel(Integer.parseInt(String.valueOf(serviceInfo.get("cancel"))));
                afsServicebyCustomerPin.setCustomerExpect(Integer.valueOf(String.valueOf(serviceInfo.get("customerExpect"))));
                afsServicebyCustomerPin.setCustomerExpectName(String.valueOf(serviceInfo.get("customerExpectName")));
                afsServicebyCustomerPin.setOrderId(Long.valueOf(String.valueOf(serviceInfo.get("orderId"))));
                afsServicebyCustomerPin.setWareId(Long.valueOf(String.valueOf(serviceInfo.get("wareId"))));
                afsServicebyCustomerPin.setWareName(String.valueOf(serviceInfo.get("wareName")));
                afsSerList.add(afsServicebyCustomerPin);
            }
        }
        return afsSerList;
    }

    @Override
    public void updateAfterServiceSchedule(DynamicObject malreturnreqDyn) {
        JDAfterSaleUpdater jdAfterSaleUpdater = new JDAfterSaleUpdater(malreturnreqDyn, null, this.getSource());
        jdAfterSaleUpdater.updateAndCommit();
    }

    @Override
    public void updateAfterSaleTrack(AbstractFormDataModel model, String afservicebillid) {
        JSONArray appendInfoSteps = JSONArray.fromObject((Object)"[4]");
        JSONObject compatibleServiceDetailJo = this.getServiceDetailInfo(afservicebillid, appendInfoSteps.toString());
        if (compatibleServiceDetailJo.isNullObject()) {
            return;
        }
        new JDAfterSaleService(this.getSource()).updateAfterSaleTrackByDetail(model, compatibleServiceDetailJo);
    }

    public JSONObject getServiceDetailInfo(String afservicebillid, String appendInfoSteps) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("sheetId", afservicebillid);
        paramMap.put("appendInfoSteps", appendInfoSteps);
        String token = this.getTokenByAfservicebillId(afservicebillid);
        if (StringUtils.isNotBlank((CharSequence)token)) {
            paramMap.put("token", token);
        }
        Object res = ApiAccessor.invoke((String)this.getApiNumber("SRM_JD_AFTERSALE_getServiceDetailInfo"), paramMap);
        log.info("getServiceDetailInfo.res:" + res);
        Object result = this.getResult(res);
        return result != null ? JSONObject.fromObject((Object)result) : new JSONObject(true);
    }

    @Override
    protected String getSource() {
        return EcPlatformEnum.ECPLATFORM_JD.getVal();
    }

    protected String getApiNumber(String apiNumber) {
        return JdApiParser.getJdApiNumber((String)this.getSource(), (String)apiNumber);
    }

    private String getTokenByAfservicebillId(String afservicebillId) {
        try {
            DynamicObject returnReqDyn = QueryServiceHelper.queryOne((String)"mal_returnreq", (String)"settleorg.id", (QFilter[])new QFilter[]{new QFilter("aftersaleentry.afservicebill.number", "=", (Object)afservicebillId)});
            if (returnReqDyn != null) {
                log.info("kd.scm.mal.common.aftersale.impl.JDNewAfterSaleService.getTokenByAfservicebillId\uff1a" + returnReqDyn.getString("settleorg.id"));
                return JDAccessTokenUtil.getValidToken((String)returnReqDyn.getString("settleorg.id"), (String)this.getSource());
            }
        }
        catch (Exception e) {
            log.info("\u83b7\u53d6token\u8bc6\u522b\uff1a" + ExceptionUtil.getStackTrace((Throwable)e));
        }
        return "";
    }

    private String getTokenByEcOrderId(String ecOrderId) {
        DynamicObject jdOrderDyn = QueryServiceHelper.queryOne((String)"pbd_jdorder", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)ecOrderId)});
        if (jdOrderDyn != null) {
            return this.getTokenByEcOrderPk(jdOrderDyn.getLong("id"));
        }
        return "";
    }

    private String getTokenByEcOrderPk(Long ecOrderPk) {
        DynamicObject malOrderDyn = QueryServiceHelper.queryOne((String)"mal_order", (String)"settleorg.id", (QFilter[])new QFilter[]{new QFilter("entryentity.order", "=", (Object)ecOrderPk)});
        if (malOrderDyn != null) {
            return JDAccessTokenUtil.getValidToken((String)malOrderDyn.getString("settleorg.id"), (String)this.getSource());
        }
        return "";
    }
}

