/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.aftersale.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.ecapi.jd.enums.AfterSaleServiceTypeEnum;
import kd.scm.common.ecapi.jd.enums.ComponentExportEnum;
import kd.scm.common.ecapi.util.AddressUtil;
import kd.scm.common.helper.apiconnector.api.ApiAccessor;
import kd.scm.common.helper.apiconnector.api.util.EcGroupApiUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.mal.common.aftersale.SNAfterSaleUpdater;
import kd.scm.mal.common.aftersale.bean.AfterSrvSchInfo;
import kd.scm.mal.common.aftersale.bean.AftersaleSubmitParam;
import kd.scm.mal.common.aftersale.bean.AftersaleSubmitSkuInfo;
import kd.scm.mal.common.aftersale.bean.ReturnInfo;
import kd.scm.mal.common.aftersale.bean.SNAftersaleSubmitSkuInfo;
import kd.scm.mal.common.aftersale.bean.SNServiceResult;
import kd.scm.mal.common.aftersale.bean.SNServiceScheduleResultInfo;
import kd.scm.mal.common.aftersale.bean.SNSubmitAfterSaleResultInfo;
import kd.scm.mal.common.aftersale.bean.ServiceResult;
import kd.scm.mal.common.aftersale.enums.SNAfterSrvStatusEnum;
import kd.scm.mal.common.aftersale.impl.StandardAfterSaleService;
import kd.scm.mal.common.util.MalPlaceOrderUtils;

public class SNAfterSaleService
extends StandardAfterSaleService {
    private static final String SUCCESS = "1";
    private Log log = LogFactory.getLog((String)this.getClass().getName());
    private static final String CANCEL_OP_RETURN = "1";
    private static final String CANCEL_OP_EXCHANGE = "2";
    private static final String CANCEL_OP_REPAIRE = "3";

    @Override
    public ServiceResult doSubmit(AftersaleSubmitParam aftersaleSubmitParam) {
        if (AfterSaleServiceTypeEnum.RETURN.getVal() == Integer.parseInt(aftersaleSubmitParam.getAftersaleType())) {
            return this.submitReturn(aftersaleSubmitParam);
        }
        if (AfterSaleServiceTypeEnum.EXCHANGE.getVal() == Integer.parseInt(aftersaleSubmitParam.getAftersaleType())) {
            return this.submitExchange(aftersaleSubmitParam);
        }
        if (AfterSaleServiceTypeEnum.REPAIR.getVal() == Integer.parseInt(aftersaleSubmitParam.getAftersaleType())) {
            return this.submitRepaire(aftersaleSubmitParam);
        }
        return new ServiceResult();
    }

    protected SNServiceResult<SNSubmitAfterSaleResultInfo> submitRepaire(AftersaleSubmitParam snAftersaleSubmitParam) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, String> skuOrderItemIdMap = new HashMap<String, String>();
        List<AftersaleSubmitSkuInfo> skus = snAftersaleSubmitParam.getSkus();
        skus.forEach(snAftersaleSubmitSkuInfo -> {
            paramMap.put("num", (String)snAftersaleSubmitSkuInfo.getNum());
            paramMap.put("skuId", snAftersaleSubmitSkuInfo.getSkuId());
            paramMap.put("orderMemo", ((SNAftersaleSubmitSkuInfo)snAftersaleSubmitSkuInfo).getReasonDetails());
            paramMap.put("orderItemId", ((SNAftersaleSubmitSkuInfo)snAftersaleSubmitSkuInfo).getOrderItemId());
            paramMap.put("serviceTime", ((SNAftersaleSubmitSkuInfo)snAftersaleSubmitSkuInfo).getServicetime());
            skuOrderItemIdMap.put(snAftersaleSubmitSkuInfo.getSkuId(), ((SNAftersaleSubmitSkuInfo)snAftersaleSubmitSkuInfo).getOrderItemId());
        });
        paramMap.put("orderId", snAftersaleSubmitParam.getOrderId());
        paramMap.put("cityId", snAftersaleSubmitParam.getCityId());
        paramMap.put("countyId", snAftersaleSubmitParam.getCountyId());
        paramMap.put("provinceId", snAftersaleSubmitParam.getProvinceId());
        paramMap.put("address", snAftersaleSubmitParam.getAddress());
        paramMap.put("aftersaleName", snAftersaleSubmitParam.getAftersaleName());
        paramMap.put("aftersalePhone", snAftersaleSubmitParam.getAftersalePhone());
        paramMap.put("townId", snAftersaleSubmitParam.getTownId());
        paramMap.put("mobPhoneNum", snAftersaleSubmitParam.getAftersalePhone());
        Object res = ApiAccessor.invoke((String)"SRM_SN_AFTERSALE_createApplyRepairGoods", paramMap);
        if (res != null) {
            return this.parseAfterSaleRes(res, skuOrderItemIdMap);
        }
        return null;
    }

    protected SNServiceResult<SNSubmitAfterSaleResultInfo> submitExchange(AftersaleSubmitParam snAftersaleSubmitParam) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        HashMap<String, String> skuOrderItemIdMap = new HashMap<String, String>();
        List<AftersaleSubmitSkuInfo> skus = snAftersaleSubmitParam.getSkus();
        ArrayList skuMapList = new ArrayList();
        skus.forEach(snAftersaleSubmitSkuInfo -> {
            HashMap<String, Object> skuMap = new HashMap<String, Object>();
            skuMap.put("num", snAftersaleSubmitSkuInfo.getNum());
            skuMap.put("skuId", snAftersaleSubmitSkuInfo.getSkuId());
            skuMap.put("reasonDetails", ((SNAftersaleSubmitSkuInfo)snAftersaleSubmitSkuInfo).getReasonDetails());
            skuMap.put("orderItemId", ((SNAftersaleSubmitSkuInfo)snAftersaleSubmitSkuInfo).getOrderItemId());
            skuOrderItemIdMap.put(snAftersaleSubmitSkuInfo.getSkuId(), ((SNAftersaleSubmitSkuInfo)snAftersaleSubmitSkuInfo).getOrderItemId());
            skuMapList.add(skuMap);
        });
        paramMap.put("orderId", snAftersaleSubmitParam.getOrderId());
        paramMap.put("orderItems", skuMapList);
        Object res = ApiAccessor.invoke((String)"SRM_SN_AFTERSALE_createApplyexchangegoods", paramMap);
        return this.parseAfterSaleRes(res, skuOrderItemIdMap);
    }

    public SNServiceResult<SNSubmitAfterSaleResultInfo> submitReturn(AftersaleSubmitParam snAftersaleSubmitParam) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("address", snAftersaleSubmitParam.getAddress());
        paramMap.put("orderId", snAftersaleSubmitParam.getOrderId());
        paramMap.put("aftersalePhone", snAftersaleSubmitParam.getAftersalePhone());
        paramMap.put("cityId", snAftersaleSubmitParam.getCityId());
        paramMap.put("aftersaleName", snAftersaleSubmitParam.getAftersaleName());
        paramMap.put("townId", snAftersaleSubmitParam.getTownId());
        paramMap.put("provinceId", snAftersaleSubmitParam.getProvinceId());
        paramMap.put("countyId", snAftersaleSubmitParam.getCountyId());
        HashMap<String, String> skuOrderItemIdMap = new HashMap<String, String>();
        List<AftersaleSubmitSkuInfo> skus = snAftersaleSubmitParam.getSkus();
        ArrayList skuMapList = new ArrayList();
        skus.forEach(snAftersaleSubmitSkuInfo -> {
            HashMap<String, Object> skuMap = new HashMap<String, Object>();
            skuMap.put("reason", ((SNAftersaleSubmitSkuInfo)snAftersaleSubmitSkuInfo).getReason());
            skuMap.put("num", snAftersaleSubmitSkuInfo.getNum());
            skuMap.put("skuId", snAftersaleSubmitSkuInfo.getSkuId());
            skuMap.put("reasonDetails", ((SNAftersaleSubmitSkuInfo)snAftersaleSubmitSkuInfo).getReasonDetails());
            skuOrderItemIdMap.put(snAftersaleSubmitSkuInfo.getSkuId(), ((SNAftersaleSubmitSkuInfo)snAftersaleSubmitSkuInfo).getOrderItemId());
            skuMapList.add(skuMap);
        });
        paramMap.put("skus", skuMapList);
        Object res = ApiAccessor.invoke((String)"SRM_SN_AFTERSALE_addReturnPartOrder", paramMap);
        return this.parseAfterSaleRes(res, skuOrderItemIdMap);
    }

    public SNServiceResult<SNSubmitAfterSaleResultInfo> parseAfterSaleRes(Object res, Map<String, String> skuOrderItemIdMap) {
        SNServiceResult<SNSubmitAfterSaleResultInfo> snServiceResult;
        try {
            Map resMap = (Map)res;
            if (!((Boolean)resMap.get("success")).booleanValue()) {
                this.log.error((String)resMap.get("resultMessage"));
                throw new KDBizException((String)resMap.get("resultMessage"));
            }
            Map resultMap = (Map)resMap.get("result");
            List infoMapList = (List)resultMap.get("infoList");
            String orderId = (String)resultMap.get("orderId");
            ArrayList snSubmitAfterSaleResultInfos = new ArrayList();
            infoMapList.forEach(infoMap -> {
                SNSubmitAfterSaleResultInfo snSubmitAfterSaleResultInfo = new SNSubmitAfterSaleResultInfo((String)infoMap.get("skuId"), (String)infoMap.get("status"), (String)infoMap.get("unableReason"), (String)infoMap.get("sheetId"), (String)skuOrderItemIdMap.get(infoMap.get("skuId")));
                snSubmitAfterSaleResultInfos.add(snSubmitAfterSaleResultInfo);
            });
            snServiceResult = new SNServiceResult<SNSubmitAfterSaleResultInfo>(orderId, snSubmitAfterSaleResultInfos);
        }
        catch (ClassCastException e) {
            this.log.error(res.toString());
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u8f6c\u6362\u9519\u8bef\u3002", (String)"SNAfterSaleService_0", (String)"scm-mal-common", (Object[])new Object[0]));
        }
        return snServiceResult;
    }

    @Override
    public List<Long> cancelAfterSale(Map<String, String> orderItemIdSkuIdMap, String orderId, String cancelType, String sheetId) {
        Object res = null;
        if ("1".equals(cancelType) || CANCEL_OP_EXCHANGE.equals(cancelType)) {
            res = this.cancelRetchg(orderItemIdSkuIdMap, orderId, cancelType);
        } else if (CANCEL_OP_REPAIRE.equals(cancelType)) {
            res = this.cancelRepaire(orderItemIdSkuIdMap, orderId, sheetId);
        }
        if (res != null) {
            return this.parseCancelRes(res);
        }
        return new ArrayList<Long>();
    }

    public Object cancelRepaire(Map<String, String> orderItemIdSkuIdMap, String orderId, String sheetId) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("orderId", orderId);
        paramMap.put("sheetId", sheetId);
        paramMap.put("cancelReason", ResManager.loadKDString((String)"\u6682\u4e0d\u9700\u8981\u7ef4\u4fee\u3002", (String)"SNAfterSaleService_1", (String)"scm-mal-common", (Object[])new Object[0]));
        orderItemIdSkuIdMap.forEach((orderItemId, skuId) -> {
            paramMap.put("orderItemId", (String)orderItemId);
            paramMap.put("skuId", (String)skuId);
        });
        return ApiAccessor.invoke((String)"SRM_SN_AFTERSALE_cancelRepairGoods", paramMap);
    }

    public Object cancelRetchg(Map<String, String> orderItemIdSkuIdMap, String orderId, String cancelType) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("orderId", orderId);
        paramMap.put("operateType", cancelType);
        ArrayList orderItems = new ArrayList();
        orderItemIdSkuIdMap.forEach((orderItemId, skuId) -> {
            HashMap<String, String> orderItemMap = new HashMap<String, String>(1);
            orderItemMap.put("orderItemId", (String)orderItemId);
            orderItemMap.put("skuId", (String)skuId);
            orderItems.add(orderItemMap);
        });
        paramMap.put("orderItems", orderItems);
        return ApiAccessor.invoke((String)"SRM_SN_AFTERSALE_cancelRetchggoods", paramMap);
    }

    public List<Long> parseCancelRes(Object res) {
        ArrayList<Long> orderItemIds;
        block6: {
            orderItemIds = new ArrayList<Long>();
            try {
                Map resMap = (Map)res;
                if (((Boolean)resMap.get("success")).booleanValue()) {
                    Map resultMap = (Map)resMap.get("result");
                    List orderItemMapList = (List)resultMap.get("orderItems");
                    if (null != orderItemMapList) {
                        orderItemMapList.forEach(infoMap -> {
                            if ("0".equals(String.valueOf(infoMap.get("status")))) {
                                throw new KDBizException(String.valueOf(infoMap.get("unableReason")));
                            }
                            orderItemIds.add(Long.parseLong((String)infoMap.get("orderItemId")));
                        });
                    } else {
                        Object orerItemId = resultMap.get("orderItemId");
                        if (orerItemId != null) {
                            orderItemIds.add(Long.parseLong((String)orerItemId));
                        }
                    }
                    break block6;
                }
                throw new KDBizException((String)resMap.get("resultMessage"));
            }
            catch (ClassCastException e) {
                this.log.error(res.toString());
                throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u8f6c\u6362\u9519\u8bef\u3002", (String)"SNAfterSaleService_0", (String)"scm-mal-common", (Object[])new Object[0]));
            }
        }
        return orderItemIds;
    }

    @Override
    public List<AfterSaleServiceTypeEnum> getCustomerExpectComp(String orderItemId, String skuId, String orderId, String cityId, String countyId) {
        HashMap paramMap = new HashMap();
        HashMap<String, Object> snParamMap = new HashMap<String, Object>();
        snParamMap.put("cityId", cityId);
        snParamMap.put("orderId", orderId);
        snParamMap.put("countyId", countyId);
        ArrayList skus = new ArrayList();
        HashMap<String, String> skuMap = new HashMap<String, String>();
        skus.add(skuMap);
        skuMap.put("orderItemId", orderItemId);
        skuMap.put("skuId", skuId);
        snParamMap.put("skus", skus);
        paramMap.put(EcPlatformEnum.ECPLATFORM_SUNING.getVal(), snParamMap);
        Map res = EcGroupApiUtil.getEcAfterServce(paramMap);
        Map afterSaleServiceTypeEnumMap = (Map)res.get(EcPlatformEnum.ECPLATFORM_SUNING.getVal());
        if (afterSaleServiceTypeEnumMap != null) {
            return (List)afterSaleServiceTypeEnumMap.get(skuId);
        }
        return new ArrayList<AfterSaleServiceTypeEnum>();
    }

    @Override
    public List<ComponentExportEnum> getComponentExport(String var1, String var2) {
        ArrayList<ComponentExportEnum> componentExportEnums = new ArrayList<ComponentExportEnum>();
        componentExportEnums.add(ComponentExportEnum.DOOR_TO_TAKE);
        componentExportEnums.add(ComponentExportEnum.CUSTOMER_SEND);
        return componentExportEnums;
    }

    @Override
    public AftersaleSubmitParam packageAfterSaleParam(DynamicObject returnReqDyn) {
        AftersaleSubmitParam aftersaleSubmitParam = new AftersaleSubmitParam();
        aftersaleSubmitParam.setBank(returnReqDyn.getString("bank"));
        aftersaleSubmitParam.setCardNumber(returnReqDyn.getString("cardnumber"));
        aftersaleSubmitParam.setAddress(returnReqDyn.getString("address"));
        aftersaleSubmitParam.setCardUsername(returnReqDyn.getString("cardusername"));
        aftersaleSubmitParam.setAftersaleName(returnReqDyn.getString("linkman"));
        aftersaleSubmitParam.setAftersalePhone(returnReqDyn.getString("phone"));
        String snAddrLongnumber = AddressUtil.getLongNumber((Long)returnReqDyn.getLong("admindivision"), (String)EcPlatformEnum.ECPLATFORM_SUNING.getVal());
        String[] snAddrLongnumberStrs = snAddrLongnumber.split("\\.");
        DynamicObjectCollection entryentityCol = returnReqDyn.getDynamicObjectCollection("entryentity");
        String ecPorderPk = ((DynamicObject)entryentityCol.get(0)).getString("ecorder.id");
        DynamicObject snOrderDyn = null;
        if (StringUtils.isNotEmpty((CharSequence)ecPorderPk)) {
            snOrderDyn = MalPlaceOrderUtils.getOrderDyn(ecPorderPk, EcPlatformEnum.ECPLATFORM_SUNING.getVal());
        }
        String snOrderid = snOrderDyn == null ? "" : snOrderDyn.getString("porderid");
        String snOrderItemId = snOrderDyn == null ? "" : snOrderDyn.getString("orderid");
        DynamicObjectCollection asentryCol = returnReqDyn.getDynamicObjectCollection("aftersaleentry");
        String sheetId = "";
        if (!asentryCol.isEmpty()) {
            sheetId = ((DynamicObject)asentryCol.get(0)).getString("afservicebill.number");
        }
        aftersaleSubmitParam.setOrderId(snOrderid);
        if (snAddrLongnumberStrs.length >= 3) {
            aftersaleSubmitParam.setProvinceId(snAddrLongnumberStrs[0]);
            aftersaleSubmitParam.setCityId(snAddrLongnumberStrs[1]);
            aftersaleSubmitParam.setCountyId(snAddrLongnumberStrs[2]);
            if (snAddrLongnumberStrs.length > 3) {
                aftersaleSubmitParam.setTownId(snAddrLongnumberStrs[3]);
            }
        }
        ArrayList<AftersaleSubmitSkuInfo> snAftersaleSubmitSkuInfos = new ArrayList<AftersaleSubmitSkuInfo>();
        String aftersaleType = "";
        for (DynamicObject entry : entryentityCol) {
            snAftersaleSubmitSkuInfos.add(new SNAftersaleSubmitSkuInfo(entry.getString("retreasoncode"), entry.getInt("qty"), entry.getString("retreason"), snOrderItemId, entry.getString("goods.number"), entry.getString("servicetime"), sheetId));
            if (!StringUtils.isEmpty((CharSequence)aftersaleType)) continue;
            aftersaleType = entry.getString("returntype");
        }
        aftersaleSubmitParam.setSkus(snAftersaleSubmitSkuInfos);
        aftersaleSubmitParam.setAftersaleType(aftersaleType);
        return aftersaleSubmitParam;
    }

    @Override
    public BigDecimal getAvailableNumberComp(String orderId, String sku) {
        return BigDecimal.ONE;
    }

    @Override
    public Map<String, Boolean> canCancelAfterSale(String ecOrderId) {
        return new HashMap<String, Boolean>();
    }

    @Override
    public DynamicObject createAfServiceBill(Object submitResult, DynamicObject returnReqDyn) {
        SNServiceResult snSubmitResult = (SNServiceResult)submitResult;
        List snSubmitAfterSaleResultInfos = snSubmitResult.getResultInfoList();
        if (!snSubmitAfterSaleResultInfos.isEmpty()) {
            SNSubmitAfterSaleResultInfo snSubmitAfterSaleResultInfo = (SNSubmitAfterSaleResultInfo)snSubmitAfterSaleResultInfos.get(0);
            if ("1".equals(snSubmitAfterSaleResultInfo.getStatus())) {
                DynamicObject afServiceBillDyn = super.createAfServiceBill(submitResult, returnReqDyn);
                afServiceBillDyn.set("orderid", (Object)snSubmitAfterSaleResultInfo.getOrderItemId());
                afServiceBillDyn.set("number", (Object)snSubmitAfterSaleResultInfo.getSheetId());
                return afServiceBillDyn;
            }
            throw new KDBizException(snSubmitAfterSaleResultInfo.getUnableReason());
        }
        return null;
    }

    @Override
    public Map<String, String> queryRepaireServiceTime(String ecOrderId, String ecSku, String ecPorderId, String cityId, String countyId) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("orderItemId", ecOrderId);
        paramMap.put("skuId", ecSku);
        paramMap.put("orderId", ecPorderId);
        paramMap.put("cityId", cityId);
        paramMap.put("countyId", countyId);
        Object res = ApiAccessor.invoke((String)"SRM_SN_AFTERSALE_queryRepairMethod", paramMap);
        return this.parseRepaireServiceTimeRes(res);
    }

    protected Map<String, String> parseRepaireServiceTimeRes(Object res) {
        Map resultMap;
        String serviceTimeStr;
        HashMap<String, String> retMap = new HashMap<String, String>();
        if (((Boolean)((Map)res).get("success")).booleanValue() && StringUtils.isNotEmpty((CharSequence)(serviceTimeStr = (String)(resultMap = (Map)((Map)res).get("result")).get("serviceTime")))) {
            String[] serviceTimes;
            for (String serviceTime : serviceTimes = serviceTimeStr.split("\uff0c")) {
                String time = serviceTime.substring(8);
                if ("090000".equals(time)) {
                    retMap.put(serviceTime, ResManager.loadKDString((String)"\u4e0a\u5348", (String)"SNAfterSaleService_2", (String)"scm-mal-common", (Object[])new Object[0]));
                }
                if ("150000".equals(time)) {
                    retMap.put(serviceTime, ResManager.loadKDString((String)"\u4e0b\u5348", (String)"SNAfterSaleService_3", (String)"scm-mal-common", (Object[])new Object[0]));
                }
                if (!"180000".equals(time)) continue;
                retMap.put(serviceTime, ResManager.loadKDString((String)"\u5168\u5929", (String)"SNAfterSaleService_4", (String)"scm-mal-common", (Object[])new Object[0]));
            }
        }
        return retMap;
    }

    @Override
    public <T extends AftersaleSubmitParam> SNServiceResult<SNServiceScheduleResultInfo> queryAfterSrvSchedule(T aftersaleSubmitParam) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        List<AftersaleSubmitSkuInfo> skus = aftersaleSubmitParam.getSkus();
        HashMap<String, Integer> skuNumMap = new HashMap<String, Integer>();
        ArrayList orderItemMapList = new ArrayList();
        skus.forEach(snAftersaleSubmitSkuInfo -> {
            HashMap<String, String> orderItemMap = new HashMap<String, String>(1);
            orderItemMap.put("sheetId", ((SNAftersaleSubmitSkuInfo)snAftersaleSubmitSkuInfo).getSheetId());
            orderItemMap.put("skuId", snAftersaleSubmitSkuInfo.getSkuId());
            orderItemMap.put("orderItemId", ((SNAftersaleSubmitSkuInfo)snAftersaleSubmitSkuInfo).getOrderItemId());
            orderItemMapList.add(orderItemMap);
            skuNumMap.put(snAftersaleSubmitSkuInfo.getSkuId(), snAftersaleSubmitSkuInfo.getNum());
        });
        paramMap.put("orderId", aftersaleSubmitParam.getOrderId());
        paramMap.put("serviceType", aftersaleSubmitParam.getAftersaleType());
        paramMap.put("orderItemIds", orderItemMapList);
        Object res = ApiAccessor.invoke((String)"SRM_SN_AFTERSALE_querysServiceSchedule", paramMap);
        if (res != null) {
            return this.parseAfterSrvScheduleRes(res, skuNumMap);
        }
        return null;
    }

    public SNServiceResult<SNServiceScheduleResultInfo> parseAfterSrvScheduleRes(Object res, Map<String, Integer> skuNumMap) {
        SNServiceResult<SNServiceScheduleResultInfo> snServiceResult;
        try {
            Map resMap = (Map)res;
            if (!((Boolean)resMap.get("success")).booleanValue()) {
                this.log.error((String)resMap.get("resultMessage"));
                throw new KDBizException((String)resMap.get("resultMessage"));
            }
            Map resultMap = (Map)resMap.get("result");
            List infoMapList = (List)resultMap.get("orderItemIds");
            ArrayList snServiceScheduleResultInfos = new ArrayList();
            infoMapList.forEach(infoMap -> {
                SNServiceScheduleResultInfo snServiceScheduleResultInfo = new SNServiceScheduleResultInfo();
                snServiceScheduleResultInfo.setPictureCode((String)infoMap.get("pictureCode"));
                snServiceScheduleResultInfo.setAfterSrvStatus(SNAfterSrvStatusEnum.fromVal((String)infoMap.get("afterSrvStatus")));
                snServiceScheduleResultInfo.setOrderItemId((String)infoMap.get("orderItemId"));
                snServiceScheduleResultInfo.setSku((String)infoMap.get("skuId"));
                snServiceScheduleResultInfo.setNum((Integer)skuNumMap.get(snServiceScheduleResultInfo.getSku()));
                Object sheetId = infoMap.get("sheetId");
                if (sheetId != null) {
                    snServiceScheduleResultInfo.setSheetId((String)sheetId);
                }
                Object afterSrvSchs = infoMap.get("afterSrvSchs");
                ArrayList<AfterSrvSchInfo> afterSrvSchList = new ArrayList<AfterSrvSchInfo>();
                if (afterSrvSchs != null) {
                    List afterSrvSchsMapList = (List)afterSrvSchs;
                    afterSrvSchsMapList.forEach(afterSrvSchsMap -> afterSrvSchList.add(new AfterSrvSchInfo((String)afterSrvSchsMap.get("afterSrvSch"), (String)afterSrvSchsMap.get("time"))));
                }
                snServiceScheduleResultInfo.setAfterSrvSchs(afterSrvSchList);
                Object returnInfo = infoMap.get("returnInfo");
                ArrayList<ReturnInfo> returnInfoList = new ArrayList<ReturnInfo>();
                if (returnInfo != null) {
                    List returnInfoMapList = (List)returnInfo;
                    returnInfoMapList.forEach(returnInfoMap -> returnInfoList.add(new ReturnInfo((String)returnInfoMap.get("returnAddress"), (String)returnInfoMap.get("returnPhone"), (String)returnInfoMap.get("returnName"))));
                }
                snServiceScheduleResultInfo.setReturnInfos(returnInfoList);
                snServiceScheduleResultInfos.add(snServiceScheduleResultInfo);
            });
            String orderId = (String)resultMap.get("orderId");
            snServiceResult = new SNServiceResult<SNServiceScheduleResultInfo>(orderId, snServiceScheduleResultInfos);
        }
        catch (ClassCastException e) {
            this.log.error(res.toString() + "\r\n" + ExceptionUtil.getStackTrace((Throwable)e));
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u8f6c\u6362\u9519\u8bef\u3002", (String)"SNAfterSaleService_0", (String)"scm-mal-common", (Object[])new Object[0]));
        }
        return snServiceResult;
    }

    @Override
    public void updateAfterServiceSchedule(DynamicObject malreturnreqDyn) {
        AftersaleSubmitParam aftersaleSubmitParam = this.packageAfterSaleParam(malreturnreqDyn);
        ServiceResult snServiceResult = this.queryAfterSrvSchedule(aftersaleSubmitParam);
        if (snServiceResult == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u7684\u552e\u540e\u8fdb\u5ea6,\u8bf7\u8054\u7cfb\u5ba2\u670d\u4eba\u5458\u5904\u7406\u3002", (String)"SNAfterSaleService_5", (String)"scm-mal-common", (Object[])new Object[0]));
        }
        SNAfterSaleUpdater snAfterSaleUpdater = new SNAfterSaleUpdater(malreturnreqDyn, (SNServiceResult<SNServiceScheduleResultInfo>)snServiceResult);
        snAfterSaleUpdater.updateAndCommit();
    }
}

