/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.aftersale.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.ecapi.jd.enums.AfterSaleServiceTypeEnum;
import kd.scm.common.ecapi.jd.enums.ComponentExportEnum;
import kd.scm.common.ecapi.util.AddressUtil;
import kd.scm.common.helper.apiconnector.api.ApiAccessor;
import kd.scm.common.util.mal.MalNewOrderUtils;
import kd.scm.mal.common.aftersale.bean.AftersaleSubmitParam;
import kd.scm.mal.common.aftersale.bean.AftersaleSubmitSkuInfo;
import kd.scm.mal.common.aftersale.bean.ServiceResult;
import kd.scm.mal.common.aftersale.impl.StandardAfterSaleService;

public class XFSAfterSaleService
extends StandardAfterSaleService {
    private final Log log = LogFactory.getLog((String)this.getClass().getName());

    @Override
    public ServiceResult doSubmit(AftersaleSubmitParam aftersaleSubmitParam) {
        return this.submitReturn(aftersaleSubmitParam);
    }

    private ServiceResult submitReturn(AftersaleSubmitParam xfsAftersaleSubmitParam) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(32);
        paramMap.put("orderId", xfsAftersaleSubmitParam.getOrderId());
        paramMap.put("chnRefundOrderNo", xfsAftersaleSubmitParam.getChnRefundOrderNo());
        paramMap.put("questionDesc", xfsAftersaleSubmitParam.getQuestionDesc());
        paramMap.put("pickwareType", xfsAftersaleSubmitParam.getPickwareType());
        paramMap.put("returnReason", xfsAftersaleSubmitParam.getReturnReason());
        paramMap.put("aftersaleName", xfsAftersaleSubmitParam.getAftersaleName());
        paramMap.put("customerMobilePhone", xfsAftersaleSubmitParam.getCustomerMobilePhone());
        paramMap.put("returnwareProvince", xfsAftersaleSubmitParam.getProvinceId());
        paramMap.put("returnwareCity", xfsAftersaleSubmitParam.getCityId());
        paramMap.put("returnwareCounty", xfsAftersaleSubmitParam.getCountyId());
        if (Objects.nonNull(xfsAftersaleSubmitParam.getTownId())) {
            paramMap.put("returnwareVillage", xfsAftersaleSubmitParam.getTownId());
        }
        paramMap.put("returnwareAddress", xfsAftersaleSubmitParam.getAddress());
        paramMap.put("questionPic", xfsAftersaleSubmitParam.getQuestionPic());
        List<AftersaleSubmitSkuInfo> skus = xfsAftersaleSubmitParam.getSkus();
        ArrayList skuMapList = new ArrayList();
        skus.forEach(aftersaleSubmitSkuInfo -> {
            HashMap<String, Object> skuMap = new HashMap<String, Object>();
            skuMap.put("returnNum", aftersaleSubmitSkuInfo.getNum());
            skuMap.put("skuNo", aftersaleSubmitSkuInfo.getSkuId());
            skuMapList.add(skuMap);
        });
        paramMap.put("skus", skuMapList);
        Object res = ApiAccessor.invoke((String)"SRM_XFS_AFTERSALE_refundApply", paramMap);
        return this.parseAfterSaleRes(res);
    }

    private ServiceResult parseAfterSaleRes(Object res) {
        ServiceResult xfsServiceResult;
        try {
            Map resMap = (Map)res;
            if (!((Boolean)resMap.get("success")).booleanValue()) {
                this.log.error((String)resMap.get("resultMessage"));
                throw new KDBizException((String)resMap.get("resultMessage"));
            }
            Map resultMap = (Map)resMap.get("result");
            xfsServiceResult = new ServiceResult();
            xfsServiceResult.setSheetId(String.valueOf(resultMap.get("refundOrderNo")));
        }
        catch (ClassCastException e) {
            this.log.error(res.toString());
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u8f6c\u6362\u9519\u8bef\u3002", (String)"XFSAfterSaleService_0", (String)"scm-mal-common", (Object[])new Object[0]));
        }
        return xfsServiceResult;
    }

    @Override
    public List<ComponentExportEnum> getComponentExport(String var1, String var2) {
        ArrayList<ComponentExportEnum> componentExportEnums = new ArrayList<ComponentExportEnum>();
        componentExportEnums.add(ComponentExportEnum.XFS_DOOR_TO_TAKE);
        componentExportEnums.add(ComponentExportEnum.XFS_CUSTOMER_SEND);
        return componentExportEnums;
    }

    @Override
    public AftersaleSubmitParam packageAfterSaleParam(DynamicObject returnReqDyn) {
        DynamicObjectCollection entryentityCol = returnReqDyn.getDynamicObjectCollection("entryentity");
        DynamicObject returnEntry = (DynamicObject)entryentityCol.get(0);
        AftersaleSubmitParam xfsAftersaleSubmitParam = new AftersaleSubmitParam();
        DynamicObject xfsEcOrder = MalNewOrderUtils.getOrderDyn((String)returnEntry.getString("ecorder_id"), (String)EcPlatformEnum.ECPLATFORM_XFS.getVal());
        xfsAftersaleSubmitParam.setOrderId((String)xfsEcOrder.get("orderid"));
        xfsAftersaleSubmitParam.setQuestionDesc(returnEntry.getString("retreason"));
        xfsAftersaleSubmitParam.setReturnReason(returnEntry.getString("retreasoncode"));
        xfsAftersaleSubmitParam.setPickwareType(returnEntry.getString("pickwaretype"));
        String admindivisionLongNum = AddressUtil.getLongNumber((Long)returnReqDyn.getLong("admindivision"), (String)EcPlatformEnum.ECPLATFORM_XFS.getVal());
        String[] addrLongnumberStrs = admindivisionLongNum.split("\\.");
        if (addrLongnumberStrs.length > 2) {
            xfsAftersaleSubmitParam.setProvinceId(addrLongnumberStrs[0]);
            xfsAftersaleSubmitParam.setCityId(addrLongnumberStrs[1]);
            xfsAftersaleSubmitParam.setCountyId(addrLongnumberStrs[2]);
            if (addrLongnumberStrs.length > 3) {
                xfsAftersaleSubmitParam.setTownId(addrLongnumberStrs[3]);
            }
        }
        xfsAftersaleSubmitParam.setAddress(returnReqDyn.getString("address"));
        xfsAftersaleSubmitParam.setAftersaleName(returnReqDyn.getString("linkman"));
        xfsAftersaleSubmitParam.setCustomerMobilePhone(returnReqDyn.getString("phone"));
        ArrayList<AftersaleSubmitSkuInfo> aftersaleSubmitSkuInfos = new ArrayList<AftersaleSubmitSkuInfo>();
        for (DynamicObject entry : entryentityCol) {
            aftersaleSubmitSkuInfos.add(new AftersaleSubmitSkuInfo(entry.getInt("qty"), entry.getString("goods.number")));
        }
        xfsAftersaleSubmitParam.setSkus(aftersaleSubmitSkuInfos);
        xfsAftersaleSubmitParam.setChnRefundOrderNo(returnReqDyn.getString("billno"));
        xfsAftersaleSubmitParam.setQuestionPic("");
        return xfsAftersaleSubmitParam;
    }

    @Override
    public BigDecimal getAvailableNumberComp(String orderId, String sku) {
        return BigDecimal.ONE;
    }

    @Override
    public DynamicObject createAfServiceBill(Object submitResult, DynamicObject returnReqDyn) {
        ServiceResult xfsSubmitResult = (ServiceResult)submitResult;
        DynamicObject afServiceBillDyn = super.createAfServiceBill(submitResult, returnReqDyn);
        afServiceBillDyn.set("number", (Object)xfsSubmitResult.getSheetId());
        DynamicObjectCollection entryentityCol = returnReqDyn.getDynamicObjectCollection("entryentity");
        DynamicObject returnEntry = (DynamicObject)entryentityCol.get(0);
        DynamicObject xfsEcOrder = MalNewOrderUtils.getOrderDyn((String)returnEntry.getString("ecorder_id"), (String)EcPlatformEnum.ECPLATFORM_XFS.getVal());
        afServiceBillDyn.set("orderid", xfsEcOrder.get("orderid"));
        afServiceBillDyn.set("porderid", xfsEcOrder.get("porderid"));
        return afServiceBillDyn;
    }

    @Override
    public List<AfterSaleServiceTypeEnum> getCustomerExpectComp(String orderItemId, String skuId, String orderId, String cityId, String countyId) {
        ArrayList<AfterSaleServiceTypeEnum> afterSaleServiceTypeEnums = new ArrayList<AfterSaleServiceTypeEnum>();
        afterSaleServiceTypeEnums.add(AfterSaleServiceTypeEnum.XY_RETURN);
        return afterSaleServiceTypeEnums;
    }
}

