/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.aftersale.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.ecapi.jd.enums.AfterSaleServiceTypeEnum;
import kd.scm.common.ecapi.jd.enums.ComponentExportEnum;
import kd.scm.common.ecapi.util.AddressUtil;
import kd.scm.common.helper.apiconnector.api.ApiAccessor;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.mal.common.aftersale.XYAfterSaleUpdater;
import kd.scm.mal.common.aftersale.bean.AfterSaleServiceDetailInfo;
import kd.scm.mal.common.aftersale.bean.AftersaleSubmitParam;
import kd.scm.mal.common.aftersale.bean.AftersaleSubmitSkuInfo;
import kd.scm.mal.common.aftersale.bean.ServiceResult;
import kd.scm.mal.common.aftersale.impl.StandardAfterSaleService;

public class XYAfterSaleService
extends StandardAfterSaleService {
    private final Log log = LogFactory.getLog((String)this.getClass().getName());

    @Override
    public ServiceResult doSubmit(AftersaleSubmitParam aftersaleSubmitParam) {
        return this.submitReturn(aftersaleSubmitParam);
    }

    public ServiceResult submitReturn(AftersaleSubmitParam xyAftersaleSubmitParam) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(32);
        paramMap.put("orderId", xyAftersaleSubmitParam.getOrderId());
        paramMap.put("aftersaleType", xyAftersaleSubmitParam.getAftersaleType());
        paramMap.put("questionDesc", xyAftersaleSubmitParam.getQuestionDesc());
        paramMap.put("questionPic", xyAftersaleSubmitParam.getQuestionPic());
        paramMap.put("address", xyAftersaleSubmitParam.getAddress());
        paramMap.put("pickwareType", xyAftersaleSubmitParam.getPickwareType());
        paramMap.put("pickwareStartTime", xyAftersaleSubmitParam.getPickwareStartTime());
        paramMap.put("pickwareEndTime", xyAftersaleSubmitParam.getPickwareEndTime());
        paramMap.put("aftersaleName", xyAftersaleSubmitParam.getAftersaleName());
        paramMap.put("aftersalePhone", xyAftersaleSubmitParam.getAftersalePhone());
        paramMap.put("customerMobilePhone", xyAftersaleSubmitParam.getCustomerMobilePhone());
        paramMap.put("customerEmail", xyAftersaleSubmitParam.getCustomerEmail());
        paramMap.put("customerPostcode", xyAftersaleSubmitParam.getCustomerPostcode());
        paramMap.put("returnwareType", xyAftersaleSubmitParam.getAftersaleType());
        paramMap.put("returnwareProvince", xyAftersaleSubmitParam.getProvinceId());
        paramMap.put("returnwareCity", xyAftersaleSubmitParam.getCityId());
        paramMap.put("returnwareCounty", xyAftersaleSubmitParam.getCountyId());
        paramMap.put("returnwareVillage", xyAftersaleSubmitParam.getTownId());
        paramMap.put("returnwareAddress", xyAftersaleSubmitParam.getAddress());
        List<AftersaleSubmitSkuInfo> skus = xyAftersaleSubmitParam.getSkus();
        ArrayList skuMapList = new ArrayList();
        skus.forEach(aftersaleSubmitSkuInfo -> {
            HashMap<String, Object> skuMap = new HashMap<String, Object>();
            skuMap.put("skuNum", aftersaleSubmitSkuInfo.getNum());
            skuMap.put("skuId", aftersaleSubmitSkuInfo.getSkuId());
            skuMapList.add(skuMap);
        });
        paramMap.put("skus", skuMapList);
        Object res = ApiAccessor.invoke((String)"SRM_XY_AFTERSALE_serviceOrder", paramMap);
        return this.parseAfterSaleRes(res);
    }

    public ServiceResult parseAfterSaleRes(Object res) {
        ServiceResult xyServiceResult;
        try {
            Map resMap = (Map)res;
            if (!((Boolean)resMap.get("success")).booleanValue()) {
                this.log.error((String)resMap.get("resultMessage"));
                throw new KDBizException((String)resMap.get("resultMessage"));
            }
            Map resultMap = (Map)resMap.get("result");
            xyServiceResult = new ServiceResult();
            xyServiceResult.setSheetId(String.valueOf(resultMap.get("serviceId")));
        }
        catch (ClassCastException e) {
            this.log.error(res.toString());
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u8f6c\u6362\u9519\u8bef\u3002", (String)"XYAfterSaleService_0", (String)"scm-mal-common", (Object[])new Object[0]));
        }
        return xyServiceResult;
    }

    @Override
    public List<ComponentExportEnum> getComponentExport(String var1, String var2) {
        ArrayList<ComponentExportEnum> componentExportEnums = new ArrayList<ComponentExportEnum>();
        componentExportEnums.add(ComponentExportEnum.DOOR_TO_TAKE);
        componentExportEnums.add(ComponentExportEnum.XY_CUSTOMER_SEND);
        return componentExportEnums;
    }

    @Override
    public AftersaleSubmitParam packageAfterSaleParam(DynamicObject returnReqDyn) {
        DynamicObjectCollection entryentityCol = returnReqDyn.getDynamicObjectCollection("entryentity");
        DynamicObject returnEntry = (DynamicObject)entryentityCol.get(0);
        AftersaleSubmitParam xyAftersaleSubmitParam = new AftersaleSubmitParam();
        xyAftersaleSubmitParam.setAddress(returnReqDyn.getString("address"));
        xyAftersaleSubmitParam.setAftersaleName(returnReqDyn.getString("linkman"));
        xyAftersaleSubmitParam.setAftersalePhone(returnReqDyn.getString("phone"));
        xyAftersaleSubmitParam.setAftersaleType(returnEntry.getString("returntype"));
        xyAftersaleSubmitParam.setQuestionDesc(returnEntry.getString("retreason"));
        xyAftersaleSubmitParam.setPickwareType(returnEntry.getString("pickwaretype"));
        xyAftersaleSubmitParam.setPickwareStartTime("");
        xyAftersaleSubmitParam.setPickwareEndTime("");
        String admindivisionLongNum = AddressUtil.getLongNumber((Long)returnReqDyn.getLong("admindivision"), (String)EcPlatformEnum.ECPLATFORM_XY.getVal());
        String[] addrLongnumberStrs = admindivisionLongNum.split("\\.");
        if (addrLongnumberStrs.length >= 3) {
            xyAftersaleSubmitParam.setProvinceId(addrLongnumberStrs[0]);
            xyAftersaleSubmitParam.setCityId(addrLongnumberStrs[1]);
            xyAftersaleSubmitParam.setCountyId(addrLongnumberStrs[2]);
            if (addrLongnumberStrs.length >= 4) {
                xyAftersaleSubmitParam.setTownId(addrLongnumberStrs[3]);
            }
        }
        xyAftersaleSubmitParam.setAftersaleName(returnReqDyn.getString("linkman"));
        xyAftersaleSubmitParam.setCustomerMobilePhone(returnReqDyn.getString("phone"));
        xyAftersaleSubmitParam.setCustomerEmail(returnReqDyn.getString("email"));
        xyAftersaleSubmitParam.setOrderId(this.getOrderId(returnReqDyn));
        ArrayList<AftersaleSubmitSkuInfo> aftersaleSubmitSkuInfos = new ArrayList<AftersaleSubmitSkuInfo>();
        for (DynamicObject entry : entryentityCol) {
            aftersaleSubmitSkuInfos.add(new AftersaleSubmitSkuInfo(entry.getInt("qty"), entry.getString("goods.number")));
        }
        xyAftersaleSubmitParam.setSkus(aftersaleSubmitSkuInfos);
        return xyAftersaleSubmitParam;
    }

    @Override
    public BigDecimal getAvailableNumberComp(String orderId, String sku) {
        return BigDecimal.ONE;
    }

    @Override
    public DynamicObject createAfServiceBill(Object submitResult, DynamicObject returnReqDyn) {
        ServiceResult xySubmitResult = (ServiceResult)submitResult;
        DynamicObject afServiceBillDyn = super.createAfServiceBill(submitResult, returnReqDyn);
        afServiceBillDyn.set("number", (Object)xySubmitResult.getSheetId());
        afServiceBillDyn.set("porderid", (Object)xySubmitResult.getOrderId());
        afServiceBillDyn.set("orderid", (Object)xySubmitResult.getOrderId());
        return afServiceBillDyn;
    }

    @Override
    public <T extends AftersaleSubmitParam> ServiceResult queryAfterSrvSchedule(T aftersaleSubmitParam) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("sheetId", aftersaleSubmitParam.getSheetId());
        Object res = ApiAccessor.invoke((String)"SRM_XY_AFTERSALE_getServiceDetailInfo", paramMap);
        if (res != null) {
            return this.parseAfterSrvScheduleRes(res);
        }
        return new AfterSaleServiceDetailInfo();
    }

    public AfterSaleServiceDetailInfo parseAfterSrvScheduleRes(Object res) {
        AfterSaleServiceDetailInfo xyAfterSaleServiceDetailInfo;
        try {
            Map resMap = (Map)res;
            if (!((Boolean)resMap.get("success")).booleanValue()) {
                this.log.error((String)resMap.get("resultMessage"));
                throw new KDBizException((String)resMap.get("resultMessage"));
            }
            Map resultMap = (Map)resMap.get("result");
            xyAfterSaleServiceDetailInfo = new AfterSaleServiceDetailInfo(resultMap);
        }
        catch (ClassCastException e) {
            this.log.error(res.toString() + "\r\n" + ExceptionUtil.getStackTrace((Throwable)e));
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u8f6c\u6362\u9519\u8bef\u3002", (String)"XYAfterSaleService_0", (String)"scm-mal-common", (Object[])new Object[0]));
        }
        return xyAfterSaleServiceDetailInfo;
    }

    @Override
    public void updateAfterServiceSchedule(DynamicObject malreturnreqDyn) {
        AftersaleSubmitParam aftersaleSubmitParam = new AftersaleSubmitParam();
        aftersaleSubmitParam.setSheetId(this.getAfsId(malreturnreqDyn));
        AfterSaleServiceDetailInfo xyServiceResult = (AfterSaleServiceDetailInfo)this.queryAfterSrvSchedule(aftersaleSubmitParam);
        DynamicObjectCollection entryentityCol = malreturnreqDyn.getDynamicObjectCollection("entryentity");
        DynamicObject firstEntry = (DynamicObject)entryentityCol.get(0);
        xyServiceResult.setNum(firstEntry.getInt("qty"));
        xyServiceResult.setSkuId(firstEntry.getString("goods.number"));
        XYAfterSaleUpdater xyAfterSaleUpdater = new XYAfterSaleUpdater(malreturnreqDyn, xyServiceResult);
        xyAfterSaleUpdater.updateAndCommit();
    }

    @Override
    public List<AfterSaleServiceTypeEnum> getCustomerExpectComp(String orderItemId, String skuId, String orderId, String cityId, String countyId) {
        ArrayList<AfterSaleServiceTypeEnum> afterSaleServiceTypeEnums = new ArrayList<AfterSaleServiceTypeEnum>();
        afterSaleServiceTypeEnums.add(AfterSaleServiceTypeEnum.XY_RETURN);
        return afterSaleServiceTypeEnums;
    }

    @Override
    public List<Long> cancelAfterSale(Map<String, String> orderItemIdSkuIdMap, String orderId, String cancelType, String sheetId) {
        return null;
    }
}

