/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.aftersale.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.ecapi.jd.enums.AfterSaleServiceTypeEnum;
import kd.scm.common.ecapi.jd.enums.ComponentExportEnum;
import kd.scm.common.helper.apiconnector.api.ApiAccessor;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.mal.MalNewOrderUtils;
import kd.scm.mal.common.aftersale.ZKHAfterSaleUpdater;
import kd.scm.mal.common.aftersale.bean.AfterSaleServiceDetailInfo;
import kd.scm.mal.common.aftersale.bean.AftersaleSubmitParam;
import kd.scm.mal.common.aftersale.bean.AftersaleSubmitSkuInfo;
import kd.scm.mal.common.aftersale.bean.ServiceResult;
import kd.scm.mal.common.aftersale.impl.StandardAfterSaleService;

public class ZKHAfterSaleService
extends StandardAfterSaleService {
    private final Log log = LogFactory.getLog((String)this.getClass().getName());

    @Override
    public ServiceResult doSubmit(AftersaleSubmitParam aftersaleSubmitParam) {
        return this.submitReturn(aftersaleSubmitParam);
    }

    private ServiceResult submitReturn(AftersaleSubmitParam zkhAftersaleSubmitParam) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(32);
        paramMap.put("orderNumber", zkhAftersaleSubmitParam.getOrderId());
        paramMap.put("serviceType", Integer.parseInt(zkhAftersaleSubmitParam.getAftersaleType()));
        paramMap.put("description", zkhAftersaleSubmitParam.getQuestionDesc());
        paramMap.put("returnType", zkhAftersaleSubmitParam.getPickwareType());
        paramMap.put("applicant", zkhAftersaleSubmitParam.getAftersaleName());
        paramMap.put("applicationPhone", zkhAftersaleSubmitParam.getCustomerMobilePhone());
        List<AftersaleSubmitSkuInfo> skus = zkhAftersaleSubmitParam.getSkus();
        ArrayList skuMapList = new ArrayList();
        skus.forEach(aftersaleSubmitSkuInfo -> {
            HashMap<String, Object> skuMap = new HashMap<String, Object>();
            skuMap.put("num", aftersaleSubmitSkuInfo.getNum());
            skuMap.put("skuId", aftersaleSubmitSkuInfo.getSkuId());
            skuMapList.add(skuMap);
        });
        paramMap.put("detail", skuMapList);
        Object res = ApiAccessor.invoke((String)"SRM_ZKH_AFTERSALE_serviceOrder", paramMap);
        return this.parseAfterSaleRes(res);
    }

    private ServiceResult parseAfterSaleRes(Object res) {
        try {
            Map resMap = (Map)res;
            if (((Boolean)resMap.get("success")).booleanValue()) {
                Map resultMap = (Map)resMap.get("result");
                ServiceResult zkhServiceResult = new ServiceResult();
                zkhServiceResult.setSheetId(String.valueOf(resultMap.get("serviceId")));
                return zkhServiceResult;
            }
            this.log.error((String)resMap.get("resultMessage"));
            throw new KDBizException((String)resMap.get("resultMessage"));
        }
        catch (ClassCastException var5) {
            this.log.error(res.toString());
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u8f6c\u6362\u9519\u8bef\u3002", (String)"ZKHAfterSaleService_0", (String)"scm-mal-common", (Object[])new Object[0]));
        }
    }

    @Override
    public Object packageAfterSaleParam(DynamicObject returnReqDyn) {
        DynamicObjectCollection entryentityCol = returnReqDyn.getDynamicObjectCollection("entryentity");
        DynamicObject returnEntry = (DynamicObject)entryentityCol.get(0);
        AftersaleSubmitParam zkhAftersaleSubmitParam = new AftersaleSubmitParam();
        DynamicObject zkhEcOrder = MalNewOrderUtils.getOrderDyn((String)returnEntry.getString("ecorder_id"), (String)EcPlatformEnum.ECPLATFORM_ZKH.getVal());
        zkhAftersaleSubmitParam.setOrderId((String)zkhEcOrder.get("orderid"));
        zkhAftersaleSubmitParam.setQuestionDesc(returnEntry.getString("retreason"));
        zkhAftersaleSubmitParam.setReturnReason(returnEntry.getString("retreasoncode"));
        zkhAftersaleSubmitParam.setPickwareType(returnEntry.getString("pickwaretype").substring(1));
        zkhAftersaleSubmitParam.setAftersaleType(returnEntry.getString("returntype"));
        zkhAftersaleSubmitParam.setAddress(returnReqDyn.getString("address"));
        zkhAftersaleSubmitParam.setAftersaleName(returnReqDyn.getString("linkman"));
        zkhAftersaleSubmitParam.setCustomerMobilePhone(returnReqDyn.getString("phone"));
        ArrayList<AftersaleSubmitSkuInfo> aftersaleSubmitSkuInfos = new ArrayList<AftersaleSubmitSkuInfo>();
        for (DynamicObject entry : entryentityCol) {
            aftersaleSubmitSkuInfos.add(new AftersaleSubmitSkuInfo(entry.getInt("qty"), entry.getString("goods.number")));
        }
        zkhAftersaleSubmitParam.setSkus(aftersaleSubmitSkuInfos);
        zkhAftersaleSubmitParam.setChnRefundOrderNo(returnReqDyn.getString("billno"));
        zkhAftersaleSubmitParam.setQuestionPic("");
        return zkhAftersaleSubmitParam;
    }

    @Override
    public DynamicObject createAfServiceBill(Object submitResult, DynamicObject returnReqDyn) {
        ServiceResult zkhSubmitResult = (ServiceResult)submitResult;
        DynamicObject afServiceBillDyn = super.createAfServiceBill(submitResult, returnReqDyn);
        afServiceBillDyn.set("number", (Object)zkhSubmitResult.getSheetId());
        DynamicObjectCollection entryentityCol = returnReqDyn.getDynamicObjectCollection("entryentity");
        DynamicObject returnEntry = (DynamicObject)entryentityCol.get(0);
        DynamicObject xfsEcOrder = MalNewOrderUtils.getOrderDyn((String)returnEntry.getString("ecorder_id"), (String)EcPlatformEnum.ECPLATFORM_ZKH.getVal());
        afServiceBillDyn.set("orderid", xfsEcOrder.get("orderid"));
        afServiceBillDyn.set("porderid", xfsEcOrder.get("porderid"));
        return afServiceBillDyn;
    }

    @Override
    public List<AfterSaleServiceTypeEnum> getCustomerExpectComp(String orderItemId, String skuId, String orderId, String cityId, String countyId) {
        ArrayList<AfterSaleServiceTypeEnum> afterSaleServiceTypeEnums = new ArrayList<AfterSaleServiceTypeEnum>();
        afterSaleServiceTypeEnums.add(AfterSaleServiceTypeEnum.RETURN);
        return afterSaleServiceTypeEnums;
    }

    @Override
    public List<ComponentExportEnum> getComponentExport(String var1, String var2) {
        ArrayList<ComponentExportEnum> componentExportEnums = new ArrayList<ComponentExportEnum>();
        componentExportEnums.add(ComponentExportEnum.ZKH_DOOR_TO_TAKE);
        componentExportEnums.add(ComponentExportEnum.ZKH_CUSTOMER_SEND);
        return componentExportEnums;
    }

    @Override
    public List<Long> cancelAfterSale(Map<String, String> orderItemIdSkuIdMap, String orderId, String cancelType, String sheetId) {
        AftersaleSubmitParam aftersaleSubmitParam = new AftersaleSubmitParam();
        aftersaleSubmitParam.setSheetId(sheetId);
        AfterSaleServiceDetailInfo afterSaleServiceDetailInfo = (AfterSaleServiceDetailInfo)this.queryAfterSrvSchedule(aftersaleSubmitParam);
        String afterSrvStatus = afterSaleServiceDetailInfo.getAfterSrvStatus();
        if ("4".equals(afterSrvStatus) || "5".equals(afterSrvStatus)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u552e\u540e\u7533\u8bf7\u53d6\u6d88\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u670d\u52a1\u5355{0}\u5ba1\u6838\u901a\u8fc7\u6216\u552e\u540e\u5b8c\u6210\u4e0d\u53ef\u53d6\u6d88\u3002", (String)"ZKHAfterSaleService_1", (String)"scm-mal-common", (Object[])new Object[]{sheetId}));
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("serviceId", sheetId);
        Map map = (Map)ApiAccessor.invoke((String)"SRM_ZKH_AFTERSALE_serviceOrder_cancel", paramMap);
        boolean success = Boolean.parseBoolean(String.valueOf(map.get("success")));
        if (success) {
            return new ArrayList<Long>();
        }
        String msg = String.valueOf(map.get("resultMessage"));
        throw new KDBizException(ResManager.loadKDString((String)"\u552e\u540e\u7533\u8bf7\u53d6\u6d88\u5931\u8d25\uff0c\u539f\u56e0{0}\u3002", (String)"ZKHAfterSaleService_2", (String)"scm-mal-common", (Object[])new Object[]{msg}));
    }

    @Override
    public <T extends AftersaleSubmitParam> ServiceResult queryAfterSrvSchedule(T aftersaleSubmitParam) {
        HashMap<String, String> paramMap = new HashMap<String, String>(8);
        paramMap.put("serviceId", aftersaleSubmitParam.getSheetId());
        Object res = ApiAccessor.invoke((String)"SRM_ZKH_AFTERSALE_serviceOrder_fetch", paramMap);
        if (res != null) {
            return this.parseAfterSrvScheduleRes(res);
        }
        return new AfterSaleServiceDetailInfo();
    }

    private AfterSaleServiceDetailInfo parseAfterSrvScheduleRes(Object res) {
        try {
            Map resMap = (Map)res;
            if (((Boolean)resMap.get("success")).booleanValue()) {
                Object totalPrice;
                Object serviceType;
                Object orderNumber;
                Object state;
                Map resultMap = (Map)resMap.get("result");
                AfterSaleServiceDetailInfo zkhAfterSaleServiceDetailInfo = new AfterSaleServiceDetailInfo();
                Object serviceId = resultMap.get("serviceId");
                if (serviceId != null) {
                    zkhAfterSaleServiceDetailInfo.setSheetId(String.valueOf(serviceId));
                }
                if ((state = resultMap.get("state")) != null) {
                    zkhAfterSaleServiceDetailInfo.setAfterSrvStatus(String.valueOf(state));
                }
                if ((orderNumber = resultMap.get("orderNumber")) != null) {
                    zkhAfterSaleServiceDetailInfo.setOrderId(String.valueOf(orderNumber));
                    zkhAfterSaleServiceDetailInfo.setPorderid(String.valueOf(orderNumber));
                }
                if ((serviceType = resultMap.get("serviceType")) != null) {
                    zkhAfterSaleServiceDetailInfo.setCustomerExpect(String.valueOf(serviceType));
                }
                if (StringUtils.isNotBlank(totalPrice = resultMap.get("totalPrice"))) {
                    zkhAfterSaleServiceDetailInfo.setTaxPrice(new BigDecimal(String.valueOf(totalPrice)));
                }
                List details = (List)resultMap.get("detail");
                Map detail = (Map)details.get(0);
                zkhAfterSaleServiceDetailInfo.setSkuId(String.valueOf(detail.get("skuId")));
                zkhAfterSaleServiceDetailInfo.setNum(Integer.parseInt(String.valueOf(detail.get("num"))));
                return zkhAfterSaleServiceDetailInfo;
            }
            this.log.error((String)resMap.get("resultMessage"));
            throw new KDBizException((String)resMap.get("resultMessage"));
        }
        catch (ClassCastException var5) {
            this.log.error(res.toString() + "\r\n" + ExceptionUtil.getStackTrace((Throwable)var5));
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u8f6c\u6362\u9519\u8bef\u3002", (String)"ZKHAfterSaleService_0", (String)"scm-mal-common", (Object[])new Object[0]));
        }
    }

    @Override
    public void updateAfterServiceSchedule(DynamicObject malreturnreqDyn) {
        AftersaleSubmitParam aftersaleSubmitParam = new AftersaleSubmitParam();
        aftersaleSubmitParam.setSheetId(this.getAfsId(malreturnreqDyn));
        AfterSaleServiceDetailInfo afterSaleServiceDetailInfo = (AfterSaleServiceDetailInfo)this.queryAfterSrvSchedule(aftersaleSubmitParam);
        if (afterSaleServiceDetailInfo == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u7684\u552e\u540e\u8fdb\u5ea6,\u8bf7\u8054\u7cfb\u5ba2\u670d\u4eba\u5458\u5904\u7406\u3002", (String)"ZKHAfterSaleService_3", (String)"scm-mal-common", (Object[])new Object[0]));
        }
        ZKHAfterSaleUpdater zkhAfterSaleUpdater = new ZKHAfterSaleUpdater(malreturnreqDyn, afterSaleServiceDetailInfo);
        zkhAfterSaleUpdater.updateAndCommit();
    }
}

