/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.ecmessage.factory;

import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.scm.common.helper.apiconnector.api.util.ReadLockFreeMap;
import kd.scm.mal.common.ecmessage.enums.CgMsgTypeEnum;
import kd.scm.mal.common.ecmessage.factory.EcMessageHandlerFactory;
import kd.scm.mal.common.ecmessage.msg.AbstractMessageHandler;
import kd.scm.mal.common.ecmessage.msg.MessageHadler;
import kd.scm.mal.common.ecmessage.msg.cg.CgCancelOrderMessageHandler;
import kd.scm.mal.common.ecmessage.msg.cg.CgDeliverdOrderMessageHandler;
import kd.scm.mal.common.ecmessage.msg.cg.CgInvoiceAuditMessageHandler;
import kd.scm.mal.common.ecmessage.msg.cg.CgOrderStateMessageHandler;
import kd.scm.mal.common.ecmessage.msg.cg.CgPriceMessageHandler;
import kd.scm.mal.common.ecmessage.msg.cg.CgProdPoolMessageHadler;
import kd.scm.mal.common.ecmessage.msg.cg.CgProdStatusMessageHandler;
import kd.scm.mal.common.ecmessage.msg.cg.CgReturnRequestStateMessageHandler;
import kd.scm.mal.common.ecmessage.msg.cg.CgReturnStateMessageHandler;
import kd.scm.mal.common.ecmessage.msg.cg.CgSplitOrderMessageHandler;

public class CgMessageHadlerFactory
implements EcMessageHandlerFactory {
    private static final ReadLockFreeMap<String, MessageHadler> HADLERCACHE = new ReadLockFreeMap();

    @Override
    public MessageHadler getMessageHadler(String msgType) {
        if (StringUtils.isBlank((CharSequence)msgType) || null == HADLERCACHE.get((Object)msgType)) {
            throw new KDBizException("@@@CgMessageHadlerFactory: Init JD " + CgMsgTypeEnum.valueOf(msgType).name() + "MessageHadler Failed!");
        }
        return (MessageHadler)HADLERCACHE.get((Object)msgType);
    }

    @Override
    public void registerHadler(String msgType, AbstractMessageHandler handler) {
        if (StringUtils.isBlank((CharSequence)msgType)) {
            throw new KDBizException("@@@CgMessageHadlerFactory can not be null or empty String!");
        }
        if (null == handler) {
            throw new KDBizException("@@@CgMessageHadlerFactory " + msgType + " MessageFacory Failed!");
        }
        HADLERCACHE.put((Object)msgType, (Object)handler);
    }

    static {
        HADLERCACHE.put((Object)CgMsgTypeEnum.PROD_STATUS.getVal(), (Object)new CgProdStatusMessageHandler());
        HADLERCACHE.put((Object)CgMsgTypeEnum.PROD_POOLPRODCHANGE.getVal(), (Object)new CgProdPoolMessageHadler());
        HADLERCACHE.put((Object)CgMsgTypeEnum.ORDERS_SPLIT.getVal(), (Object)new CgSplitOrderMessageHandler());
        HADLERCACHE.put((Object)CgMsgTypeEnum.ORDER_DELIVERED.getVal(), (Object)new CgDeliverdOrderMessageHandler());
        HADLERCACHE.put((Object)CgMsgTypeEnum.ORDER_CANCELED.getVal(), (Object)new CgCancelOrderMessageHandler());
        HADLERCACHE.put((Object)CgMsgTypeEnum.ORDERS_STATE.getVal(), (Object)new CgOrderStateMessageHandler());
        HADLERCACHE.put((Object)CgMsgTypeEnum.PRICE.getVal(), (Object)new CgPriceMessageHandler());
        HADLERCACHE.put((Object)CgMsgTypeEnum.INVOICE.getVal(), null);
        HADLERCACHE.put((Object)CgMsgTypeEnum.INVOICE_AUDIT.getVal(), (Object)new CgInvoiceAuditMessageHandler());
        HADLERCACHE.put((Object)CgMsgTypeEnum.RETURN_STATE.getVal(), (Object)new CgReturnStateMessageHandler());
        HADLERCACHE.put((Object)CgMsgTypeEnum.RETURN_REQUEST_STATE.getVal(), (Object)new CgReturnRequestStateMessageHandler());
    }
}

