/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.ecmessage.factory;

import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.scm.common.helper.apiconnector.api.util.ReadLockFreeMap;
import kd.scm.mal.common.ecmessage.enums.DlMsgTypeEnum;
import kd.scm.mal.common.ecmessage.factory.EcMessageHandlerFactory;
import kd.scm.mal.common.ecmessage.msg.AbstractMessageHandler;
import kd.scm.mal.common.ecmessage.msg.MessageHadler;
import kd.scm.mal.common.ecmessage.msg.dl.DlCancelOrderMessageHandler;
import kd.scm.mal.common.ecmessage.msg.dl.DlDeliverdOrderMessageHandler;
import kd.scm.mal.common.ecmessage.msg.dl.DlInvoiceAuditMessageHandler;
import kd.scm.mal.common.ecmessage.msg.dl.DlPriceMessageHandler;
import kd.scm.mal.common.ecmessage.msg.dl.DlProdChangeMessageHadler;
import kd.scm.mal.common.ecmessage.msg.dl.DlReturnStateMessageHandler;

public class DlMessageHadlerFactory
implements EcMessageHandlerFactory {
    private static final ReadLockFreeMap<String, MessageHadler> HADLERCACHE = new ReadLockFreeMap();

    @Override
    public MessageHadler getMessageHadler(String msgType) {
        if (StringUtils.isBlank((CharSequence)msgType) || null == HADLERCACHE.get((Object)msgType)) {
            throw new KDBizException("@@@DlMessageHadlerFactory: Init DL " + DlMsgTypeEnum.valueOf(msgType).name() + "MessageHadler Failed!");
        }
        return (MessageHadler)HADLERCACHE.get((Object)msgType);
    }

    @Override
    public void registerHadler(String msgType, AbstractMessageHandler handler) {
        if (StringUtils.isBlank((CharSequence)msgType)) {
            throw new KDBizException("@@@DlMessageHadlerFactory can not be null or empty String!");
        }
        if (null == handler) {
            throw new KDBizException("@@@DlMessageHadlerFactory " + msgType + " MessageFacory Failed!");
        }
        HADLERCACHE.put((Object)msgType, (Object)handler);
    }

    static {
        HADLERCACHE.put((Object)DlMsgTypeEnum.PROD_CHANGE.getVal(), (Object)new DlProdChangeMessageHadler());
        HADLERCACHE.put((Object)DlMsgTypeEnum.ORDER_DELIVERED.getVal(), (Object)new DlDeliverdOrderMessageHandler());
        HADLERCACHE.put((Object)DlMsgTypeEnum.ORDER_CANCELED.getVal(), (Object)new DlCancelOrderMessageHandler());
        HADLERCACHE.put((Object)DlMsgTypeEnum.PRICE.getVal(), (Object)new DlPriceMessageHandler());
        HADLERCACHE.put((Object)DlMsgTypeEnum.INVOICE.getVal(), (Object)new DlInvoiceAuditMessageHandler());
        HADLERCACHE.put((Object)DlMsgTypeEnum.RETURN_STATE.getVal(), (Object)new DlReturnStateMessageHandler());
    }
}

