/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.ecmessage.factory;

import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.helper.apiconnector.api.util.ReadLockFreeMap;
import kd.scm.mal.common.ecmessage.factory.CgMessageHadlerFactory;
import kd.scm.mal.common.ecmessage.factory.DlMessageHadlerFactory;
import kd.scm.mal.common.ecmessage.factory.EcMessageHandlerFactory;
import kd.scm.mal.common.ecmessage.factory.JdMessageHadlerFactory;
import kd.scm.mal.common.ecmessage.factory.SnMessageHadlerFactory;
import kd.scm.mal.common.ecmessage.factory.XfsMessageHadlerFactory;
import kd.scm.mal.common.ecmessage.factory.XyMessageHadlerFactory;
import kd.scm.mal.common.ecmessage.factory.ZkhMessageHadlerFactory;

public class EcMessageFactoryManager {
    private static final ReadLockFreeMap<String, EcMessageHandlerFactory> FACTORIES = new ReadLockFreeMap(16);

    public static final EcMessageHandlerFactory getFactory(String ecType) {
        if (StringUtils.isBlank((CharSequence)ecType) || null == FACTORIES.get((Object)ecType)) {
            throw new KDBizException("Init " + EcPlatformEnum.valueOf((String)ecType).name() + " MessageFacory Failed!");
        }
        return (EcMessageHandlerFactory)FACTORIES.get((Object)ecType);
    }

    public static final void registerFactory(String ecType, EcMessageHandlerFactory factory) {
        if (StringUtils.isBlank((CharSequence)ecType)) {
            throw new KDBizException("ecType can not be null or empty String !");
        }
        if (null == factory) {
            throw new KDBizException("register " + ecType + " MessageFacory Failed!");
        }
        FACTORIES.putIfAbsent((Object)ecType, (Object)factory);
    }

    static {
        FACTORIES.put((Object)EcPlatformEnum.ECPLATFORM_JD.getVal(), (Object)new JdMessageHadlerFactory());
        FACTORIES.put((Object)EcPlatformEnum.ECPLATFORM_JDPRO.getVal(), (Object)new JdMessageHadlerFactory());
        FACTORIES.put((Object)EcPlatformEnum.ECPLATFORM_SUNING.getVal(), (Object)new SnMessageHadlerFactory());
        FACTORIES.put((Object)EcPlatformEnum.ECPLATFORM_XY.getVal(), (Object)new XyMessageHadlerFactory());
        FACTORIES.put((Object)EcPlatformEnum.ECPLATFORM_CG.getVal(), (Object)new CgMessageHadlerFactory());
        FACTORIES.put((Object)EcPlatformEnum.ECPLATFORM_DL.getVal(), (Object)new DlMessageHadlerFactory());
        FACTORIES.put((Object)EcPlatformEnum.ECPLATFORM_XFS.getVal(), (Object)new XfsMessageHadlerFactory());
        FACTORIES.put((Object)EcPlatformEnum.ECPLATFORM_ZKH.getVal(), (Object)new ZkhMessageHadlerFactory());
    }
}

