/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.ecmessage.factory;

import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.scm.common.helper.apiconnector.api.util.ReadLockFreeMap;
import kd.scm.mal.common.ecmessage.enums.JdMsgTypeEnum;
import kd.scm.mal.common.ecmessage.factory.EcMessageHandlerFactory;
import kd.scm.mal.common.ecmessage.msg.AbstractMessageHandler;
import kd.scm.mal.common.ecmessage.msg.MessageHadler;
import kd.scm.mal.common.ecmessage.msg.jd.JdAddressMessageHandler;
import kd.scm.mal.common.ecmessage.msg.jd.JdCancelOrderMessageHandler;
import kd.scm.mal.common.ecmessage.msg.jd.JdCompleteOrderMessageHandler;
import kd.scm.mal.common.ecmessage.msg.jd.JdDeliverdOrderMessageHandler;
import kd.scm.mal.common.ecmessage.msg.jd.JdInvoiceOrderMessageHandler;
import kd.scm.mal.common.ecmessage.msg.jd.JdPriceMessageHandler;
import kd.scm.mal.common.ecmessage.msg.jd.JdProdPoolMessageHadler;
import kd.scm.mal.common.ecmessage.msg.jd.JdReturnOrderMessageHandler;
import kd.scm.mal.common.ecmessage.msg.jd.JdSplitOrderMessageHandler;

public class JdMessageHadlerFactory
implements EcMessageHandlerFactory {
    private static final ReadLockFreeMap<String, MessageHadler> HADLERCACHE = new ReadLockFreeMap();

    @Override
    public MessageHadler getMessageHadler(String msgType) {
        if (StringUtils.isBlank((CharSequence)msgType) || null == HADLERCACHE.get((Object)msgType)) {
            throw new KDBizException("@@@JdMessageHadlerFactory: Init JD " + JdMsgTypeEnum.valueOf(msgType).name() + "MessageHadler Failed!");
        }
        return (MessageHadler)HADLERCACHE.get((Object)msgType);
    }

    @Override
    public void registerHadler(String msgType, AbstractMessageHandler handler) {
        if (StringUtils.isBlank((CharSequence)msgType)) {
            throw new KDBizException("@@@JdMessageHadlerFactory\uff1aecType can not be null or empty String!");
        }
        if (null == handler) {
            throw new KDBizException("@@@JdMessageHadlerFactory\uff1aregister " + msgType + " MessageFacory Failed!");
        }
        HADLERCACHE.put((Object)msgType, (Object)handler);
    }

    static {
        HADLERCACHE.put((Object)JdMsgTypeEnum.PROD_STATUS.getVal(), (Object)new JdProdPoolMessageHadler());
        HADLERCACHE.put((Object)JdMsgTypeEnum.PROD_POOLPRODCHANGE.getVal(), (Object)new JdProdPoolMessageHadler());
        HADLERCACHE.put((Object)JdMsgTypeEnum.PROD_PRODCHANGE.getVal(), (Object)new JdProdPoolMessageHadler());
        HADLERCACHE.put((Object)JdMsgTypeEnum.PROD_POOLCHANGE.getVal(), (Object)new JdProdPoolMessageHadler());
        HADLERCACHE.put((Object)JdMsgTypeEnum.ORDERS_SPLIT.getVal(), (Object)new JdSplitOrderMessageHandler());
        HADLERCACHE.put((Object)JdMsgTypeEnum.ORDER_DELIVERED.getVal(), (Object)new JdDeliverdOrderMessageHandler());
        HADLERCACHE.put((Object)JdMsgTypeEnum.ORDER_CANCELED.getVal(), (Object)new JdCancelOrderMessageHandler());
        HADLERCACHE.put((Object)JdMsgTypeEnum.ORDER_WAITCONFIRMREV.getVal(), null);
        HADLERCACHE.put((Object)JdMsgTypeEnum.ORDER_COMPLETE.getVal(), (Object)new JdCompleteOrderMessageHandler());
        HADLERCACHE.put((Object)JdMsgTypeEnum.PRICE.getVal(), (Object)new JdPriceMessageHandler());
        HADLERCACHE.put((Object)JdMsgTypeEnum.ADDRESS.getVal(), (Object)new JdAddressMessageHandler());
        HADLERCACHE.put((Object)JdMsgTypeEnum.INVOICE.getVal(), (Object)new JdInvoiceOrderMessageHandler());
        HADLERCACHE.put((Object)JdMsgTypeEnum.RETURN.getVal(), (Object)new JdReturnOrderMessageHandler());
    }
}

