/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.ecmessage.factory;

import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.scm.common.helper.apiconnector.api.util.ReadLockFreeMap;
import kd.scm.mal.common.ecmessage.enums.SnMsgTypeEnum;
import kd.scm.mal.common.ecmessage.factory.EcMessageHandlerFactory;
import kd.scm.mal.common.ecmessage.msg.AbstractMessageHandler;
import kd.scm.mal.common.ecmessage.msg.MessageHadler;
import kd.scm.mal.common.ecmessage.msg.sn.SnInvoiceMessageHandler;
import kd.scm.mal.common.ecmessage.msg.sn.SnInvoiceStatusMessageHandler;
import kd.scm.mal.common.ecmessage.msg.sn.SnLogisticsMessageHandler;
import kd.scm.mal.common.ecmessage.msg.sn.SnOrderMessageHandler;
import kd.scm.mal.common.ecmessage.msg.sn.SnPriceMessageHandler;
import kd.scm.mal.common.ecmessage.msg.sn.SnProdPoolMessageHadler;
import kd.scm.mal.common.ecmessage.msg.sn.SnReturnStateMessageHandler;

public class SnMessageHadlerFactory
implements EcMessageHandlerFactory {
    private static final ReadLockFreeMap<String, MessageHadler> HADLERCACHE = new ReadLockFreeMap();

    @Override
    public MessageHadler getMessageHadler(String msgType) {
        if (StringUtils.isBlank((CharSequence)msgType) || null == HADLERCACHE.get((Object)msgType)) {
            throw new KDBizException("@@@SnMessageHadlerFactory: Init SN " + SnMsgTypeEnum.valueOf(msgType).name() + "MessageHadler Failed!");
        }
        return (MessageHadler)HADLERCACHE.get((Object)msgType);
    }

    @Override
    public void registerHadler(String msgType, AbstractMessageHandler handler) {
        if (StringUtils.isBlank((CharSequence)msgType)) {
            throw new KDBizException("@@@SnMessageHadlerFactory\uff1aecType can not be null or empty String !");
        }
        if (null == handler) {
            throw new KDBizException("@@@SnMessageHadlerFactory\uff1aregister " + msgType + " MessageFacory Failed!");
        }
        HADLERCACHE.put((Object)msgType, (Object)handler);
    }

    static {
        HADLERCACHE.put((Object)SnMsgTypeEnum.PRODPOOL.getVal(), (Object)new SnProdPoolMessageHadler());
        HADLERCACHE.put((Object)SnMsgTypeEnum.ORDERS.getVal(), (Object)new SnOrderMessageHandler());
        HADLERCACHE.put((Object)SnMsgTypeEnum.LOGISTICS.getVal(), (Object)new SnLogisticsMessageHandler());
        HADLERCACHE.put((Object)SnMsgTypeEnum.PRICE.getVal(), (Object)new SnPriceMessageHandler());
        HADLERCACHE.put((Object)SnMsgTypeEnum.RETURN.getVal(), (Object)new SnReturnStateMessageHandler());
        HADLERCACHE.put((Object)SnMsgTypeEnum.INVOICE.getVal(), (Object)new SnInvoiceMessageHandler());
        HADLERCACHE.put((Object)SnMsgTypeEnum.INVOICESTATUS.getVal(), (Object)new SnInvoiceStatusMessageHandler());
    }
}

