/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.ecmessage.factory;

import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.scm.common.helper.apiconnector.api.util.ReadLockFreeMap;
import kd.scm.mal.common.ecmessage.enums.XfsMsgTypeEnum;
import kd.scm.mal.common.ecmessage.factory.EcMessageHandlerFactory;
import kd.scm.mal.common.ecmessage.msg.AbstractMessageHandler;
import kd.scm.mal.common.ecmessage.msg.MessageHadler;
import kd.scm.mal.common.ecmessage.msg.xfs.XfsAfterOrderStateMessageHandler;
import kd.scm.mal.common.ecmessage.msg.xfs.XfsCancelOrderMessageHandler;
import kd.scm.mal.common.ecmessage.msg.xfs.XfsDeliverdOrderMessageHandler;
import kd.scm.mal.common.ecmessage.msg.xfs.XfsOrderStateMessageHandler;
import kd.scm.mal.common.ecmessage.msg.xfs.XfsProdAddMessageHandler;
import kd.scm.mal.common.ecmessage.msg.xfs.XfsProdPriceMessageHandler;
import kd.scm.mal.common.ecmessage.msg.xfs.XfsProdStatusMessageHandler;
import kd.scm.mal.common.ecmessage.msg.xfs.XfsProdUpdateMessageHandler;
import kd.scm.mal.common.ecmessage.msg.xfs.XfsSplitOrderMessageHandler;

public class XfsMessageHadlerFactory
implements EcMessageHandlerFactory {
    private static final ReadLockFreeMap<String, MessageHadler> HADLERCACHE = new ReadLockFreeMap();

    @Override
    public MessageHadler getMessageHadler(String msgType) {
        if (StringUtils.isBlank((CharSequence)msgType) || null == HADLERCACHE.get((Object)msgType)) {
            throw new KDBizException("@@@XfsMessageHadlerFactory: Init XFS " + XfsMsgTypeEnum.valueOf(msgType).name() + "MessageHadler Failed!");
        }
        return (MessageHadler)HADLERCACHE.get((Object)msgType);
    }

    @Override
    public void registerHadler(String msgType, AbstractMessageHandler handler) {
        if (StringUtils.isBlank((CharSequence)msgType)) {
            throw new KDBizException("@@@XfsMessageHadlerFactory can not be null or empty String!");
        }
        if (null == handler) {
            throw new KDBizException("@@@XfsMessageHadlerFactory " + msgType + " MessageFacory Failed!");
        }
        HADLERCACHE.put((Object)msgType, (Object)handler);
    }

    static {
        HADLERCACHE.put((Object)XfsMsgTypeEnum.PROD_STATUS.getVal(), (Object)new XfsProdStatusMessageHandler());
        HADLERCACHE.put((Object)XfsMsgTypeEnum.PROD_ADD.getVal(), (Object)new XfsProdAddMessageHandler());
        HADLERCACHE.put((Object)XfsMsgTypeEnum.PROD_UPDATE.getVal(), (Object)new XfsProdUpdateMessageHandler());
        HADLERCACHE.put((Object)XfsMsgTypeEnum.PROD_PRICE.getVal(), (Object)new XfsProdPriceMessageHandler());
        HADLERCACHE.put((Object)XfsMsgTypeEnum.ORDER_SPLIT.getVal(), (Object)new XfsSplitOrderMessageHandler());
        HADLERCACHE.put((Object)XfsMsgTypeEnum.ORDER_DELIVERED.getVal(), (Object)new XfsDeliverdOrderMessageHandler());
        HADLERCACHE.put((Object)XfsMsgTypeEnum.ORDER_CANCELED.getVal(), (Object)new XfsCancelOrderMessageHandler());
        HADLERCACHE.put((Object)XfsMsgTypeEnum.ORDER_STATE.getVal(), (Object)new XfsOrderStateMessageHandler());
        HADLERCACHE.put((Object)XfsMsgTypeEnum.INVOICE.getVal(), null);
        HADLERCACHE.put((Object)XfsMsgTypeEnum.RETURN_STATE.getVal(), (Object)new XfsAfterOrderStateMessageHandler());
        HADLERCACHE.put((Object)XfsMsgTypeEnum.RETURN_NOTIFY.getVal(), null);
    }
}

