/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.ecmessage.factory;

import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.scm.common.helper.apiconnector.api.util.ReadLockFreeMap;
import kd.scm.mal.common.ecmessage.enums.XyMsgTypeEnum;
import kd.scm.mal.common.ecmessage.factory.EcMessageHandlerFactory;
import kd.scm.mal.common.ecmessage.msg.AbstractMessageHandler;
import kd.scm.mal.common.ecmessage.msg.MessageHadler;
import kd.scm.mal.common.ecmessage.msg.xy.XyCancelOrderMessageHandler;
import kd.scm.mal.common.ecmessage.msg.xy.XyDeliverdOrderMessageHandler;
import kd.scm.mal.common.ecmessage.msg.xy.XyInvoiceOrderMessageHandler;
import kd.scm.mal.common.ecmessage.msg.xy.XyPriceMessageHandler;
import kd.scm.mal.common.ecmessage.msg.xy.XyProdPoolMessageHadler;
import kd.scm.mal.common.ecmessage.msg.xy.XyReturnStateMessageHandler;
import kd.scm.mal.common.ecmessage.msg.xy.XySplitOrderMessageHandler;

public class XyMessageHadlerFactory
implements EcMessageHandlerFactory {
    private static final ReadLockFreeMap<String, MessageHadler> HADLERCACHE = new ReadLockFreeMap();

    @Override
    public MessageHadler getMessageHadler(String msgType) {
        if (StringUtils.isBlank((CharSequence)msgType) || null == HADLERCACHE.get((Object)msgType)) {
            throw new KDBizException("@@@XyMessageHadlerFactory: Init JD " + XyMsgTypeEnum.valueOf(msgType).name() + "MessageHadler Failed!");
        }
        return (MessageHadler)HADLERCACHE.get((Object)msgType);
    }

    @Override
    public void registerHadler(String msgType, AbstractMessageHandler handler) {
        if (StringUtils.isBlank((CharSequence)msgType)) {
            throw new KDBizException("@@@XyMessageHadlerFactory\uff1aecType can not be null or empty String!");
        }
        if (null == handler) {
            throw new KDBizException("@@@XyMessageHadlerFactory\uff1aregister " + msgType + " MessageFacory Failed!");
        }
        HADLERCACHE.put((Object)msgType, (Object)handler);
    }

    static {
        HADLERCACHE.put((Object)XyMsgTypeEnum.PROD_STATUS.getVal(), (Object)new XyProdPoolMessageHadler());
        HADLERCACHE.put((Object)XyMsgTypeEnum.PROD_POOLPRODCHANGE.getVal(), (Object)new XyProdPoolMessageHadler());
        HADLERCACHE.put((Object)XyMsgTypeEnum.PROD_PRODCHANGE.getVal(), (Object)new XyProdPoolMessageHadler());
        HADLERCACHE.put((Object)XyMsgTypeEnum.PROD_POOLCHANGE.getVal(), (Object)new XyProdPoolMessageHadler());
        HADLERCACHE.put((Object)XyMsgTypeEnum.ORDERS_SPLIT.getVal(), (Object)new XySplitOrderMessageHandler());
        HADLERCACHE.put((Object)XyMsgTypeEnum.ORDER_DELIVERED.getVal(), (Object)new XyDeliverdOrderMessageHandler());
        HADLERCACHE.put((Object)XyMsgTypeEnum.ORDER_CANCELED.getVal(), (Object)new XyCancelOrderMessageHandler());
        HADLERCACHE.put((Object)XyMsgTypeEnum.PRICE.getVal(), (Object)new XyPriceMessageHandler());
        HADLERCACHE.put((Object)XyMsgTypeEnum.INVOICE.getVal(), (Object)new XyInvoiceOrderMessageHandler());
        HADLERCACHE.put((Object)XyMsgTypeEnum.INVOICELOGISTIC.getVal(), null);
        HADLERCACHE.put((Object)XyMsgTypeEnum.RETURN.getVal(), (Object)new XyReturnStateMessageHandler());
    }
}

