/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.ecmessage.factory;

import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.scm.common.helper.apiconnector.api.util.ReadLockFreeMap;
import kd.scm.mal.common.ecmessage.enums.XfsMsgTypeEnum;
import kd.scm.mal.common.ecmessage.enums.ZkhMsgTypeEnum;
import kd.scm.mal.common.ecmessage.factory.EcMessageHandlerFactory;
import kd.scm.mal.common.ecmessage.msg.AbstractMessageHandler;
import kd.scm.mal.common.ecmessage.msg.MessageHadler;
import kd.scm.mal.common.ecmessage.msg.zkh.ZkhAfterOrderStateMessageHandler;
import kd.scm.mal.common.ecmessage.msg.zkh.ZkhCancelOrderMessageHandler;
import kd.scm.mal.common.ecmessage.msg.zkh.ZkhDeliverdOrderMessageHandler;
import kd.scm.mal.common.ecmessage.msg.zkh.ZkhInvoiceAuditMessageHandler;
import kd.scm.mal.common.ecmessage.msg.zkh.ZkhProdAddMessageHandler;
import kd.scm.mal.common.ecmessage.msg.zkh.ZkhProdPriceMessageHandler;
import kd.scm.mal.common.ecmessage.msg.zkh.ZkhProdStatusMessageHandler;
import kd.scm.mal.common.ecmessage.msg.zkh.ZkhProdUpdateMessageHandler;
import kd.scm.mal.common.ecmessage.msg.zkh.ZkhSplitOrderMessageHandler;

public class ZkhMessageHadlerFactory
implements EcMessageHandlerFactory {
    private static final ReadLockFreeMap<String, MessageHadler> HADLERCACHE = new ReadLockFreeMap();

    @Override
    public MessageHadler getMessageHadler(String msgType) {
        if (StringUtils.isBlank((CharSequence)msgType) || null == HADLERCACHE.get((Object)msgType)) {
            throw new KDBizException("@@@ZkhMessageHadlerFactory: Init XFS " + XfsMsgTypeEnum.valueOf(msgType).name() + "MessageHadler Failed!");
        }
        return (MessageHadler)HADLERCACHE.get((Object)msgType);
    }

    @Override
    public void registerHadler(String msgType, AbstractMessageHandler handler) {
        if (StringUtils.isBlank((CharSequence)msgType)) {
            throw new KDBizException("@@@ZkhMessageHadlerFactory can not be null or empty String!");
        }
        if (null == handler) {
            throw new KDBizException("@@@ZkhMessageHadlerFactory " + msgType + " MessageFacory Failed!");
        }
        HADLERCACHE.put((Object)msgType, (Object)handler);
    }

    static {
        HADLERCACHE.put((Object)ZkhMsgTypeEnum.PROD_STATUS.getVal(), (Object)new ZkhProdStatusMessageHandler());
        HADLERCACHE.put((Object)ZkhMsgTypeEnum.PROD_ADD.getVal(), (Object)new ZkhProdAddMessageHandler());
        HADLERCACHE.put((Object)ZkhMsgTypeEnum.PROD_UPDATE.getVal(), (Object)new ZkhProdUpdateMessageHandler());
        HADLERCACHE.put((Object)ZkhMsgTypeEnum.PROD_PRICE.getVal(), (Object)new ZkhProdPriceMessageHandler());
        HADLERCACHE.put((Object)ZkhMsgTypeEnum.ORDER_SPLIT.getVal(), (Object)new ZkhSplitOrderMessageHandler());
        HADLERCACHE.put((Object)ZkhMsgTypeEnum.ORDER_DELIVERED.getVal(), (Object)new ZkhDeliverdOrderMessageHandler());
        HADLERCACHE.put((Object)ZkhMsgTypeEnum.ORDER_CANCELED.getVal(), (Object)new ZkhCancelOrderMessageHandler());
        HADLERCACHE.put((Object)ZkhMsgTypeEnum.INVOICE.getVal(), (Object)new ZkhInvoiceAuditMessageHandler());
        HADLERCACHE.put((Object)ZkhMsgTypeEnum.RETURN_STATE.getVal(), (Object)new ZkhAfterOrderStateMessageHandler());
    }
}

