/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.ecmessage.msg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.mal.common.ecmessage.msg.MessageHadler;
import kd.scm.mal.common.service.EcOrderAutoReceiveFactory;
import kd.scm.mal.common.service.IEcOrderAutoReceive;
import net.sf.json.JSONObject;

public abstract class AbstractMessageHandler
implements MessageHadler {
    private static final Log logger = LogFactory.getLog(AbstractMessageHandler.class);

    @Override
    public void handleMsg(DynamicObject[] messageDyos) {
        this.checkMsg(messageDyos);
        try {
            boolean isAllSuccess = this.doExcute(messageDyos);
            if (isAllSuccess) {
                this.changeConsumeStatus(messageDyos);
            }
        }
        catch (Exception e) {
            this.addRetryTimes(messageDyos, this.getClass().getName(), e);
        }
    }

    public List<String> getKeyList(DynamicObject[] messageDyos, String msgType, String keyName) {
        ArrayList<String> resultList = new ArrayList<String>(messageDyos.length);
        for (DynamicObject dyo : messageDyos) {
            String result;
            JSONObject json;
            String val;
            String type = dyo.getString("msgtype");
            if (!StringUtils.equals((CharSequence)type, (CharSequence)msgType) || StringUtils.isBlank((CharSequence)(val = (json = JSONObject.fromObject((Object)(result = dyo.getString("result")))).getString(keyName)))) continue;
            resultList.add(val);
        }
        return resultList;
    }

    public Map<String, String> getKeyMap(DynamicObject[] messageDyos, String msgType, String keyName, String valueName) {
        HashMap<String, String> resultMap = new HashMap<String, String>(messageDyos.length);
        for (DynamicObject dyo : messageDyos) {
            String type = dyo.getString("msgtype");
            if (!StringUtils.equals((CharSequence)type, (CharSequence)msgType)) continue;
            String result = dyo.getString("result");
            JSONObject json = JSONObject.fromObject((Object)result);
            String key = json.getString(keyName);
            String val = json.getString(valueName);
            if (StringUtils.isBlank((CharSequence)key) || StringUtils.isBlank((CharSequence)val)) continue;
            resultMap.put(key, val);
        }
        return resultMap;
    }

    protected DynamicObject[] getFailedMessageDyo(Set<String> sucessOrders, Map<String, DynamicObject> msgMap) {
        DynamicObject[] messageDyos = new DynamicObject[msgMap.size() - sucessOrders.size()];
        int index = 0;
        for (Map.Entry<String, DynamicObject> entry : msgMap.entrySet()) {
            if (sucessOrders.contains(entry.getKey())) continue;
            messageDyos[index++] = msgMap.get(entry.getKey());
        }
        return messageDyos;
    }

    protected DynamicObject[] getSuccessMessageDyo(Set<String> sucessOrders, Map<String, DynamicObject> msgMap) {
        DynamicObject[] messageDyos = new DynamicObject[sucessOrders.size()];
        int index = 0;
        for (String order : sucessOrders) {
            messageDyos[index++] = msgMap.get(order);
        }
        return messageDyos;
    }

    public abstract boolean doExcute(DynamicObject[] var1);

    public void addRetryTimes(DynamicObject[] messageDyos, String className, Exception e) {
        logger.info("@@@" + className + "\u6d88\u606f\u6d88\u8d39\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + ExceptionUtil.getStackTrace((Throwable)e));
        for (DynamicObject dyo : messageDyos) {
            dyo.set("retrytimes", (Object)1);
        }
        SaveServiceHelper.save((DynamicObject[])messageDyos);
    }

    public void addRetryTimes(DynamicObject[] messageDyos, String className) {
        logger.info("@@@" + className + "\u6d88\u606f\u6d88\u8d39\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        for (DynamicObject dyo : messageDyos) {
            dyo.set("retrytimes", (Object)1);
        }
        SaveServiceHelper.save((DynamicObject[])messageDyos);
    }

    public void changeConsumeStatus(DynamicObject[] messageDyos) {
        for (DynamicObject dyo : messageDyos) {
            dyo.set("status", (Object)"1");
        }
        SaveServiceHelper.save((DynamicObject[])messageDyos);
    }

    public IEcOrderAutoReceive getEcOrderAutoReceiveService(DynamicObject[] purOrders) {
        return EcOrderAutoReceiveFactory.getEcOrderAutoReceiveServiceByConnectErp();
    }
}

