/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.ecmessage.msg.cg;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.helper.apiconnector.api.parser.CgApiParser;
import kd.scm.mal.common.ecmessage.enums.CgMsgTypeEnum;
import kd.scm.mal.common.ecmessage.msg.AbstractMessageHandler;
import kd.scm.mal.common.ecmessage.msg.util.EcMessageUtil;
import kd.scm.mal.common.service.impl.EcOrderAutoReceiceProxy;

public class CgDeliverdOrderMessageHandler
extends AbstractMessageHandler {
    private static final Log logger = LogFactory.getLog(CgDeliverdOrderMessageHandler.class);

    @Override
    public boolean doExcute(DynamicObject[] messageDyos) {
        List<String> deliveredOrderList = this.getKeyList(messageDyos, CgMsgTypeEnum.ORDER_DELIVERED.getVal(), "orderId");
        Map<String, String> orderIdStatusMap = this.getKeyMap(messageDyos, CgMsgTypeEnum.ORDER_DELIVERED.getVal(), "orderId", "state");
        logger.info("@@@CgDeliverdOrderMessageHandler\u5904\u7406\u59a5\u6295\u8ba2\u5355\uff1a" + deliveredOrderList);
        if (deliveredOrderList.isEmpty()) {
            this.addRetryTimes(messageDyos, this.getClass().getName());
            return false;
        }
        CgApiParser.updateCgOrderState(orderIdStatusMap);
        boolean ecAutoReceive = (Boolean)SystemParamServiceHelper.getBillParameter((String)"mal_order", (String)"ecautoreceive");
        if (ecAutoReceive) {
            Set<String> completeIds = EcMessageUtil.getPurEntryIdsByEcOrderNo(new HashSet<String>(deliveredOrderList), "pbd_order_cg", "id,orderid", "orderid");
            DynamicObject[] purOrders = EcMessageUtil.getPurOrderByEcOrder(EcPlatformEnum.ECPLATFORM_CG.getVal(), new HashSet<String>(deliveredOrderList));
            new EcOrderAutoReceiceProxy(this.getEcOrderAutoReceiveService(purOrders)).autoReceive(purOrders, completeIds);
        }
        return true;
    }
}

