/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.ecmessage.msg.dl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.helper.apiconnector.api.parser.DlApiParser;
import kd.scm.common.helper.apiconnector.api.util.EcGroupApiUtil;
import kd.scm.mal.common.ecmessage.enums.DlMsgTypeEnum;
import kd.scm.mal.common.ecmessage.msg.AbstractMessageHandler;
import kd.scm.mal.common.ecmessage.msg.util.EcMessageUtil;
import kd.scm.mal.common.service.impl.EcOrderAutoReceiceProxy;

public class DlDeliverdOrderMessageHandler
extends AbstractMessageHandler {
    private static final Log logger = LogFactory.getLog(DlDeliverdOrderMessageHandler.class);

    @Override
    public boolean doExcute(DynamicObject[] messageDyos) {
        List<String> deliveredOrderList = this.getKeyList(messageDyos, DlMsgTypeEnum.ORDER_DELIVERED.getVal(), "pxOrderId");
        HashMap<String, String> orderIdStatusMap = new HashMap<String, String>(deliveredOrderList.size());
        logger.info("@@@DlDeliverdOrderMessageHandler\u5904\u7406\u59a5\u6295\u8ba2\u5355\uff1a" + deliveredOrderList);
        if (deliveredOrderList.isEmpty()) {
            this.addRetryTimes(messageDyos, this.getClass().getName());
            return false;
        }
        for (String orderId : deliveredOrderList) {
            orderIdStatusMap.put(orderId, "4");
            EcGroupApiUtil.confirmOrderReceive(null, (String)orderId, (String)EcPlatformEnum.ECPLATFORM_DL.getVal());
        }
        DlApiParser.updateDlOrderState(orderIdStatusMap);
        boolean ecAutoReceive = (Boolean)SystemParamServiceHelper.getBillParameter((String)"mal_order", (String)"ecautoreceive");
        if (ecAutoReceive) {
            Set<String> completeIds = EcMessageUtil.getPurEntryIdsByEcOrderNo(new HashSet<String>(deliveredOrderList), "pbd_order_dl", "id,orderid", "orderid");
            DynamicObject[] purOrders = EcMessageUtil.getPurOrderByEcOrder(EcPlatformEnum.ECPLATFORM_DL.getVal(), new HashSet<String>(deliveredOrderList));
            new EcOrderAutoReceiceProxy(this.getEcOrderAutoReceiveService(purOrders)).autoReceive(purOrders, completeIds);
        }
        return true;
    }
}

