/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.ecmessage.msg.jd;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.helper.apiconnector.api.parser.JdApiParser;
import kd.scm.common.helper.apiconnector.api.util.Parser;
import kd.scm.mal.common.ecmessage.enums.JdMsgTypeEnum;
import kd.scm.mal.common.ecmessage.msg.AbstractMessageHandler;
import kd.scm.mal.common.ecmessage.msg.util.EcMessageUtil;
import kd.scm.mal.common.service.impl.EcOrderAutoReceiceProxy;
import net.sf.json.JSONObject;

public class JdDeliverdOrderMessageHandler
extends AbstractMessageHandler {
    private static final Log logger = LogFactory.getLog(JdDeliverdOrderMessageHandler.class);

    @Override
    public boolean doExcute(DynamicObject[] messageDyos) {
        String source = EcPlatformEnum.ECPLATFORM_JD.getVal();
        HashSet<String> deliveredOrderList = new HashSet<String>(messageDyos.length);
        for (DynamicObject dyo : messageDyos) {
            source = dyo.getString("systype");
            String msgType = dyo.getString("msgtype");
            if (!msgType.equals(JdMsgTypeEnum.ORDER_DELIVERED.getVal())) continue;
            String result = dyo.getString("result");
            JSONObject json = JSONObject.fromObject((Object)result);
            String orderId = json.getString("orderId");
            if (!"1".equals(Parser.toString((Object)json.get("state"))) && !"3".equals(Parser.toString((Object)json.get("state")))) continue;
            deliveredOrderList.add(orderId);
        }
        logger.info("@@@JdDeliverdOrderMessageHandler\u5904\u7406\u59a5\u6295\u8ba2\u5355\uff1a" + deliveredOrderList);
        if (deliveredOrderList.isEmpty()) {
            this.addRetryTimes(messageDyos, this.getClass().getName());
            return false;
        }
        JdApiParser.updateJdOrderStatus((String)"jdstate", new HashSet(deliveredOrderList), (String)"1");
        boolean ecAutoReceive = (Boolean)SystemParamServiceHelper.getBillParameter((String)"mal_order", (String)"ecautoreceive");
        if (ecAutoReceive) {
            Set orderNoSet = JdApiParser.getJdParentOrderByNumber(deliveredOrderList);
            Set<String> completeIds = EcMessageUtil.getPurEntryIdsByEcOrderNo(deliveredOrderList, "pbd_jdorder", "id,number", "number");
            DynamicObject[] purOrders = EcMessageUtil.getPurOrderByEcOrder(source, orderNoSet);
            new EcOrderAutoReceiceProxy(this.getEcOrderAutoReceiveService(purOrders)).autoReceive(purOrders, completeIds);
        }
        return true;
    }
}

