/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.ecmessage.msg.jd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.helper.apiconnector.api.parser.JdApiParser;
import kd.scm.mal.common.ecmessage.enums.JdMsgTypeEnum;
import kd.scm.mal.common.ecmessage.msg.AbstractMessageHandler;
import kd.scm.mal.common.ecmessage.msg.util.EcMessageUtil;
import net.sf.json.JSONObject;

public class JdProdPoolMessageHadler
extends AbstractMessageHandler {
    private static final Log logger = LogFactory.getLog(JdProdPoolMessageHadler.class);

    @Override
    public boolean doExcute(DynamicObject[] messageDyos) {
        String source = EcPlatformEnum.ECPLATFORM_JD.getVal();
        HashMap<String, String> skuStateMap = new HashMap<String, String>(messageDyos.length);
        List<String> addSkuList = new ArrayList<String>(messageDyos.length);
        for (DynamicObject dyo : messageDyos) {
            String status;
            String sku;
            source = dyo.getString("systype");
            String msgType = dyo.getString("msgtype");
            String result = dyo.getString("result");
            JSONObject json = JSONObject.fromObject((Object)result);
            if (msgType.equals(JdMsgTypeEnum.PROD_STATUS.getVal()) || msgType.equals(JdMsgTypeEnum.PROD_POOLPRODCHANGE.getVal())) {
                sku = json.getString("skuId");
                status = json.getString("state");
                if (msgType.equals(JdMsgTypeEnum.PROD_POOLPRODCHANGE.getVal()) && status.equals("1")) {
                    addSkuList.add(sku);
                    continue;
                }
                skuStateMap.put(sku, status.equals("2") ? "0" : status);
                continue;
            }
            if (msgType.equals(JdMsgTypeEnum.PROD_PRODCHANGE.getVal())) {
                sku = json.getString("skuId");
                addSkuList.add(sku);
                continue;
            }
            String pageNum = json.getString("page_num");
            status = json.getString("state");
            List<String> skuList = EcMessageUtil.getSkuListByPoolPageNum(pageNum, 1);
            if (status.equals("1")) {
                addSkuList.addAll(skuList);
                continue;
            }
            for (String key : skuList) {
                skuStateMap.put(key, "0");
            }
        }
        if (addSkuList.size() > 0) {
            logger.info("@@@JdProdPoolMessageHadler\u65b0\u589eSKU\uff1a" + addSkuList);
            addSkuList = EcMessageUtil.filterUnsyncWhenEnableExternalSearch(addSkuList, source);
            if (!addSkuList.isEmpty()) {
                EcMessageUtil.startServiceFlow(JdApiParser.getJdApiNumber((String)source, (String)"SRM_JD_GOODS_INIT_SUB"), addSkuList);
            }
        }
        if (skuStateMap.size() > 0) {
            logger.info("@@@JdProdPoolMessageHadler\u72b6\u6001\u6539\u53d8SKU\uff1a" + skuStateMap.keySet());
            EcMessageUtil.changeGoodsState(source, skuStateMap);
        }
        return true;
    }
}

