/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.ecmessage.msg.sn;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.helper.apiconnector.api.parser.SnApiParser;
import kd.scm.common.helper.apiconnector.api.util.EcApiUtil;
import kd.scm.mal.common.ecmessage.msg.AbstractMessageHandler;
import kd.scm.mal.common.ecmessage.msg.util.EcMessageUtil;
import kd.scm.mal.common.service.impl.EcOrderAutoReceiceProxy;
import net.sf.json.JSONObject;

public class SnLogisticsMessageHandler
extends AbstractMessageHandler {
    private static final Log logger = LogFactory.getLog(SnLogisticsMessageHandler.class);

    @Override
    public boolean doExcute(DynamicObject[] messageDyos) {
        HashSet<String> orderNoSet = new HashSet<String>(messageDyos.length);
        HashSet<String> orderItemNoSet = new HashSet<String>(messageDyos.length);
        for (DynamicObject dyo : messageDyos) {
            String result = dyo.getString("result");
            JSONObject json = JSONObject.fromObject((Object)result);
            String status = json.getString("status");
            String orderNo = json.getString("orderNo");
            String orderItemNo = json.getString("orderItemNo");
            if (!status.equals("2")) continue;
            orderNoSet.add(orderNo);
            orderItemNoSet.add(orderItemNo);
        }
        if (orderNoSet.size() <= 0 && orderItemNoSet.size() <= 0) {
            this.addRetryTimes(messageDyos, this.getClass().getName());
            return false;
        }
        logger.info("@@@SnLogisticsMessageHandler\u59a5\u6295\u8ba2\u5355\u53f7\uff1a" + orderNoSet + "\uff0c\u5b50\u8ba2\u5355\u53f7\uff1a" + orderItemNoSet);
        for (String orderNo : orderNoSet) {
            Map orderIdStatusMap = EcApiUtil.getSnOrderStatusMap((String)orderNo);
            SnApiParser.updateSnOrderStatus((Map)orderIdStatusMap);
        }
        boolean ecAutoReceive = (Boolean)SystemParamServiceHelper.getBillParameter((String)"mal_order", (String)"ecautoreceive");
        if (ecAutoReceive) {
            Set<String> completeIds = EcMessageUtil.getPurEntryIdsByEcOrderNo(orderItemNoSet, "pbd_order_sn", "id,orderid", "orderid");
            DynamicObject[] purOrders = EcMessageUtil.getPurOrderByEcOrder(EcPlatformEnum.ECPLATFORM_SUNING.getVal(), orderNoSet);
            new EcOrderAutoReceiceProxy(this.getEcOrderAutoReceiveService(purOrders)).autoReceive(purOrders, completeIds);
        }
        return true;
    }
}

