/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.ecmessage.msg.sn;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.mal.common.ecmessage.msg.AbstractMessageHandler;
import kd.scm.mal.common.ecmessage.msg.util.EcMessageUtil;
import net.sf.json.JSONObject;

public class SnPriceMessageHandler
extends AbstractMessageHandler {
    private static final Log logger = LogFactory.getLog(SnPriceMessageHandler.class);

    @Override
    public boolean doExcute(DynamicObject[] messageDyos) {
        HashMap citySkuMap = new HashMap(messageDyos.length);
        List<String> allSkuList = new ArrayList<String>(messageDyos.length);
        for (DynamicObject dyo : messageDyos) {
            String result = dyo.getString("result");
            JSONObject json = JSONObject.fromObject((Object)result);
            String city = json.getString("city");
            String sku = json.getString("cmmdtyCode");
            allSkuList.add(sku);
            List citis = (List)citySkuMap.get(city);
            if (null != citis) {
                citis.add(city);
                continue;
            }
            ArrayList<String> skuList = new ArrayList<String>(16);
            skuList.add(sku);
            citySkuMap.put(city, skuList);
        }
        if (citySkuMap.isEmpty()) {
            this.addRetryTimes(messageDyos, this.getClass().getName());
            return false;
        }
        allSkuList = EcMessageUtil.filterUnsyncWhenEnableExternalSearch(allSkuList, EcPlatformEnum.ECPLATFORM_SUNING.getVal());
        StringBuilder logString = new StringBuilder();
        for (Map.Entry entry : citySkuMap.entrySet()) {
            String cityStr = (String)entry.getKey();
            List skuIdList = (List)entry.getValue();
            if ((skuIdList = skuIdList.stream().filter(allSkuList::contains).collect(Collectors.toList())).isEmpty()) continue;
            String msg = "@@SnProdPoolMessageHadler update price goods is:";
            String msg1 = ",address is:";
            logString.append(msg).append(SerializationUtils.toJsonString(skuIdList)).append(msg1).append(cityStr).append("\n");
            EcMessageUtil.startServiceFlow("SRM_SN_PRICE_UPDATE", skuIdList, cityStr);
        }
        logger.info(logString.toString());
        return true;
    }
}

